/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed$1;
import com.ibm.team.filesystem.client.internal.Shed$2;
import com.ibm.team.filesystem.client.internal.Shed$3;
import com.ibm.team.filesystem.client.internal.Shed$4;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedBufferedInputStream;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.ContentHash;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class Shed {
    public static final String JAZZ_SHED = ".jazzShed";
    private static final String PREFIX = "b";
    private static final String FORMAT = "yy-MM-dd HH.mm.ss.SSS";
    private BackupDilemmaHandler problemHandler;
    private boolean backupEnabled;
    private long maxFileSize;
    private boolean shedEntryCreated;
    private String preferredName;
    private IPath shedEntry;
    private SimpleDateFormat formatter;

    public Shed(BackupDilemmaHandler backupDilemmaHandler) {
        this.problemHandler = backupDilemmaHandler == null ? BackupDilemmaHandler.getDefault() : backupDilemmaHandler;
        this.backupEnabled = this.problemHandler.backupEnabled();
        this.maxFileSize = this.problemHandler.getMaxFileSize() * 0x100000;
        this.shedEntryCreated = false;
        this.formatter = new SimpleDateFormat(FORMAT);
        this.preferredName = PREFIX + this.formatter.format(new Date(System.currentTimeMillis()));
    }

    public void forceBackup(Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            SharingManager.getInstance().doSilentChange(new Shed$1(this, shareable, subMonitor));
        }
        catch (FileSystemClientException fileSystemClientException) {
            throw (Throwable)((Object)fileSystemClientException);
        }
        catch (CoreException coreException) {
            throw (Throwable)new TeamRepositoryException((Throwable)coreException);
        }
    }

    public boolean backupIfDirty(Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        boolean[] blArray = new boolean[1];
        if (this.backupEnabled) {
            try {
                SharingManager.getInstance().doSilentChange(new Shed$2(this, blArray, shareable, iProgressMonitor));
            }
            catch (FileSystemClientException fileSystemClientException) {
                throw (Throwable)((Object)fileSystemClientException);
            }
            catch (CoreException coreException) {
                throw (Throwable)new TeamRepositoryException((Throwable)coreException);
            }
        }
        return blArray[0];
    }

    private boolean backup(Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        boolean bl = false;
        try {
            ResourceType resourceType = shareable.getResourceType((IProgressMonitor)subMonitor.newChild(1));
            FileItemInfo fileItemInfo = shareable.getFileItemInfo((IProgressMonitor)subMonitor.newChild(1));
            if (resourceType == ResourceType.FILE) {
                if (fileItemInfo == null || !fileItemInfo.isFile() || fileItemInfo.isContentChanged() || fileItemInfo.getContentLength() != shareable.getFileStorage().getSize((IProgressMonitor)subMonitor.newChild(1))) {
                    bl = true;
                } else if (shareable.getFileStorage().getModificationStamp() > fileItemInfo.getLastContentChangeCheckStamp()) {
                    bl = true;
                }
            } else if (resourceType == ResourceType.FOLDER) {
                String[] stringArray = shareable.getFullPath().toFile().list();
                if (stringArray != null && stringArray.length != 0) {
                    bl = true;
                }
            } else if (resourceType == ResourceType.SYMBOLIC_LINK) {
                if (fileItemInfo == null || fileItemInfo.isContentChanged() || !fileItemInfo.isSymbolicLink()) {
                    bl = true;
                } else {
                    String string = shareable.getFileStorage().getTarget((IProgressMonitor)subMonitor.newChild(1));
                    if (string == null) {
                        bl = true;
                    } else {
                        ContentHash contentHash = FileItemInfoProxy.getLinkTargetHash(string);
                        if (!contentHash.equals((Object)fileItemInfo.getHash())) {
                            bl = true;
                        }
                    }
                }
            }
        }
        catch (FileSystemClientException fileSystemClientException) {
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        if (!bl) {
            bl = shareable.getFileStorage().requiresBackup((IProgressMonitor)subMonitor.newChild(1));
        }
        if (bl) {
            shareable.getFileStorage().backup(this, this.problemHandler, (IProgressMonitor)subMonitor.newChild(98));
        }
        return bl;
    }

    public void backupInShed(Shareable shareable, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (!this.shedEntryCreated) {
            this.cleanup(shareable.getSandbox().getRoot().append(JAZZ_SHED), (IProgressMonitor)subMonitor.newChild(9));
            this.shedEntry = shareable.getSandbox().getRoot().append(JAZZ_SHED).append(this.preferredName);
            object = this.shedEntry.toFile();
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.Shed_0, (Object)this.shedEntry.toString(), (Object[])new Object[0]));
            }
            this.shedEntryCreated = true;
        }
        object = shareable.getResourceType((IProgressMonitor)subMonitor.newChild(1));
        byte[] byArray = new byte[32768];
        if (object != null) {
            IPath iPath = this.shedEntry.append(shareable.getLocalPath().removeLastSegments(1));
            File file = iPath.toFile();
            if (!file.exists() && !file.mkdirs()) {
                throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.Shed_1, (Object)iPath.toString(), (Object[])new Object[]{shareable.getLocalPath().toString()}));
            }
            this.makeBackupCopy(shareable.getSandbox().getRoot(), shareable.getLocalPath(), file, byArray, (IProgressMonitor)subMonitor.newChild(90));
            this.problemHandler.backedUpInShed(shareable, iPath.append(shareable.getLocalPath().lastSegment()));
        }
    }

    private void makeBackupCopy(IPath iPath, IPath iPath2, File file, byte[] byArray, IProgressMonitor iProgressMonitor) {
        block17: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            IPath iPath3 = iPath.append(iPath2);
            IFileStore iFileStore = EFS.getLocalFileSystem().getStore(iPath3);
            try {
                IFileInfo iFileInfo = iFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
                if (iFileInfo.getAttribute(32)) {
                    IPath iPath4 = new Path(file.getAbsolutePath()).append(iPath3.lastSegment());
                    IFileStore iFileStore2 = EFS.getLocalFileSystem().getStore(iPath4);
                    IPath iPath5 = iPath4.removeFirstSegments(iPath.segmentCount());
                    iPath5 = iPath5.setDevice(null);
                    iPath5 = iPath5.makeRelative();
                    ManagedFileStore managedFileStore = new ManagedFileStore(iPath, iPath5, iFileStore2);
                    String string = iFileInfo.getStringAttribute(64);
                    managedFileStore.symlink(string == null ? "" : string, (IProgressMonitor)subMonitor.newChild(98));
                    break block17;
                }
                if (iFileInfo.isDirectory()) {
                    File file2 = new File(file, iPath3.lastSegment());
                    if (file2.mkdir()) {
                        String[] stringArray = iPath3.toFile().list();
                        if (stringArray != null) {
                            subMonitor.setWorkRemaining(stringArray.length);
                            String[] stringArray2 = stringArray;
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String string = stringArray2[n2];
                                this.makeBackupCopy(iPath, iPath2.append(string), file2, byArray, (IProgressMonitor)subMonitor.newChild(1));
                                ++n2;
                            }
                        }
                    } else {
                        LoggingHelper.log(new FileSystemStatus(2, NLS.bind((String)Messages.Shed_2, (Object)iPath2.toString(), (Object[])new Object[0])));
                    }
                    break block17;
                }
                if (!iFileInfo.exists() || iFileInfo.getLength() > this.maxFileSize) break block17;
                File file3 = new File(file, iPath3.lastSegment());
                try {
                    FileInputStream fileInputStream = new FileInputStream(iPath3.toFile());
                    UnsynchronizedBufferedInputStream unsynchronizedBufferedInputStream = new UnsynchronizedBufferedInputStream((InputStream)fileInputStream);
                    try {
                        if (!file3.createNewFile()) break block17;
                        FileOutputStream fileOutputStream = new FileOutputStream(file3);
                        try {
                            int n = unsynchronizedBufferedInputStream.read(byArray);
                            while (n != -1) {
                                fileOutputStream.write(byArray, 0, n);
                                n = unsynchronizedBufferedInputStream.read(byArray);
                            }
                        }
                        finally {
                            fileOutputStream.close();
                        }
                    }
                    finally {
                        unsynchronizedBufferedInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    LoggingHelper.log(FileSystemStatus.getStatusFor(2, NLS.bind((String)Messages.Shed_2, (Object)iPath2.toString(), (Object[])new Object[0]), (Throwable)iOException));
                }
            }
            catch (CoreException coreException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(2, NLS.bind((String)Messages.Shed_2, (Object)iPath2.toString(), (Object[])new Object[0]), (Throwable)coreException));
            }
        }
    }

    private void cleanup(IPath iPath, IProgressMonitor iProgressMonitor) {
        File[] fileArray;
        File file = iPath.toFile();
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            file.delete();
            return;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(5, -1 * this.problemHandler.getPreferredShedLifespan());
        Date date = ((Calendar)gregorianCalendar).getTime();
        File[] fileArray2 = fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            String string = file2.getName();
            if (string.startsWith(PREFIX)) {
                String string2 = string.substring(PREFIX.length());
                try {
                    Date date2 = this.formatter.parse(string2);
                    if (date2.before(date)) {
                        this.delete(file2, iProgressMonitor);
                    }
                }
                catch (ParseException parseException) {
                    this.delete(file2, iProgressMonitor);
                }
            } else {
                this.delete(file2, iProgressMonitor);
            }
            ++n2;
        }
    }

    private void delete(File file, IProgressMonitor iProgressMonitor) {
        if (file.delete() || !file.exists()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IFileStore iFileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath()));
        try {
            IFileInfo iFileInfo = iFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
            if (!iFileInfo.getAttribute(32) && iFileInfo.isDirectory()) {
                File[] fileArray = file.listFiles();
                subMonitor.setWorkRemaining(1 + fileArray.length);
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray2[n2];
                    this.delete(file2, (IProgressMonitor)subMonitor.newChild(1));
                    ++n2;
                }
            }
            file.delete();
        }
        catch (CoreException coreException) {}
        subMonitor.done();
    }

    public static int getShedEntryCount(ISandbox iSandbox) {
        return Shed.getShedEntryCount(iSandbox.getRoot());
    }

    public static int getShedEntryCount(IPath iPath) {
        File file = Shed.getShedLocation(iPath);
        if (!file.exists() || !file.isDirectory()) {
            return 0;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return 0;
        }
        return stringArray.length;
    }

    private static File getShedLocation(IPath iPath) {
        return iPath.append(JAZZ_SHED).toFile();
    }

    public static Iterable getShedEntries(IPath iPath) {
        File file = Shed.getShedLocation(iPath);
        File[] fileArray = file.listFiles(new Shed$3());
        return new Shed$4(fileArray);
    }

    static /* synthetic */ boolean access$0(Shed shed, Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        return shed.backup(shareable, iProgressMonitor);
    }
}

