/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.AsyncSavePDBHMJob;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IRemoteVisitor;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.ISharingMetadata$ISharingDescriptorPath;
import com.ibm.team.filesystem.client.internal.ISharingMetadata$ITransaction;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoadedComponentsStore;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.SharingDescriptorsMap;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$1;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$2;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$3;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$4;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$5;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$6;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$7;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$ConnectionComponent;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$Directory;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$InverseMetadataStore;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$MetadataDiskBackedMapManager;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$ShareRoot;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FilesystemLock;
import com.ibm.team.filesystem.client.internal.utils.IPersistentFlag;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.filesystem.client.internal.utils.PersistentFlag;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class SharingMetadata2
implements ISharingMetadata {
    public static final String JAZZLOCK_NAME = ".jazzlock";
    static final FileFilter DIRECTORY_FILTER = new SharingMetadata2$1();
    public static final String SCM_DESCRIPTORS = ".descriptors.dat";
    public static final String SCM_ITEM_INFOS = ".iteminfo.dat";
    public static final String SCM_INVERSE_ITEM_INFOS = ".inverseiteminfo.dat";
    public static final String SCM_LOADED_COMPONENTS = ".components";
    protected static final String SCM_COMPLETED_FLAGS = ".flags";
    protected static final String SCM_FLAG_MAP_MGR = ".mapMgr";
    protected static final String SCM_FLAG_DESCRIPTORS = ".descriptors";
    protected static final String SCM_FLAG_INVERSE_ITEM_INFOS = ".inverseItemInfos";
    protected static final String SCM_FLAG_LOADED_COMPONENTS = ".loadedComponents";
    protected static final String SCM_FLAG_IS_CORRUPT = ".isCorrupt";
    private final IPath cfaRoot;
    private IPath metadataRoot;
    private ReadWriteLock globalLock;
    private AsyncSavePDBHMJob saveDescriptorsJob;
    private AsyncSavePDBHMJob saveInverseMapJob;
    private AsyncSavePDBHMJob saveLoadedComponentsJob;
    private PersistentDiskBackedHashMap descriptors;
    private Map inverseDescriptors;
    private PersistentDiskBackedHashMap inverseItemInfos;
    private Object inverseItemInfosLock;
    private PersistentDiskBackedHashMap loadedComponents;
    private Object loadedComponentsLock;
    private SharingMetadata2$MetadataDiskBackedMapManager mapMgr;
    private PersistentHeapManager heapMgr;
    private boolean isCaseSensitive;
    private final PersistentBusyFlag mapMgrFlag;
    private final PersistentBusyFlag descriptorsFlag;
    private final PersistentBusyFlag inverseItemInfosFlag;
    private final PersistentBusyFlag loadedComponentsFlag;
    private final PersistentBusyFlag persistentMetadataFlag;
    final FilesystemLock fsLock;
    private final Object corruptionLock = new Object();
    private final IPersistentFlag isCorruptFlag;
    final HashSet corruptionListeners = new HashSet();

    public SharingMetadata2(IPath iPath, IPath iPath2) throws FileSystemClientException {
        this.cfaRoot = iPath;
        this.globalLock = new ReadWriteLock();
        this.fsLock = new FilesystemLock(CopyFileAreaManager.getMetadataPathForRoot(this.cfaRoot).append(JAZZLOCK_NAME));
        this.ensureExclusiveCFAAccess(null);
        IPath iPath3 = iPath2.append(SCM_COMPLETED_FLAGS);
        this.mapMgrFlag = new PersistentBusyFlag(iPath3.append(".metadata.isComplete").toFile());
        this.descriptorsFlag = new PersistentBusyFlag(iPath3.append(".descriptors.isComplete").toFile());
        this.inverseItemInfosFlag = new PersistentBusyFlag(iPath3.append(".inverseItemInfos.isComplete").toFile());
        this.loadedComponentsFlag = new PersistentBusyFlag(iPath3.append(".loadedComponents.isComplete").toFile());
        this.persistentMetadataFlag = new PersistentBusyFlag(iPath3.append(".persistentMetadata.isComplete").toFile());
        this.isCorruptFlag = new PersistentFlag(iPath3.append(SCM_FLAG_IS_CORRUPT).toFile());
        this.validateFlags(iPath3);
        this.mapMgr = new SharingMetadata2$MetadataDiskBackedMapManager(this, this.globalLock, this.mapMgrFlag);
        this.heapMgr = new PersistentHeapManager();
        this.saveDescriptorsJob = new SharingMetadata2$2(this, Messages.SharingMetadata2_7, this.descriptorsFlag, this, this);
        this.inverseItemInfosLock = new Object();
        this.saveInverseMapJob = new SharingMetadata2$3(this, Messages.SharingMetadata2_8, this.inverseItemInfosFlag, this.inverseItemInfosLock, this);
        this.loadedComponentsLock = new Object();
        this.saveLoadedComponentsJob = new SharingMetadata2$4(this, Messages.SharingMetadata2_9, this.loadedComponentsFlag, this.loadedComponentsLock, this);
        this.metadataRoot = iPath2;
        this.isCaseSensitive = !iPath.append("a").toFile().equals(iPath.append("A").toFile());
    }

    private void validateFlags(IPath iPath) {
        if (FileSystemCore.isShutDown()) {
            return;
        }
        if (!iPath.toFile().exists()) {
            if (!iPath.toFile().mkdirs()) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_10, null));
                return;
            }
            this.mapMgrFlag.setComplete(null);
            this.descriptorsFlag.setComplete(null);
            this.inverseItemInfosFlag.setComplete(null);
            this.loadedComponentsFlag.setComplete(null);
            this.persistentMetadataFlag.setComplete(null);
            this.setCorrupt(false, "First run", null);
            return;
        }
        if (this.isCorruptFlag.getState() || this.mapMgrFlag.isBusy() || this.descriptorsFlag.isBusy() || this.inverseItemInfosFlag.isBusy() || this.loadedComponentsFlag.isBusy() || this.persistentMetadataFlag.isBusy()) {
            this.setCorrupt(true, "isCorruptFlag: " + this.isCorruptFlag.getState() + " mapMgrFlag: " + this.mapMgrFlag.isBusy() + " descriptorsFlag: " + this.descriptorsFlag.isBusy() + " inverseItemInfosFlag: " + this.inverseItemInfosFlag.isBusy() + " loadedComponentsFlag: " + this.loadedComponentsFlag.isBusy() + " persistentMetadataFlag: " + this.persistentMetadataFlag.isBusy(), null);
        }
    }

    private IPath getLocation(IPath iPath) {
        return this.metadataRoot.append(iPath);
    }

    private void initInverseItemInfos() throws IOException, FileSystemClientException {
        if (this.inverseItemInfos == null) {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            File file = this.metadataRoot.append(SCM_INVERSE_ITEM_INFOS).toFile();
            try {
                this.inverseItemInfos = new SharingMetadata2$InverseMetadataStore(this, file);
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(true, "Corruption on inverseItemItemInfos load: " + file.toString(), dBHMException.getCause());
                throw (Throwable)dBHMException;
            }
            this.inverseItemInfos.persist();
        }
    }

    private void initLoadedComponents() throws IOException, FileSystemClientException {
        if (this.loadedComponents == null) {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            File file = this.metadataRoot.append(SCM_LOADED_COMPONENTS).toFile();
            try {
                this.loadedComponents = new LoadedComponentsStore(this.heapMgr, file);
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(true, "Corruption on loadedComponents load: " + file.toString(), dBHMException.getCause());
                throw (Throwable)dBHMException;
            }
            this.loadedComponents.persist();
        }
    }

    private void initDescriptors() throws IOException, FileSystemClientException {
        if (this.descriptors == null) {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            File file = this.metadataRoot.append(SCM_DESCRIPTORS).toFile();
            try {
                this.descriptors = new SharingDescriptorsMap(file, this.isCaseSensitive);
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(true, "Corruption on descriptors load: " + file.toString(), dBHMException.getCause());
                throw (Throwable)dBHMException;
            }
            this.descriptors.persist();
            this.inverseDescriptors = new HashMap((int)((double)this.descriptors.size() / 0.75));
            for (Map.Entry entry : this.descriptors.entrySet()) {
                Path path = new Path(null, ((StringWrapper)entry.getKey()).toString());
                ISharingDescriptor iSharingDescriptor = (ISharingDescriptor)entry.getValue();
                this.inverseDescriptors.put(new SharingMetadata2$ShareRoot(iSharingDescriptor.getRootVersionable(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle()), path);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void accept(IVisitor iVisitor, IPath iPath, int n, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SharingMetadata2$Directory sharingMetadata2$Directory = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            block13: {
                block12: {
                    block11: {
                        FileItemInfo fileItemInfo;
                        if (iPath.segmentCount() == 0) break block11;
                        sharingMetadata2$Directory = this.loadDirectory(iPath.removeLastSegments(1), bl);
                        try {
                            fileItemInfo = (FileItemInfo)sharingMetadata2$Directory.entries().get(new StringWrapper(iPath.lastSegment(), this.isCaseSensitive));
                        }
                        catch (DBHMException dBHMException) {
                            this.setCorrupt(dBHMException);
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_11, (Object)iPath.toOSString(), (Object[])new Object[0]), dBHMException.getCause())));
                        }
                        if (fileItemInfo != null && !iVisitor.visit(iPath, fileItemInfo, (IProgressMonitor)subMonitor.newChild(5))) break block12;
                    }
                    if (n != 0) break block13;
                }
                if (sharingMetadata2$Directory != null) {
                    this.releaseDirectory(sharingMetadata2$Directory);
                }
                subMonitor.done();
                return;
            }
            this.acceptAll(iVisitor, iPath, n, bl, (IProgressMonitor)subMonitor.newChild(95));
        }
        catch (Throwable throwable) {
            if (sharingMetadata2$Directory != null) {
                this.releaseDirectory(sharingMetadata2$Directory);
            }
            subMonitor.done();
            throw throwable;
        }
        if (sharingMetadata2$Directory != null) {
            this.releaseDirectory(sharingMetadata2$Directory);
        }
        subMonitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptAll(IVisitor iVisitor, IPath iPath, int n, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        SharingMetadata2$Directory sharingMetadata2$Directory = this.loadDirectory(iPath, bl);
        try {
            HashMap hashMap;
            HashSet<StringWrapper> hashSet = new HashSet<StringWrapper>();
            Map map = sharingMetadata2$Directory.entries();
            synchronized (map) {
                hashMap = new HashMap(sharingMetadata2$Directory.entries());
            }
            map = subMonitor.newChild(10);
            map.setWorkRemaining(hashMap.size());
            for (Map.Entry entry : hashMap.entrySet()) {
                FileItemInfo fileItemInfo = (FileItemInfo)entry.getValue();
                StringWrapper stringWrapper = (StringWrapper)entry.getKey();
                IPath iPath2 = iPath.append(stringWrapper.toString());
                if (iVisitor.visit(iPath2, fileItemInfo, (IProgressMonitor)map.newChild(1))) continue;
                hashSet.add(stringWrapper);
            }
            map.done();
            if (n == 1) {
                return;
            }
            try {
                --n;
                IPath[] iPathArray = sharingMetadata2$Directory.children();
                subMonitor.setWorkRemaining(iPathArray.length - hashSet.size());
                int n2 = 0;
                while (n2 < iPathArray.length) {
                    if (!hashSet.contains(new StringWrapper(iPathArray[n2].lastSegment(), this.isCaseSensitive))) {
                        this.acceptAll(iVisitor, iPathArray[n2], n, bl, (IProgressMonitor)subMonitor.newChild(1));
                    }
                    ++n2;
                }
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(dBHMException);
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_12, dBHMException.getCause())));
            }
        }
        finally {
            this.releaseDirectory(sharingMetadata2$Directory);
            subMonitor.done();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPath getRemotePath(IVersionableHandle var1_1, IComponentHandle var2_2, IContextHandle var3_3) throws FileSystemClientException {
        var4_4 = this.inverseItemInfosLock;
        synchronized (var4_4) {
            try {
                this.initInverseItemInfos();
                var6_5 = new ArrayList<String>();
                var8_6 = 0;
                while (true) {
                    block13: {
                        if ((var9_10 = this.getPathForShareRoot(var1_1, var2_2, var3_3)) == null) break block13;
                        var7_12 = var9_10.removeTrailingSeparator().toString();
                        var9_10 = new StringBuffer(var7_12.length() + var8_6 + var6_5.size());
                        var9_10.append(var7_12);
                        var10_11 = var6_5.listIterator(var6_5.size());
                        if (true) ** GOTO lbl47
                    }
                    try {
                        var10_11 = (Map)this.inverseItemInfos.get((Object)var1_1.getItemId().getUuidValue());
                    }
                    catch (DBHMException var11_13) {
                        this.setCorrupt(var11_13);
                        throw (Throwable)var11_13;
                    }
                    if (var10_11 == null) {
                        throw (Throwable)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_13, (Object)var1_1.getItemId().getUuidValue(), (Object[])new Object[0]), null));
                    }
                    var5_7 = (InverseFileItemInfo)var10_11.get(new SharingMetadata2$ConnectionComponent(var3_3, var2_2));
                    if (var5_7 == null) {
                        throw (Throwable)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_14, (Object)var1_1.getItemId().getUuidValue(), (Object[])new Object[0]), null));
                    }
                    if (var5_7.getParent() == null || var5_7.getName() == null) {
                        throw (Throwable)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_15, (Object)var1_1.getItemId().getUuidValue(), (Object[])new Object[0]), null));
                    }
                    var8_6 += var5_7.getName().length();
                    var6_5.add(var5_7.getName());
                    var1_1 = var5_7.getParent();
                }
            }
            catch (DBHMException var5_8) {
                throw (Throwable)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_16, var5_8.getCause()));
                catch (IOException var5_9) {
                    throw (Throwable)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_17, (Throwable)var5_9));
                }
            }
            do {
                var11_14 = (String)var10_11.previous();
                var9_10.append('/');
                var9_10.append(var11_14);
lbl47:
                // 2 sources

            } while (var10_11.hasPrevious());
            return (IPath)new Path(null, var9_10.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(IRemoteVisitor iRemoteVisitor, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, int n, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        this.globalLock.acquireWrite();
        try {
            try {
                Object object = this.inverseItemInfosLock;
                synchronized (object) {
                    this.initInverseItemInfos();
                    ArrayList<IVersionableHandle> arrayList = new ArrayList<IVersionableHandle>();
                    ArrayList<IPath> arrayList2 = new ArrayList<IPath>();
                    ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                    arrayList.add(iVersionableHandle);
                    arrayList2.add(this.getRemotePath(iVersionableHandle, iComponentHandle, iContextHandle));
                    arrayList3.add(0);
                    SharingMetadata2$ConnectionComponent sharingMetadata2$ConnectionComponent = new SharingMetadata2$ConnectionComponent(iContextHandle, iComponentHandle);
                    do {
                        int n2;
                        IVersionableHandle iVersionableHandle2;
                        Map map;
                        if ((map = (Map)this.inverseItemInfos.get((Object)(iVersionableHandle2 = (IVersionableHandle)arrayList.remove(n2 = arrayList.size() - 1)).getItemId().getUuidValue())) == null) {
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_18, (Object)iVersionableHandle2.getItemId().getUuidValue(), (Object[])new Object[0]), null)));
                        }
                        InverseFileItemInfo inverseFileItemInfo = (InverseFileItemInfo)map.get(sharingMetadata2$ConnectionComponent);
                        if (inverseFileItemInfo == null) {
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_19, (Object)iVersionableHandle2.getItemId().getUuidValue(), (Object[])new Object[0]), null)));
                        }
                        IPath iPath = (IPath)arrayList2.remove(n2);
                        Integer n3 = (Integer)arrayList3.remove(n2);
                        subMonitor.setWorkRemaining(arrayList.size() + 1);
                        boolean bl2 = iRemoteVisitor.visit(iPath, inverseFileItemInfo, (IProgressMonitor)subMonitor.newChild(1));
                        if (n == n3 || !bl2) continue;
                        Integer n4 = n3 + 1;
                        for (Map.Entry entry : inverseFileItemInfo.getRemoteChildren().entrySet()) {
                            String string = (String)entry.getKey();
                            IVersionableHandle iVersionableHandle3 = (IVersionableHandle)entry.getValue();
                            arrayList.add(iVersionableHandle3);
                            arrayList2.add(iPath.append(string));
                            arrayList3.add(n4);
                        }
                    } while (!arrayList.isEmpty());
                }
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(dBHMException);
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_20, dBHMException.getCause())));
            }
            catch (IOException iOException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_21, (Throwable)iOException)));
            }
        }
        finally {
            this.globalLock.release();
            subMonitor.done();
        }
    }

    private SharingMetadata2$Directory loadDirectory(IPath iPath, boolean bl) throws FileSystemClientException {
        IPath iPath2 = this.getCanonicalPath(iPath, true);
        try {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            return (SharingMetadata2$Directory)this.mapMgr.loadMap(iPath2, bl, iPath);
        }
        catch (DBHMException dBHMException) {
            this.setCorrupt(true, "Problem reading Directory at " + iPath2, dBHMException.getCause());
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.DiskBackedMapManager_0, dBHMException.getCause())));
        }
    }

    public IPath getCanonicalPath(IPath iPath, boolean bl) {
        if (this.isCaseSensitive || !bl) {
            return iPath.setDevice(null).makeUNC(false).makeAbsolute().removeTrailingSeparator();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = iPath.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            stringBuilder.append('/');
            stringBuilder.append(string.toUpperCase().toLowerCase());
            ++n2;
        }
        return new Path(null, stringBuilder.toString()).makeAbsolute();
    }

    private void releaseDirectory(SharingMetadata2$Directory sharingMetadata2$Directory) throws FileSystemClientException {
        this.mapMgr.releaseMap(sharingMetadata2$Directory);
    }

    public synchronized IPath[] allShares() throws FileSystemClientException {
        try {
            this.initDescriptors();
            return this.inverseDescriptors.values().toArray(new IPath[this.inverseDescriptors.size()]);
        }
        catch (DBHMException dBHMException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_22, dBHMException.getCause())));
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_23, (Throwable)iOException)));
        }
    }

    public synchronized Collection allShares(IPath iPath) throws FileSystemClientException {
        try {
            IPath[] iPathArray;
            this.initDescriptors();
            ArrayList<IPath> arrayList = new ArrayList<IPath>();
            iPath = this.getCanonicalPath(iPath, true);
            IPath[] iPathArray2 = iPathArray = this.allShares();
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath iPath2 = iPathArray2[n2];
                if (iPath.isPrefixOf(this.getCanonicalPath(iPath2, true))) {
                    arrayList.add(iPath2);
                }
                ++n2;
            }
            return arrayList;
        }
        catch (DBHMException dBHMException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_22, dBHMException.getCause())));
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_23, (Throwable)iOException)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws FileSystemClientException {
        this.globalLock.acquireWrite();
        try {
            this.mapMgr.closeAll((IPath)Path.ROOT);
            Object object = this.inverseItemInfosLock;
            synchronized (object) {
                Object object2 = this.loadedComponentsLock;
                synchronized (object2) {
                    SharingMetadata2 sharingMetadata2 = this;
                    synchronized (sharingMetadata2) {
                        try {
                            if (this.descriptors != null) {
                                this.descriptors.close();
                                this.descriptors = null;
                                this.inverseDescriptors = null;
                            }
                            if (this.loadedComponents != null) {
                                this.loadedComponents.close();
                                this.loadedComponents = null;
                            }
                            if (this.inverseItemInfos != null) {
                                this.inverseItemInfos.close();
                                this.inverseItemInfos = null;
                            }
                        }
                        catch (DBHMException dBHMException) {
                            this.setCorrupt(true, "Problem in " + (this.descriptors == null ? "" : "descriptors? ") + (this.loadedComponents == null ? "" : "loadedComponents? ") + (this.inverseItemInfos == null ? "" : "inverseItemInfos?"), dBHMException.getCause());
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_24, dBHMException.getCause())));
                        }
                        catch (IOException iOException) {
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_25, (Throwable)iOException)));
                        }
                        this.releaseExclusiveCFAAccess(null);
                        try {
                            EFS.getLocalFileSystem().getStore(this.metadataRoot).delete(0, null);
                        }
                        catch (CoreException coreException) {
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_26, (Throwable)coreException)));
                        }
                    }
                }
            }
        }
        finally {
            this.globalLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws FileSystemClientException {
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", -1, Messages.SharingMetadata2_27, null);
        this.globalLock.acquireWrite();
        try {
            try {
                Object object = this;
                synchronized (object) {
                    if (this.descriptors != null) {
                        this.descriptors.close();
                        this.descriptors = null;
                        this.inverseDescriptors = null;
                    }
                    this.descriptorsFlag.setComplete(multiStatus);
                }
                object = this.loadedComponentsLock;
                synchronized (object) {
                    if (this.loadedComponents != null) {
                        this.loadedComponents.close();
                        this.loadedComponentsFlag.setComplete(multiStatus);
                        this.loadedComponents = null;
                    }
                    this.loadedComponentsFlag.setComplete(multiStatus);
                }
                object = this.inverseItemInfosLock;
                synchronized (object) {
                    if (this.inverseItemInfos != null) {
                        this.inverseItemInfos.close();
                        this.inverseItemInfos = null;
                    }
                    this.inverseItemInfosFlag.setComplete(multiStatus);
                }
                this.mapMgr.closeAll((IPath)Path.ROOT);
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(true, "Problem in " + (this.descriptors == null ? "" : "descriptors? ") + (this.loadedComponents == null ? "" : "loadedComponents? ") + (this.inverseItemInfos == null ? "" : "inverseItemInfos?"), dBHMException.getCause());
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_28, dBHMException.getCause())));
            }
            catch (IOException iOException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_29, (Throwable)iOException)));
            }
        }
        finally {
            this.globalLock.release();
            if (this.descriptors == null && this.loadedComponents == null && this.inverseItemInfos == null) {
                this.releaseExclusiveCFAAccess(null);
            }
            if (multiStatus.getChildren().length > 0) {
                LoggingHelper.log((IStatus)multiStatus);
            }
        }
    }

    public FileItemInfo deleteFileItemInfo(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo;
        this.globalLock.acquireWrite();
        try {
            SharingMetadata2$Directory sharingMetadata2$Directory;
            block11: {
                if (iPath.segmentCount() != 0) {
                    sharingMetadata2$Directory = this.loadDirectory(iPath.removeLastSegments(1), true);
                    try {
                        try {
                            fileItemInfo = (FileItemInfo)sharingMetadata2$Directory.entries().remove(new StringWrapper(iPath.lastSegment(), this.isCaseSensitive));
                            break block11;
                        }
                        catch (DBHMException dBHMException) {
                            this.setCorrupt(dBHMException);
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_30, dBHMException.getCause())));
                        }
                    }
                    finally {
                        this.releaseDirectory(sharingMetadata2$Directory);
                    }
                }
                fileItemInfo = null;
            }
            this.mapMgr.closeAll(iPath);
            sharingMetadata2$Directory = EFS.getLocalFileSystem().getStore(this.getLocation(iPath));
            try {
                sharingMetadata2$Directory.delete(0, null);
            }
            catch (CoreException coreException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_31, (Throwable)coreException)));
            }
        }
        finally {
            this.globalLock.release();
        }
        return fileItemInfo;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public FileItemInfo getFileItemInfo(IPath iPath) throws FileSystemClientException {
        if (iPath.segmentCount() == 0) {
            return null;
        }
        iPath = iPath.makeAbsolute();
        SharingMetadata2$Directory sharingMetadata2$Directory = this.loadDirectory(iPath.removeLastSegments(1), false);
        try {
            FileItemInfo fileItemInfo = (FileItemInfo)sharingMetadata2$Directory.entries().get(new StringWrapper(iPath.lastSegment(), this.isCaseSensitive));
            return fileItemInfo;
        }
        catch (DBHMException dBHMException) {
            this.setCorrupt(dBHMException);
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_32, dBHMException.getCause())));
        }
        finally {
            this.releaseDirectory(sharingMetadata2$Directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getChildInfos(IPath iPath) throws FileSystemClientException {
        iPath = iPath.makeAbsolute();
        SharingMetadata2$Directory sharingMetadata2$Directory = this.loadDirectory(iPath, false);
        try {
            HashMap hashMap;
            Map map;
            Map map2 = map = sharingMetadata2$Directory.entries();
            synchronized (map2) {
                hashMap = new HashMap(map);
            }
            HashMap hashMap2 = hashMap;
            return hashMap2;
        }
        catch (DBHMException dBHMException) {
            this.setCorrupt(dBHMException);
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_33, dBHMException.getCause())));
        }
        finally {
            this.releaseDirectory(sharingMetadata2$Directory);
        }
    }

    public InverseFileItemInfo getFileItemInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        Object object = this.inverseItemInfosLock;
        synchronized (object) {
            Map map;
            block7: {
                this.initInverseItemInfos();
                map = (Map)this.inverseItemInfos.get((Object)iVersionableHandle.getItemId().getUuidValue());
                if (map != null) break block7;
                return null;
            }
            try {
                return (InverseFileItemInfo)map.get(new SharingMetadata2$ConnectionComponent(iContextHandle, iComponentHandle));
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(dBHMException);
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_34, dBHMException.getCause())));
            }
            catch (IOException iOException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_35, (Throwable)iOException)));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getLocations(IVersionableHandle iVersionableHandle) throws FileSystemClientException {
        Object object = this.inverseItemInfosLock;
        synchronized (object) {
            Map map;
            try {
                this.initInverseItemInfos();
                try {
                    map = (Map)this.inverseItemInfos.get((Object)iVersionableHandle.getItemId().getUuidValue());
                }
                catch (DBHMException dBHMException) {
                    this.setCorrupt(dBHMException);
                    throw (Throwable)dBHMException;
                }
                if (map == null) {
                    return Collections.emptyList();
                }
            }
            catch (DBHMException dBHMException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_36, dBHMException.getCause())));
                catch (IOException iOException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_37, (Throwable)iOException)));
                }
            }
            return new ArrayList(map.keySet());
        }
    }

    public synchronized IPath findConflictingShare(IPath iPath) throws FileSystemClientException {
        this.initDescriptors();
        try {
            iPath = this.getCanonicalPath(iPath, true);
            for (IPath iPath2 : this.inverseDescriptors.values()) {
                IPath iPath3 = this.getCanonicalPath(iPath2, true);
                if (!iPath3.isPrefixOf(iPath) && !iPath.isPrefixOf(iPath3)) continue;
                return iPath3;
            }
            return null;
        }
        catch (DBHMException dBHMException) {
            try {
                this.setCorrupt(dBHMException);
                throw (Throwable)dBHMException;
            }
            catch (DBHMException dBHMException2) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_38, dBHMException2.getCause())));
            }
            catch (IOException iOException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_39, (Throwable)iOException)));
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public synchronized ISharingDescriptor findSharingDescriptor(IPath iPath) throws FileSystemClientException {
        try {
            this.initDescriptors();
            try {
                ISharingDescriptor iSharingDescriptor;
                iPath = this.getCanonicalPath(iPath, false);
                int n = iPath.segmentCount();
                if (n >= 1 && (iSharingDescriptor = (ISharingDescriptor)this.descriptors.get((Object)new StringWrapper(this.getCanonicalPath(iPath.removeLastSegments(n - 1), false).toString(), this.isCaseSensitive))) != null) {
                    return iSharingDescriptor;
                }
                iSharingDescriptor = (ISharingDescriptor)this.descriptors.get((Object)new StringWrapper(this.getCanonicalPath((IPath)Path.ROOT, false).toString(), this.isCaseSensitive));
                if (iSharingDescriptor != null) {
                    return iSharingDescriptor;
                }
                if (n <= 1) {
                    return null;
                }
                n -= 2;
                do {
                    if ((iSharingDescriptor = (ISharingDescriptor)this.descriptors.get((Object)new StringWrapper(this.getCanonicalPath(iPath.removeLastSegments(n), false).toString(), this.isCaseSensitive))) == null) continue;
                    return iSharingDescriptor;
                } while (n-- != 0);
                return null;
            }
            catch (DBHMException dBHMException) {
                try {
                    this.setCorrupt(dBHMException);
                    throw (Throwable)dBHMException;
                }
                catch (DBHMException dBHMException2) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_38, dBHMException2.getCause())));
                }
            }
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_39, (Throwable)iOException)));
        }
    }

    public synchronized ISharingMetadata$ISharingDescriptorPath findSharingDescriptorPath(IPath iPath) throws FileSystemClientException {
        ISharingDescriptor iSharingDescriptor = this.findSharingDescriptor(iPath);
        if (iSharingDescriptor == null) {
            return null;
        }
        IPath iPath2 = (IPath)this.inverseDescriptors.get(new SharingMetadata2$ShareRoot(iSharingDescriptor.getRootVersionable(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle()));
        return new SharingMetadata2$5(this, iSharingDescriptor, iPath2);
    }

    public synchronized ISharingDescriptor getSharingDescriptor(IPath iPath) throws FileSystemClientException {
        try {
            this.initDescriptors();
            try {
                return (ISharingDescriptor)this.descriptors.get((Object)new StringWrapper(this.getCanonicalPath(iPath, false).toString(), this.isCaseSensitive));
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(dBHMException);
                throw (Throwable)dBHMException;
            }
        }
        catch (DBHMException dBHMException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_38, dBHMException.getCause())));
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_39, (Throwable)iOException)));
        }
    }

    private void setCorrupt(DBHMException dBHMException) {
        this.setCorrupt(true, null, dBHMException.getCause());
    }

    public synchronized IPath getPathForShareRoot(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        try {
            this.initDescriptors();
            try {
                return (IPath)this.inverseDescriptors.get(new SharingMetadata2$ShareRoot(iVersionableHandle, iComponentHandle, iContextHandle));
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(dBHMException);
                throw (Throwable)dBHMException;
            }
        }
        catch (DBHMException dBHMException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_40, dBHMException.getCause())));
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_41, (Throwable)iOException)));
        }
    }

    public FileItemInfo moveFileItemInfo(IPath iPath, IPath iPath2) throws FileSystemClientException {
        FileItemInfo fileItemInfo;
        block17: {
            Assert.isLegal((!(iPath = this.getCanonicalPath(iPath, false)).equals((Object)(iPath2 = this.getCanonicalPath(iPath2, false))) ? 1 : 0) != 0);
            IPath iPath3 = this.getCanonicalPath(iPath, true);
            IPath iPath4 = this.getCanonicalPath(iPath2, true);
            if (!iPath3.equals((Object)iPath4)) {
                Assert.isLegal((!iPath3.isPrefixOf(iPath4) ? 1 : 0) != 0);
                Assert.isLegal((!iPath4.isPrefixOf(iPath3) ? 1 : 0) != 0);
            }
            this.globalLock.acquireWrite();
            try {
                IPath iPath5;
                IPath iPath6 = iPath3.removeLastSegments(1);
                SharingMetadata2$Directory sharingMetadata2$Directory = this.loadDirectory(iPath6, true);
                try {
                    iPath5 = iPath4.removeLastSegments(1);
                    boolean bl = iPath6.equals((Object)iPath5);
                    SharingMetadata2$Directory sharingMetadata2$Directory2 = bl ? sharingMetadata2$Directory : this.loadDirectory(iPath5, true);
                    try {
                        try {
                            fileItemInfo = (FileItemInfo)sharingMetadata2$Directory.entries().remove(new StringWrapper(iPath.lastSegment(), this.isCaseSensitive));
                            if (fileItemInfo != null) {
                                sharingMetadata2$Directory2.entries().put(new StringWrapper(iPath2.lastSegment(), this.isCaseSensitive), fileItemInfo);
                            }
                        }
                        catch (DBHMException dBHMException) {
                            this.setCorrupt(dBHMException);
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_42, dBHMException.getCause())));
                        }
                    }
                    finally {
                        if (!bl) {
                            this.releaseDirectory(sharingMetadata2$Directory2);
                        }
                    }
                }
                finally {
                    this.releaseDirectory(sharingMetadata2$Directory);
                }
                this.mapMgr.closeAll(iPath3);
                this.mapMgr.closeAll(iPath4);
                iPath5 = EFS.getLocalFileSystem().getStore(this.getLocation(iPath));
                IFileStore iFileStore = EFS.getLocalFileSystem().getStore(this.getLocation(iPath2));
                if (!iPath5.fetchInfo().exists()) break block17;
                try {
                    iPath5.move(iFileStore, 0, null);
                }
                catch (CoreException coreException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_43, (Throwable)coreException)));
                }
            }
            finally {
                this.globalLock.release();
            }
        }
        return fileItemInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ISharingMetadata$ITransaction iSharingMetadata$ITransaction) throws FileSystemClientException {
        this.globalLock.acquireWrite();
        try {
            Object object = this.inverseItemInfosLock;
            synchronized (object) {
                Object object2 = this.loadedComponentsLock;
                synchronized (object2) {
                    SharingMetadata2 sharingMetadata2 = this;
                    synchronized (sharingMetadata2) {
                        iSharingMetadata$ITransaction.run();
                    }
                }
            }
        }
        finally {
            this.globalLock.release();
        }
    }

    public FileItemInfo setFileItemInfo(IPath iPath, FileItemInfo fileItemInfo) throws FileSystemClientException {
        iPath = iPath.makeAbsolute();
        SharingMetadata2$Directory sharingMetadata2$Directory = this.loadDirectory(iPath.removeLastSegments(1), true);
        try {
            FileItemInfo fileItemInfo2 = fileItemInfo == null ? (FileItemInfo)sharingMetadata2$Directory.entries().remove(new StringWrapper(iPath.lastSegment(), this.isCaseSensitive)) : sharingMetadata2$Directory.entries().put(new StringWrapper(iPath.lastSegment(), this.isCaseSensitive), fileItemInfo);
            FileItemInfo fileItemInfo3 = fileItemInfo2;
            return fileItemInfo3;
        }
        catch (DBHMException dBHMException) {
            this.setCorrupt(dBHMException);
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_44, dBHMException.getCause())));
        }
        finally {
            this.releaseDirectory(sharingMetadata2$Directory);
        }
    }

    public InverseFileItemInfo setFileItemInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, InverseFileItemInfo inverseFileItemInfo) throws FileSystemClientException {
        Object object = this.inverseItemInfosLock;
        synchronized (object) {
            try {
                this.initInverseItemInfos();
                try {
                    this.setBusy(this.inverseItemInfosFlag);
                    Map map = (Map)this.inverseItemInfos.get((Object)iVersionableHandle.getItemId().getUuidValue());
                    if (map == null) {
                        map = Collections.emptyMap();
                    }
                    LinkedHashMap<SharingMetadata2$ConnectionComponent, InverseFileItemInfo> linkedHashMap = new LinkedHashMap<SharingMetadata2$ConnectionComponent, InverseFileItemInfo>(map);
                    SharingMetadata2$ConnectionComponent sharingMetadata2$ConnectionComponent = new SharingMetadata2$ConnectionComponent((IContextHandle)iContextHandle.getItemType().createItemHandle(iContextHandle.getItemId(), null), (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(iComponentHandle.getItemId(), null));
                    InverseFileItemInfo inverseFileItemInfo2 = (InverseFileItemInfo)map.get(sharingMetadata2$ConnectionComponent);
                    if (inverseFileItemInfo == null) {
                        linkedHashMap.remove(sharingMetadata2$ConnectionComponent);
                    } else {
                        linkedHashMap.put(sharingMetadata2$ConnectionComponent, inverseFileItemInfo);
                    }
                    if (linkedHashMap.isEmpty()) {
                        this.inverseItemInfos.remove((Object)iVersionableHandle.getItemId().getUuidValue());
                    } else {
                        this.inverseItemInfos.put((Object)iVersionableHandle.getItemId().getUuidValue(), linkedHashMap);
                    }
                    this.saveInverseMapJob.requestSave();
                    return inverseFileItemInfo2;
                }
                catch (DBHMException dBHMException) {
                    this.setCorrupt(dBHMException);
                    throw (Throwable)dBHMException;
                }
            }
            catch (DBHMException dBHMException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_45, dBHMException.getCause())));
            }
            catch (IOException iOException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_46, (Throwable)iOException)));
            }
        }
    }

    public synchronized ISharingDescriptor setSharingDescriptor(IPath iPath, ISharingDescriptor iSharingDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        try {
            this.initDescriptors();
            try {
                ISharingDescriptor iSharingDescriptor2;
                this.setBusy(this.descriptorsFlag);
                iPath = this.getCanonicalPath(iPath, false);
                if (iSharingDescriptor == null) {
                    iSharingDescriptor2 = (ISharingDescriptor)this.descriptors.remove((Object)new StringWrapper(iPath.toString(), this.isCaseSensitive));
                    if (iSharingDescriptor2 != null) {
                        this.inverseDescriptors.remove(new SharingMetadata2$ShareRoot(iSharingDescriptor2.getRootVersionable(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle()));
                    }
                } else {
                    Object object;
                    iSharingDescriptor2 = (ISharingDescriptor)this.descriptors.put((Object)new StringWrapper(iPath.toString(), this.isCaseSensitive), (Object)iSharingDescriptor);
                    SharingMetadata2$ShareRoot sharingMetadata2$ShareRoot = new SharingMetadata2$ShareRoot(iSharingDescriptor.getRootVersionable(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                    if (iSharingDescriptor2 != null && !((SharingMetadata2$ShareRoot)(object = new SharingMetadata2$ShareRoot(iSharingDescriptor2.getRootVersionable(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle()))).equals(sharingMetadata2$ShareRoot)) {
                        this.inverseDescriptors.remove(object);
                    }
                    if ((object = this.inverseDescriptors.put(sharingMetadata2$ShareRoot, iPath)) != null && !iPath.equals(object) && !this.getCanonicalPath(iPath, true).equals((Object)this.getCanonicalPath((IPath)object, true))) {
                        throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.SharingMetadata2_47, (Object[])new Object[]{object, iPath}, (Object[])new Object[0]))));
                    }
                }
                this.saveDescriptorsJob.requestSave();
                return iSharingDescriptor2;
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(dBHMException);
                throw (Throwable)dBHMException;
            }
        }
        catch (DBHMException dBHMException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_48, dBHMException.getCause())));
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_49, (Throwable)iOException)));
        }
    }

    private void setBusy(PersistentBusyFlag persistentBusyFlag) {
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", -1, NLS.bind((String)Messages.SharingMetadata2_50, (Object)persistentBusyFlag, (Object[])new Object[0]), null);
        persistentBusyFlag.setBusy(multiStatus);
        if (!multiStatus.isOK()) {
            LoggingHelper.log((IStatus)multiStatus);
        }
    }

    public synchronized Map getSharingDescriptors(IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        try {
            Set set;
            this.initDescriptors();
            HashMap<Path, ISharingDescriptor> hashMap = new HashMap<Path, ISharingDescriptor>();
            try {
                set = this.descriptors.entrySet();
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(dBHMException);
                throw (Throwable)dBHMException;
            }
            for (Map.Entry entry : set) {
                ISharingDescriptor iSharingDescriptor = (ISharingDescriptor)entry.getValue();
                if (iSharingDescriptor == null || !iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iContextHandle) || !iSharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle)) continue;
                hashMap.put(new Path(null, ((StringWrapper)entry.getKey()).toString()), iSharingDescriptor);
            }
            return hashMap;
        }
        catch (DBHMException dBHMException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_51, dBHMException.getCause())));
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_52, (Throwable)iOException)));
        }
    }

    public synchronized Map getSharingDescriptors() throws FileSystemClientException {
        try {
            Set set;
            this.initDescriptors();
            HashMap<Path, ISharingDescriptor> hashMap = new HashMap<Path, ISharingDescriptor>();
            try {
                set = this.descriptors.entrySet();
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(dBHMException);
                throw (Throwable)dBHMException;
            }
            for (Map.Entry entry : set) {
                ISharingDescriptor iSharingDescriptor = (ISharingDescriptor)entry.getValue();
                hashMap.put(new Path(null, ((StringWrapper)entry.getKey()).toString()), iSharingDescriptor);
            }
            return hashMap;
        }
        catch (DBHMException dBHMException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_51, dBHMException.getCause())));
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_52, (Throwable)iOException)));
        }
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.accept(new SharingMetadata2$6(this, stringBuffer), (IPath)Path.ROOT, Integer.MAX_VALUE, false, null);
        }
        catch (FileSystemClientException fileSystemClientException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            fileSystemClientException.printStackTrace(printWriter);
            printWriter.flush();
            stringBuffer.append(stringWriter);
        }
        return stringBuffer.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection allLoadedComponents(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                this.initLoadedComponents();
                return new ArrayList(this.loadedComponents.values());
            }
            catch (DBHMException dBHMException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_53, dBHMException.getCause())));
                catch (IOException iOException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_54, (Throwable)iOException)));
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection allLoadedContexts(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                this.initLoadedComponents();
                HashSet<ConnectionDescriptor> hashSet = new HashSet<ConnectionDescriptor>();
                Iterator iterator = this.loadedComponents.values().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return hashSet;
                    }
                    ConfigurationDescriptor configurationDescriptor = (ConfigurationDescriptor)iterator.next();
                    hashSet.add(new ConnectionDescriptor(configurationDescriptor.id, configurationDescriptor.uri, configurationDescriptor.connectionHandle));
                }
            }
            catch (DBHMException dBHMException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_55, dBHMException.getCause())));
                catch (IOException iOException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_56, (Throwable)iOException)));
                }
            }
        }
    }

    public LoadedConfigurationDescriptor componentLoaded(LoadedConfigurationDescriptor loadedConfigurationDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                this.initLoadedComponents();
                this.setBusy(this.loadedComponentsFlag);
                LoadedConfigurationDescriptor loadedConfigurationDescriptor2 = (LoadedConfigurationDescriptor)this.loadedComponents.put((Object)new SharingMetadata2$ConnectionComponent(loadedConfigurationDescriptor.connectionHandle, loadedConfigurationDescriptor.componentHandle), (Object)loadedConfigurationDescriptor);
                this.saveLoadedComponentsJob.requestSave();
                return loadedConfigurationDescriptor2;
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(dBHMException);
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_57, dBHMException.getCause())));
            }
            catch (IOException iOException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_58, (Throwable)iOException)));
            }
        }
    }

    public LoadedConfigurationDescriptor componentUnloaded(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                LoadedConfigurationDescriptor loadedConfigurationDescriptor;
                this.initLoadedComponents();
                this.setBusy(this.loadedComponentsFlag);
                try {
                    loadedConfigurationDescriptor = (LoadedConfigurationDescriptor)this.loadedComponents.remove((Object)new SharingMetadata2$ConnectionComponent(iContextHandle, iComponentHandle));
                }
                catch (DBHMException dBHMException) {
                    this.setCorrupt(dBHMException);
                    throw (Throwable)dBHMException;
                }
                this.saveLoadedComponentsJob.requestSave();
                return loadedConfigurationDescriptor;
            }
            catch (DBHMException dBHMException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_59, dBHMException.getCause())));
            }
            catch (IOException iOException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_60, (Throwable)iOException)));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean hasShares(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        try {
            SharingMetadata2$ShareRoot sharingMetadata2$ShareRoot;
            this.initDescriptors();
            Iterator iterator = this.inverseDescriptors.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!SharingMetadata2$ShareRoot.access$0(sharingMetadata2$ShareRoot = (SharingMetadata2$ShareRoot)iterator.next()).getComponent().sameItemId((IItemHandle)iComponentHandle) || !SharingMetadata2$ShareRoot.access$0(sharingMetadata2$ShareRoot).getConnection().sameItemId((IItemHandle)iContextHandle));
            return true;
        }
        catch (DBHMException dBHMException) {
            this.setCorrupt(dBHMException);
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_61, dBHMException.getCause())));
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_62, (Throwable)iOException)));
        }
    }

    public boolean isLoaded(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                this.initLoadedComponents();
                try {
                    return this.loadedComponents.containsKey((Object)new SharingMetadata2$ConnectionComponent(iContextHandle, iComponentHandle));
                }
                catch (DBHMException dBHMException) {
                    this.setCorrupt(dBHMException);
                    throw (Throwable)dBHMException;
                }
            }
            catch (DBHMException dBHMException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_63, dBHMException.getCause())));
            }
            catch (IOException iOException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.SharingMetadata2_64, (Throwable)iOException)));
            }
        }
    }

    public PersistentBusyFlag getPersistentMetadataFlag() {
        return this.persistentMetadataFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCorruptionListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) {
        Object object = this.corruptionLock;
        synchronized (object) {
            if (this.isCorruptFlag.getState()) {
                iCorruptCopyFileAreaListener.corrupt(this.getCorruptionEvent());
            }
            this.corruptionListeners.add(iCorruptCopyFileAreaListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCorruptionListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) {
        Object object = this.corruptionLock;
        synchronized (object) {
            this.corruptionListeners.remove(iCorruptCopyFileAreaListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorrupt(boolean bl, String string, Throwable throwable) {
        if (FileSystemCore.isShutDown()) {
            return;
        }
        Object object = this.corruptionLock;
        synchronized (object) {
            if (bl == this.isCorruptFlag.getState()) {
                return;
            }
            try {
                this.isCorruptFlag.setState(bl);
            }
            catch (IOException iOException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, "Could not write corruption bit", (Throwable)iOException));
            }
            if (bl) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, string == null ? null : string, throwable));
            }
            ICorruptCopyFileAreaEvent iCorruptCopyFileAreaEvent = this.getCorruptionEvent();
            for (ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener : this.corruptionListeners) {
                iCorruptCopyFileAreaListener.corrupt(iCorruptCopyFileAreaEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ICorruptCopyFileAreaEvent getCorruptionEvent() {
        Object object = this.corruptionLock;
        synchronized (object) {
            boolean bl = this.isCorruptFlag.getState();
            return new SharingMetadata2$7(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCorrupted() {
        Object object = this.corruptionLock;
        synchronized (object) {
            return this.isCorruptFlag.getState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureExclusiveCFAAccess(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FilesystemLock filesystemLock = this.fsLock;
        synchronized (filesystemLock) {
            if (!this.fsLock.isAcquired() && !this.fsLock.acquire(iProgressMonitor)) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 209, NLS.bind((String)Messages.CopyFileArea_LOCK_FAILED_ON_PATH, (Object)this.fsLock.getFile().getAbsolutePath(), (Object[])new Object[0]), null)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseExclusiveCFAAccess(IProgressMonitor iProgressMonitor) {
        FilesystemLock filesystemLock = this.fsLock;
        synchronized (filesystemLock) {
            this.fsLock.release(iProgressMonitor);
        }
    }

    public boolean isSamePath(IPath iPath, IPath iPath2) {
        return this.getCanonicalPath(iPath, true).equals((Object)this.getCanonicalPath(iPath2, true));
    }

    static /* synthetic */ PersistentHeapManager access$0(SharingMetadata2 sharingMetadata2) {
        return sharingMetadata2.heapMgr;
    }

    static /* synthetic */ boolean access$1(SharingMetadata2 sharingMetadata2) {
        return sharingMetadata2.isCaseSensitive;
    }

    static /* synthetic */ IPath access$2(SharingMetadata2 sharingMetadata2, IPath iPath) {
        return sharingMetadata2.getLocation(iPath);
    }

    static /* synthetic */ void access$3(SharingMetadata2 sharingMetadata2, DBHMException dBHMException) {
        sharingMetadata2.setCorrupt(dBHMException);
    }

    static /* synthetic */ PersistentDiskBackedHashMap access$4(SharingMetadata2 sharingMetadata2) {
        return sharingMetadata2.descriptors;
    }

    static /* synthetic */ PersistentDiskBackedHashMap access$5(SharingMetadata2 sharingMetadata2) {
        return sharingMetadata2.inverseItemInfos;
    }

    static /* synthetic */ PersistentDiskBackedHashMap access$6(SharingMetadata2 sharingMetadata2) {
        return sharingMetadata2.loadedComponents;
    }

    static /* synthetic */ IPath access$7(SharingMetadata2 sharingMetadata2) {
        return sharingMetadata2.cfaRoot;
    }
}

