/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.SharingMetadata2;
import com.ibm.team.filesystem.client.internal.Store;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

class SharingMetadata2$MetadataStore
extends Store {
    private static final int METADATA_VERSION = 1;
    private static final int IS_FOLDER = 1;
    private static final int IS_CONTENT_CHANGED = 2;
    private static final int HAS_PARENT = 4;
    private static final int IS_REMOTE = 8;
    private static final int IS_ORIGINAL_EXECUTABLE = 16;
    private static final int HAS_LINE_DELIMITER = 32;
    private static final int HAS_CURRENT_PROPERTIES = 64;
    private static final int IS_EXECUTABLE = 128;
    private static final int HAS_PREDECESSOR_HINT_HASH = 256;
    private static final int HAS_ORIGINAL_ENCODING = 512;
    private static final int HAS_ORIGINAL_PROPERTIES = 1024;
    private static final int HAS_LAST_CONTENT_CHANGE_CHECK_STAMP = 2048;
    private static final int IS_LOADED_WITH_ANOTHER_NAME = 4096;
    private static final int IS_SYMBOLIC_LINK = 8192;
    final /* synthetic */ SharingMetadata2 this$0;

    public SharingMetadata2$MetadataStore(SharingMetadata2 sharingMetadata2, File file) {
        this.this$0 = sharingMetadata2;
        super(file, SharingMetadata2.access$0(sharingMetadata2));
    }

    protected void writeCustomMetadata(DataOutputStream dataOutputStream) throws IOException {
        super.writeCustomMetadata(dataOutputStream);
        dataOutputStream.writeInt(1);
    }

    protected void readCustomMetadata(DataInputStream dataInputStream) throws IOException {
        super.readCustomMetadata(dataInputStream);
        int n = dataInputStream.readInt();
        if (n != 1) {
            throw (Throwable)new IllegalArgumentException("Metadata version mismatch " + n + " != " + 1);
        }
    }

    protected long persistStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        long l = this.heap.allocate((long)byteArrayOutputStream.size());
        byteArrayOutputStream.writeTo(this.heap.getOutputStream(l));
        return l;
    }

    protected long writeObject(Object object, int n) throws IOException {
        boolean bl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if ((n & 1) != 0) {
            dataOutputStream.writeUTF(object.toString());
            return this.persistStream(byteArrayOutputStream);
        }
        FileItemInfo fileItemInfo = (FileItemInfo)object;
        boolean bl2 = fileItemInfo.getVersionableHandle().hasStateId();
        int n2 = bl2 ? 8 : 0;
        boolean bl3 = bl = fileItemInfo.getParent() != null;
        if (bl) {
            n2 |= 4;
        }
        boolean bl4 = fileItemInfo.isFolder();
        boolean bl5 = fileItemInfo.isFile();
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        if (bl4) {
            n2 |= 1;
        } else if (bl5) {
            if (fileItemInfo.isContentChanged()) {
                n2 |= 2;
            }
            if (fileItemInfo.isOriginalExecutable()) {
                n2 |= 0x10;
            }
            if (fileItemInfo.getLineDelimiter() != null) {
                bl6 = true;
                n2 |= 0x20;
            }
            if (fileItemInfo.getContentType() != null) {
                bl7 = true;
                n2 |= 0x40;
            }
            if (bl2) {
                n2 |= 0x400;
            }
            if (fileItemInfo.isExecutable()) {
                n2 |= 0x80;
            }
            if (fileItemInfo.getStoredPredecessorHintHash() != null) {
                bl8 = true;
                n2 |= 0x100;
            }
            if (fileItemInfo.getStoredEncoding() != null) {
                bl9 = true;
                n2 |= 0x200;
            }
            if (fileItemInfo.getStoredNumLineDelimiters() != -1L) {
                bl10 = true;
            }
            if (fileItemInfo.getLastContentChangeCheckStamp() != -1L) {
                bl11 = true;
                n2 |= 0x800;
            }
        } else {
            n2 |= 0x2000;
            if (fileItemInfo.isContentChanged()) {
                n2 |= 2;
            }
        }
        if (fileItemInfo.isLoadedWithAnotherName()) {
            n2 |= 0x1000;
        }
        dataOutputStream.writeShort(n2);
        IVersionableHandle iVersionableHandle = fileItemInfo.getVersionableHandle();
        dataOutputStream.writeUTF(iVersionableHandle.getItemId().getUuidValue());
        if (bl2) {
            dataOutputStream.writeUTF(iVersionableHandle.getStateId().getUuidValue());
        }
        if (bl) {
            dataOutputStream.writeUTF(fileItemInfo.getParent().getItemId().getUuidValue());
            dataOutputStream.writeUTF(fileItemInfo.getName());
        }
        if (bl5) {
            if (bl6) {
                dataOutputStream.writeInt(fileItemInfo.getLineDelimiter().dbValue());
            }
            if (bl7) {
                dataOutputStream.writeInt(1);
                dataOutputStream.writeUTF("contentType");
                dataOutputStream.writeUTF(fileItemInfo.getContentType());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (bl2) {
                if (bl11) {
                    dataOutputStream.writeLong(fileItemInfo.getLastContentChangeCheckStamp());
                }
                dataOutputStream.writeUTF(fileItemInfo.getHash().toString());
                dataOutputStream.writeLong(fileItemInfo.getContentLength());
                dataOutputStream.writeInt(fileItemInfo.getOriginalLineDelimiter().dbValue());
                dataOutputStream.writeInt(1);
                dataOutputStream.writeUTF("contentType");
                dataOutputStream.writeUTF(fileItemInfo.getOriginalContentType());
                if (bl8) {
                    dataOutputStream.writeUTF(fileItemInfo.getStoredPredecessorHintHash().toString());
                }
                dataOutputStream.writeLong(fileItemInfo.getStoredSize());
                if (bl9) {
                    dataOutputStream.writeUTF(fileItemInfo.getStoredEncoding());
                }
                dataOutputStream.writeUTF(fileItemInfo.getStoredHash().toString());
                if (bl10) {
                    dataOutputStream.writeInt(1);
                    dataOutputStream.writeUTF("numLineDelim");
                    dataOutputStream.writeUTF(Long.toString(fileItemInfo.getStoredNumLineDelimiters()));
                } else {
                    dataOutputStream.writeInt(0);
                }
            }
        } else if (!bl4 && bl2) {
            dataOutputStream.writeUTF(fileItemInfo.getHash().toString());
            dataOutputStream.writeUTF(fileItemInfo.getStoredHash().toString());
        }
        return this.persistStream(byteArrayOutputStream);
    }

    protected Object readObject(InputStream inputStream, int n) throws IOException, ClassNotFoundException {
        long l;
        String string;
        ContentHash contentHash;
        String string2;
        FileLineDelimiter fileLineDelimiter;
        long l2;
        boolean bl;
        boolean bl2;
        String string3;
        FileLineDelimiter fileLineDelimiter2;
        long l3;
        long l4;
        ContentHash contentHash2;
        ContentHash contentHash3;
        boolean bl3;
        String string4;
        IFolderHandle iFolderHandle;
        UUID uUID;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if ((n & 1) != 0) {
            return new StringWrapper(dataInputStream.readUTF(), SharingMetadata2.access$1(this.this$0));
        }
        short s = dataInputStream.readShort();
        boolean bl4 = (s & 8) != 0;
        UUID uUID2 = UUID.valueOf((String)dataInputStream.readUTF());
        UUID uUID3 = bl4 ? UUID.valueOf((String)dataInputStream.readUTF()) : null;
        if ((s & 4) != 0) {
            uUID = UUID.valueOf((String)dataInputStream.readUTF());
            iFolderHandle = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(uUID, null);
            string4 = dataInputStream.readUTF();
        } else {
            iFolderHandle = null;
            string4 = null;
        }
        boolean bl5 = (s & 0x1000) != 0;
        if ((s & 0x2000) != 0) {
            uUID = (ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle(uUID2, uUID3);
            boolean bl6 = bl3 = (s & 2) != 0;
            if (bl4) {
                contentHash3 = ContentHash.valueOf((String)dataInputStream.readUTF());
                contentHash2 = ContentHash.valueOf((String)dataInputStream.readUTF());
            } else {
                bl3 = false;
                contentHash3 = null;
                contentHash2 = null;
            }
            l4 = -1L;
            l3 = -1L;
            fileLineDelimiter2 = null;
            string3 = null;
            bl2 = false;
            bl = false;
            l2 = -1L;
            fileLineDelimiter = null;
            string2 = null;
            contentHash = null;
            string = null;
            l = -1L;
        } else if ((s & 1) != 0) {
            uUID = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(uUID2, uUID3);
            bl3 = false;
            l3 = -1L;
            contentHash3 = null;
            l4 = -1L;
            contentHash2 = null;
            fileLineDelimiter2 = null;
            string3 = null;
            bl2 = false;
            bl = false;
            l2 = -1L;
            fileLineDelimiter = null;
            string2 = null;
            contentHash = null;
            string = null;
            l = -1L;
        } else {
            String string5;
            String string6;
            int n2;
            int n3;
            uUID = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(uUID2, uUID3);
            bl3 = (s & 2) != 0;
            bl2 = (s & 0x80) != 0;
            bl = (s & 0x10) != 0;
            fileLineDelimiter2 = (s & 0x20) != 0 ? FileLineDelimiter.getLineDelimiter((int)dataInputStream.readInt()) : null;
            string3 = null;
            if ((s & 0x40) != 0) {
                n3 = dataInputStream.readInt();
                n2 = 0;
                while (n2 < n3) {
                    string6 = dataInputStream.readUTF();
                    string5 = dataInputStream.readUTF();
                    if (string6.equals("contentType")) {
                        string3 = string5;
                    }
                    ++n2;
                }
            }
            if (bl4) {
                l3 = (s & 0x800) != 0 ? dataInputStream.readLong() : -1L;
                contentHash3 = ContentHash.valueOf((String)dataInputStream.readUTF());
                l2 = dataInputStream.readLong();
                fileLineDelimiter = FileLineDelimiter.getLineDelimiter((int)dataInputStream.readInt());
                string2 = null;
                if ((s & 0x400) != 0) {
                    n3 = dataInputStream.readInt();
                    n2 = 0;
                    while (n2 < n3) {
                        string6 = dataInputStream.readUTF();
                        string5 = dataInputStream.readUTF();
                        if (string6.equals("contentType")) {
                            string2 = string5;
                        }
                        ++n2;
                    }
                }
                contentHash = (s & 0x100) != 0 ? ContentHash.valueOf((String)dataInputStream.readUTF()) : null;
                l4 = dataInputStream.readLong();
                string = (s & 0x200) != 0 ? dataInputStream.readUTF() : null;
                contentHash2 = ContentHash.valueOf((String)dataInputStream.readUTF());
                l = -1L;
                n3 = dataInputStream.readInt();
                n2 = 0;
                while (n2 < n3) {
                    string6 = dataInputStream.readUTF();
                    string5 = dataInputStream.readUTF();
                    if (string6.equals("numLineDelim")) {
                        l = Long.parseLong(string5);
                    }
                    ++n2;
                }
            } else {
                l3 = -1L;
                contentHash3 = null;
                l2 = -1L;
                fileLineDelimiter = null;
                string2 = null;
                contentHash = null;
                l4 = -1L;
                string = null;
                contentHash2 = null;
                l = -1L;
            }
        }
        return new FileItemInfo((IVersionableHandle)uUID, bl3, l3, iFolderHandle, string4, bl5, contentHash3, l2, fileLineDelimiter, fileLineDelimiter2, string2, string3, contentHash, l4, string, contentHash2, l, bl2, bl);
    }
}

