/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ISharingManager$RuleKind;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.RestoreVersionableOperation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager$$Cold;
import com.ibm.team.filesystem.client.internal.SharingManager$1;
import com.ibm.team.filesystem.client.internal.SharingManager$2;
import com.ibm.team.filesystem.client.internal.SharingManager$CoreRunnable;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.magic.LocalContentExaminer;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class SharingManager
implements ISharingManager {
    public static final int NONE = 0;
    public static final int OVERWRITE = 1;
    public static final int UPDATE = 2;
    public static final int LOAD_CHANGES = 4;
    private static final ThreadLocal changeMonitoring = new SharingManager$1();
    protected static volatile SharingManager instance;
    public static final String PT_SHARING_MANAGER = "sharingManager";
    public static final String PT_CONTENT_EXAMINER = "contentExaminer";
    private IContentExaminer contentExaminer;

    protected SharingManager() {
    }

    public void addListener(ICopyFileAreaListener iCopyFileAreaListener) {
        ICopyFileAreaManager.instance.addListener(iCopyFileAreaListener);
    }

    public void removeListener(ICopyFileAreaListener iCopyFileAreaListener) {
        ICopyFileAreaManager.instance.removeListener(iCopyFileAreaListener);
    }

    public Shareable findShareable(ISandbox iSandbox, IPath iPath, ResourceType resourceType) {
        return new Shareable(iSandbox, iPath, resourceType);
    }

    protected void shutDown() throws FileSystemClientException {
    }

    public static void conditionalShutDown() throws FileSystemClientException {
        SharingManager sharingManager = instance;
        if (sharingManager != null) {
            sharingManager.shutDown();
        }
    }

    IMetadataChangeTracker getChangeTracker(CopyFileArea copyFileArea) {
        return (IMetadataChangeTracker)((Object)copyFileArea.internalGetMetadata());
    }

    public ILocalChangeManager getLocalChangeManager() {
        return LocalChangeManager.getInstance();
    }

    public IIgnoreManager getIgnoreManager() {
        return IgnoreManager.getInstance();
    }

    public void addListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) {
        ICopyFileAreaManager.instance.addCorruptionListener(iCorruptCopyFileAreaListener);
    }

    public void removeListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) {
        ICopyFileAreaManager.instance.removeCorruptionListener(iCorruptCopyFileAreaListener);
    }

    public ISchedulingRule getTrackingRule(IPath iPath) {
        return null;
    }

    public void runWithinFileSystemLock(IRunnableWithProgress iRunnableWithProgress, ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        iRunnableWithProgress.run(iProgressMonitor);
    }

    public void restoreFile(IShareable iShareable, InputStream inputStream, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException, IOException {
        RestoreVersionableOperation.restoreFile(iShareable, inputStream, iVersionableHandle, iProgressMonitor);
    }

    public void restoreFolder(IShareable iShareable, IFolderHandle iFolderHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        RestoreVersionableOperation.restoreFolder(iShareable, iFolderHandle, iProgressMonitor);
    }

    public void restoreLink(IShareable iShareable, String string, ISymbolicLinkHandle iSymbolicLinkHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        RestoreVersionableOperation.restoreLink(iShareable, string, iSymbolicLinkHandle, iProgressMonitor);
    }

    public IPath getIDEWorkAreaRoot() {
        return null;
    }

    public boolean isConnectionShared(IContextHandle iContextHandle) throws FileSystemClientException {
        return ICopyFileAreaManager.instance.isConnectionShared(iContextHandle);
    }

    public void resolveFileStorage(FileStorageWrapper fileStorageWrapper, ResourceType resourceType) {
        this.resolveLocalFileStorage(fileStorageWrapper, resourceType);
    }

    public int getNumShares(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return ICopyFileAreaManager.instance.getNumShares(iContextHandle, iComponentHandle, iProgressMonitor);
    }

    public ISchedulingRule makeSchedulingRuleForIDE(Collection collection) {
        return null;
    }

    public ISchedulingRule makeSchedulingRuleForIDE(Collection collection, ISharingManager$RuleKind iSharingManager$RuleKind) {
        return null;
    }

    public IFileContentMerger getFileContentMerger() {
        return new SharingManager$2(this);
    }

    private static SharingManager doGetInstance() throws  {
        return SharingManager$$Cold.doGetInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SharingManager getInstance() {
        SharingManager sharingManager = instance;
        if (sharingManager != null) return sharingManager;
        Class<SharingManager> clazz = SharingManager.class;
        synchronized (SharingManager.class) {
            sharingManager = instance;
            if (sharingManager != null) return sharingManager;
            instance = sharingManager = SharingManager.doGetInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sharingManager;
        }
    }

    public FileSystemOperation getLoadMutator(int n, IConnection iConnection, IComponent iComponent, ISandbox iSandbox, List list, LoadTree loadTree, LoadDilemmaHandler loadDilemmaHandler, IDownloadListener iDownloadListener) throws  {
        return SharingManager$$Cold.getLoadMutator(this, n, iConnection, iComponent, iSandbox, list, loadTree, loadDilemmaHandler, iDownloadListener);
    }

    public IShare[] allShares(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.allShares(this, iPath, iProgressMonitor);
    }

    public IShare[] allShares(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.allShares(this, iProgressMonitor);
    }

    public IShare[] allShares(IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.allShares(this, iPath, iContextHandle, iComponentHandle, iProgressMonitor);
    }

    public IShareable findShareable(IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.findShareable(this, iPath, iContextHandle, iComponentHandle, iVersionableHandle, iProgressMonitor);
    }

    public Collection findShareables(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.findShareables(this, iContextHandle, iComponentHandle, iVersionableHandle, iProgressMonitor);
    }

    public IShareable findShareable(IPath iPath, ResourceType resourceType) throws  {
        return SharingManager$$Cold.findShareable(this, iPath, resourceType);
    }

    public IShare getShare(IPath iPath, IPath iPath2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.getShare(this, iPath, iPath2, iProgressMonitor);
    }

    public IShare share(Shareable shareable, ISharingDescriptor iSharingDescriptor, FileItemInfo fileItemInfo, int n, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.share(this, shareable, iSharingDescriptor, fileItemInfo, n, iProgressMonitor);
    }

    public void forget(Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SharingManager$$Cold.forget(this, shareable, iProgressMonitor);
    }

    public boolean isConnectionShared(IPath iPath, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.isConnectionShared(this, iPath, iContextHandle, iProgressMonitor);
    }

    public ITeamRepository getRepository(IShare iShare) throws  {
        return SharingManager$$Cold.getRepository(this, iShare);
    }

    public void disableChangeMonitoring() {
        changeMonitoring.set(new Integer((Integer)changeMonitoring.get() + 1));
    }

    public void enableChangeMonitoring() {
        int n = (Integer)changeMonitoring.get();
        if (n == 0) {
            throw (Throwable)new IllegalStateException();
        }
        changeMonitoring.set(new Integer(n - 1));
    }

    public boolean isChangeMonitoringEnabled() {
        return (Integer)changeMonitoring.get() == 0;
    }

    public ILocalChange getChange(Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.getChange(this, shareable, iProgressMonitor);
    }

    public final void doSilentChange(SharingManager$CoreRunnable sharingManager$CoreRunnable) throws CoreException {
        SharingManager$$Cold.doSilentChange(this, sharingManager$CoreRunnable);
    }

    public Collection findShareables(IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.findShareables(this, iVersionableHandle, iProgressMonitor);
    }

    public Collection findShareables(IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.findShareables(this, iComponentHandle, iVersionableHandle, iProgressMonitor);
    }

    protected List getShareablesForPaths(IPath iPath, Collection collection, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.getShareablesForPaths(this, iPath, collection, iVersionableHandle, iProgressMonitor);
    }

    public UpdateMutator getUpdateMutator(IConnection iConnection, Collection collection, Collection collection2, FileAreaUpdateReport fileAreaUpdateReport, Collection collection3, UpdateDilemmaHandler updateDilemmaHandler, IDownloadListener iDownloadListener) throws  {
        return SharingManager$$Cold.getUpdateMutator(this, iConnection, collection, collection2, fileAreaUpdateReport, collection3, updateDilemmaHandler, iDownloadListener);
    }

    public List getRootShareables(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.getRootShareables(this, iPath, iProgressMonitor);
    }

    public List getPathRelativeToShares(IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, List list, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.getPathRelativeToShares(this, iPath, iContextHandle, iComponentHandle, list, iProgressMonitor);
    }

    public Collection getRegisteredSandboxes() throws  {
        return SharingManager$$Cold.getRegisteredSandboxes(this);
    }

    public boolean isConfigurationShared(ISandbox iSandbox, ConfigurationDescriptor configurationDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.isConfigurationShared(this, iSandbox, configurationDescriptor, iProgressMonitor);
    }

    public void resolveLocalFileStorage(FileStorageWrapper fileStorageWrapper, ResourceType resourceType) throws  {
        SharingManager$$Cold.resolveLocalFileStorage(this, fileStorageWrapper, resourceType);
    }

    public final IFileStorage getLocalFileStorage(ISandbox iSandbox, IPath iPath, ResourceType resourceType) throws  {
        return SharingManager$$Cold.getLocalFileStorage(this, iSandbox, iPath, resourceType);
    }

    public void forget(IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SharingManager$$Cold.forget(this, iPath, iContextHandle, iComponentHandle, iVersionableHandle, iProgressMonitor);
    }

    public ISandbox getSandbox(IPath iPath, boolean bl) throws  {
        return SharingManager$$Cold.getSandbox(this, iPath, bl);
    }

    public Collection getSandboxes(ConfigurationDescriptor configurationDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.getSandboxes(this, configurationDescriptor, iProgressMonitor);
    }

    public void register(ISandbox iSandbox, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SharingManager$$Cold.register(this, iSandbox, bl, iProgressMonitor);
    }

    public void deregister(ISandbox iSandbox, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SharingManager$$Cold.deregister(this, iSandbox, iProgressMonitor);
    }

    public boolean isExistingCopyFileArea(IPath iPath, boolean bl) throws  {
        return SharingManager$$Cold.isExistingCopyFileArea(this, iPath, bl);
    }

    public final synchronized IContentExaminer getContentExaminer() {
        if (this.contentExaminer == null) {
            IConfigurationElement[] iConfigurationElementArray = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_CONTENT_EXAMINER);
            if (iConfigurationElementArray.length > 1) {
                throw (Throwable)new IllegalStateException("Only one content examiner implementation can be registered");
            }
            if (iConfigurationElementArray.length == 1) {
                try {
                    this.contentExaminer = (IContentExaminer)iConfigurationElementArray[0].createExecutableExtension("class");
                }
                catch (CoreException coreException) {
                    this.contentExaminer = LocalContentExaminer.getInstance();
                    LoggingHelper.log(coreException);
                }
            } else {
                this.contentExaminer = LocalContentExaminer.getInstance();
            }
        }
        return this.contentExaminer;
    }

    public Collection getShares(IConnection iConnection, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.getShares(this, iConnection, iProgressMonitor);
    }

    public Collection getShares(ConfigurationDescriptor configurationDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.getShares(this, configurationDescriptor, iProgressMonitor);
    }

    public boolean isCorruptedCopyFileArea(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.isCorruptedCopyFileArea(this, iPath, iProgressMonitor);
    }

    public Collection allLoadedConfigurations(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.allLoadedConfigurations(this, iPath, iProgressMonitor);
    }
}

