/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.SharingManager$CoreRunnable;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemUpdateMutator;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SubMonitor;

public class SharingManager$$Cold {
    public static /* synthetic */ Collection allLoadedConfigurations(SharingManager sharingManager, IPath iPath, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.lockExistingForRead(iPath, (IProgressMonitor)subMonitor.newChild(1));
        if (abstractLock == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
            Collection collection = iCopyFileArea.allLoadedConfigurations((IProgressMonitor)subMonitor.newChild(98));
            return collection;
        }
        finally {
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    public static /* synthetic */ IShare[] allShares(SharingManager sharingManager, IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) {
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (iCopyFileAreaManager.copyFileAreaExists(iPath, 1)) {
            AbstractLock abstractLock = CFALockUtil.createAndLockForReading(iPath, true, (IProgressMonitor)subMonitor.newChild(1));
            try {
                Collection collection = iCopyFileAreaManager.getExistingCopyFileArea(iPath).allShares(iContextHandle, iComponentHandle, (IProgressMonitor)subMonitor.newChild(98));
                IShare[] iShareArray = collection.toArray(new IShare[collection.size()]);
                return iShareArray;
            }
            finally {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                subMonitor.done();
            }
        }
        subMonitor.done();
        return new IShare[0];
    }

    public static /* synthetic */ IShare[] allShares(SharingManager sharingManager, IPath iPath, IProgressMonitor iProgressMonitor) {
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (iCopyFileAreaManager.copyFileAreaExists(iPath, 1)) {
            AbstractLock abstractLock = CFALockUtil.createAndLockForReading(iPath, true, (IProgressMonitor)subMonitor.newChild(1));
            try {
                Collection collection = iCopyFileAreaManager.getExistingCopyFileArea(iPath).allShares();
                IShare[] iShareArray = collection.toArray(new IShare[collection.size()]);
                return iShareArray;
            }
            finally {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                subMonitor.done();
            }
        }
        subMonitor.done();
        return new IShare[0];
    }

    public static /* synthetic */ IShare[] allShares(SharingManager sharingManager, IProgressMonitor iProgressMonitor) {
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        Collection collection = iCopyFileAreaManager.getAllCopyFileAreas();
        ArrayList arrayList = new ArrayList();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)collection.size());
        for (ICopyFileArea iCopyFileArea : collection) {
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            subMonitor2.setWorkRemaining(2);
            AbstractLock abstractLock = CFALockUtil.lockExistingForRead(iCopyFileArea.getRoot(), (IProgressMonitor)subMonitor2.newChild(1));
            if (abstractLock == null) continue;
            try {
                arrayList.addAll(ICopyFileAreaManager.instance.getExistingCopyFileArea(iCopyFileArea.getRoot()).allShares());
            }
            finally {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor2.newChild(1));
            }
        }
        return arrayList.toArray(new IShare[arrayList.size()]);
    }

    public static /* synthetic */ void deregister(SharingManager sharingManager, ISandbox iSandbox, IProgressMonitor iProgressMonitor) {
        ICopyFileAreaManager.instance.deregister(iSandbox.getRoot(), false, iProgressMonitor);
    }

    public static /* synthetic */ SharingManager doGetInstance() {
        IConfigurationElement[] iConfigurationElementArray = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", "sharingManager");
        if (iConfigurationElementArray.length > 1) {
            throw (Throwable)new IllegalStateException("Only one sharing manager implementation can be registered");
        }
        if (iConfigurationElementArray.length == 1) {
            try {
                return (SharingManager)iConfigurationElementArray[0].createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                LoggingHelper.log(coreException);
            }
        }
        return new SharingManager();
    }

    public static final /* synthetic */ void doSilentChange(SharingManager sharingManager, SharingManager$CoreRunnable sharingManager$CoreRunnable) {
        SharingManager.getInstance().disableChangeMonitoring();
        try {
            sharingManager$CoreRunnable.run();
        }
        finally {
            SharingManager.getInstance().enableChangeMonitoring();
        }
    }

    public static /* synthetic */ IShareable findShareable(SharingManager sharingManager, IPath iPath, ResourceType resourceType) {
        if (!iPath.isAbsolute()) {
            throw (Throwable)new IllegalArgumentException("Path must be absolute");
        }
        ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getCopyFileAreaForPath(iPath);
        if (iCopyFileArea != null) {
            IPath iPath2 = iCopyFileArea.getRoot();
            IPath iPath3 = iPath.removeFirstSegments(iPath2.segmentCount()).setDevice(null).makeUNC(false).makeAbsolute();
            return new Shareable(iPath2, iPath3, resourceType);
        }
        return null;
    }

    public static /* synthetic */ IShareable findShareable(SharingManager sharingManager, IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) {
        if (iVersionableHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iContextHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iPath == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (iCopyFileAreaManager.copyFileAreaExists(iPath, 1)) {
            AbstractLock abstractLock = CFALockUtil.createAndLockForUpdate(iPath, iContextHandle, iComponentHandle, (IProgressMonitor)subMonitor.newChild(1));
            try {
                ICopyFileArea iCopyFileArea = iCopyFileAreaManager.getExistingCopyFileArea(iPath);
                IPath iPath2 = iCopyFileArea.getLocalPathFor(iContextHandle, iComponentHandle, iVersionableHandle, (IProgressMonitor)subMonitor.newChild(98));
                if (iPath2 != null) {
                    Shareable shareable = new Shareable(iPath, iPath2, ResourceType.getResourceType(iVersionableHandle));
                    return shareable;
                }
            }
            finally {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                subMonitor.done();
            }
        }
        subMonitor.done();
        return null;
    }

    public static /* synthetic */ Collection findShareables(SharingManager sharingManager, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) {
        if (iVersionableHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        ArrayList arrayList = new ArrayList();
        Collection collection = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)collection.size());
        for (ICopyFileArea iCopyFileArea : collection) {
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            subMonitor2.setWorkRemaining(100);
            AbstractLock abstractLock = CFALockUtil.lockExistingForGlobalUpdate(iCopyFileArea.getRoot(), (IProgressMonitor)subMonitor2.newChild(1));
            if (abstractLock == null) continue;
            try {
                iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(iCopyFileArea.getRoot());
                Collection collection2 = iCopyFileArea.getLocalPathsFor(iComponentHandle, iVersionableHandle, (IProgressMonitor)subMonitor2.newChild(97));
                arrayList.addAll(sharingManager.getShareablesForPaths(iCopyFileArea.getRoot(), collection2, iVersionableHandle, (IProgressMonitor)subMonitor.newChild(1)));
            }
            finally {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor2.newChild(1));
            }
        }
        subMonitor.done();
        return arrayList;
    }

    public static /* synthetic */ Collection findShareables(SharingManager sharingManager, IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) {
        if (iVersionableHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iContextHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        ArrayList<Shareable> arrayList = new ArrayList<Shareable>();
        Collection collection = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)collection.size());
        for (ICopyFileArea iCopyFileArea : collection) {
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            subMonitor2.setWorkRemaining(100);
            AbstractLock abstractLock = CFALockUtil.lockExistingForUpdate(iCopyFileArea.getRoot(), iContextHandle, iComponentHandle, (IProgressMonitor)subMonitor2.newChild(1));
            if (abstractLock == null) continue;
            try {
                iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(iCopyFileArea.getRoot());
                IPath iPath = iCopyFileArea.getLocalPathFor(iContextHandle, iComponentHandle, iVersionableHandle, (IProgressMonitor)subMonitor2.newChild(98));
                if (iPath == null) continue;
                arrayList.add(new Shareable(iCopyFileArea.getRoot(), iPath, ResourceType.getResourceType(iVersionableHandle)));
            }
            finally {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor2.newChild(1));
            }
        }
        return arrayList;
    }

    public static /* synthetic */ Collection findShareables(SharingManager sharingManager, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) {
        if (iVersionableHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        ArrayList arrayList = new ArrayList();
        Collection collection = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)collection.size());
        for (ICopyFileArea iCopyFileArea : collection) {
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            subMonitor2.setWorkRemaining(100);
            AbstractLock abstractLock = CFALockUtil.lockExistingForGlobalUpdate(iCopyFileArea.getRoot(), (IProgressMonitor)subMonitor2.newChild(1));
            if (abstractLock == null) continue;
            try {
                iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(iCopyFileArea.getRoot());
                Collection collection2 = iCopyFileArea.getLocalPathsFor(iVersionableHandle, (IProgressMonitor)subMonitor.newChild(97));
                arrayList.addAll(sharingManager.getShareablesForPaths(iCopyFileArea.getRoot(), collection2, iVersionableHandle, (IProgressMonitor)subMonitor.newChild(1)));
            }
            finally {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor2.newChild(1));
            }
        }
        subMonitor.done();
        return arrayList;
    }

    public static /* synthetic */ void forget(SharingManager sharingManager, Shareable shareable, IProgressMonitor iProgressMonitor) {
        boolean bl;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.createAndLockForUpdate(shareable.getCopyFileAreaRoot(), shareable.getLocalPath(), true, (IProgressMonitor)subMonitor.newChild(1));
        if (abstractLock == null) {
            return;
        }
        try {
            ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getCopyFileAreaRoot());
            bl = iCopyFileArea.forget(shareable.getLocalPath(), (IProgressMonitor)subMonitor.newChild(74));
        }
        finally {
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        if (bl) {
            IFileStorage iFileStorage = shareable.getFileStorage();
            iFileStorage.deregisterRepositoryProvider((IProgressMonitor)subMonitor.newChild(25));
        }
        subMonitor.done();
    }

    public static /* synthetic */ void forget(SharingManager sharingManager, IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) {
        boolean bl;
        IShareable iShareable;
        Object object;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.createAndLockForUpdate(iPath, iContextHandle, iComponentHandle, (IProgressMonitor)subMonitor.newChild(1));
        try {
            object = ICopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
            iShareable = sharingManager.findShareable(iPath, iContextHandle, iComponentHandle, iVersionableHandle, (IProgressMonitor)subMonitor.newChild(93));
            bl = object.forget(iContextHandle, iComponentHandle, iVersionableHandle, (IProgressMonitor)subMonitor);
        }
        finally {
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        if (bl & iShareable != null && (object = ((Shareable)iShareable).getFileStorage()) != null) {
            object.deregisterRepositoryProvider((IProgressMonitor)subMonitor.newChild(5));
        }
    }

    public static /* synthetic */ ILocalChange getChange(SharingManager sharingManager, Shareable shareable, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)2);
        if (shareable.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(1))) {
            subMonitor.done();
            return null;
        }
        ILocalChange iLocalChange = LocalChangeManager.getInstance().getPendingChange(shareable, (IProgressMonitor)subMonitor.newChild(1));
        return iLocalChange == null ? NoOpChange.NO_OP : iLocalChange;
    }

    public static /* synthetic */ FileSystemOperation getLoadMutator(SharingManager sharingManager, int n, IConnection iConnection, IComponent iComponent, ISandbox iSandbox, List list, LoadTree loadTree, LoadDilemmaHandler loadDilemmaHandler, IDownloadListener iDownloadListener) {
        return new MergeLoadMutator(iConnection, iComponent, iSandbox, list, loadTree, loadDilemmaHandler, iDownloadListener);
    }

    public static final /* synthetic */ IFileStorage getLocalFileStorage(SharingManager sharingManager, ISandbox iSandbox, IPath iPath, ResourceType resourceType) {
        Shareable shareable = new Shareable(iSandbox, iPath, resourceType);
        IFileStorage iFileStorage = shareable.getFileStorage();
        LocalFileStorage localFileStorage = new LocalFileStorage(shareable.getFileStorage());
        ((FileStorageWrapper)iFileStorage).setUnderlyingStorage(localFileStorage);
        return iFileStorage;
    }

    public static /* synthetic */ List getPathRelativeToShares(SharingManager sharingManager, IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, List list, IProgressMonitor iProgressMonitor) {
        IPath iPath2;
        Collection collection;
        Object object;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ArrayList<IPath> arrayList = new ArrayList<IPath>(list.size());
        AbstractLock abstractLock = CFALockUtil.lockExistingForRead(iPath, (IProgressMonitor)subMonitor.newChild(1));
        if (abstractLock == null) {
            subMonitor.done();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                List cfr_ignored_0 = (List)iterator.next();
                arrayList.add(null);
            }
            return arrayList;
        }
        try {
            object = ICopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
            collection = object.allShares();
        }
        finally {
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        object = new HashMap();
        for (Object object2 : collection) {
            ISharingDescriptor iSharingDescriptor = object2.getSharingDescriptor();
            if (!iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iContextHandle) || !iSharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle)) continue;
            iPath2 = object2.getPath();
            ((HashMap)object).put(iSharingDescriptor.getRootVersionable().getItemId(), iPath2);
        }
        for (Object object2 : list) {
            boolean bl = false;
            iPath2 = null;
            if (!((HashMap)object).isEmpty()) {
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    INameItemPair iNameItemPair = (INameItemPair)iterator.next();
                    if (bl) {
                        iPath2 = iPath2.append(iNameItemPair.getName());
                        continue;
                    }
                    IPath iPath3 = (IPath)((HashMap)object).get(iNameItemPair.getItem().getItemId());
                    if (iPath3 == null) continue;
                    bl = true;
                    iPath2 = iPath3;
                }
            }
            arrayList.add(iPath2);
        }
        subMonitor.done();
        return arrayList;
    }

    public static /* synthetic */ Collection getRegisteredSandboxes(SharingManager sharingManager) {
        Collection collection = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        ArrayList<Sandbox> arrayList = new ArrayList<Sandbox>(collection.size());
        for (ICopyFileArea iCopyFileArea : collection) {
            arrayList.add(new Sandbox(iCopyFileArea));
        }
        return arrayList;
    }

    public static /* synthetic */ ITeamRepository getRepository(SharingManager sharingManager, IShare iShare) {
        ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
        return RepositoryUtils.getTeamRepository(iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getRepositoryId());
    }

    public static /* synthetic */ List getRootShareables(SharingManager sharingManager, IPath iPath, IProgressMonitor iProgressMonitor) {
        File file = iPath.toFile();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Shareable> arrayList = new ArrayList<Shareable>();
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            arrayList.add(new Shareable(iPath, (IPath)new Path(file2.getName()), PathUtils.getResourceType((IPath)new Path(file2.getAbsolutePath()), iProgressMonitor)));
            ++n2;
        }
        return arrayList;
    }

    public static /* synthetic */ ISandbox getSandbox(SharingManager sharingManager, IPath iPath, boolean bl) {
        if (bl && !ICopyFileAreaManager.instance.copyFileAreaExists(iPath, 0)) {
            return null;
        }
        return new Sandbox(iPath);
    }

    public static /* synthetic */ Collection getSandboxes(SharingManager sharingManager, ConfigurationDescriptor configurationDescriptor, IProgressMonitor iProgressMonitor) {
        ArrayList<Sandbox> arrayList = new ArrayList<Sandbox>();
        Collection collection = ICopyFileAreaManager.instance.getCopyFileAreasForConfiguration(configurationDescriptor, iProgressMonitor);
        for (ICopyFileArea iCopyFileArea : collection) {
            arrayList.add(new Sandbox(iCopyFileArea));
        }
        return arrayList;
    }

    public static /* synthetic */ IShare getShare(SharingManager sharingManager, IPath iPath, IPath iPath2, IProgressMonitor iProgressMonitor) {
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.lockExistingForRead(iPath, (IProgressMonitor)subMonitor.newChild(1));
        if (abstractLock == null) {
            subMonitor.done();
            return null;
        }
        try {
            ICopyFileArea iCopyFileArea = iCopyFileAreaManager.getExistingCopyFileArea(iPath);
            IShare iShare = iCopyFileArea.getShare(iPath2);
            subMonitor.worked(98);
            IShare iShare2 = iShare;
            return iShare2;
        }
        finally {
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    public static /* synthetic */ List getShareablesForPaths(SharingManager sharingManager, IPath iPath, Collection collection, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)collection.size());
        ArrayList<Shareable> arrayList = new ArrayList<Shareable>(collection.size());
        iPath.toFile();
        ResourceType resourceType = ResourceType.getResourceType(iVersionableHandle);
        for (IPath iPath2 : collection) {
            Shareable shareable = new Shareable(iPath, iPath2, resourceType);
            IFileStorage iFileStorage = shareable.getFileStorage();
            if (iFileStorage.getResourceType((IProgressMonitor)subMonitor.newChild(1)) != resourceType) continue;
            arrayList.add(shareable);
        }
        return arrayList;
    }

    public static /* synthetic */ Collection getShares(SharingManager sharingManager, ConfigurationDescriptor configurationDescriptor, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ArrayList<IShare> arrayList = new ArrayList<IShare>();
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        Collection collection = iCopyFileAreaManager.getCopyFileAreasForConfiguration(configurationDescriptor, (IProgressMonitor)subMonitor.newChild(1));
        subMonitor.setWorkRemaining(collection.size() + 1);
        for (ICopyFileArea iCopyFileArea : collection) {
            AbstractLock abstractLock = CFALockUtil.lockExistingForRead(iCopyFileArea.getRoot(), (IProgressMonitor)subMonitor.newChild(1));
            if (abstractLock == null) continue;
            try {
                Collection collection2 = ICopyFileAreaManager.instance.getExistingCopyFileArea(iCopyFileArea.getRoot()).allShares();
                for (IShare iShare : collection2) {
                    ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
                    if (!iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)configurationDescriptor.connectionHandle) || !iSharingDescriptor.getComponent().sameItemId((IItemHandle)configurationDescriptor.componentHandle)) continue;
                    arrayList.add(iShare);
                }
            }
            finally {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        return arrayList;
    }

    public static /* synthetic */ Collection getShares(SharingManager sharingManager, IConnection iConnection, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ArrayList<IShare> arrayList = new ArrayList<IShare>();
        ICopyFileAreaManager iCopyFileAreaManager = ICopyFileAreaManager.instance;
        Collection collection = iCopyFileAreaManager.getCopyFileAreasForConnection(iConnection, (IProgressMonitor)subMonitor.newChild(1));
        subMonitor.setWorkRemaining(collection.size() + 1);
        for (ICopyFileArea iCopyFileArea : collection) {
            AbstractLock abstractLock = CFALockUtil.lockExistingForRead(iCopyFileArea.getRoot(), (IProgressMonitor)subMonitor.newChild(1));
            if (abstractLock == null) continue;
            try {
                Collection collection2 = ICopyFileAreaManager.instance.getExistingCopyFileArea(iCopyFileArea.getRoot()).allShares();
                for (IShare iShare : collection2) {
                    if (!iShare.getSharingDescriptor().isAssociatedWithConnection(iConnection)) continue;
                    arrayList.add(iShare);
                }
            }
            finally {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        return arrayList;
    }

    public static /* synthetic */ UpdateMutator getUpdateMutator(SharingManager sharingManager, IConnection iConnection, Collection collection, Collection collection2, FileAreaUpdateReport fileAreaUpdateReport, Collection collection3, UpdateDilemmaHandler updateDilemmaHandler, IDownloadListener iDownloadListener) {
        return new LocalFileSystemUpdateMutator(iConnection, collection, collection2, fileAreaUpdateReport, collection3, updateDilemmaHandler, iDownloadListener);
    }

    public static /* synthetic */ boolean isConfigurationShared(SharingManager sharingManager, ISandbox iSandbox, ConfigurationDescriptor configurationDescriptor, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.lockExistingForRead(iSandbox.getRoot(), (IProgressMonitor)subMonitor.newChild(1));
        if (abstractLock == null) {
            return false;
        }
        try {
            ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(iSandbox.getRoot());
            boolean bl = iCopyFileArea.isConfigurationShared(configurationDescriptor.connectionHandle, configurationDescriptor.componentHandle, (IProgressMonitor)subMonitor.newChild(98));
            return bl;
        }
        finally {
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    public static /* synthetic */ boolean isConnectionShared(SharingManager sharingManager, IPath iPath, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.lockExistingForRead(iPath, (IProgressMonitor)subMonitor.newChild(1));
        if (abstractLock == null) {
            subMonitor.done();
            return false;
        }
        try {
            ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
            boolean bl = iCopyFileArea.isConnectionShared(iContextHandle);
            subMonitor.worked(98);
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.done();
        }
    }

    public static /* synthetic */ boolean isCorruptedCopyFileArea(SharingManager sharingManager, IPath iPath, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.lockExistingForRead(iPath, (IProgressMonitor)subMonitor.newChild(1));
        if (abstractLock == null) {
            return false;
        }
        try {
            ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
            boolean bl = iCopyFileArea.isCorrupted();
            return bl;
        }
        finally {
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    public static /* synthetic */ boolean isExistingCopyFileArea(SharingManager sharingManager, IPath iPath, boolean bl) {
        int n = bl ? 0 : 1;
        return ICopyFileAreaManager.instance.copyFileAreaExists(iPath, n);
    }

    public static /* synthetic */ void register(SharingManager sharingManager, ISandbox iSandbox, boolean bl, IProgressMonitor iProgressMonitor) {
        IPath iPath = iSandbox.getRoot();
        if (bl && !ICopyFileAreaManager.instance.copyFileAreaExists(iPath, 1)) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 210, NLS.bind((String)Messages.SharingManager_InvalidSandbox, (Object)iPath.toOSString(), (Object[])new Object[0]), null)));
        }
        ICopyFileAreaManager.instance.createCopyFileArea(iPath, iProgressMonitor);
    }

    public static /* synthetic */ void resolveLocalFileStorage(SharingManager sharingManager, FileStorageWrapper fileStorageWrapper, ResourceType resourceType) {
        fileStorageWrapper.setUnderlyingStorage(new LocalFileStorage(fileStorageWrapper));
    }

    public static /* synthetic */ IShare share(SharingManager sharingManager, Shareable shareable, ISharingDescriptor iSharingDescriptor, FileItemInfo fileItemInfo, int n, IProgressMonitor iProgressMonitor) {
        IFileStorage iFileStorage;
        boolean bl;
        Object object;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath = shareable.getLocalPath();
        if (!iSharingDescriptor.getRootVersionable().hasStateId()) {
            throw (Throwable)new IllegalArgumentException(iPath + " cannot be shared. Root has no state id");
        }
        int n2 = 0;
        if ((n & 1) == 1) {
            n2 |= 1;
        } else if ((n & 2) == 2) {
            n2 |= 2;
        }
        IPath iPath2 = shareable.getCopyFileAreaRoot();
        AbstractLock abstractLock = CFALockUtil.createAndLockForReading(iPath2, true, (IProgressMonitor)subMonitor.newChild(1));
        try {
            object = ICopyFileAreaManager.instance.getExistingCopyFileArea(iPath2);
            iPath2 = object.getRoot();
            object.share(shareable.getLocalPath(), iSharingDescriptor, fileItemInfo, n2, (IProgressMonitor)subMonitor.newChild(13));
            bl = object.isCaseSensitive();
        }
        finally {
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        object = new Share(iPath2, iPath, bl, iSharingDescriptor);
        if ((n & 4) == 4 && sharingManager.isChangeMonitoringEnabled()) {
            LocalChangeManager.getInstance().loadChanges((IShare)object, (IProgressMonitor)subMonitor.newChild(70));
        }
        if ((iFileStorage = shareable.getFileStorage()) != null) {
            iFileStorage.registerRepositorProvider((IProgressMonitor)subMonitor.newChild(15));
        }
        subMonitor.done();
        return (IShare)object;
    }
}

