/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.ItemHandleHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.core.runtime.Assert;

public class SharingDescriptor
implements ISharingDescriptor,
Serializable {
    private static final int METADATA_VERSION3 = 3;
    private static final int METADATA_VERSION4 = 4;
    private static final UUID UNKNOWN_CONFIGURATION_STATE_UUID = UUID.valueOf((String)"_R9t0ULhfEduBzK-rvZth-A");
    private static final UUID NEW_CONFIGURATION_STATE_UUID = UUID.valueOf((String)"_EHcPcCUoEdyQ476u2X18-Q");
    private static final long serialVersionUID = 7918534741066530000L;
    private String repositoryUri;
    private UUID repoId;
    private transient IContextHandle connectionHandle;
    private transient IComponentHandle component;
    private transient IVersionableHandle rootFolder;
    private String connectionName;
    private String componentName;
    private ISyncTime configurationState;
    private int flags;
    private static final int UNKNOWN_CONFIG_STATE = 1;
    private static final int FILE_ROOT = 2;
    private static final int LINK_ROOT = 4;

    public SharingDescriptor(String string, UUID uUID, IContextHandle iContextHandle, String string2, IComponentHandle iComponentHandle, String string3, IVersionableHandle iVersionableHandle) {
        this(string, uUID, iContextHandle, string2, iComponentHandle, string3, iVersionableHandle, ISyncTime.TIME_NONE);
    }

    private SharingDescriptor(String string, UUID uUID, IContextHandle iContextHandle, String string2, IComponentHandle iComponentHandle, String string3, IVersionableHandle iVersionableHandle, ISyncTime iSyncTime) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)uUID);
        Assert.isNotNull((Object)iComponentHandle);
        Assert.isNotNull((Object)string3);
        Assert.isNotNull((Object)iVersionableHandle);
        Assert.isNotNull((Object)string2);
        Assert.isNotNull((Object)iContextHandle);
        Assert.isNotNull((Object)iSyncTime);
        Assert.isLegal((iContextHandle instanceof IWorkspaceHandle || iContextHandle instanceof IBaselineHandle ? 1 : 0) != 0);
        this.repositoryUri = string;
        this.repoId = uUID;
        this.connectionHandle = iContextHandle.hasFullState() ? (IContextHandle)iContextHandle.getItemType().createItemHandle(iContextHandle.getItemId(), iContextHandle.getStateId()) : iContextHandle;
        this.connectionName = string2;
        this.component = iComponentHandle.hasFullState() ? (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(iComponentHandle.getItemId(), iComponentHandle.getStateId()) : iComponentHandle;
        this.componentName = string3;
        this.rootFolder = iVersionableHandle.hasFullState() ? (IVersionableHandle)iVersionableHandle.getItemType().createItemHandle(iVersionableHandle.getItemId(), iVersionableHandle.getStateId()) : iVersionableHandle;
        this.flags = 0;
        this.configurationState = iSyncTime;
        if (iSyncTime.equals(ISyncTime.TIME_NONE)) {
            this.flags |= 1;
        }
        if (iVersionableHandle instanceof IFileItemHandle) {
            this.flags |= 2;
        } else if (iVersionableHandle instanceof ISymbolicLinkHandle) {
            this.flags |= 4;
        }
    }

    public SharingDescriptor(String string, UUID uUID, IConnection iConnection, IComponentHandle iComponentHandle, String string2, IVersionableHandle iVersionableHandle) {
        this(string, uUID, iConnection.getContextHandle(), iConnection.getName(), iComponentHandle, string2, iVersionableHandle, ISyncTime.TIME_NONE);
    }

    public SharingDescriptor(String string, UUID uUID, IConnection iConnection, IComponentHandle iComponentHandle, String string2, IVersionableHandle iVersionableHandle, ISyncTime iSyncTime) throws TeamRepositoryException {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)uUID);
        Assert.isNotNull((Object)iComponentHandle);
        Assert.isNotNull((Object)string2);
        Assert.isNotNull((Object)iVersionableHandle);
        Assert.isNotNull((Object)iConnection);
        Assert.isNotNull((Object)iSyncTime);
        Assert.isLegal((iConnection instanceof IWorkspaceConnection || iConnection instanceof IBaselineConnection ? 1 : 0) != 0);
        this.repositoryUri = string;
        this.repoId = uUID;
        this.component = iComponentHandle.hasFullState() ? (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(iComponentHandle.getItemId(), iComponentHandle.getStateId()) : iComponentHandle;
        this.componentName = string2;
        this.connectionName = iConnection.getName();
        this.connectionHandle = (IContextHandle)(iConnection instanceof IBaselineConnection ? ((IBaselineConnection)iConnection).getBaseline() : ((IWorkspaceConnection)iConnection).getResolvedWorkspace());
        this.flags = 0;
        this.rootFolder = iVersionableHandle.hasFullState() ? (IVersionableHandle)IFolder.ITEM_TYPE.createItemHandle(iVersionableHandle.getItemId(), iVersionableHandle.getStateId()) : iVersionableHandle;
        if (this.rootFolder instanceof IFileItemHandle) {
            this.flags |= 2;
        } else if (this.rootFolder instanceof ISymbolicLinkHandle) {
            this.flags |= 4;
        }
        this.setConfigurationState(iSyncTime);
    }

    public SharingDescriptor(ISharingDescriptor iSharingDescriptor, ISyncTime iSyncTime) {
        if (iSharingDescriptor == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iSyncTime == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.component = iSharingDescriptor.getComponent();
        this.componentName = iSharingDescriptor.getComponentName();
        this.configurationState = iSyncTime;
        this.connectionHandle = iSharingDescriptor.getConnectionHandle();
        this.connectionName = iSharingDescriptor.getConnectionName();
        this.repoId = iSharingDescriptor.getRepositoryId();
        this.repositoryUri = iSharingDescriptor.getRepositoryUri();
        this.rootFolder = iSharingDescriptor.getRootVersionable();
        if (this.rootFolder instanceof IFileItemHandle) {
            this.flags = 2;
        } else if (this.rootFolder instanceof ISymbolicLinkHandle) {
            this.flags = 4;
        }
        this.setConfigurationState(iSyncTime);
    }

    private void setConfigurationState(ISyncTime iSyncTime) {
        this.flags = iSyncTime.equals(ISyncTime.TIME_NONE) ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        this.configurationState = iSyncTime;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        if (n != 4 && n != 3) {
            throw (Throwable)new ClassNotFoundException(NLS.bind((String)Messages.SharingDescriptor_0, (Object[])new Object[]{n, 4}, (Object[])new Object[0]));
        }
        this.repositoryUri = objectInputStream.readUTF();
        this.repoId = UUID.valueOf((String)objectInputStream.readUTF());
        this.component = (IComponentHandle)ItemHandleHelper.fromString(IComponent.ITEM_TYPE, objectInputStream.readUTF());
        this.componentName = objectInputStream.readUTF();
        IItemType iItemType = objectInputStream.readBoolean() ? IBaseline.ITEM_TYPE : IWorkspace.ITEM_TYPE;
        this.connectionHandle = (IContextHandle)ItemHandleHelper.fromString(iItemType, objectInputStream.readUTF());
        this.connectionName = objectInputStream.readUTF();
        String string = null;
        string = objectInputStream.readUTF();
        if (n == 3) {
            this.configurationState = this.getConfigState(objectInputStream.readUTF());
        } else {
            this.configurationState = ISyncTime.FACTORY.createFrom(objectInputStream.readUTF());
            this.flags = objectInputStream.readInt();
        }
        this.rootFolder = (this.flags & 2) == 2 ? (IVersionableHandle)ItemHandleHelper.fromString(IFileItem.ITEM_TYPE, string) : ((this.flags & 4) == 4 ? (IVersionableHandle)ItemHandleHelper.fromString(ISymbolicLink.ITEM_TYPE, string) : (IVersionableHandle)ItemHandleHelper.fromString(IFolder.ITEM_TYPE, string));
    }

    private ISyncTime getConfigState(String string) {
        if (string.equals(NEW_CONFIGURATION_STATE_UUID.getUuidValue())) {
            this.flags = 1;
            this.configurationState = ISyncTime.TIME_NONE;
        } else if (string.equals(UNKNOWN_CONFIGURATION_STATE_UUID.getUuidValue())) {
            this.flags = 1;
            this.configurationState = ISyncTime.TIME_NONE;
        }
        return ISyncTime.FACTORY.convertFromUUID(UUID.valueOf((String)string));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(4);
        objectOutputStream.writeUTF(this.repositoryUri);
        objectOutputStream.writeUTF(this.repoId.getUuidValue());
        objectOutputStream.writeUTF(ItemHandleHelper.toString((IItemHandle)this.component));
        objectOutputStream.writeUTF(this.componentName);
        objectOutputStream.writeBoolean(this.connectionHandle.getItemType() == IBaseline.ITEM_TYPE);
        objectOutputStream.writeUTF(ItemHandleHelper.toString((IItemHandle)this.connectionHandle));
        objectOutputStream.writeUTF(this.connectionName);
        objectOutputStream.writeUTF(ItemHandleHelper.toString((IItemHandle)this.rootFolder));
        objectOutputStream.writeUTF(this.configurationState.toString());
        objectOutputStream.writeInt(this.flags);
    }

    public IComponentHandle getComponent() {
        return this.component;
    }

    public IVersionableHandle getRootVersionable() {
        return this.rootFolder;
    }

    public IContextHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    public String getRepositoryUri() {
        return this.repositoryUri;
    }

    public UUID getRepositoryId() {
        return this.repoId;
    }

    public boolean associatedWithWorkspace() {
        return this.connectionHandle instanceof IWorkspaceHandle;
    }

    public boolean isAssociatedWithConnection(IConnection iConnection) {
        if (iConnection instanceof IWorkspaceConnection) {
            return ((IWorkspaceConnection)iConnection).getResolvedWorkspace().sameItemId((IItemHandle)this.getConnectionHandle());
        }
        return ((IBaselineConnection)iConnection).getBaseline().sameItemId((IItemHandle)this.getConnectionHandle());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SharingDescriptor)) {
            return false;
        }
        SharingDescriptor sharingDescriptor = (SharingDescriptor)object;
        return this.repoId.equals((Object)sharingDescriptor.repoId) && this.rootFolder.sameItemId((IItemHandle)sharingDescriptor.rootFolder) && this.component.sameItemId((IItemHandle)sharingDescriptor.component) && this.connectionHandle.sameItemId((IItemHandle)sharingDescriptor.connectionHandle);
    }

    public int hashCode() {
        return this.rootFolder.getItemId().hashCode() ^ this.connectionHandle.getItemId().hashCode() ^ this.component.getItemId().hashCode() ^ this.repoId.hashCode();
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ISyncTime getConfigurationState() {
        return this.configurationState;
    }

    public boolean isUnknownState() {
        return (this.flags & 1) == 1;
    }
}

