/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable$1;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;

public final class Shareable
implements IShareable {
    private final IPath path;
    private final ResourceType resourceTypeHint;
    private final ISandbox sandbox;
    private final int cachedHashCode;
    private IFileStorage fileStorage;
    private IPath fullPath;

    public Shareable(IPath iPath, IPath iPath2, ResourceType resourceType) {
        this.path = iPath2;
        if (resourceType == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.resourceTypeHint = resourceType;
        this.sandbox = new Sandbox(iPath);
        this.cachedHashCode = this.calculateHashCode();
    }

    public Shareable(ISandbox iSandbox, IPath iPath, ResourceType resourceType) {
        this.sandbox = iSandbox;
        this.path = iPath;
        if (resourceType == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.resourceTypeHint = resourceType;
        this.cachedHashCode = this.calculateHashCode();
    }

    public Shareable(ISandbox iSandbox, IPath iPath, IFileStorage iFileStorage) {
        this.sandbox = iSandbox;
        this.path = iPath;
        this.resourceTypeHint = null;
        this.fileStorage = iFileStorage;
        this.cachedHashCode = this.calculateHashCode();
    }

    public final IPath getCopyFileAreaRoot() {
        return this.getSandbox().getRoot();
    }

    public final IPath getLocalPath() {
        return this.path;
    }

    public final IPath getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.getCopyFileAreaRoot().append(this.getLocalPath());
        }
        return this.fullPath;
    }

    public final IShare getShare(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager.instance.getShare(this.getCopyFileAreaRoot(), this.path, iProgressMonitor);
    }

    public int getState(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IVersionableHandle iVersionableHandle;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        int n = 0;
        if (this.exists((IProgressMonitor)subMonitor.newChild(1))) {
            n |= 8;
        }
        if (this.getShare((IProgressMonitor)subMonitor.newChild(49)) == null) {
            return n;
        }
        n |= 1;
        FileItemInfo fileItemInfo = this.getFileItemInfo((IProgressMonitor)subMonitor.newChild(50));
        if (fileItemInfo != null && (iVersionableHandle = fileItemInfo.getVersionableHandle()).hasStateId()) {
            n |= 2;
        }
        return n;
    }

    public final IShare share(ISharingDescriptor iSharingDescriptor, FileItemInfo fileItemInfo, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.share(iSharingDescriptor, fileItemInfo, bl, true, iProgressMonitor);
    }

    public IShare share(ISharingDescriptor iSharingDescriptor, FileItemInfo fileItemInfo, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 4;
        }
        return SharingManager.getInstance().share(this, iSharingDescriptor, fileItemInfo, n, iProgressMonitor);
    }

    public final IVersionableHandle getRemote(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo = this.getFileItemInfo(iProgressMonitor);
        return fileItemInfo != null && fileItemInfo.getVersionableHandle().hasStateId() ? fileItemInfo.getVersionableHandle() : null;
    }

    public final IVersionableHandle getVersionable(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo = this.getFileItemInfo(iProgressMonitor);
        return fileItemInfo != null ? fileItemInfo.getVersionableHandle() : null;
    }

    public void accept(IShareableVisitor iShareableVisitor, int n, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ArrayList arrayList = new ArrayList();
        boolean[] blArray = new boolean[1];
        Shareable$1 shareable$1 = new Shareable$1(this, blArray, bl, iShareableVisitor, n, arrayList);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        AbstractLock abstractLock = CFALockUtil.lockExistingForUpdate(this.getCopyFileAreaRoot(), this.getLocalPath(), (IProgressMonitor)subMonitor.newChild(1));
        if (abstractLock == null) {
            subMonitor.done();
            return;
        }
        try {
            ICopyFileAreaManager.instance.getExistingCopyFileArea(this.getCopyFileAreaRoot()).accept(shareable$1, this.getLocalPath(), bl2, n, (IProgressMonitor)subMonitor.newChild(95));
            if (!blArray[0]) {
                subMonitor.setWorkRemaining(100);
                if (this.exists((IProgressMonitor)subMonitor.newChild(1))) {
                    iShareableVisitor.visit(this, (IProgressMonitor)subMonitor.newChild(4));
                    this.visit(iShareableVisitor, n, (IProgressMonitor)subMonitor.newChild(95));
                }
            }
        }
        finally {
            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
        }
        if (!arrayList.isEmpty()) {
            if (arrayList.size() == 1) {
                throw (Throwable)arrayList.get(0);
            }
            IStatus iStatus = ((FileSystemClientException)((Object)arrayList.get(0))).getStatus();
            MultiStatus multiStatus = new MultiStatus(iStatus.getPlugin(), iStatus.getCode(), iStatus.getMessage(), null);
            for (FileSystemClientException fileSystemClientException : arrayList) {
                multiStatus.add(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
            }
            throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
        }
    }

    public IFileStorage getFileStorage() {
        if (this.fileStorage == null) {
            this.fileStorage = new FileStorageWrapper(this, this.resourceTypeHint);
        }
        return this.fileStorage;
    }

    public void forget(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SharingManager.getInstance().forget(this, iProgressMonitor);
    }

    public void unshare(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (!this.isShare((IProgressMonitor)subMonitor.newChild(10))) {
            throw (Throwable)new IllegalStateException("Only the root of the share can be unshared");
        }
        SharingManager.getInstance().forget(this, (IProgressMonitor)subMonitor.newChild(90));
    }

    public boolean isShare(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IShare iShare = this.getShare(iProgressMonitor);
        return iShare != null && this.getLocalPath().segmentCount() == iShare.getPath().segmentCount();
    }

    public IShareable getParent() {
        IPath iPath = this.getLocalPath().removeLastSegments(1);
        if (iPath.segmentCount() == 0) {
            return null;
        }
        IFileStorage iFileStorage = this.getFileStorage().getParent();
        if (iFileStorage == null) {
            return null;
        }
        return iFileStorage.getShareable();
    }

    public boolean shouldBeIgnored(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getFileStorage().shouldBeIgnored(iProgressMonitor);
    }

    public ResourceType getResourceType(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getFileStorage().getResourceType(iProgressMonitor);
    }

    public ILocalChange getChange(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager.getInstance().getChange(this, iProgressMonitor);
    }

    public FileLineDelimiter getLineDelimiter(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo = this.getFileItemInfo(iProgressMonitor);
        if (fileItemInfo != null) {
            return fileItemInfo.getLineDelimiter();
        }
        return FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    public String getContentType(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo = this.getFileItemInfo(iProgressMonitor);
        if (fileItemInfo != null) {
            return fileItemInfo.getContentType();
        }
        return null;
    }

    public FileLineDelimiter getOriginalLineDelimiter(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo = this.getFileItemInfo(iProgressMonitor);
        if (fileItemInfo != null) {
            return fileItemInfo.getOriginalLineDelimiter();
        }
        return FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    public String getOriginalContentType(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo = this.getFileItemInfo(iProgressMonitor);
        if (fileItemInfo != null) {
            return fileItemInfo.getOriginalContentType();
        }
        return null;
    }

    public boolean isExecutable(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getFileStorage().isExecutable(iProgressMonitor);
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    private final int calculateHashCode() {
        int n = 1;
        n = this.getCopyFileAreaRoot() == null ? 0 : this.getCopyFileAreaRoot().segmentCount();
        n = 31 * n + (this.path == null ? 0 : this.path.segmentCount());
        n = 31 * n + (this.path == null || this.path.segmentCount() == 0 ? 0 : this.path.lastSegment().toLowerCase().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Shareable shareable = (Shareable)object;
        if (!PathUtils.samePath(this.getCopyFileAreaRoot(), this.sandbox.isCaseSensitive(), shareable.getCopyFileAreaRoot(), shareable.sandbox.isCaseSensitive())) {
            return false;
        }
        return PathUtils.sameRelativePath(this.path, this.sandbox.isCaseSensitive(), shareable.path, shareable.sandbox.isCaseSensitive());
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isAssignableFrom(Shareable.class)) {
            return this;
        }
        if (clazz.isAssignableFrom(File.class)) {
            return this.getFullPath().toFile();
        }
        IFileStorage iFileStorage = this.getFileStorage();
        return iFileStorage.getAdapter(clazz);
    }

    final void setFileStorage(IFileStorage iFileStorage) {
        if (iFileStorage.getShareable() == this) {
            this.fileStorage = iFileStorage;
        }
    }

    private void visit(IShareableVisitor iShareableVisitor, int n, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IFileStorage iFileStorage;
        Collection collection;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (this.getResourceType((IProgressMonitor)subMonitor.newChild(1)) == ResourceType.FOLDER && n != 0 && (collection = (iFileStorage = this.getFileStorage()).getChildren((IProgressMonitor)subMonitor.newChild(1))) != null) {
            subMonitor.setWorkRemaining(collection.size());
            for (IFileStorage iFileStorage2 : collection) {
                SubMonitor subMonitor2 = subMonitor.newChild(1);
                subMonitor2.setWorkRemaining(100);
                Shareable shareable = iFileStorage2.getShareable();
                boolean bl = iShareableVisitor.visit(shareable, (IProgressMonitor)subMonitor2.newChild(5));
                if (!bl) continue;
                shareable.visit(iShareableVisitor, n - 1, (IProgressMonitor)subMonitor2.newChild(95));
            }
        }
    }

    public ISandbox getSandbox() {
        return this.sandbox;
    }

    public FileItemInfo getFileItemInfo(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getFileItemInfo(this.path, iProgressMonitor);
    }

    private FileItemInfo getFileItemInfo(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)2);
        AbstractLock abstractLock = CFALockUtil.lockExistingForRead(this.getCopyFileAreaRoot(), (IProgressMonitor)subMonitor.newChild(1));
        if (abstractLock != null) {
            try {
                ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(this.getCopyFileAreaRoot());
                if (iCopyFileArea != null) {
                    fileItemInfo = iCopyFileArea.getItemInfo(iPath);
                }
            }
            finally {
                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        return fileItemInfo;
    }

    public String toString() {
        return String.valueOf(this.getSandbox().getRoot().toPortableString()) + " -> " + this.getLocalPath().toPortableString();
    }

    public boolean exists(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getFileStorage().exists(iProgressMonitor);
    }

    static /* synthetic */ void access$0(Shareable shareable, IShareableVisitor iShareableVisitor, int n, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        shareable.visit(iShareableVisitor, n, iProgressMonitor);
    }
}

