/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class Share
implements IShare {
    private ISharingDescriptor descriptor;
    private final IPath sharePath;
    private final IPath cfaRoot;
    private ISandbox sandbox;
    private boolean isCaseSensitive;

    public Share(IPath iPath, IPath iPath2, boolean bl, ISharingDescriptor iSharingDescriptor) {
        Assert.isNotNull((Object)iSharingDescriptor, (String)"Sharing Descriptor is null");
        this.descriptor = iSharingDescriptor;
        this.sharePath = iPath2;
        this.cfaRoot = iPath;
        this.isCaseSensitive = bl;
        this.getTracker();
    }

    public IPath getPath() {
        if (this.descriptor == null) {
            throw (Throwable)new IllegalStateException("Not shared anymore");
        }
        return this.sharePath;
    }

    public ISharingDescriptor getSharingDescriptor() {
        if (this.descriptor == null) {
            throw (Throwable)new IllegalStateException("Not shared anymore");
        }
        return this.descriptor;
    }

    public IPath getCopyFileAreaPath() {
        return this.cfaRoot;
    }

    public ISandbox getSandbox() {
        if (this.sandbox == null) {
            this.sandbox = new Sandbox(this.cfaRoot);
        }
        return this.sandbox;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.cfaRoot == null ? 0 : this.cfaRoot.segmentCount());
        n = 31 * n + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        n = 31 * n + (this.sharePath == null ? 0 : this.sharePath.segmentCount());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Share share = (Share)object;
        if (!PathUtils.samePath(this.cfaRoot, this.isCaseSensitive, share.cfaRoot, share.isCaseSensitive)) {
            return false;
        }
        if (this.descriptor == null ? share.descriptor != null : !this.descriptor.equals(share.descriptor)) {
            return false;
        }
        return PathUtils.sameRelativePath(this.sharePath, this.isCaseSensitive, share.sharePath, share.isCaseSensitive);
    }

    public LocalChangeTracker getTracker() {
        return LocalChangeManager.getInstance().getTracker(this.descriptor.getConnectionHandle(), this.descriptor.getComponent(), this.getCopyFileAreaPath(), SharingManager.getInstance().getTrackingRule(this.getCopyFileAreaPath()));
    }

    public Shareable getShareable(IPath iPath, ResourceType resourceType) {
        return new Shareable(this.cfaRoot, iPath, resourceType);
    }

    public void refreshChanges(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        LocalChangeManager.getInstance().refreshChanges(this, iShareable, iProgressMonitor);
    }

    public void syncChanges(IProgressMonitor iProgressMonitor) {
        this.getTracker().syncChanges(iProgressMonitor);
    }

    public String toString() {
        return this.sharePath + " @ " + this.getCopyFileAreaPath();
    }

    public IShareable getShareable() {
        return new Shareable(this.getCopyFileAreaPath(), this.getPath(), ResourceType.getResourceType(this.descriptor.getRootVersionable()));
    }

    public AbstractLock lock(IProgressMonitor iProgressMonitor) {
        ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaRoot);
        return ((CopyFileArea)iCopyFileArea).lock(this.descriptor.getComponent(), this.descriptor.getConnectionHandle(), iProgressMonitor);
    }

    public void unlock(AbstractLock abstractLock, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaRoot);
        ((CopyFileArea)iCopyFileArea).release(abstractLock, iProgressMonitor);
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public boolean isLoadedWithAnotherName(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo = ((Shareable)this.getShareable()).getFileItemInfo(iProgressMonitor);
        if (fileItemInfo != null) {
            return fileItemInfo.isLoadedWithAnotherName();
        }
        return false;
    }
}

