/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class Sandbox
implements ISandbox {
    private final IPath copyFileAreaRoot;
    private final boolean isCaseSensitive;

    public Sandbox(ICopyFileArea iCopyFileArea) {
        this.copyFileAreaRoot = iCopyFileArea.getRoot();
        this.isCaseSensitive = iCopyFileArea.isCaseSensitive();
    }

    public Sandbox(IPath iPath) {
        this.copyFileAreaRoot = iPath;
        this.isCaseSensitive = !iPath.append("a").toFile().equals(iPath.append("A").toFile());
    }

    public IShare[] allShares(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager.getInstance().allShares(this.copyFileAreaRoot, iProgressMonitor);
    }

    public IShareable findShareable(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager.getInstance().findShareable(this.copyFileAreaRoot, iContextHandle, iComponentHandle, iVersionableHandle, iProgressMonitor);
    }

    public IShareable findShareable(IPath iPath, ResourceType resourceType) {
        return SharingManager.getInstance().findShareable(this, iPath, resourceType);
    }

    public List getPathRelativeToShares(IContextHandle iContextHandle, IComponentHandle iComponentHandle, List list, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager.getInstance().getPathRelativeToShares(this.copyFileAreaRoot, iContextHandle, iComponentHandle, list, iProgressMonitor);
    }

    public IPath getRoot() {
        return this.copyFileAreaRoot;
    }

    public int hashCode() {
        return this.copyFileAreaRoot == null ? 0 : this.copyFileAreaRoot.segmentCount();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Sandbox sandbox = (Sandbox)object;
        return PathUtils.samePath(this.copyFileAreaRoot, this.isCaseSensitive, sandbox.copyFileAreaRoot, sandbox.isCaseSensitive);
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public boolean isExistingSandbox() {
        return SharingManager.getInstance().isExistingCopyFileArea(this.copyFileAreaRoot, false);
    }

    public boolean isRegistered() {
        return SharingManager.getInstance().isExistingCopyFileArea(this.copyFileAreaRoot, true);
    }

    public boolean isCorrupted(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager.getInstance().isCorruptedCopyFileArea(this.copyFileAreaRoot, iProgressMonitor);
    }

    public Collection allLoadedConfigurations(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager.getInstance().allLoadedConfigurations(this.copyFileAreaRoot, iProgressMonitor);
    }

    public String toString() {
        return this.getRoot().toString();
    }
}

