/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager$RuleKind;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.RestoreVersionableOperation$LockData;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class RestoreVersionableOperation {
    private RestoreVersionableOperation() {
    }

    public static void restoreFile(IShareable iShareable, InputStream inputStream, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException, IOException {
        if (inputStream == null) {
            throw (Throwable)new NullPointerException();
        }
        try {
            try {
                Shareable shareable;
                Shareable shareable2;
                if (iShareable == null) {
                    throw (Throwable)new NullPointerException();
                }
                if (iVersionableHandle == null) {
                    throw (Throwable)new NullPointerException();
                }
                if (iVersionableHandle.getItemId() == null) {
                    throw (Throwable)new NullPointerException();
                }
                if (!(iVersionableHandle instanceof IFileItemHandle)) {
                    throw (Throwable)new IllegalArgumentException("Cannot give a file a versionable of type " + iVersionableHandle.getItemType().getName());
                }
                if (iVersionableHandle.hasStateId() || iVersionableHandle.hasFullState()) {
                    iVersionableHandle = (IVersionableHandle)iVersionableHandle.getItemType().createItemHandle(iVersionableHandle.getItemId(), null);
                }
                if ((shareable2 = (Shareable)(shareable = (Shareable)iShareable).getParent()) == null) {
                    throw (Throwable)new IllegalArgumentException("Cannot restore file at " + shareable.getLocalPath() + " outside of share");
                }
                IFileStorage iFileStorage = shareable2.getFileStorage();
                if (iFileStorage == null) {
                    throw (Throwable)new IllegalArgumentException("Cannot restore file at " + shareable.getLocalPath() + " outside of share");
                }
                IFileStorage iFileStorage2 = shareable.getFileStorage();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
                RestoreVersionableOperation$LockData lockData = RestoreVersionableOperation.lockTree(iFileStorage, (IProgressMonitor)subMonitor.newChild(5));
                if (lockData == null) {
                    throw (Throwable)new IllegalArgumentException(shareable.getLocalPath() + " is not in a shared location");
                }
                try {
                    FileItemInfo fileItemInfo;
                    if (shareable.exists((IProgressMonitor)subMonitor.newChild(1))) {
                        throw (Throwable)new IllegalArgumentException(shareable.getLocalPath() + " already exists");
                    }
                    ResourceType resourceType = shareable2.getResourceType((IProgressMonitor)subMonitor.newChild(1));
                    if (resourceType == null) {
                        throw (Throwable)new IllegalArgumentException("Parent folder " + iFileStorage.getShareable().getLocalPath() + " does not exist");
                    }
                    if (resourceType != ResourceType.FOLDER) {
                        throw (Throwable)new IllegalArgumentException("Parent " + iFileStorage.getShareable().getLocalPath() + " is not a folder");
                    }
                    IShare iShare = shareable.getShare((IProgressMonitor)subMonitor.newChild(1));
                    if (iShare.getPath().equals((Object)shareable.getLocalPath())) {
                        throw (Throwable)new IllegalArgumentException("Cannot restore file at share root");
                    }
                    ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
                    ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getCopyFileAreaRoot());
                    if (((CopyFileAreaStore)((Object)iCopyFileArea)).isShareRoot((IVersionableHandle)IFolder.ITEM_TYPE.createItemHandle(iVersionableHandle.getItemId(), null), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle())) {
                        throw (Throwable)new IllegalArgumentException(iVersionableHandle.getItemId() + " already exists");
                    }
                    InverseFileItemInfo inverseFileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(iVersionableHandle, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                    if (inverseFileItemInfo != null) {
                        if (inverseFileItemInfo.getLocalName() != null) {
                            throw (Throwable)new IllegalArgumentException(iVersionableHandle.getItemId() + " already exists");
                        }
                        if (inverseFileItemInfo.getVersionableHandle().getItemType() != iVersionableHandle.getItemType()) {
                            throw (Throwable)new IllegalArgumentException("Type mismatch, existing: " + inverseFileItemInfo.getVersionableHandle().getItemType().getName() + ", restoring: " + iVersionableHandle.getItemType().getName());
                        }
                    }
                    DigestComputingInputStream digestComputingInputStream = ContentHash.getDigestComputingStream((InputStream)inputStream);
                    SharingManager.getInstance().disableChangeMonitoring();
                    try {
                        iFileStorage2.create(inputStream, (IProgressMonitor)subMonitor.newChild(60));
                    }
                    finally {
                        SharingManager.getInstance().enableChangeMonitoring();
                    }
                    digestComputingInputStream.close();
                    inputStream = null;
                    if (inverseFileItemInfo != null) {
                        boolean bl = inverseFileItemInfo.getVersionableHandle().hasStateId() && (digestComputingInputStream.getContentSize() != inverseFileItemInfo.getContentLength() || !ContentHash.valueOf((byte[])digestComputingInputStream.getFinalDigest()).equals((Object)inverseFileItemInfo.getHash()));
                        fileItemInfo = new FileItemInfo(inverseFileItemInfo.getVersionableHandle(), bl, iFileStorage2.getModificationStamp(), inverseFileItemInfo.getParent(), inverseFileItemInfo.getName(), inverseFileItemInfo.isLoadedWithAnotherName(), inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredPredecessorHintHash(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredHash(), inverseFileItemInfo.getStoredNumLineDelimiters(), inverseFileItemInfo.isOriginalExecutable(), inverseFileItemInfo.isOriginalExecutable());
                    } else {
                        fileItemInfo = new FileItemInfo(iVersionableHandle, false, -1L, null, null, false, null, -1L, null, null, null, null, null, -1L, null, null, -1L, false, false);
                    }
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(shareable.getLocalPath(), fileItemInfo, (IProgressMonitor)subMonitor.newChild(25));
                }
                finally {
                    RestoreVersionableOperation.unlockTree(lockData, (IProgressMonitor)subMonitor.newChild(5));
                }
            }
            catch (ContentHashAlgorithmException contentHashAlgorithmException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(contentHashAlgorithmException)));
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void restoreFolder(IShareable iShareable, IFolderHandle iFolderHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (iShareable == null) {
            throw (Throwable)new NullPointerException();
        }
        if (iFolderHandle == null || iFolderHandle.getItemId() == null) {
            throw (Throwable)new NullPointerException();
        }
        if (iFolderHandle.hasStateId() || iFolderHandle.hasFullState()) {
            iFolderHandle = (IFolderHandle)iFolderHandle.getItemType().createItemHandle(iFolderHandle.getItemId(), null);
        }
        Shareable shareable = (Shareable)iShareable;
        IFileStorage iFileStorage = shareable.getFileStorage();
        Shareable shareable2 = (Shareable)shareable.getParent();
        if (shareable2 == null) {
            throw (Throwable)new IllegalArgumentException("Cannot restore file at " + shareable.getLocalPath() + " outside of share");
        }
        IFileStorage iFileStorage2 = shareable2.getFileStorage();
        if (iFileStorage2 == null) {
            throw (Throwable)new IllegalArgumentException("Cannot restore file at " + shareable.getLocalPath() + " outside of share");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        RestoreVersionableOperation$LockData lockData = RestoreVersionableOperation.lockTree(iFileStorage, (IProgressMonitor)subMonitor.newChild(5));
        if (lockData == null) {
            throw (Throwable)new IllegalArgumentException(shareable.getLocalPath() + " is not in a shared location");
        }
        try {
            FileItemInfo fileItemInfo;
            if (shareable.exists((IProgressMonitor)subMonitor.newChild(1))) {
                throw (Throwable)new IllegalArgumentException(shareable.getLocalPath() + " already exists");
            }
            ResourceType resourceType = shareable2.getResourceType((IProgressMonitor)subMonitor.newChild(1));
            if (resourceType == null) {
                throw (Throwable)new IllegalArgumentException("Parent folder " + iFileStorage2.getShareable().getLocalPath() + " does not exist");
            }
            if (resourceType != ResourceType.FOLDER) {
                throw (Throwable)new IllegalArgumentException("Parent " + iFileStorage2.getShareable().getLocalPath() + " is not a folder");
            }
            IShare iShare = shareable.getShare((IProgressMonitor)subMonitor.newChild(1));
            if (iShare.getPath().equals((Object)shareable.getLocalPath())) {
                throw (Throwable)new IllegalArgumentException("Cannot restore folder at share root");
            }
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getCopyFileAreaRoot());
            if (((CopyFileAreaStore)((Object)iCopyFileArea)).isShareRoot((IVersionableHandle)iFolderHandle, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle())) {
                throw (Throwable)new IllegalArgumentException(iFolderHandle.getItemId() + " already exists");
            }
            InverseFileItemInfo inverseFileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo((IVersionableHandle)iFolderHandle, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
            if (inverseFileItemInfo != null) {
                if (inverseFileItemInfo.getLocalName() != null) {
                    throw (Throwable)new IllegalArgumentException(iFolderHandle.getItemId() + " already exists");
                }
                if (inverseFileItemInfo.getVersionableHandle().getItemType() != iFolderHandle.getItemType()) {
                    throw (Throwable)new IllegalArgumentException("Type mismatch, existing: " + inverseFileItemInfo.getVersionableHandle().getItemType().getName() + ", restoring: " + iFolderHandle.getItemType().getName());
                }
                fileItemInfo = new FileItemInfo(inverseFileItemInfo.getVersionableHandle(), false, inverseFileItemInfo.getLastContentChangeCheckStamp(), inverseFileItemInfo.getParent(), inverseFileItemInfo.getName(), inverseFileItemInfo.isLoadedWithAnotherName(), inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredPredecessorHintHash(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredHash(), inverseFileItemInfo.getStoredNumLineDelimiters(), false, false);
            } else {
                fileItemInfo = new FileItemInfo(iFolderHandle, null, null, false);
            }
            SharingManager.getInstance().disableChangeMonitoring();
            try {
                iFileStorage.create(false, (IProgressMonitor)subMonitor.newChild(30));
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
            ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(shareable.getLocalPath(), fileItemInfo, (IProgressMonitor)subMonitor.newChild(55));
        }
        finally {
            RestoreVersionableOperation.unlockTree(lockData, (IProgressMonitor)subMonitor.newChild(5));
        }
    }

    public static void restoreLink(IShareable iShareable, String string, ISymbolicLinkHandle iSymbolicLinkHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (string == null) {
            throw (Throwable)new NullPointerException();
        }
        try {
            Shareable shareable;
            Shareable shareable2;
            if (iShareable == null) {
                throw (Throwable)new NullPointerException();
            }
            if (iSymbolicLinkHandle == null) {
                throw (Throwable)new NullPointerException();
            }
            if (iSymbolicLinkHandle.getItemId() == null) {
                throw (Throwable)new NullPointerException();
            }
            if (!(iSymbolicLinkHandle instanceof ISymbolicLinkHandle)) {
                throw (Throwable)new IllegalArgumentException("Cannot give a link a versionable of type " + iSymbolicLinkHandle.getItemType().getName());
            }
            if (iSymbolicLinkHandle.hasStateId() || iSymbolicLinkHandle.hasFullState()) {
                iSymbolicLinkHandle = (ISymbolicLinkHandle)iSymbolicLinkHandle.getItemType().createItemHandle(iSymbolicLinkHandle.getItemId(), null);
            }
            if ((shareable2 = (Shareable)(shareable = (Shareable)iShareable).getParent()) == null) {
                throw (Throwable)new IllegalArgumentException("Cannot restore link at " + shareable.getLocalPath() + " outside of share");
            }
            IFileStorage iFileStorage = shareable2.getFileStorage();
            if (iFileStorage == null) {
                throw (Throwable)new IllegalArgumentException("Cannot restore link at " + shareable.getLocalPath() + " outside of share");
            }
            IFileStorage iFileStorage2 = shareable.getFileStorage();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            RestoreVersionableOperation$LockData lockData = RestoreVersionableOperation.lockTree(iFileStorage, (IProgressMonitor)subMonitor.newChild(5));
            if (lockData == null) {
                throw (Throwable)new IllegalArgumentException(shareable.getLocalPath() + " is not in a shared location");
            }
            try {
                FileItemInfo fileItemInfo;
                if (shareable.exists((IProgressMonitor)subMonitor.newChild(1))) {
                    throw (Throwable)new IllegalArgumentException(shareable.getLocalPath() + " already exists");
                }
                ResourceType resourceType = shareable2.getResourceType((IProgressMonitor)subMonitor.newChild(1));
                if (resourceType == null) {
                    throw (Throwable)new IllegalArgumentException("Parent folder " + iFileStorage.getShareable().getLocalPath() + " does not exist");
                }
                if (resourceType != ResourceType.FOLDER) {
                    throw (Throwable)new IllegalArgumentException("Parent " + iFileStorage.getShareable().getLocalPath() + " is not a folder");
                }
                IShare iShare = shareable.getShare((IProgressMonitor)subMonitor.newChild(1));
                if (iShare.getPath().equals((Object)shareable.getLocalPath())) {
                    throw (Throwable)new IllegalArgumentException("Cannot restore link at share root");
                }
                ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
                ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getCopyFileAreaRoot());
                if (((CopyFileAreaStore)((Object)iCopyFileArea)).isShareRoot((IVersionableHandle)IFolder.ITEM_TYPE.createItemHandle(iSymbolicLinkHandle.getItemId(), null), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle())) {
                    throw (Throwable)new IllegalArgumentException(iSymbolicLinkHandle.getItemId() + " already exists");
                }
                InverseFileItemInfo inverseFileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo((IVersionableHandle)iSymbolicLinkHandle, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                if (inverseFileItemInfo != null) {
                    if (inverseFileItemInfo.getLocalName() != null) {
                        throw (Throwable)new IllegalArgumentException(iSymbolicLinkHandle.getItemId() + " already exists");
                    }
                    if (inverseFileItemInfo.getVersionableHandle().getItemType() != iSymbolicLinkHandle.getItemType()) {
                        throw (Throwable)new IllegalArgumentException("Type mismatch, existing: " + inverseFileItemInfo.getVersionableHandle().getItemType().getName() + ", restoring: " + iSymbolicLinkHandle.getItemType().getName());
                    }
                }
                SharingManager.getInstance().disableChangeMonitoring();
                try {
                    iFileStorage2.create(string, (IProgressMonitor)subMonitor.newChild(60));
                }
                finally {
                    SharingManager.getInstance().enableChangeMonitoring();
                }
                if (inverseFileItemInfo != null) {
                    ContentHash contentHash = LocalChangeTracker.getLinkHash(string);
                    boolean bl = inverseFileItemInfo.getVersionableHandle().hasStateId() && !contentHash.equals((Object)inverseFileItemInfo.getHash());
                    fileItemInfo = new FileItemInfo(inverseFileItemInfo.getVersionableHandle(), bl, iFileStorage2.getModificationStamp(), inverseFileItemInfo.getParent(), inverseFileItemInfo.getName(), inverseFileItemInfo.isLoadedWithAnotherName(), inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredPredecessorHintHash(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredHash(), inverseFileItemInfo.getStoredNumLineDelimiters(), inverseFileItemInfo.isOriginalExecutable(), inverseFileItemInfo.isOriginalExecutable());
                } else {
                    fileItemInfo = new FileItemInfo(iSymbolicLinkHandle, false, null, null, false, null, null);
                }
                ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(shareable.getLocalPath(), fileItemInfo, (IProgressMonitor)subMonitor.newChild(25));
            }
            finally {
                RestoreVersionableOperation.unlockTree(lockData, (IProgressMonitor)subMonitor.newChild(5));
            }
        }
        catch (ContentHashAlgorithmException contentHashAlgorithmException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(contentHashAlgorithmException)));
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RestoreVersionableOperation$LockData lockTree(IFileStorage iFileStorage, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = SharingManager.getInstance().makeSchedulingRuleForIDE(Collections.singletonList(iFileStorage.getShareable()), ISharingManager$RuleKind.CREATE);
        boolean bl = false;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ICopyFileAreasLock iCopyFileAreasLock = null;
        try {
            Job.getJobManager().beginRule(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(45));
            Shareable shareable = iFileStorage.getShareable();
            iCopyFileAreasLock = CopyFileAreaManager.instance.lock(Collections.singleton(CopyFileAreaManager.instance.lockRequestFactory().getLockRequest(Collections.singleton(shareable))), (IProgressMonitor)subMonitor.newChild(50));
            IShare iShare = shareable.getShare((IProgressMonitor)subMonitor.newChild(5));
            if (iShare == null) {
                return null;
            }
            ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot());
            if (!CopyFileAreaManager.instance.isLocked(new ComponentLock(((CopyFileAreaStore)((Object)iCopyFileArea)).getRoot(), iShare.getSharingDescriptor().getConnectionHandle(), iShare.getSharingDescriptor().getComponent()))) {
                return null;
            }
            RestoreVersionableOperation$LockData restoreVersionableOperation$LockData = new RestoreVersionableOperation$LockData(iSchedulingRule, iCopyFileAreasLock);
            bl = true;
            RestoreVersionableOperation$LockData restoreVersionableOperation$LockData2 = restoreVersionableOperation$LockData;
            return restoreVersionableOperation$LockData2;
        }
        finally {
            if (!bl) {
                try {
                    if (iCopyFileAreasLock != null) {
                        ((CopyFileAreasLock)iCopyFileAreasLock).release((IProgressMonitor)subMonitor.newChild(1));
                    }
                }
                finally {
                    Job.getJobManager().endRule(iSchedulingRule);
                }
            }
        }
    }

    private static void unlockTree(RestoreVersionableOperation$LockData restoreVersionableOperation$LockData, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        try {
            restoreVersionableOperation$LockData.cfaRule.release(iProgressMonitor);
        }
        finally {
            Job.getJobManager().endRule(restoreVersionableOperation$LockData.fsRule);
        }
    }
}

