/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.ReadWriteLock$1;
import com.ibm.team.filesystem.client.internal.ReadWriteLock$LockStatus;
import com.ibm.team.repository.common.LogFactory;

public class ReadWriteLock {
    private final ReadWriteLock$LockStatus status = new ReadWriteLock$LockStatus(null);
    private final ThreadLocal threadStatus = new ReadWriteLock$1(this);

    public void acquireRead() {
        this.acquireRead(true);
    }

    public boolean tryAcquireRead() {
        return this.acquireRead(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean acquireRead(boolean bl) {
        ReadWriteLock$LockStatus readWriteLock$LockStatus = (ReadWriteLock$LockStatus)this.threadStatus.get();
        boolean bl2 = false;
        ReadWriteLock$LockStatus readWriteLock$LockStatus2 = this.status;
        synchronized (readWriteLock$LockStatus2) {
            while (true) {
                if (this.status.writes == readWriteLock$LockStatus.writes) {
                    ++this.status.reads;
                    break;
                }
                if (!bl) {
                    return false;
                }
                try {
                    this.status.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    LogFactory.getLog((String)ReadWriteLock.class.getName()).warn((Object)"We were interrupted", (Throwable)interruptedException);
                }
            }
        }
        ++readWriteLock$LockStatus.reads;
        if (bl2) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    public void acquireWrite() {
        this.acquireWrite(true);
    }

    public boolean tryAcquireWrite() {
        return this.acquireWrite(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean acquireWrite(boolean bl) {
        ReadWriteLock$LockStatus readWriteLock$LockStatus = (ReadWriteLock$LockStatus)this.threadStatus.get();
        if (readWriteLock$LockStatus.reads != 0) {
            throw (Throwable)new IllegalStateException("nesting of write lock inside read lock is illegal");
        }
        boolean bl2 = false;
        ReadWriteLock$LockStatus readWriteLock$LockStatus2 = this.status;
        synchronized (readWriteLock$LockStatus2) {
            while (true) {
                if (this.status.reads == 0 && this.status.writes == readWriteLock$LockStatus.writes) {
                    ++this.status.writes;
                    break;
                }
                if (!bl) {
                    return false;
                }
                try {
                    this.status.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    LogFactory.getLog((String)ReadWriteLock.class.getName()).warn((Object)"We were interrupted", (Throwable)interruptedException);
                }
            }
        }
        ++readWriteLock$LockStatus.writes;
        if (bl2) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release() {
        boolean bl;
        ReadWriteLock$LockStatus readWriteLock$LockStatus = (ReadWriteLock$LockStatus)this.threadStatus.get();
        if (readWriteLock$LockStatus.reads != 0) {
            ReadWriteLock$LockStatus readWriteLock$LockStatus2 = this.status;
            synchronized (readWriteLock$LockStatus2) {
                --this.status.reads;
                bl = this.status.reads == 0;
                this.status.notifyAll();
            }
            --readWriteLock$LockStatus.reads;
            bl = bl && readWriteLock$LockStatus.writes == 0;
        } else if (readWriteLock$LockStatus.writes != 0) {
            ReadWriteLock$LockStatus readWriteLock$LockStatus3 = this.status;
            synchronized (readWriteLock$LockStatus3) {
                --this.status.writes;
                this.status.notifyAll();
            }
            --readWriteLock$LockStatus.writes;
            bl = readWriteLock$LockStatus.writes == 0;
        } else {
            throw (Throwable)new IllegalStateException("releasing an unlocked lock is illegal");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reads() {
        ReadWriteLock$LockStatus readWriteLock$LockStatus = this.status;
        synchronized (readWriteLock$LockStatus) {
            return this.status.reads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writes() {
        ReadWriteLock$LockStatus readWriteLock$LockStatus = this.status;
        synchronized (readWriteLock$LockStatus) {
            return this.status.writes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int locks() {
        ReadWriteLock$LockStatus readWriteLock$LockStatus = this.status;
        synchronized (readWriteLock$LockStatus) {
            return this.status.reads + this.status.writes;
        }
    }

    public int threadReads() {
        return ((ReadWriteLock$LockStatus)this.threadStatus.get()).reads;
    }

    public int threadWrites() {
        return ((ReadWriteLock$LockStatus)this.threadStatus.get()).writes;
    }

    public int threadLocks() {
        ReadWriteLock$LockStatus readWriteLock$LockStatus = (ReadWriteLock$LockStatus)this.threadStatus.get();
        return readWriteLock$LockStatus.reads + readWriteLock$LockStatus.writes;
    }

    public String toString() {
        return "reads: " + this.threadReads() + "/" + this.reads() + " - writes: " + this.threadWrites() + "/" + this.writes();
    }
}

