/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.PlatformDetector$Platform;

public abstract class PlatformDetector {
    private static final String INTERNAL_OS_SUNOS = "SunOS";
    private static final String INTERNAL_OS_LINUX = "Linux";
    private static final String INTERNAL_OS_MACOSX = "Mac OS";
    private static final String INTERNAL_OS_AIX = "AIX";
    private static final String INTERNAL_OS_HPUX = "HP-UX";
    private static final String INTERNAL_OS_QNX = "QNX";
    private static final String INTERNAL_OS_OS400 = "OS/400";
    private static final String INTERNAL_OS_OS390 = "OS/390";
    private static final String INTERNAL_OS_ZOS = "z/OS";
    private static final String INTERNAL_OS_WIN32 = "win32";
    private static volatile PlatformDetector$Platform platform = null;

    public static PlatformDetector$Platform getPlatform() {
        if (platform != null) {
            return platform;
        }
        String string = System.getProperty("os.name");
        if (string == null) {
            platform = PlatformDetector$Platform.UNKNOWN;
            return platform;
        }
        if (string.regionMatches(true, 0, INTERNAL_OS_WIN32, 0, 3)) {
            platform = PlatformDetector$Platform.WINDOWS;
            return platform;
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_SUNOS)) {
            platform = PlatformDetector$Platform.UNIX;
            return platform;
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_LINUX)) {
            platform = PlatformDetector$Platform.UNIX;
            return platform;
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_QNX)) {
            platform = PlatformDetector$Platform.UNIX;
            return platform;
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_AIX)) {
            platform = PlatformDetector$Platform.UNIX;
            return platform;
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_HPUX)) {
            platform = PlatformDetector$Platform.UNIX;
            return platform;
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_OS400)) {
            platform = PlatformDetector$Platform.I;
            return platform;
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_OS390)) {
            platform = PlatformDetector$Platform.Z;
            return platform;
        }
        if (string.equalsIgnoreCase(INTERNAL_OS_ZOS) || string.equalsIgnoreCase("zos")) {
            platform = PlatformDetector$Platform.Z;
            return platform;
        }
        if (string.regionMatches(true, 0, INTERNAL_OS_MACOSX, 0, INTERNAL_OS_MACOSX.length())) {
            platform = PlatformDetector$Platform.UNIX;
            return platform;
        }
        platform = PlatformDetector$Platform.UNKNOWN;
        return platform;
    }
}

