/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.operations.AutoResolveOperation;
import com.ibm.team.filesystem.client.internal.operations.ChangeFilePropertiesOperation;
import com.ibm.team.filesystem.client.internal.operations.CreateBaselineOperation;
import com.ibm.team.filesystem.client.internal.operations.DeleteInRepositoryOperation;
import com.ibm.team.filesystem.client.internal.operations.DeliverOperation;
import com.ibm.team.filesystem.client.internal.operations.DiscardOperation;
import com.ibm.team.filesystem.client.internal.operations.LoadOperation;
import com.ibm.team.filesystem.client.internal.operations.LockOperation;
import com.ibm.team.filesystem.client.internal.operations.MoveFoldersOperation;
import com.ibm.team.filesystem.client.internal.operations.NewCheckInOperation;
import com.ibm.team.filesystem.client.internal.operations.ResumeOperation;
import com.ibm.team.filesystem.client.internal.operations.SuspendOperation;
import com.ibm.team.filesystem.client.internal.operations.TransferLockOperation;
import com.ibm.team.filesystem.client.internal.operations.UnlockOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.internal.share.ShareOperation;
import com.ibm.team.filesystem.client.internal.share.UnshareOperation;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.IChangeFilePropertiesOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICreateBaselineOperation;
import com.ibm.team.filesystem.client.operations.IDeleteFoldersOperation;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.operations.IDiscardOperation;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILockOperation;
import com.ibm.team.filesystem.client.operations.IMoveFoldersOperation;
import com.ibm.team.filesystem.client.operations.IResumeOperation;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.ISuspendOperation;
import com.ibm.team.filesystem.client.operations.ITransferLockOperation;
import com.ibm.team.filesystem.client.operations.IUnlockOperation;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MoveFoldersDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OperationOptions;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ResumeDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;

public class OperationFactory
implements IOperationFactory {
    private static OperationFactory operationFactory;
    private OperationOptions options = new OperationOptions();

    public static IOperationFactory getInstance() {
        if (operationFactory == null) {
            operationFactory = new OperationFactory();
        }
        return operationFactory;
    }

    private OperationFactory() {
    }

    public void setOperationOptions(OperationOptions operationOptions) {
        this.options = operationOptions == null ? new OperationOptions() : operationOptions;
    }

    public OperationOptions getOperationOptions() {
        return this.options;
    }

    private IFileSystemOperation configure(IFileSystemOperation iFileSystemOperation) {
        if (this.options != null) {
            this.options.configureOperation(iFileSystemOperation);
        }
        return iFileSystemOperation;
    }

    public IVerifyInSyncOperation getVerifyInSyncOperation(OutOfSyncDilemmaHandler outOfSyncDilemmaHandler) {
        return (IVerifyInSyncOperation)this.configure(new VerifySharesOperation(outOfSyncDilemmaHandler));
    }

    public ILoadOperation getLoadOperation(LoadDilemmaHandler loadDilemmaHandler) {
        return (ILoadOperation)this.configure(new LoadOperation(loadDilemmaHandler));
    }

    public IShareOperation getShareOperation(ShareDilemmaHandler shareDilemmaHandler) {
        return (IShareOperation)this.configure(new ShareOperation(shareDilemmaHandler));
    }

    public IUnshareOperation getUnshareOperation(UnshareDilemmaHandler unshareDilemmaHandler) {
        return (IUnshareOperation)this.configure(new UnshareOperation(unshareDilemmaHandler));
    }

    public ICheckinOperation getCheckinOperation(CommitDilemmaHandler commitDilemmaHandler) {
        return (ICheckinOperation)this.configure(new NewCheckInOperation(commitDilemmaHandler));
    }

    public IDeliverOperation getDeliverOperation(DeliverDilemmaHandler deliverDilemmaHandler) {
        return (IDeliverOperation)this.configure(new DeliverOperation(deliverDilemmaHandler));
    }

    public IChangeFilePropertiesOperation getChangeFilePropertiesOperation(ChangePropertiesDilemmaHandler changePropertiesDilemmaHandler) {
        return (IChangeFilePropertiesOperation)this.configure(new ChangeFilePropertiesOperation(changePropertiesDilemmaHandler));
    }

    public ICreateBaselineOperation getCreateBaselineOperation(CreateBaselineDilemmaHandler createBaselineDilemmaHandler) {
        return (ICreateBaselineOperation)this.configure(new CreateBaselineOperation(createBaselineDilemmaHandler));
    }

    public IWorkspaceUpdateOperation getWorkspaceUpdateOperation(WorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaHandler) {
        return (IWorkspaceUpdateOperation)this.configure(new WorkspaceUpdateOperation(workspaceUpdateDilemmaHandler));
    }

    public IAutoResolveConflictsOperation getAutoResolveConflictsOperation(AutoResolveConflictsDilemmaHandler autoResolveConflictsDilemmaHandler) {
        return (IAutoResolveConflictsOperation)this.configure(new AutoResolveOperation(autoResolveConflictsDilemmaHandler));
    }

    public IMoveFoldersOperation getMoveFoldersOperation(MoveFoldersDilemmaHandler moveFoldersDilemmaHandler) {
        return (IMoveFoldersOperation)this.configure(new MoveFoldersOperation(moveFoldersDilemmaHandler));
    }

    public IDeleteFoldersOperation getDeleteFoldersOperation(CommitDilemmaHandler commitDilemmaHandler) {
        return (IDeleteFoldersOperation)this.configure(new DeleteInRepositoryOperation(commitDilemmaHandler));
    }

    public ILockOperation getLockOperation(LockDilemmaHandler lockDilemmaHandler) {
        return (ILockOperation)this.configure(new LockOperation(lockDilemmaHandler));
    }

    public ITransferLockOperation getTransferLockOperation(LockDilemmaHandler lockDilemmaHandler) {
        return (ITransferLockOperation)this.configure(new TransferLockOperation(lockDilemmaHandler));
    }

    public IUnlockOperation getUnlockOperation(LockDilemmaHandler lockDilemmaHandler) {
        return (IUnlockOperation)this.configure(new UnlockOperation(lockDilemmaHandler));
    }

    public ISuspendOperation getSuspendOperation(SuspendDilemmaHandler suspendDilemmaHandler) {
        return (ISuspendOperation)this.configure(new SuspendOperation(suspendDilemmaHandler));
    }

    public IResumeOperation getResumeOperation(ResumeDilemmaHandler resumeDilemmaHandler) {
        return (IResumeOperation)this.configure(new ResumeOperation(resumeDilemmaHandler));
    }

    public IDiscardOperation getDiscardOperation(DiscardDilemmaHandler discardDilemmaHandler) {
        return (IDiscardOperation)this.configure(new DiscardOperation(discardDilemmaHandler));
    }
}

