/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.internal.FileSystemCoreActivator;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataUpdateJob$1;
import com.ibm.team.filesystem.client.internal.MetadataUpdateJob$2;
import com.ibm.team.filesystem.client.internal.MetadataUpdateJob$UpdateRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil$LockResult;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class MetadataUpdateJob
extends Job {
    private static final boolean DEBUG = System.getProperty("jazz.scm.debug.metadataUpdateJob", "false").equals("true");
    private static final boolean DETAILED_DEBUG = System.getProperty("jazz.scm.debug.metadataUpdateJob.detailed", "false").equals("true");
    private static final long MAX_LOCK_TIME = 500L;
    private static final long SCHEDULING_DELAY = 200L;
    private static MetadataUpdateJob instance;
    private final Map updates = new HashMap();
    private boolean workspaceReady = false;
    private ThreadLocal updating = new MetadataUpdateJob$1(this);

    private static synchronized MetadataUpdateJob getInstance() {
        if (instance == null) {
            instance = new MetadataUpdateJob();
            instance.setSystem(true);
        }
        return instance;
    }

    public static void queueUpdate(ManagedFileStore managedFileStore, boolean bl) {
        if (DETAILED_DEBUG) {
            System.out.print("Request to update metadata for " + managedFileStore.getCfaPath().append(managedFileStore.getLocalPath()).toOSString());
            if (bl) {
                System.out.println(" including children");
            } else {
                System.out.println();
            }
        }
        MetadataUpdateJob.getInstance().queue(new MetadataUpdateJob$UpdateRequest(managedFileStore, bl));
    }

    public MetadataUpdateJob() {
        super(Messages.MetadataUpdateJob_JobName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue(MetadataUpdateJob$UpdateRequest metadataUpdateJob$UpdateRequest) {
        Map map = this.updates;
        synchronized (map) {
            if (!((Boolean)this.updating.get()).booleanValue()) {
                IPath iPath;
                MetadataUpdateJob$UpdateRequest metadataUpdateJob$UpdateRequest2;
                IPath iPath2;
                TreeMap<IPath, MetadataUpdateJob$UpdateRequest> treeMap;
                IPath iPath3 = metadataUpdateJob$UpdateRequest.getCfaPath();
                HashMap hashMap = (HashMap)this.updates.get(iPath3);
                if (hashMap == null) {
                    hashMap = new HashMap();
                    this.updates.put(iPath3, hashMap);
                }
                if ((treeMap = (TreeMap<IPath, MetadataUpdateJob$UpdateRequest>)hashMap.get(iPath2 = metadataUpdateJob$UpdateRequest.getLockPath())) == null) {
                    treeMap = new TreeMap<IPath, MetadataUpdateJob$UpdateRequest>(new MetadataUpdateJob$2(this));
                    hashMap.put(iPath2, treeMap);
                }
                if ((metadataUpdateJob$UpdateRequest2 = (MetadataUpdateJob$UpdateRequest)treeMap.get(iPath = metadataUpdateJob$UpdateRequest.getLocalPath())) == null) {
                    treeMap.put(iPath, metadataUpdateJob$UpdateRequest);
                } else {
                    treeMap.put(iPath, metadataUpdateJob$UpdateRequest.combine(metadataUpdateJob$UpdateRequest2));
                }
            }
        }
        this.schedule(200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requeue(IPath iPath, IPath iPath2, TreeMap treeMap) {
        Map map = this.updates;
        synchronized (map) {
            IPath iPath3;
            TreeMap treeMap2;
            HashMap<IPath, TreeMap> hashMap = (HashMap<IPath, TreeMap>)this.updates.get(iPath);
            if (hashMap == null) {
                hashMap = new HashMap<IPath, TreeMap>();
                this.updates.put(iPath, hashMap);
            }
            if ((treeMap2 = (TreeMap)hashMap.get(iPath3 = iPath2)) == null) {
                hashMap.put(iPath3, treeMap);
            } else {
                for (MetadataUpdateJob$UpdateRequest metadataUpdateJob$UpdateRequest : treeMap.values()) {
                    IPath iPath4 = metadataUpdateJob$UpdateRequest.getLocalPath();
                    MetadataUpdateJob$UpdateRequest metadataUpdateJob$UpdateRequest2 = (MetadataUpdateJob$UpdateRequest)treeMap2.get(iPath4);
                    if (metadataUpdateJob$UpdateRequest2 == null) {
                        treeMap2.put(iPath4, metadataUpdateJob$UpdateRequest);
                        continue;
                    }
                    treeMap2.put(iPath4, metadataUpdateJob$UpdateRequest.combine(metadataUpdateJob$UpdateRequest2));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRun() {
        Map map = this.updates;
        synchronized (map) {
            return !this.updates.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (!this.isWorkspaceReady()) {
            this.schedule(2000L);
            return Status.OK_STATUS;
        }
        while (true) {
            TreeMap treeMap = null;
            IPath iPath = null;
            IPath iPath2 = null;
            Map map = this.updates;
            synchronized (map) {
                if (this.updates.isEmpty()) {
                    if (!FileSystemCore.isShutDown()) {
                        this.schedule(200L);
                    }
                    return Status.OK_STATUS;
                }
                Iterator iterator = this.updates.entrySet().iterator();
                Map.Entry entry = iterator.next();
                iPath = (IPath)entry.getKey();
                Iterator iterator2 = ((Map)entry.getValue()).entrySet().iterator();
                if (iterator2.hasNext()) {
                    Map.Entry entry2 = iterator2.next();
                    iPath2 = (IPath)entry2.getKey();
                    treeMap = (TreeMap)entry2.getValue();
                    iterator2.remove();
                    if (!iterator2.hasNext()) {
                        iterator.remove();
                    }
                } else {
                    iterator.remove();
                }
            }
            if (treeMap == null) continue;
            subMonitor.setWorkRemaining(100);
            try {
                this.process(iPath, iPath2, treeMap, subMonitor.newChild(1));
            }
            catch (OperationCanceledException operationCanceledException) {
                this.requeue(iPath, iPath2, treeMap);
                this.schedule(200L);
                throw (Throwable)operationCanceledException;
            }
        }
    }

    public boolean isWorkspaceReady() {
        block17: {
            if (!this.workspaceReady) {
                BundleContext bundleContext = FileSystemCoreActivator.getBundleContext();
                if (bundleContext == null) {
                    this.workspaceReady = true;
                } else {
                    ServiceTracker serviceTracker = this.getPackageAdminServiceTracker(bundleContext);
                    try {
                        try {
                            Bundle[] bundleArray;
                            PackageAdmin packageAdmin = (PackageAdmin)serviceTracker.getService();
                            this.workspaceReady = packageAdmin == null ? true : ((bundleArray = packageAdmin.getBundles("org.eclipse.core.resources", null)).length != 1 ? true : bundleArray[0].getState() == 32);
                        }
                        catch (Exception exception) {
                            this.workspaceReady = true;
                            try {
                                if (serviceTracker != null) {
                                    serviceTracker.close();
                                }
                                break block17;
                            }
                            catch (Exception exception2) {}
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (serviceTracker != null) {
                                serviceTracker.close();
                            }
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        if (serviceTracker != null) {
                            serviceTracker.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return this.workspaceReady;
    }

    private ServiceTracker getPackageAdminServiceTracker(BundleContext bundleContext) {
        ServiceTracker serviceTracker = new ServiceTracker(bundleContext, PackageAdmin.class.getName(), null);
        serviceTracker.open();
        return serviceTracker;
    }

    private void process(IPath iPath, IPath iPath2, TreeMap treeMap, SubMonitor subMonitor) {
        block17: {
            subMonitor.setWorkRemaining(100);
            try {
                subMonitor.subTask(NLS.bind((String)Messages.MetadataUpdateJob_WaitingSubTask, (Object)iPath));
                CFALockUtil$LockResult cFALockUtil$LockResult = CFALockUtil.createAndLockForUpdateOfChildren(iPath, iPath2, true, (IProgressMonitor)subMonitor.newChild(1));
                long l = System.currentTimeMillis();
                if (DEBUG) {
                    System.out.println("Processing metadata updates for share " + iPath.append(iPath2).toOSString());
                }
                if (cFALockUtil$LockResult.code == 0) {
                    boolean bl = false;
                    try {
                        subMonitor.setWorkRemaining(treeMap.size() + 1);
                        Iterator iterator = treeMap.values().iterator();
                        while (iterator.hasNext()) {
                            MetadataUpdateJob$UpdateRequest metadataUpdateJob$UpdateRequest = (MetadataUpdateJob$UpdateRequest)iterator.next();
                            if (subMonitor.isCanceled() || this.isTimeToStop(l, bl)) {
                                if (DEBUG) {
                                    System.out.println("Processing time expired. Requeuing request to update " + MetadataUpdateJob$UpdateRequest.access$0(metadataUpdateJob$UpdateRequest).getCfaPath().append(MetadataUpdateJob$UpdateRequest.access$0(metadataUpdateJob$UpdateRequest).getLocalPath()).toOSString());
                                }
                                subMonitor.subTask(Messages.MetadataUpdateJob_TimedoutSubtask);
                                throw (Throwable)new OperationCanceledException();
                            }
                            try {
                                this.updating.set(true);
                                bl |= metadataUpdateJob$UpdateRequest.update(subMonitor.newChild(1));
                                iterator.remove();
                            }
                            finally {
                                this.updating.set(false);
                            }
                        }
                    }
                    finally {
                        CFALockUtil.endBatching(cFALockUtil$LockResult, subMonitor.newChild(1));
                    }
                    if (DEBUG) {
                        System.out.println("Processing completed in " + (System.currentTimeMillis() - l) + "ms for share " + iPath.append(iPath2).toOSString());
                    }
                    break block17;
                }
                if (subMonitor.isCanceled()) {
                    if (DEBUG) {
                        System.out.println("Processing canceled. Requeuing request to update " + iPath.append(iPath2).toOSString());
                    }
                    throw (Throwable)new OperationCanceledException();
                }
            }
            catch (FileSystemClientException fileSystemClientException) {
                LoggingHelper.log(fileSystemClientException);
            }
        }
    }

    private boolean isTimeToStop(long l, boolean bl) {
        if (bl || FileSystemCore.isShutDown()) {
            return false;
        }
        return System.currentTimeMillis() - l > 500L;
    }

    public boolean belongsTo(Object object) {
        if (object == CopyFileAreaManager.instance) {
            return true;
        }
        if (object == LocalChangeManager.getInstance()) {
            return true;
        }
        return super.belongsTo(object);
    }

    public int getUpdateCount() {
        int n = 0;
        for (Map.Entry entry : this.updates.entrySet()) {
            n += 1 + ((Map)entry.getValue()).size();
        }
        return n;
    }

    static /* synthetic */ boolean access$0() {
        return DETAILED_DEBUG;
    }

    static /* synthetic */ boolean access$1() {
        return DEBUG;
    }
}

