/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.IRemoteVisitor;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.ISharingMetadata$ISharingDescriptorPath;
import com.ibm.team.filesystem.client.internal.ISharingMetadata$ITransaction;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LockableMap;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataChangeTracker$ChangeDiskBackedMapManager;
import com.ibm.team.filesystem.client.internal.MetadataChangeTracker$ChangeType;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class MetadataChangeTracker
implements ISharingMetadata,
IMetadataChangeTracker {
    private static final String SCM_CHANGED_INFOS_PREFIX = ".changedinfos";
    private static final String SCM_CHANGED_INFOS_SUFFIX = ".dat";
    protected ISharingMetadata delegate;
    protected IPath cfaRoot;
    protected IPath basePath;
    protected PersistentHeapManager heapMgr;
    protected MetadataChangeTracker$ChangeDiskBackedMapManager mapMgr;
    protected ReadWriteLock globalLock;

    private void setCorrupt(DBHMException dBHMException) {
        this.setCorrupt(true, dBHMException.getMessage(), dBHMException.getCause());
    }

    public MetadataChangeTracker(ISharingMetadata iSharingMetadata, IPath iPath, IPath iPath2) {
        this.delegate = iSharingMetadata;
        this.cfaRoot = iPath;
        this.basePath = iPath2;
        this.heapMgr = new PersistentHeapManager();
        this.globalLock = new ReadWriteLock();
        this.mapMgr = new MetadataChangeTracker$ChangeDiskBackedMapManager(this, this.globalLock, iSharingMetadata.getPersistentMetadataFlag(), this);
    }

    public void accept(IVisitor iVisitor, IPath iPath, int n, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (bl) {
            this.globalLock.acquireWrite();
        } else {
            this.globalLock.acquireRead();
        }
        try {
            this.delegate.accept(iVisitor, iPath, n, bl, iProgressMonitor);
        }
        finally {
            this.globalLock.release();
        }
    }

    public void accept(IRemoteVisitor iRemoteVisitor, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, int n, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (bl) {
            this.globalLock.acquireWrite();
        } else {
            this.globalLock.acquireRead();
        }
        try {
            this.delegate.accept(iRemoteVisitor, iVersionableHandle, iComponentHandle, iContextHandle, n, bl, iProgressMonitor);
        }
        finally {
            this.globalLock.release();
        }
    }

    public IPath[] allShares() throws FileSystemClientException {
        return this.delegate.allShares();
    }

    public Collection allShares(IPath iPath) throws FileSystemClientException {
        return this.delegate.allShares(iPath);
    }

    public void clear() throws FileSystemClientException {
        this.globalLock.acquireWrite();
        try {
            this.mapMgr.closeAll();
            this.delegate.clear();
        }
        finally {
            this.globalLock.release();
        }
    }

    public void close() throws FileSystemClientException {
        this.delegate.close();
        this.globalLock.acquireWrite();
        try {
            this.mapMgr.closeAll();
        }
        finally {
            this.globalLock.release();
        }
    }

    private void notifyTracker(IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        LocalChangeTracker localChangeTracker = LocalChangeManager.getInstance().findTracker(iContextHandle, iComponentHandle, this.cfaRoot);
        if (localChangeTracker != null) {
            localChangeTracker.metadataChanged();
        }
    }

    public FileItemInfo deleteFileItemInfo(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.deleteFileItemInfo(iPath, iProgressMonitor);
    }

    public boolean isCaseSensitive() {
        return this.delegate.isCaseSensitive();
    }

    public Map getChildInfos(IPath iPath) throws FileSystemClientException {
        return this.delegate.getChildInfos(iPath);
    }

    public FileItemInfo getFileItemInfo(IPath iPath) throws FileSystemClientException {
        return this.delegate.getFileItemInfo(iPath);
    }

    public InverseFileItemInfo getFileItemInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        return this.delegate.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
    }

    public Collection getLocations(IVersionableHandle iVersionableHandle) throws FileSystemClientException {
        return this.delegate.getLocations(iVersionableHandle);
    }

    public IPath getPathForShareRoot(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        return this.delegate.getPathForShareRoot(iVersionableHandle, iComponentHandle, iContextHandle);
    }

    public ISharingDescriptor getSharingDescriptor(IPath iPath) throws FileSystemClientException {
        return this.delegate.getSharingDescriptor(iPath);
    }

    public ISharingDescriptor findSharingDescriptor(IPath iPath) throws FileSystemClientException {
        return this.delegate.findSharingDescriptor(iPath);
    }

    public ISharingMetadata$ISharingDescriptorPath findSharingDescriptorPath(IPath iPath) throws FileSystemClientException {
        return this.delegate.findSharingDescriptorPath(iPath);
    }

    public IPath findConflictingShare(IPath iPath) throws FileSystemClientException {
        return this.delegate.findConflictingShare(iPath);
    }

    public FileItemInfo moveFileItemInfo(IPath iPath, IPath iPath2) throws FileSystemClientException {
        return this.delegate.moveFileItemInfo(iPath, iPath2);
    }

    public void run(ISharingMetadata$ITransaction iSharingMetadata$ITransaction) throws FileSystemClientException {
        this.globalLock.acquireWrite();
        try {
            this.delegate.run(iSharingMetadata$ITransaction);
        }
        finally {
            this.globalLock.release();
        }
    }

    private boolean isIgnored(IPath iPath, SubMonitor subMonitor) throws FileSystemClientException {
        SharingManager sharingManager = SharingManager.getInstance();
        Shareable shareable = new Shareable(this.cfaRoot, iPath, ResourceType.FILE);
        sharingManager.disableChangeMonitoring();
        try {
            boolean bl = shareable.shouldBeIgnored((IProgressMonitor)subMonitor);
            return bl;
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getLocalChanges(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        LockableMap lockableMap = this.getMapFor(iComponentHandle, iContextHandle, false);
        HashMap hashMap = new HashMap();
        try {
            ArrayList<MetadataChangeTracker$ChangeType> arrayList;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
            Map map = lockableMap.entries();
            synchronized (map) {
                int n = lockableMap.entries().size();
                arrayList = new ArrayList<MetadataChangeTracker$ChangeType>(n);
                subMonitor.beginTask(Messages.MetadataChangeTracker_LOADING_CHANGES, n);
                block15: for (Map.Entry entry : lockableMap.entries().entrySet()) {
                    boolean bl;
                    boolean bl2;
                    IFolderHandle iFolderHandle;
                    IFolderHandle iFolderHandle2;
                    IPath iPath;
                    IPath iPath2;
                    Object object;
                    IVersionableHandle iVersionableHandle = (IVersionableHandle)((IItemType)entry.getValue()).createItemHandle((UUID)entry.getKey(), null);
                    InverseFileItemInfo inverseFileItemInfo = this.getInverseInfo(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                    if (inverseFileItemInfo == null) {
                        FileSystemClientException fileSystemClientException = new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.MetadataChangeTracker_8, (Object)iVersionableHandle.getItemId().toString()), null));
                        fileSystemClientException.fillInStackTrace();
                        this.setCorrupt(true, fileSystemClientException.getMessage(), (Throwable)((Object)fileSystemClientException));
                        throw (Throwable)((Object)fileSystemClientException);
                    }
                    int n2 = inverseFileItemInfo.getVersionableHandle().getStateId() == null ? 4 : (inverseFileItemInfo.getLocalName() == null ? (this.getPathForShareRoot(inverseFileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle) == null ? (((InverseFileItemInfo)(object = this.getInverseInfo((IVersionableHandle)inverseFileItemInfo.getParent(), iComponentHandle, iContextHandle, hashMap))).getLocalName() == null ? 2 : 1) : 1) : (this.noPathChange(inverseFileItemInfo) ? 0 : 3));
                    switch (n2) {
                        case 2: {
                            object = null;
                            iPath2 = null;
                            iPath = null;
                            break;
                        }
                        case 1: {
                            object = this.computeDeletionPath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            if (this.isIgnored((IPath)object, subMonitor.newChild(1))) continue block15;
                            iPath2 = this.computeRemotePath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            iPath = null;
                            break;
                        }
                        case 0: {
                            object = this.computeLocalPath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            if (this.isIgnored((IPath)object, subMonitor.newChild(1))) continue block15;
                            iPath2 = this.computeRemotePath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            iPath = null;
                            break;
                        }
                        case 4: {
                            object = this.computeLocalPath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            if (this.isIgnored((IPath)object, subMonitor.newChild(1))) continue block15;
                            iPath2 = null;
                            iPath = null;
                            break;
                        }
                        case 3: {
                            object = this.computeLocalPath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            iFolderHandle2 = this.getPathForShareRoot(iVersionableHandle, iComponentHandle, iContextHandle);
                            iPath = iFolderHandle2 != null ? iFolderHandle2.removeLastSegments(1).append(inverseFileItemInfo.getName()) : this.computeDeletionPath((IVersionableHandle)inverseFileItemInfo.getParent(), iComponentHandle, iContextHandle, hashMap).append(inverseFileItemInfo.getName());
                            iFolderHandle = subMonitor.newChild(1);
                            iFolderHandle.setWorkRemaining(2);
                            bl2 = this.isIgnored((IPath)object, iFolderHandle.newChild(1));
                            bl = this.isIgnored(iPath, iFolderHandle.newChild(1));
                            if (bl && bl2) continue block15;
                            if (bl && !bl2) {
                                n2 = 4;
                                iPath2 = null;
                                iPath = null;
                                break;
                            }
                            if (!bl && bl2) {
                                n2 = 1;
                                iPath2 = this.computeRemotePath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                                object = iPath;
                                iPath = null;
                                break;
                            }
                            Assert.isTrue((!bl && !bl2 ? 1 : 0) != 0);
                            iPath2 = this.computeRemotePath(iVersionableHandle, iComponentHandle, iContextHandle, hashMap);
                            break;
                        }
                        default: {
                            throw (Throwable)new IllegalStateException();
                        }
                    }
                    iFolderHandle2 = inverseFileItemInfo.getLocalParent();
                    iFolderHandle = inverseFileItemInfo.getParent();
                    bl2 = !inverseFileItemInfo.isFolder() && (inverseFileItemInfo.isContentChanged() || inverseFileItemInfo.getOriginalLineDelimiter() != inverseFileItemInfo.getLineDelimiter());
                    boolean bl3 = bl = inverseFileItemInfo.isExecutable() != inverseFileItemInfo.isOriginalExecutable() || inverseFileItemInfo.getOriginalContentType() == null && inverseFileItemInfo.getContentType() != null || inverseFileItemInfo.getOriginalContentType() != null && !inverseFileItemInfo.getOriginalContentType().equals(inverseFileItemInfo.getContentType());
                    if (n2 == 0 && !bl2 && !bl) {
                        throw (Throwable)new IllegalStateException();
                    }
                    arrayList.add(new MetadataChangeTracker$ChangeType(inverseFileItemInfo.getVersionableHandle(), n2, iFolderHandle2, iFolderHandle, (IPath)object, iPath2, iPath, bl2, bl));
                }
            }
            ArrayList<MetadataChangeTracker$ChangeType> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (DBHMException dBHMException) {
            this.setCorrupt(true, "Failure during getLocalChanges()", dBHMException.getCause());
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_4, dBHMException.getCause())));
        }
        finally {
            this.releaseMap(lockableMap);
        }
    }

    private IPath computeLocalPath(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, Map map) throws FileSystemClientException {
        ArrayList<CharSequence> arrayList = null;
        int n = 0;
        while (true) {
            CharSequence charSequence;
            IPath iPath;
            if ((iPath = this.delegate.getPathForShareRoot(iVersionableHandle, iComponentHandle, iContextHandle)) != null) {
                if (arrayList == null) {
                    return iPath;
                }
                int n2 = arrayList.size() - 1;
                if (n2 == 0) {
                    return iPath.append((String)arrayList.get(0));
                }
                charSequence = new StringBuffer(n + n2);
                ((StringBuffer)charSequence).append((String)arrayList.get(n2));
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    ((StringBuffer)charSequence).append('/');
                    ((StringBuffer)charSequence).append((String)arrayList.get(n3));
                    --n3;
                }
                return iPath.append(((StringBuffer)charSequence).toString());
            }
            InverseFileItemInfo inverseFileItemInfo = this.getInverseInfo(iVersionableHandle, iComponentHandle, iContextHandle, map);
            if (inverseFileItemInfo == null) {
                this.setCorrupt(true, "Could not resolve path via getInverseInfo() for " + (iVersionableHandle == null ? "null item" : iVersionableHandle.getItemId().getUuidValue()), null);
                throw (Throwable)new IllegalStateException("Path to " + inverseFileItemInfo.getVersionableHandle() + " does not resolve");
            }
            charSequence = inverseFileItemInfo.getLocalName();
            if (charSequence == null) {
                this.setCorrupt(true, "Could not resolve path via getInverseInfo() for " + (iVersionableHandle == null ? "null item" : iVersionableHandle.getItemId().getUuidValue()), null);
                throw (Throwable)new IllegalStateException("Path to " + inverseFileItemInfo.getVersionableHandle() + " does not resolve");
            }
            if (arrayList == null) {
                arrayList = new ArrayList<CharSequence>();
            }
            n += ((String)charSequence).length();
            arrayList.add(charSequence);
            iVersionableHandle = inverseFileItemInfo.getLocalParent();
        }
    }

    private IPath computeRemotePath(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, Map map) throws FileSystemClientException {
        ArrayList<String> arrayList = null;
        int n = 0;
        while (true) {
            InverseFileItemInfo inverseFileItemInfo = this.getInverseInfo(iVersionableHandle, iComponentHandle, iContextHandle, map);
            String string = inverseFileItemInfo.getName();
            IPath iPath = this.delegate.getPathForShareRoot(iVersionableHandle, iComponentHandle, iContextHandle);
            if (iPath != null) {
                if (string != null && !string.equals(inverseFileItemInfo.getLocalName())) {
                    iPath = iPath.removeLastSegments(1);
                    if (arrayList == null) {
                        return iPath.append(string);
                    }
                    arrayList.add(string);
                } else if (arrayList == null) {
                    return iPath;
                }
                int n2 = arrayList.size() - 1;
                if (n2 == 0) {
                    return iPath.append((String)arrayList.get(0));
                }
                StringBuffer stringBuffer = new StringBuffer(n + n2);
                stringBuffer.append((String)arrayList.get(n2));
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    stringBuffer.append('/');
                    stringBuffer.append((String)arrayList.get(n3));
                    --n3;
                }
                return iPath.append(stringBuffer.toString());
            }
            if (string == null) {
                throw (Throwable)new IllegalStateException("Path to " + inverseFileItemInfo.getVersionableHandle() + " does not resolve");
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            n += string.length();
            arrayList.add(string);
            iVersionableHandle = inverseFileItemInfo.getParent();
        }
    }

    private IPath computeDeletionPath(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, Map map) throws FileSystemClientException {
        ArrayList<CharSequence> arrayList = null;
        int n = 0;
        boolean bl = true;
        while (true) {
            CharSequence charSequence;
            InverseFileItemInfo inverseFileItemInfo;
            IPath iPath;
            if ((iPath = this.delegate.getPathForShareRoot(iVersionableHandle, iComponentHandle, iContextHandle)) != null) {
                if (bl) {
                    inverseFileItemInfo = this.getInverseInfo(iVersionableHandle, iComponentHandle, iContextHandle, map);
                    charSequence = inverseFileItemInfo.getName();
                    if (charSequence != null && inverseFileItemInfo.getLocalName() == null && !((String)charSequence).equals(iPath.lastSegment())) {
                        iPath = iPath.removeLastSegments(1);
                        if (arrayList == null) {
                            return iPath.append((String)charSequence);
                        }
                        arrayList.add(charSequence);
                    } else if (arrayList == null) {
                        return iPath;
                    }
                } else if (arrayList == null) {
                    return iPath;
                }
                int n2 = arrayList.size() - 1;
                if (n2 == 0) {
                    return iPath.append((String)arrayList.get(0));
                }
                charSequence = new StringBuffer(n + n2);
                ((StringBuffer)charSequence).append((String)arrayList.get(n2));
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    ((StringBuffer)charSequence).append('/');
                    ((StringBuffer)charSequence).append((String)arrayList.get(n3));
                    --n3;
                }
                return iPath.append(((StringBuffer)charSequence).toString());
            }
            inverseFileItemInfo = this.getInverseInfo(iVersionableHandle, iComponentHandle, iContextHandle, map);
            charSequence = inverseFileItemInfo.getLocalName();
            if (bl) {
                if (charSequence != null) {
                    bl = false;
                } else {
                    charSequence = inverseFileItemInfo.getName();
                }
            }
            if (charSequence == null) {
                throw (Throwable)new IllegalStateException("Path to " + inverseFileItemInfo.getVersionableHandle() + " does not resolve");
            }
            if (arrayList == null) {
                arrayList = new ArrayList<CharSequence>();
            }
            n += ((String)charSequence).length();
            arrayList.add(charSequence);
            iVersionableHandle = bl ? inverseFileItemInfo.getParent() : inverseFileItemInfo.getLocalParent();
        }
    }

    private InverseFileItemInfo getInverseInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, Map map) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo = (InverseFileItemInfo)map.get(iVersionableHandle.getItemId());
        if (inverseFileItemInfo != null) {
            return inverseFileItemInfo;
        }
        inverseFileItemInfo = this.delegate.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
        map.put(iVersionableHandle.getItemId(), inverseFileItemInfo);
        return inverseFileItemInfo;
    }

    public FileItemInfo setFileItemInfo(IPath iPath, FileItemInfo fileItemInfo) throws FileSystemClientException {
        return this.delegate.setFileItemInfo(iPath, fileItemInfo);
    }

    private static boolean isUnchanged(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private static boolean isUnchanged(IVersionableHandle iVersionableHandle, IVersionableHandle iVersionableHandle2, boolean bl) {
        if (iVersionableHandle == iVersionableHandle2) {
            return true;
        }
        if (iVersionableHandle == null || iVersionableHandle2 == null) {
            return false;
        }
        if (bl && !MetadataChangeTracker.isUnchanged(iVersionableHandle.getStateId(), iVersionableHandle2.getStateId())) {
            return false;
        }
        return iVersionableHandle.sameItemId((IItemHandle)iVersionableHandle2);
    }

    private static boolean isUnchanged(UUID uUID, UUID uUID2) {
        if (uUID == uUID2) {
            return true;
        }
        if (uUID == null || uUID2 == null) {
            return false;
        }
        return uUID.equals((Object)uUID2);
    }

    private boolean itemUnchanged(InverseFileItemInfo inverseFileItemInfo, InverseFileItemInfo inverseFileItemInfo2) {
        if (inverseFileItemInfo == inverseFileItemInfo2) {
            return true;
        }
        if (inverseFileItemInfo == null || inverseFileItemInfo2 == null) {
            return false;
        }
        return MetadataChangeTracker.isUnchanged((IVersionableHandle)inverseFileItemInfo.getParent(), (IVersionableHandle)inverseFileItemInfo2.getParent(), false) && MetadataChangeTracker.isUnchanged(inverseFileItemInfo.getName(), inverseFileItemInfo2.getName()) && MetadataChangeTracker.isUnchanged((IVersionableHandle)inverseFileItemInfo.getLocalParent(), (IVersionableHandle)inverseFileItemInfo2.getLocalParent(), false) && (MetadataChangeTracker.isUnchanged(inverseFileItemInfo.getLocalName(), inverseFileItemInfo2.getLocalName()) || inverseFileItemInfo.isLoadedWithAnotherName() && inverseFileItemInfo2.isLoadedWithAnotherName()) && inverseFileItemInfo.isContentChanged() == inverseFileItemInfo2.isContentChanged() && MetadataChangeTracker.isUnchanged(inverseFileItemInfo.getContentType(), inverseFileItemInfo2.getContentType()) && inverseFileItemInfo.getLineDelimiter() == inverseFileItemInfo2.getLineDelimiter() && MetadataChangeTracker.isUnchanged(inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo2.getOriginalContentType()) && inverseFileItemInfo.getOriginalLineDelimiter() == inverseFileItemInfo2.getOriginalLineDelimiter() && inverseFileItemInfo.isExecutable() == inverseFileItemInfo2.isExecutable() && inverseFileItemInfo.isOriginalExecutable() == inverseFileItemInfo2.isOriginalExecutable();
    }

    private boolean noChange(InverseFileItemInfo inverseFileItemInfo) throws FileSystemClientException {
        if (inverseFileItemInfo == null) {
            return true;
        }
        return inverseFileItemInfo.getVersionableHandle().hasStateId() && inverseFileItemInfo.getOriginalLineDelimiter() == inverseFileItemInfo.getLineDelimiter() && inverseFileItemInfo.isExecutable() == inverseFileItemInfo.isOriginalExecutable() && !inverseFileItemInfo.isContentChanged() && MetadataChangeTracker.isUnchanged(inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType()) && this.noPathChange(inverseFileItemInfo);
    }

    private boolean noPathChange(InverseFileItemInfo inverseFileItemInfo) throws FileSystemClientException {
        if (inverseFileItemInfo == null) {
            return true;
        }
        return (MetadataChangeTracker.isUnchanged(inverseFileItemInfo.getLocalName(), inverseFileItemInfo.getName()) || inverseFileItemInfo.isLoadedWithAnotherName()) && MetadataChangeTracker.isUnchanged((IVersionableHandle)inverseFileItemInfo.getLocalParent(), (IVersionableHandle)inverseFileItemInfo.getParent(), false);
    }

    private LockableMap getMapFor(IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        return this.getMapFor(iComponentHandle, iContextHandle, true);
    }

    private LockableMap getMapFor(IComponentHandle iComponentHandle, IContextHandle iContextHandle, boolean bl) throws FileSystemClientException {
        Path path = new Path(SCM_CHANGED_INFOS_PREFIX + iComponentHandle.getItemId().getUuidValue() + "_" + iContextHandle.getItemId().getUuidValue() + SCM_CHANGED_INFOS_SUFFIX);
        try {
            return this.mapMgr.loadMap((IPath)path, bl, (IPath)path);
        }
        catch (DBHMException dBHMException) {
            this.setCorrupt(true, "Failed to get map for " + path.toString(), dBHMException.getCause());
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.DiskBackedMapManager_0, dBHMException.getCause())));
        }
    }

    private void releaseMap(LockableMap lockableMap) throws FileSystemClientException {
        this.mapMgr.releaseMap(lockableMap);
    }

    public InverseFileItemInfo setFileItemInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, InverseFileItemInfo inverseFileItemInfo) throws FileSystemClientException {
        if (inverseFileItemInfo != null && !iVersionableHandle.sameItemId((IItemHandle)inverseFileItemInfo.getVersionableHandle())) {
            throw (Throwable)new IllegalArgumentException();
        }
        InverseFileItemInfo inverseFileItemInfo2 = this.delegate.setFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle, inverseFileItemInfo);
        boolean bl = this.noChange(inverseFileItemInfo);
        if (this.noChange(inverseFileItemInfo2) != bl) {
            try {
                LockableMap lockableMap = this.getMapFor(iComponentHandle, iContextHandle);
                try {
                    if (bl) {
                        lockableMap.entries().remove(iVersionableHandle.getItemId());
                    } else {
                        lockableMap.entries().put(iVersionableHandle.getItemId(), iVersionableHandle.getItemType());
                    }
                }
                finally {
                    this.releaseMap(lockableMap);
                }
            }
            catch (DBHMException dBHMException) {
                this.setCorrupt(true, "Failure when setting item info", dBHMException.getCause());
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_6, dBHMException.getCause())));
            }
            this.notifyTracker(iComponentHandle, iContextHandle);
        } else if (!this.itemUnchanged(inverseFileItemInfo, inverseFileItemInfo2)) {
            this.notifyTracker(iComponentHandle, iContextHandle);
        }
        return inverseFileItemInfo2;
    }

    public ISharingDescriptor setSharingDescriptor(IPath iPath, ISharingDescriptor iSharingDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.setSharingDescriptor(iPath, iSharingDescriptor, iProgressMonitor);
    }

    public String toDebugString() {
        return this.delegate.toDebugString();
    }

    public Map getSharingDescriptors(IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        return this.delegate.getSharingDescriptors(iComponentHandle, iContextHandle);
    }

    public Map getSharingDescriptors() throws FileSystemClientException {
        return this.delegate.getSharingDescriptors();
    }

    public Collection allLoadedComponents(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.allLoadedComponents(iProgressMonitor);
    }

    public Collection allLoadedContexts(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.allLoadedContexts(iProgressMonitor);
    }

    public LoadedConfigurationDescriptor componentLoaded(LoadedConfigurationDescriptor loadedConfigurationDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.componentLoaded(loadedConfigurationDescriptor, iProgressMonitor);
    }

    public LoadedConfigurationDescriptor componentUnloaded(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.componentUnloaded(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public boolean hasShares(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.hasShares(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public boolean isLoaded(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.delegate.isLoaded(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public PersistentBusyFlag getPersistentMetadataFlag() {
        return this.delegate.getPersistentMetadataFlag();
    }

    public void addCorruptionListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) {
        this.delegate.addCorruptionListener(iCorruptCopyFileAreaListener);
    }

    public void removeCorruptionListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) {
        this.delegate.removeCorruptionListener(iCorruptCopyFileAreaListener);
    }

    public void setCorrupt(boolean bl, String string, Throwable throwable) {
        this.delegate.setCorrupt(bl, string, throwable);
    }

    public boolean isCorrupted() {
        return this.delegate.isCorrupted();
    }

    public IPath getCanonicalPath(IPath iPath, boolean bl) {
        return this.delegate.getCanonicalPath(iPath, bl);
    }

    public boolean isSamePath(IPath iPath, IPath iPath2) {
        return this.delegate.isSamePath(iPath, iPath2);
    }

    static /* synthetic */ void access$0(MetadataChangeTracker metadataChangeTracker, DBHMException dBHMException) {
        metadataChangeTracker.setCorrupt(dBHMException);
    }
}

