/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.Store;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IFolder;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class MetadataChangeTracker$ChangedDescriptorsStore
extends Store {
    private static final int METADATA_VERSION = 0;

    public MetadataChangeTracker$ChangedDescriptorsStore(File file, PersistentHeapManager persistentHeapManager) {
        super(file, persistentHeapManager);
    }

    protected void writeCustomMetadata(DataOutputStream dataOutputStream) throws IOException {
        super.writeCustomMetadata(dataOutputStream);
        dataOutputStream.writeInt(0);
    }

    protected void readCustomMetadata(DataInputStream dataInputStream) throws IOException {
        super.readCustomMetadata(dataInputStream);
        int n = dataInputStream.readInt();
        if (n != 0) {
            throw (Throwable)new IllegalArgumentException("Metadata version mismatch " + n + " != " + 0);
        }
    }

    private long persistStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        long l = this.heap.allocate((long)byteArrayOutputStream.size());
        byteArrayOutputStream.writeTo(this.heap.getOutputStream(l));
        return l;
    }

    protected long writeObject(Object object, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if ((n & 1) != 0) {
            UUID uUID = (UUID)object;
            dataOutputStream.writeUTF(uUID.getUuidValue());
            return this.persistStream(byteArrayOutputStream);
        }
        return object == IFolder.ITEM_TYPE ? 1 : 0;
    }

    protected void freeObject(long l, int n) throws IOException {
        if ((n & 1) != 0) {
            super.freeObject(l, n);
        }
    }

    protected Object readObject(long l, int n) throws IOException, ClassNotFoundException {
        if ((n & 1) != 0) {
            return super.readObject(l, n);
        }
        return l == 0L ? IFileItem.ITEM_TYPE : IFolder.ITEM_TYPE;
    }

    protected Object readObject(InputStream inputStream, int n) throws IOException, ClassNotFoundException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        return UUID.valueOf((String)dataInputStream.readUTF());
    }
}

