/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.ManagedFileSystem$ManagedLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ManagedFileSystem
extends FileSystem {
    private static final IFileStore NULL_ROOT = EFS.getNullFileSystem().getStore((IPath)Path.ROOT);
    private static final boolean caseSensitive = EFS.getLocalFileSystem().isCaseSensitive();
    private static ManagedFileSystem instance;
    public static final String SCHEME_MANAGED = "sourcecontrol";
    public static final String DEFAULT_CFA = "default";

    public static ManagedFileSystem getInstance() {
        ManagedFileSystem managedFileSystem = instance;
        if (managedFileSystem != null) {
            return managedFileSystem;
        }
        instance = new ManagedFileSystem();
        return instance;
    }

    public ManagedFileSystem() {
        instance = this;
    }

    public IFileStore getStore(URI uRI) {
        try {
            ManagedFileSystem$ManagedLocation managedFileSystem$ManagedLocation = ManagedFileSystem.expandUri(uRI);
            if (managedFileSystem$ManagedLocation == null) {
                return NULL_ROOT;
            }
            IFileStore iFileStore = EFS.getStore((URI)managedFileSystem$ManagedLocation.getBaseStoreURI());
            return (IFileStore)new ManagedFileStore(managedFileSystem$ManagedLocation.getCfaRoot(), managedFileSystem$ManagedLocation.getSharePath(), iFileStore);
        }
        catch (CoreException coreException) {
            LoggingHelper.error("com.ibm.team.filesystem.client", "Could not find base file system implementation for " + uRI, coreException);
            return NULL_ROOT;
        }
    }

    public static ManagedFileSystem$ManagedLocation expandUri(URI uRI) {
        URI uRI2;
        IPath iPath;
        int n;
        Path path;
        block8: {
            Assert.isLegal((boolean)SCHEME_MANAGED.equals(uRI.getScheme()));
            try {
                path = new Path(uRI.getPath());
                if (path.segmentCount() >= 1) break block8;
                LoggingHelper.error("com.ibm.team.filesystem.client", "Invalid URI: " + uRI, new Exception().fillInStackTrace());
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                LoggingHelper.error("com.ibm.team.filesystem.client", "Could not find base file system implementation for " + uRI, uRISyntaxException);
                return null;
            }
        }
        SharingManager sharingManager = null;
        if (path.segment(0).equals(DEFAULT_CFA)) {
            n = 0;
            sharingManager = SharingManager.getInstance();
            iPath = sharingManager.getIDEWorkAreaRoot();
        } else {
            n = Integer.parseInt(path.segment(0));
            iPath = path.removeLastSegments(path.segmentCount() - n - 1).removeFirstSegments(1).makeUNC(path.isUNC());
        }
        IPath iPath2 = path.removeFirstSegments(n + 1).setDevice(null).makeUNC(false).makeAbsolute();
        if (uRI.getQuery() != null) {
            uRI2 = new URI(uRI.getQuery());
        } else {
            if (sharingManager == null) {
                sharingManager = SharingManager.getInstance();
            }
            uRI2 = URIUtil.toURI((IPath)sharingManager.getIDEWorkAreaRoot().append(iPath2));
        }
        return new ManagedFileSystem$ManagedLocation(iPath.makeAbsolute(), iPath2, uRI2);
    }

    public static URI getManagedURI(IPath iPath, IPath iPath2, URI uRI) {
        String string = iPath == null ? new Path(null, "/default").append(iPath2).makeUNC(false).makeAbsolute().toString() : new Path(iPath.getDevice(), Integer.toString(iPath.segmentCount())).append(iPath).append(iPath2).makeUNC(iPath.isUNC()).makeAbsolute().toString();
        if (string.charAt(0) != '/') {
            string = String.valueOf('/') + string;
        }
        try {
            return new URI(SCHEME_MANAGED, null, "jazz", -1, string, uRI == null ? null : uRI.toString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (Throwable)new IllegalArgumentException(uRISyntaxException);
        }
    }

    public static URI getCanonicalManagedURI(IPath iPath, IPath iPath2, URI uRI) {
        IPath iPath3 = SharingManager.getInstance().getIDEWorkAreaRoot();
        if (iPath != null && iPath.equals((Object)iPath3)) {
            iPath = null;
        }
        if (uRI != null && iPath3 != null && iPath3.append(iPath2).equals((Object)URIUtil.toPath((URI)uRI))) {
            uRI = null;
        }
        return ManagedFileSystem.getManagedURI(iPath, iPath2, uRI);
    }

    public static URI getBasicURI(URI uRI) {
        ManagedFileSystem$ManagedLocation managedFileSystem$ManagedLocation;
        block4: {
            Assert.isLegal((boolean)SCHEME_MANAGED.equals(uRI.getScheme()));
            try {
                if (uRI.getQuery() != null) {
                    return new URI(uRI.getQuery());
                }
                managedFileSystem$ManagedLocation = ManagedFileSystem.expandUri(uRI);
                IPath iPath = managedFileSystem$ManagedLocation.getCfaRoot().append(ManagedFileSystem$ManagedLocation.access$0(managedFileSystem$ManagedLocation));
                IPath iPath2 = SharingManager.getInstance().getIDEWorkAreaRoot();
                if (!PathUtils.isPrefixOf(iPath2, caseSensitive, iPath) || iPath.segmentCount() != iPath2.segmentCount() + 1) break block4;
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                throw (Throwable)new IllegalArgumentException("Could not find base file system implementation for " + uRI, uRISyntaxException);
            }
        }
        return managedFileSystem$ManagedLocation.getBaseStoreURI();
    }

    public boolean isCaseSensitive() {
        return caseSensitive;
    }
}

