/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.ChangeTrackingOutputStream;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.JavaSymLinkHelper;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore$1;
import com.ibm.team.filesystem.client.internal.ManagedFileSystem;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataUpdateJob;
import com.ibm.team.filesystem.client.internal.NativeSymLinkHelper;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.SymLinkHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil$LockResult;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class ManagedFileStore
extends FileStore {
    private static final SymLinkHelper symlinkHelper;
    private final IFileStore baseStore;
    private final IPath cfaPath;
    private final IPath localPath;

    static {
        boolean bl;
        SymLinkHelper symLinkHelper;
        block11: {
            symLinkHelper = NativeSymLinkHelper.newInstance();
            if (symLinkHelper == null) {
                try {
                    Class<?> clazz = ManagedFileStore.class.getClassLoader().loadClass("com.ibm.team.filesystem.client.internal.Java17SymLinkHelper");
                    Method method = clazz.getDeclaredMethod("newInstance", new Class[0]);
                    try {
                        symLinkHelper = (SymLinkHelper)method.invoke(null, new Object[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getCause();
                        if (throwable == null) {
                            throw (Throwable)invocationTargetException;
                        }
                        if (throwable instanceof NoClassDefFoundError) {
                            symLinkHelper = JavaSymLinkHelper.newInstance();
                            break block11;
                        }
                        if (throwable instanceof Exception) {
                            throw throwable;
                        }
                        if (throwable instanceof Error) {
                            throw throwable;
                        }
                        throw (Throwable)new RuntimeException(throwable);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw (Throwable)runtimeException;
                }
                catch (Exception exception) {
                    throw (Throwable)new RuntimeException(exception);
                }
            }
        }
        symlinkHelper = symLinkHelper;
        boolean bl2 = symLinkHelper.supportsSymLinks();
        boolean bl3 = bl = (EFS.getLocalFileSystem().attributes() & 0x20) != 0;
        if (bl2 != bl) {
            LoggingHelper.log((IStatus)new Status(2, "com.ibm.team.filesystem.client", bl2 ? Messages.ManagedFileStore_10 : Messages.ManagedFileStore_11));
        }
    }

    public static boolean supportsSymLinks() {
        return symlinkHelper.supportsSymLinks();
    }

    public static String getResolvedPath(String string) throws CoreException {
        return symlinkHelper.getResolvedPath(string);
    }

    public static void createSymlink(IFileStore iFileStore, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!symlinkHelper.supportsSymLinks()) {
            throw (Throwable)new CoreException(FileSystemStatus.getStatusFor(4, Messages.ManagedFileStore_5, null));
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)3);
        String string2 = iFileStore.toLocalFile(0, (IProgressMonitor)subMonitor.newChild(1)).getPath();
        IFileInfo iFileInfo = iFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
        if (iFileInfo.exists() || iFileInfo.getAttribute(32)) {
            throw (Throwable)new CoreException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ManagedFileStore_6, (Object)string2), null));
        }
        IFileStore iFileStore2 = iFileStore.getParent();
        IFileInfo iFileInfo2 = iFileStore2.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
        if (!iFileInfo2.exists()) {
            throw (Throwable)new CoreException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ManagedFileStore_7, (Object)string2), null));
        }
        if (!iFileInfo2.isDirectory()) {
            throw (Throwable)new CoreException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ManagedFileStore_8, (Object)string2), null));
        }
        symlinkHelper.createSymlink(string2, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void symlink(String string, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!symlinkHelper.supportsSymLinks()) {
            throw (Throwable)new CoreException(FileSystemStatus.getStatusFor(4, Messages.ManagedFileStore_5, null));
        }
        if (this.trackingChanges()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)4);
            CFALockUtil$LockResult cFALockUtil$LockResult = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, false, (IProgressMonitor)subMonitor.newChild(1));
            try {
                ManagedFileStore.createSymlink(this.baseStore, string, (IProgressMonitor)subMonitor.newChild(1));
                if (cFALockUtil$LockResult.code == 0) {
                    IFileInfo iFileInfo = this.baseStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
                    ManagedFileStore.updateMetadata(this, iFileInfo, (IProgressMonitor)subMonitor.newChild(1));
                    return;
                }
                if (cFALockUtil$LockResult.code != 2) return;
                this.requestBackgroundMetadataUpdate(false);
                return;
            }
            finally {
                if (cFALockUtil$LockResult != null) {
                    CFALockUtil.endBatching(cFALockUtil$LockResult, subMonitor.newChild(1));
                }
            }
        } else {
            ManagedFileStore.createSymlink(this.baseStore, string, iProgressMonitor);
        }
    }

    protected void addDatelessItem(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        ISchedulingRule iSchedulingRule = SharingManager.getInstance().getTrackingRule(this.cfaPath);
        LocalChangeTracker localChangeTracker = LocalChangeManager.getInstance().getTracker(iContextHandle, iComponentHandle, this.cfaPath, iSchedulingRule);
        localChangeTracker.registerDatelessVersionable(this.baseStore.fetchInfo().getLastModified(), iVersionableHandle, iComponentHandle, iContextHandle);
    }

    public ManagedFileStore(IPath iPath, IPath iPath2, IFileStore iFileStore) {
        this.cfaPath = iPath;
        this.baseStore = iFileStore;
        this.localPath = iPath2;
    }

    public IFileInfo[] childInfos(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            IFileInfo[] iFileInfoArray = this.childInfosInternal(false, n, (IProgressMonitor)subMonitor.newChild(100));
            return iFileInfoArray;
        }
        finally {
            ManagedFileStore.done(iProgressMonitor);
        }
    }

    private static void done(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    private boolean trackingChanges() {
        return SharingManager.getInstance().isChangeMonitoringEnabled() && !FileSystemCore.isShutDown();
    }

    private IFileInfo[] childInfosInternal(boolean bl, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        SubMonitor subMonitor;
        block16: {
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            if (this.trackingChanges()) {
                try {
                    IFileInfo[] iFileInfoArray;
                    block15: {
                        CFALockUtil$LockResult cFALockUtil$LockResult = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, false, (IProgressMonitor)subMonitor.newChild(1));
                        try {
                            IFileInfo[] iFileInfoArray2 = this.baseStore.childInfos(n, (IProgressMonitor)subMonitor.newChild(40));
                            if (cFALockUtil$LockResult.code == 0) {
                                this.updateMetadataForChildren(iFileInfoArray2, subMonitor.newChild(58));
                            } else if (cFALockUtil$LockResult.code == 2) {
                                this.requestBackgroundMetadataUpdate(true);
                            }
                            iFileInfoArray = iFileInfoArray2;
                            if (cFALockUtil$LockResult == null) break block15;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (cFALockUtil$LockResult != null) {
                                    CFALockUtil.endBatching(cFALockUtil$LockResult, subMonitor.newChild(1));
                                }
                                throw throwable;
                            }
                            catch (RuntimeException runtimeException) {
                                this.handleException(bl, runtimeException);
                                ManagedFileStore.done(iProgressMonitor);
                                break block16;
                            }
                            catch (CoreException coreException) {
                                this.handleException(bl, coreException);
                                break block16;
                            }
                        }
                        CFALockUtil.endBatching(cFALockUtil$LockResult, subMonitor.newChild(1));
                    }
                    return iFileInfoArray;
                }
                finally {
                    ManagedFileStore.done(iProgressMonitor);
                }
            }
        }
        subMonitor.setWorkRemaining(45);
        return this.baseStore.childInfos(n, (IProgressMonitor)subMonitor.newChild(45));
    }

    private void handleException(boolean bl, CoreException coreException) throws CoreException {
        if (bl) {
            throw (Throwable)coreException;
        }
        LoggingHelper.log(FileSystemStatus.getStatusFor(coreException));
    }

    private void handleException(boolean bl, RuntimeException runtimeException) {
        if (bl) {
            throw (Throwable)runtimeException;
        }
        LoggingHelper.log(FileSystemStatus.getStatusFor(runtimeException));
    }

    private void requestBackgroundMetadataUpdate(boolean bl) {
        MetadataUpdateJob.queueUpdate(this, bl);
    }

    private boolean updateMetadataForChildren(IFileInfo[] subMonitor, SubMonitor subMonitor2) throws FileSystemClientException, CoreException {
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
        FileItemInfo fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(this.localPath);
        if (fileItemInfo != null && (fileItemInfo.isSymbolicLink() || fileItemInfo.isFile() && ((SubMonitor)subMonitor).length == 0)) {
            return false;
        }
        SharingManager sharingManager = SharingManager.getInstance();
        Sandbox sandbox = new Sandbox(iCopyFileArea);
        Shareable shareable = sharingManager.findShareable(sandbox, this.localPath, ResourceType.FOLDER);
        Share share = ((CopyFileArea)iCopyFileArea).getShare(shareable.getLocalPath());
        IFileStorage iFileStorage = shareable.getFileStorage();
        boolean bl = ((CopyFileAreaStore)((Object)iCopyFileArea)).isCaseSensitive();
        HashMap<StringWrapper, Object> hashMap = new HashMap<StringWrapper, Object>(((SubMonitor)subMonitor).length * 4 / 3);
        Object object = subMonitor;
        int n = ((SubMonitor)object).length;
        int n2 = 0;
        while (n2 < n) {
            SubMonitor iFileInfo = object[n2];
            hashMap.put(new StringWrapper(iFileInfo.getName(), bl), iFileInfo);
            ++n2;
        }
        boolean bl2 = false;
        if (share != null) {
            Object object2;
            Object object3;
            FileItemInfo fileItemInfo2;
            StringWrapper stringWrapper;
            Object object4;
            if (iFileStorage.shouldBeIgnored((IProgressMonitor)subMonitor2.newChild(5))) {
                return false;
            }
            if (!(share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle)) {
                if (((SubMonitor)subMonitor).length != 0) {
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).deleteTreeInfo(share.getPath(), false, (IProgressMonitor)subMonitor2.newChild(53));
                }
                return true;
            }
            if (!(((SubMonitor)subMonitor).length == 0 || fileItemInfo != null && fileItemInfo.isFolder())) {
                IFileInfo iFileInfo = this.fetchInfoInternal(true, 0, (IProgressMonitor)subMonitor2.newChild(5));
                if (iFileInfo.getAttribute(32) || !iFileInfo.isDirectory()) {
                    return false;
                }
                fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(this.localPath);
                if (fileItemInfo == null) {
                    return false;
                }
            }
            subMonitor2.setWorkRemaining(52);
            Map map = ((CopyFileAreaStore)((Object)iCopyFileArea)).getChildInfos(this.localPath, (IProgressMonitor)subMonitor2.newChild(35));
            HashMap<StringWrapper, Object> hashMap2 = new HashMap<StringWrapper, Object>();
            object = iFileStorage.getChildren((IProgressMonitor)subMonitor2.newChild(1));
            if (object != null) {
                Iterator object52 = object.iterator();
                while (object52.hasNext()) {
                    object4 = (IFileStorage)object52.next();
                    hashMap2.put(new StringWrapper(object4.getName(), bl), object4);
                }
            }
            object4 = subMonitor2.newChild(10);
            object4.beginTask(Messages.ManagedFileStore_0, map.size());
            for (Map.Entry entry : map.entrySet()) {
                Object object5;
                IFileStorage iFileStorage2;
                SubMonitor subMonitor3 = object4.newChild(1);
                subMonitor3.setWorkRemaining(3);
                stringWrapper = (StringWrapper)entry.getKey();
                fileItemInfo2 = (FileItemInfo)entry.getValue();
                object3 = (IFileInfo)hashMap.remove(stringWrapper);
                object2 = this.localPath.append(object3 == null ? stringWrapper.toString() : object3.getName());
                IFileStorage iFileStorage3 = iFileStorage2 = object3 == null ? null : (IFileStorage)hashMap2.get(stringWrapper);
                if (iFileStorage2 == null) {
                    object5 = object3 == null ? ResourceType.getResourceType(fileItemInfo2.getVersionableHandle()) : (object3.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
                    Shareable shareable2 = sharingManager.findShareable(sandbox, (IPath)object2, (ResourceType)((Object)object5));
                    iFileStorage2 = shareable2.getFileStorage();
                }
                if (iFileStorage2.shouldBeIgnored((IProgressMonitor)subMonitor3.newChild(1))) continue;
                if (object3 == null) {
                    subMonitor3.setWorkRemaining(1);
                    bl2 |= ((CopyFileAreaStore)((Object)iCopyFileArea)).deleteTreeInfo((IPath)object2, false, (IProgressMonitor)subMonitor3.newChild(1));
                    continue;
                }
                if (!ManagedFileStore.isSameType(object3, fileItemInfo2)) {
                    subMonitor3.setWorkRemaining(1);
                    bl2 |= ((CopyFileAreaStore)((Object)iCopyFileArea)).deleteTreeInfo((IPath)object2, false, (IProgressMonitor)subMonitor3.newChild(1));
                    hashMap.put(stringWrapper, object3);
                    continue;
                }
                if (fileItemInfo2.isFile()) {
                    long l;
                    subMonitor3.setWorkRemaining(2);
                    object5 = this.getChild(object3.getName());
                    boolean bl3 = ManagedFileStore.contentChanged((ManagedFileStore)((Object)object5), object3, fileItemInfo2, share, iFileStorage2, subMonitor3.newChild(1));
                    boolean bl4 = iFileStorage2.supportsExecBit() ? object3.getAttribute(4) : fileItemInfo2.isExecutable();
                    long l2 = l = fileItemInfo2.getVersionableHandle().hasStateId() ? iFileStorage2.getModificationStamp() : -1L;
                    if (stringWrapper.toString().equals(object3.getName()) && bl3 == fileItemInfo2.isContentChanged() && bl4 == fileItemInfo2.isExecutable() && l == fileItemInfo2.getLastContentChangeCheckStamp()) continue;
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo((IPath)object2, new FileItemInfo(fileItemInfo2.getVersionableHandle(), bl3, l, fileItemInfo2.getParent(), fileItemInfo2.getName(), fileItemInfo2.isLoadedWithAnotherName(), fileItemInfo2.getHash(), fileItemInfo2.getContentLength(), fileItemInfo2.getOriginalLineDelimiter(), fileItemInfo2.getLineDelimiter(), fileItemInfo2.getOriginalContentType(), fileItemInfo2.getContentType(), fileItemInfo2.getStoredPredecessorHintHash(), fileItemInfo2.getStoredSize(), fileItemInfo2.getStoredEncoding(), fileItemInfo2.getStoredHash(), fileItemInfo2.getStoredNumLineDelimiters(), bl4, fileItemInfo2.isOriginalExecutable()), (IProgressMonitor)subMonitor3.newChild(1));
                    bl2 = true;
                    continue;
                }
                if (fileItemInfo2.isSymbolicLink()) {
                    boolean bl5 = LocalChangeTracker.contentChanged(fileItemInfo2, object3.getStringAttribute(64));
                    if (bl5 == fileItemInfo2.isContentChanged()) continue;
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo((IPath)object2, new FileItemInfo((ISymbolicLinkHandle)fileItemInfo2.getVersionableHandle(), bl5, fileItemInfo2.getParent(), fileItemInfo2.getName(), fileItemInfo2.isLoadedWithAnotherName(), fileItemInfo2.getHash(), fileItemInfo2.getStoredHash()), (IProgressMonitor)subMonitor3.newChild(1));
                    bl2 = true;
                    continue;
                }
                if (stringWrapper.toString().equals(object3.getName())) continue;
                subMonitor3.setWorkRemaining(1);
                ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo((IPath)object2, fileItemInfo2, (IProgressMonitor)subMonitor3.newChild(1));
                bl2 = true;
            }
            object4.done();
            SubMonitor subMonitor4 = subMonitor2.newChild(5);
            subMonitor4.setWorkRemaining(hashMap.size());
            for (IFileInfo iFileInfo : hashMap.values()) {
                stringWrapper = subMonitor4.newChild(1).setWorkRemaining(3);
                fileItemInfo2 = this.localPath.append(iFileInfo.getName());
                object2 = iFileStorage.getChild(iFileInfo.getName(), (IProgressMonitor)stringWrapper.newChild(1));
                object3 = object2 != null ? object2.getShareable() : sharingManager.findShareable(sandbox, (IPath)fileItemInfo2, this.getResourceType(iFileInfo));
                if (object3.shouldBeIgnored((IProgressMonitor)stringWrapper.newChild(1))) continue;
                if (iFileInfo.getAttribute(32)) {
                    share.getTracker().trackSymbolicLinkAddition((IFolderHandle)fileItemInfo.getVersionableHandle(), (IShareable)object3, (IProgressMonitor)stringWrapper.newChild(1));
                } else if (iFileInfo.isDirectory()) {
                    share.getTracker().trackFolderAddition((IFolderHandle)fileItemInfo.getVersionableHandle(), (IShareable)object3, (IProgressMonitor)stringWrapper.newChild(1));
                } else {
                    share.getTracker().trackFileAddition((IFolderHandle)fileItemInfo.getVersionableHandle(), (IShareable)object3, (IProgressMonitor)stringWrapper.newChild(1));
                }
                bl2 = true;
            }
        } else {
            Object object6;
            Object object7;
            IFileInfo iFileInfo;
            IPath iPath2;
            subMonitor2.setWorkRemaining(51);
            Collection collection = ((CopyFileAreaStore)((Object)iCopyFileArea)).allSharePaths(this.localPath);
            n = this.localPath.segmentCount();
            object = subMonitor2.newChild(25);
            object.setWorkRemaining(collection.size());
            for (IPath iPath2 : collection) {
                SubMonitor subMonitor5 = object.newChild(1);
                subMonitor5.setWorkRemaining(2);
                iFileInfo = (IFileInfo)hashMap.get(new StringWrapper(iPath2.segment(n), bl));
                boolean bl6 = false;
                object7 = null;
                if (iFileInfo != null) {
                    if (iPath2.segmentCount() == n + 1) {
                        object7 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getSharingInfo(iPath2);
                        if (this.isSameType(object7.getRootVersionable(), iFileInfo)) {
                            bl6 = true;
                        }
                    } else if (iFileInfo.isDirectory()) {
                        bl6 = true;
                    }
                }
                if (!bl6) {
                    if (object7 == null) {
                        object7 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getSharingInfo(iPath2);
                    }
                    if (((Shareable)(object6 = sharingManager.findShareable(sandbox, iPath2, ResourceType.getResourceType(object7.getRootVersionable())))).shouldBeIgnored((IProgressMonitor)subMonitor5.newChild(1))) continue;
                    bl2 |= ((CopyFileAreaStore)((Object)iCopyFileArea)).deleteTreeInfo(iPath2, false, (IProgressMonitor)subMonitor5.newChild(1));
                    continue;
                }
                if (iPath2.segment(n).equals(iFileInfo.getName())) continue;
                if (object7 == null) {
                    object7 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getSharingInfo(iPath2);
                }
                if (((Shareable)(object6 = sharingManager.findShareable(sandbox, iPath2, ResourceType.getResourceType(object7.getRootVersionable())))).shouldBeIgnored((IProgressMonitor)subMonitor5.newChild(1))) continue;
                IPath iPath3 = iPath2.removeLastSegments(iPath2.segmentCount() - n).append(iFileInfo.getName()).append(iPath2.removeFirstSegments(n + 1));
                ((CopyFileAreaStore)((Object)iCopyFileArea)).moveSharingInfo(iPath2, iPath3, (IProgressMonitor)subMonitor5.newChild(1));
                bl2 = true;
            }
            object.done();
            iPath2 = subMonitor2.newChild(25);
            iPath2.setWorkRemaining(collection.size());
            for (IPath iPath4 : collection) {
                boolean bl7;
                IFileInfo iFileInfo2;
                iFileInfo = iPath2.newChild(1);
                iFileInfo.setWorkRemaining(2);
                if (iPath4.segmentCount() != n + 1 || (iFileInfo2 = (IFileInfo)hashMap.get(new StringWrapper(iPath4.segment(n), bl))) == null || ((Shareable)(object7 = sharingManager.findShareable(sandbox, iPath4.removeLastSegments(1).append(iFileInfo2.getName()), iFileInfo2.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE))).shouldBeIgnored((IProgressMonitor)iFileInfo.newChild(1))) continue;
                object6 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(iPath4);
                if (object6 == null) {
                    Share share2 = ((CopyFileArea)iCopyFileArea).getShare(iPath4);
                    if (!this.isSameType(share2.getSharingDescriptor().getRootVersionable(), iFileInfo2)) continue;
                    iFileInfo.setWorkRemaining(1);
                    if (iFileInfo2.getAttribute(32)) {
                        share2.getTracker().trackSymbolicLinkAddition(null, (IShareable)object7, (IProgressMonitor)iFileInfo.newChild(1));
                    } else if (iFileInfo2.isDirectory()) {
                        share2.getTracker().trackFolderAddition(null, (IShareable)object7, (IProgressMonitor)iFileInfo.newChild(1));
                    } else {
                        share2.getTracker().trackFileAddition(null, (IShareable)object7, (IProgressMonitor)iFileInfo.newChild(1));
                    }
                    if (!iFileInfo2.getName().equals(iPath4.segment(n))) {
                        iFileInfo.setWorkRemaining(1);
                        ((CopyFileAreaStore)((Object)iCopyFileArea)).moveSharingInfo(iPath4, iPath4.removeLastSegments(1).append(iFileInfo2.getName()), (IProgressMonitor)iFileInfo.newChild(1));
                    }
                    bl2 = true;
                    continue;
                }
                Assert.isTrue((boolean)ManagedFileStore.isSameType(iFileInfo2, (FileItemInfo)object6));
                if (((FileItemInfo)object6).isFile()) {
                    long l;
                    iFileInfo.setWorkRemaining(3);
                    ManagedFileStore managedFileStore = this.getChild(iFileInfo2.getName());
                    Share share3 = share == null ? ((CopyFileArea)iCopyFileArea).getShare(((Shareable)object7).getLocalPath()) : share;
                    boolean bl8 = ManagedFileStore.contentChanged(managedFileStore, iFileInfo2, (FileItemInfo)object6, share3, ((Shareable)object7).getFileStorage(), iFileInfo.newChild(1));
                    boolean bl9 = ((Shareable)object7).getFileStorage().supportsExecBit() ? iFileInfo2.getAttribute(4) : ((FileItemInfo)object6).isExecutable();
                    long l3 = l = ((FileItemInfo)object6).getVersionableHandle().hasStateId() ? ((Shareable)object7).getFileStorage().getModificationStamp() : -1L;
                    if (bl8 != ((FileItemInfo)object6).isContentChanged() || bl9 != ((FileItemInfo)object6).isExecutable() || l != ((FileItemInfo)object6).getLastContentChangeCheckStamp()) {
                        ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(iPath4, new FileItemInfo(((FileItemInfo)object6).getVersionableHandle(), bl8, l, ((FileItemInfo)object6).getParent(), ((FileItemInfo)object6).getName(), ((FileItemInfo)object6).isLoadedWithAnotherName(), ((FileItemInfo)object6).getHash(), ((FileItemInfo)object6).getContentLength(), ((FileItemInfo)object6).getOriginalLineDelimiter(), ((FileItemInfo)object6).getLineDelimiter(), ((FileItemInfo)object6).getOriginalContentType(), ((FileItemInfo)object6).getContentType(), ((FileItemInfo)object6).getStoredPredecessorHintHash(), ((FileItemInfo)object6).getStoredSize(), ((FileItemInfo)object6).getStoredEncoding(), ((FileItemInfo)object6).getStoredHash(), ((FileItemInfo)object6).getStoredNumLineDelimiters(), bl9, ((FileItemInfo)object6).isOriginalExecutable()), (IProgressMonitor)iFileInfo.newChild(1));
                        bl2 = true;
                    }
                } else if (((FileItemInfo)object6).isSymbolicLink() && (bl7 = LocalChangeTracker.contentChanged((FileItemInfo)object6, iFileInfo2.getStringAttribute(64))) != ((FileItemInfo)object6).isContentChanged()) {
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(iPath4, new FileItemInfo((ISymbolicLinkHandle)((FileItemInfo)object6).getVersionableHandle(), bl7, ((FileItemInfo)object6).getParent(), ((FileItemInfo)object6).getName(), ((FileItemInfo)object6).isLoadedWithAnotherName(), ((FileItemInfo)object6).getHash(), ((FileItemInfo)object6).getStoredHash()), (IProgressMonitor)iFileInfo.newChild(1));
                    bl2 = true;
                }
                if (iFileInfo2.getName().equals(iPath4.segment(n))) continue;
                iFileInfo.setWorkRemaining(1);
                ((CopyFileAreaStore)((Object)iCopyFileArea)).moveSharingInfo(iPath4, iPath4.removeLastSegments(1).append(iFileInfo2.getName()), (IProgressMonitor)iFileInfo.newChild(1));
                bl2 = true;
            }
        }
        return bl2;
    }

    private ResourceType getResourceType(IFileInfo iFileInfo) {
        if (iFileInfo.getAttribute(32)) {
            return ResourceType.SYMBOLIC_LINK;
        }
        return iFileInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
    }

    private boolean isSameType(IVersionableHandle iVersionableHandle, IFileInfo iFileInfo) {
        if (iFileInfo.getAttribute(32)) {
            return iVersionableHandle instanceof ISymbolicLinkHandle;
        }
        if (iFileInfo.isDirectory()) {
            return iVersionableHandle instanceof IFolderHandle;
        }
        return iVersionableHandle instanceof IFileItemHandle;
    }

    public String[] childNames(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        return this.childNamesInternal(false, n, iProgressMonitor);
    }

    public String[] childNamesInternal(boolean bl, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            if (!this.trackingChanges()) {
                String[] stringArray = this.baseStore.childNames(n, (IProgressMonitor)subMonitor.newChild(100));
                return stringArray;
            }
            IFileInfo[] iFileInfoArray = this.childInfosInternal(bl, n, (IProgressMonitor)subMonitor.newChild(100));
            String[] stringArray = new String[iFileInfoArray.length];
            int n2 = iFileInfoArray.length - 1;
            while (n2 >= 0) {
                stringArray[n2] = iFileInfoArray[n2].getName();
                --n2;
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            ManagedFileStore.done(iProgressMonitor);
        }
    }

    public IFileStore[] childStores(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        return (IFileStore[])this.childStoresInternal(false, n, iProgressMonitor);
    }

    public ManagedFileStore[] childStoresInternal(boolean bl, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            String[] stringArray = this.childNamesInternal(bl, n, (IProgressMonitor)subMonitor.newChild(100));
            ManagedFileStore[] managedFileStoreArray = new ManagedFileStore[stringArray.length];
            int n2 = managedFileStoreArray.length - 1;
            while (n2 >= 0) {
                managedFileStoreArray[n2] = new ManagedFileStore(this.cfaPath, this.localPath.append(stringArray[n2]), this.baseStore.getChild(stringArray[n2]));
                --n2;
            }
            ManagedFileStore[] managedFileStoreArray2 = managedFileStoreArray;
            return managedFileStoreArray2;
        }
        finally {
            ManagedFileStore.done(iProgressMonitor);
        }
    }

    public void copy(IFileStore iFileStore, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.baseStore.copy(iFileStore, n, iProgressMonitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.trackingChanges()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            try {
                CFALockUtil$LockResult cFALockUtil$LockResult = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, true, (IProgressMonitor)subMonitor.newChild(1));
                try {
                    this.baseStore.delete(n, (IProgressMonitor)subMonitor.newChild(60));
                    if (cFALockUtil$LockResult.code == 0) {
                        this.updateMetadataForDeletion(subMonitor);
                        return;
                    }
                    if (cFALockUtil$LockResult.code != 2) return;
                    this.requestBackgroundMetadataUpdate(false);
                    return;
                }
                finally {
                    if (cFALockUtil$LockResult != null) {
                        CFALockUtil.endBatching(cFALockUtil$LockResult, subMonitor.newChild(1));
                    }
                }
            }
            finally {
                ManagedFileStore.done(iProgressMonitor);
            }
        } else {
            this.baseStore.delete(n, iProgressMonitor);
        }
    }

    private void updateMetadataForDeletion(SubMonitor subMonitor) throws FileSystemClientException {
        SharingManager sharingManager = SharingManager.getInstance();
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
        Sandbox sandbox = new Sandbox(iCopyFileArea);
        Share share = ((CopyFileArea)iCopyFileArea).getShare(this.localPath);
        if (share != null) {
            FileItemInfo fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(this.localPath);
            if (fileItemInfo != null) {
                Shareable shareable = sharingManager.findShareable(sandbox, this.localPath, ResourceType.getResourceType(fileItemInfo.getVersionableHandle()));
                if (shareable.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(10))) {
                    return;
                }
                if (share.getPath().segmentCount() == this.localPath.segmentCount()) {
                    ((CopyFileArea)iCopyFileArea).forget(this.localPath, (IProgressMonitor)subMonitor.newChild(28));
                } else {
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).deleteTreeInfo(this.localPath, false, (IProgressMonitor)subMonitor.newChild(28));
                }
            }
        } else {
            Collection collection = ((CopyFileAreaStore)((Object)iCopyFileArea)).allSharePaths(this.localPath);
            SubMonitor subMonitor2 = subMonitor.newChild(38);
            subMonitor2.setWorkRemaining(collection.size());
            for (IPath iPath : collection) {
                Shareable shareable;
                SubMonitor subMonitor3 = subMonitor2.newChild(1).setWorkRemaining(2);
                FileItemInfo fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(iPath);
                if (fileItemInfo == null || (shareable = sharingManager.findShareable(sandbox, iPath, ResourceType.getResourceType(fileItemInfo.getVersionableHandle()))).shouldBeIgnored((IProgressMonitor)subMonitor3.newChild(1))) continue;
                ((CopyFileArea)iCopyFileArea).forget(iPath, (IProgressMonitor)subMonitor3.newChild(1));
            }
            subMonitor2.done();
        }
    }

    public IFileInfo fetchInfo(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        return this.fetchInfoInternal(false, n, iProgressMonitor);
    }

    public static IFolderHandle createFolderHierarchyUpToParentOf(IPath iPath, Share share, CopyFileArea copyFileArea, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        IPath iPath2;
        SubMonitor subMonitor;
        SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        int n = share.getPath().segmentCount();
        int n2 = iPath.segmentCount();
        int n3 = n2 - n;
        if (n3 <= 0) {
            subMonitor2.done();
            return null;
        }
        SharingManager sharingManager = SharingManager.getInstance();
        Sandbox sandbox = new Sandbox(copyFileArea);
        if (share.getSharingDescriptor().getRootVersionable() instanceof ISymbolicLinkHandle) {
            subMonitor2.done();
            return null;
        }
        if (!(share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle)) {
            Shareable shareable;
            if (bl && (shareable = (Shareable)sharingManager.findShareable(share.getPath(), ResourceType.getResourceType(share.getSharingDescriptor().getRootVersionable()))).shouldBeIgnored((IProgressMonitor)subMonitor2.newChild(30))) {
                subMonitor2.done();
                return null;
            }
            copyFileArea.deleteTreeInfo(share.getPath(), false, (IProgressMonitor)subMonitor2.newChild(70));
            subMonitor2.done();
            return null;
        }
        IFolderHandle iFolderHandle = null;
        SubMonitor subMonitor3 = subMonitor2.newChild(50);
        subMonitor3.setWorkRemaining(n3);
        int n4 = 1;
        while (n4 <= n3) {
            subMonitor = subMonitor3.newChild(1).setWorkRemaining(2);
            iPath2 = iPath.removeLastSegments(n4);
            object = copyFileArea.getItemInfo(iPath2);
            if (object != null) {
                if (((FileItemInfo)object).isSymbolicLink()) {
                    subMonitor2.done();
                    return null;
                }
                if (!((FileItemInfo)object).isFolder()) {
                    Shareable shareable;
                    if (bl && (shareable = (Shareable)sharingManager.findShareable(iPath2, ResourceType.getResourceType(((FileItemInfo)object).getVersionableHandle()))).shouldBeIgnored((IProgressMonitor)subMonitor.newChild(1))) {
                        subMonitor2.done();
                        return null;
                    }
                    copyFileArea.deleteTreeInfo(iPath2, false, (IProgressMonitor)subMonitor.newChild(1));
                    if (n4 != n3) {
                        iFolderHandle = (IFolderHandle)copyFileArea.getItemInfo(iPath2.removeLastSegments(1)).getVersionableHandle();
                    }
                    ++n4;
                    break;
                }
                iFolderHandle = (IFolderHandle)((FileItemInfo)object).getVersionableHandle();
                break;
            }
            ++n4;
        }
        subMonitor3.done();
        subMonitor3 = subMonitor2.newChild(50);
        subMonitor3.setWorkRemaining(n4 - 1);
        while (n4 != 1) {
            subMonitor = subMonitor3.newChild(1).setWorkRemaining(2);
            iPath2 = iPath.removeLastSegments(--n4);
            object = sharingManager.findShareable(sandbox, iPath2, ResourceType.FOLDER);
            if (bl && ((Shareable)object).shouldBeIgnored((IProgressMonitor)subMonitor.newChild(1))) {
                subMonitor2.done();
                return null;
            }
            if (((Shareable)object).getFileStorage().getResourceType((IProgressMonitor)subMonitor.newChild(1)) == ResourceType.SYMBOLIC_LINK) {
                share.getTracker().trackSymbolicLinkAddition(iFolderHandle, (IShareable)object, (IProgressMonitor)subMonitor.newChild(1));
                iFolderHandle = null;
                break;
            }
            share.getTracker().trackFolderAddition(iFolderHandle, (IShareable)object, (IProgressMonitor)subMonitor.newChild(1));
            iFolderHandle = (IFolderHandle)copyFileArea.getItemInfo(iPath2).getVersionableHandle();
        }
        subMonitor3.done();
        subMonitor2.done();
        return iFolderHandle;
    }

    public IFileInfo fetchInfoInternal(boolean bl, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        SubMonitor subMonitor;
        block18: {
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            if (this.trackingChanges()) {
                try {
                    IFileInfo iFileInfo;
                    block17: {
                        if (iProgressMonitor == null) {
                            this.requestBackgroundMetadataUpdate(false);
                            IFileInfo iFileInfo2 = this.baseStore.fetchInfo(n, iProgressMonitor);
                            return iFileInfo2;
                        }
                        CFALockUtil$LockResult cFALockUtil$LockResult = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, false, (IProgressMonitor)subMonitor.newChild(1));
                        try {
                            IFileInfo iFileInfo3 = this.baseStore.fetchInfo(n, (IProgressMonitor)subMonitor.newChild(40));
                            if (cFALockUtil$LockResult.code == 0) {
                                ManagedFileStore.updateMetadata(this, iFileInfo3, (IProgressMonitor)subMonitor.newChild(58));
                            } else if (cFALockUtil$LockResult.code == 2) {
                                this.requestBackgroundMetadataUpdate(false);
                            }
                            iFileInfo = iFileInfo3;
                            if (cFALockUtil$LockResult == null) break block17;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (cFALockUtil$LockResult != null) {
                                    CFALockUtil.endBatching(cFALockUtil$LockResult, subMonitor.newChild(1));
                                }
                                throw throwable;
                            }
                            catch (RuntimeException runtimeException) {
                                this.handleException(bl, runtimeException);
                                break block18;
                            }
                            catch (CoreException coreException) {
                                this.handleException(bl, coreException);
                                break block18;
                            }
                        }
                        CFALockUtil.endBatching(cFALockUtil$LockResult, subMonitor.newChild(1));
                    }
                    return iFileInfo;
                }
                finally {
                    ManagedFileStore.done(iProgressMonitor);
                }
            }
        }
        subMonitor.setWorkRemaining(45);
        return this.baseStore.fetchInfo(n, (IProgressMonitor)subMonitor.newChild(45));
    }

    public boolean ensureMetadataUpToDate(boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        CFALockUtil$LockResult cFALockUtil$LockResult = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, true, (IProgressMonitor)subMonitor.newChild(10));
        try {
            IFileInfo[] iFileInfoArray;
            if (cFALockUtil$LockResult.code != 0) {
                throw (Throwable)new OperationCanceledException();
            }
            boolean bl3 = false;
            if (bl) {
                iFileInfoArray = this.baseStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(20));
                bl3 |= ManagedFileStore.updateMetadata(this, (IFileInfo)iFileInfoArray, (IProgressMonitor)subMonitor.newChild(20));
            }
            if (bl2) {
                iFileInfoArray = this.baseStore.childInfos(0, (IProgressMonitor)subMonitor.newChild(20));
                bl3 |= this.updateMetadataForChildren(iFileInfoArray, subMonitor.newChild(20));
            }
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            if (cFALockUtil$LockResult != null) {
                CFALockUtil.endBatching(cFALockUtil$LockResult, subMonitor.newChild(10));
            }
            subMonitor.done();
        }
    }

    public static boolean updateMetadata(ManagedFileStore managedFileStore, IFileInfo iFileInfo, IProgressMonitor iProgressMonitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath = managedFileStore.getCfaPath();
        IPath iPath2 = managedFileStore.getLocalPath();
        ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(iPath);
        SharingManager sharingManager = SharingManager.getInstance();
        Sandbox sandbox = new Sandbox(iCopyFileArea);
        Shareable shareable = sharingManager.findShareable(sandbox, iPath2, iFileInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
        Share share = ((CopyFileArea)iCopyFileArea).getShare(iPath2);
        if (shareable.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(30))) {
            if (share != null && iFileInfo.exists()) {
                if (!iFileInfo.isDirectory()) {
                    ManagedFileStore.createFolderHierarchyUpToParentOf(iPath2, share, (CopyFileArea)iCopyFileArea, true, (IProgressMonitor)subMonitor.newChild(28));
                } else {
                    ManagedFileStore.createFolderHierarchyUpToParentOf(iPath2.append("a"), share, (CopyFileArea)iCopyFileArea, true, (IProgressMonitor)subMonitor.newChild(28));
                }
            }
            return false;
        }
        if (share != null) {
            if (!iFileInfo.exists() && !iFileInfo.getAttribute(32)) {
                return ((CopyFileAreaStore)((Object)iCopyFileArea)).deleteTreeInfo(iPath2, false, (IProgressMonitor)subMonitor.newChild(28));
            }
            FileItemInfo fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(iPath2);
            if (fileItemInfo == null) {
                IPath iPath3;
                IFolderHandle iFolderHandle = null;
                int n = share.getPath().segmentCount();
                if (iPath2.segmentCount() != n) {
                    iFolderHandle = ManagedFileStore.createFolderHierarchyUpToParentOf(iPath2, share, (CopyFileArea)iCopyFileArea, false, (IProgressMonitor)subMonitor.newChild(20));
                    if (iFolderHandle == null) {
                        return true;
                    }
                    if (!(share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle)) {
                        return true;
                    }
                } else if (share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle != iFileInfo.isDirectory()) {
                    return false;
                }
                subMonitor.setWorkRemaining(21);
                IPath iPath4 = iPath3 = iPath2.segmentCount() == 0 ? iPath2 : iPath2.removeLastSegments(1).append(iFileInfo.getName());
                if (iFileInfo.getAttribute(32)) {
                    share.getTracker().trackSymbolicLinkAddition(iFolderHandle, sharingManager.findShareable(sandbox, iPath3, iFileInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE), (IProgressMonitor)subMonitor.newChild(10));
                } else if (iFileInfo.isDirectory()) {
                    share.getTracker().trackFolderAddition(iFolderHandle, sharingManager.findShareable(sandbox, iPath3, ResourceType.FOLDER), (IProgressMonitor)subMonitor.newChild(10));
                } else {
                    share.getTracker().trackFileAddition(iFolderHandle, sharingManager.findShareable(sandbox, iPath3, ResourceType.FILE), (IProgressMonitor)subMonitor.newChild(10));
                }
                if (n != 0 && n == iPath2.segmentCount() && !iFileInfo.getName().equals(share.getPath().lastSegment())) {
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).moveSharingInfo(share.getPath(), share.getPath().removeLastSegments(1).append(iFileInfo.getName()), (IProgressMonitor)subMonitor.newChild(10));
                }
                return true;
            }
            if (!ManagedFileStore.isSameType(iFileInfo, fileItemInfo)) {
                ((CopyFileAreaStore)((Object)iCopyFileArea)).deleteTreeInfo(iPath2, false, (IProgressMonitor)subMonitor.newChild(18));
                if (iPath2.segmentCount() != share.getPath().segmentCount()) {
                    IFolderHandle iFolderHandle = (IFolderHandle)((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(iPath2.removeLastSegments(1)).getVersionableHandle();
                    if (iFileInfo.getAttribute(32)) {
                        share.getTracker().trackSymbolicLinkAddition(iFolderHandle, sharingManager.findShareable(sandbox, iPath2.removeLastSegments(1).append(iFileInfo.getName()), iFileInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE), (IProgressMonitor)subMonitor.newChild(10));
                    } else if (iFileInfo.isDirectory()) {
                        share.getTracker().trackFolderAddition(iFolderHandle, sharingManager.findShareable(sandbox, iPath2.removeLastSegments(1).append(iFileInfo.getName()), ResourceType.FOLDER), (IProgressMonitor)subMonitor.newChild(10));
                    } else {
                        share.getTracker().trackFileAddition(iFolderHandle, sharingManager.findShareable(sandbox, iPath2.removeLastSegments(1).append(iFileInfo.getName()), ResourceType.FILE), (IProgressMonitor)subMonitor.newChild(10));
                    }
                }
                return true;
            }
            if (fileItemInfo.isSymbolicLink()) {
                boolean bl = LocalChangeTracker.contentChanged(fileItemInfo, iFileInfo.getStringAttribute(64));
                boolean bl2 = false;
                boolean bl3 = false;
                if (iPath2.segmentCount() == share.getPath().segmentCount()) {
                    if (iPath2.segmentCount() != 0 && !share.getPath().lastSegment().equals(iFileInfo.getName())) {
                        ((CopyFileAreaStore)((Object)iCopyFileArea)).moveSharingInfo(share.getPath(), share.getPath().removeLastSegments(1).append(iFileInfo.getName()), (IProgressMonitor)subMonitor.newChild(1));
                        bl3 = true;
                    }
                } else {
                    ISharingDescriptor iSharingDescriptor = share.getSharingDescriptor();
                    InverseFileItemInfo inverseFileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                    boolean bl4 = bl2 = !inverseFileItemInfo.getLocalName().equals(iFileInfo.getName());
                }
                if (bl2 || bl != fileItemInfo.isContentChanged()) {
                    subMonitor.setWorkRemaining(11);
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(iPath2.removeLastSegments(1).append(iFileInfo.getName()), new FileItemInfo((ISymbolicLinkHandle)fileItemInfo.getVersionableHandle(), bl, fileItemInfo.getParent(), fileItemInfo.getName(), fileItemInfo.isLoadedWithAnotherName(), fileItemInfo.getHash(), fileItemInfo.getStoredHash()), (IProgressMonitor)subMonitor.newChild(10));
                    bl3 = true;
                }
                return bl3;
            }
            if (fileItemInfo.isFile()) {
                boolean bl = ManagedFileStore.contentChanged(managedFileStore, iFileInfo, fileItemInfo, share, shareable.getFileStorage(), subMonitor.newChild(15));
                boolean bl5 = shareable.getFileStorage().supportsExecBit() ? iFileInfo.getAttribute(4) : fileItemInfo.isExecutable();
                long l = fileItemInfo.getVersionableHandle().hasStateId() ? shareable.getFileStorage().getModificationStamp() : -1L;
                boolean bl6 = false;
                boolean bl7 = false;
                if (iPath2.segmentCount() == share.getPath().segmentCount()) {
                    if (iPath2.segmentCount() != 0 && !share.getPath().lastSegment().equals(iFileInfo.getName())) {
                        ((CopyFileAreaStore)((Object)iCopyFileArea)).moveSharingInfo(share.getPath(), share.getPath().removeLastSegments(1).append(iFileInfo.getName()), (IProgressMonitor)subMonitor.newChild(1));
                        bl7 = true;
                    }
                } else {
                    ISharingDescriptor iSharingDescriptor = share.getSharingDescriptor();
                    InverseFileItemInfo inverseFileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                    boolean bl8 = bl6 = !inverseFileItemInfo.getLocalName().equals(iFileInfo.getName());
                }
                if (bl6 || bl != fileItemInfo.isContentChanged() || bl5 != fileItemInfo.isExecutable() || l != fileItemInfo.getLastContentChangeCheckStamp()) {
                    subMonitor.setWorkRemaining(11);
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(iPath2.removeLastSegments(1).append(iFileInfo.getName()), new FileItemInfo(fileItemInfo.getVersionableHandle(), bl, l, fileItemInfo.getParent(), fileItemInfo.getName(), fileItemInfo.isLoadedWithAnotherName(), fileItemInfo.getHash(), fileItemInfo.getContentLength(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getLineDelimiter(), fileItemInfo.getOriginalContentType(), fileItemInfo.getContentType(), fileItemInfo.getStoredPredecessorHintHash(), fileItemInfo.getStoredSize(), fileItemInfo.getStoredEncoding(), fileItemInfo.getStoredHash(), fileItemInfo.getStoredNumLineDelimiters(), bl5, fileItemInfo.isOriginalExecutable()), (IProgressMonitor)subMonitor.newChild(10));
                    bl7 = true;
                }
                return bl7;
            }
            if (iPath2.segmentCount() == share.getPath().segmentCount()) {
                if (iPath2.segmentCount() != 0 && !share.getPath().lastSegment().equals(iFileInfo.getName())) {
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).moveSharingInfo(share.getPath(), share.getPath().removeLastSegments(1).append(iFileInfo.getName()), (IProgressMonitor)subMonitor.newChild(28));
                    return true;
                }
            } else {
                ISharingDescriptor iSharingDescriptor = share.getSharingDescriptor();
                InverseFileItemInfo inverseFileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                if (!inverseFileItemInfo.getLocalName().equals(iFileInfo.getName())) {
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(iPath2.removeLastSegments(1).append(iFileInfo.getName()), fileItemInfo, (IProgressMonitor)subMonitor.newChild(28));
                    return true;
                }
            }
        } else {
            Collection collection = ((CopyFileAreaStore)((Object)iCopyFileArea)).allSharePaths(iPath2);
            if (!iFileInfo.exists() || !iFileInfo.isDirectory()) {
                SubMonitor subMonitor2 = subMonitor.newChild(28);
                subMonitor2.setWorkRemaining(collection.size());
                for (IPath iPath5 : collection) {
                    Shareable shareable2;
                    SubMonitor subMonitor3 = subMonitor2.newChild(1).setWorkRemaining(2);
                    FileItemInfo fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(iPath5);
                    if (fileItemInfo == null || (shareable2 = sharingManager.findShareable(sandbox, iPath5, ResourceType.getResourceType(fileItemInfo.getVersionableHandle()))).shouldBeIgnored((IProgressMonitor)subMonitor3.newChild(1))) continue;
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).deleteTreeInfo(iPath5, false, (IProgressMonitor)subMonitor3.newChild(1));
                    return true;
                }
                subMonitor2.done();
            } else {
                int n = iPath2.segmentCount() - 1;
                boolean bl = false;
                if (n >= 0) {
                    SubMonitor subMonitor4 = subMonitor.newChild(28);
                    subMonitor4.setWorkRemaining(collection.size());
                    for (IPath iPath6 : collection) {
                        ISharingDescriptor iSharingDescriptor;
                        Shareable shareable3;
                        SubMonitor subMonitor5 = subMonitor4.newChild(1).setWorkRemaining(2);
                        if (iPath6.segment(n).equals(iFileInfo.getName()) || (shareable3 = sharingManager.findShareable(sandbox, iPath6, ResourceType.getResourceType((iSharingDescriptor = ((CopyFileAreaStore)((Object)iCopyFileArea)).getSharingInfo(iPath6)).getRootVersionable()))).shouldBeIgnored((IProgressMonitor)subMonitor5.newChild(1))) continue;
                        IPath iPath7 = iPath6.removeLastSegments(iPath6.segmentCount() - n).append(iFileInfo.getName()).append(iPath6.removeFirstSegments(n + 1));
                        ((CopyFileAreaStore)((Object)iCopyFileArea)).moveSharingInfo(iPath6, iPath7, (IProgressMonitor)subMonitor5.newChild(1));
                        bl = true;
                    }
                }
                return bl;
            }
        }
        return false;
    }

    private static boolean isSameType(IFileInfo iFileInfo, FileItemInfo fileItemInfo) {
        if (iFileInfo.getAttribute(32)) {
            return fileItemInfo.isSymbolicLink();
        }
        if (iFileInfo.isDirectory()) {
            return fileItemInfo.isFolder();
        }
        return fileItemInfo.isFile();
    }

    private static boolean contentChanged(ManagedFileStore managedFileStore, IFileInfo iFileInfo, FileItemInfo fileItemInfo, Share share, IFileStorage iFileStorage, SubMonitor subMonitor) throws CoreException {
        ContentHash contentHash;
        if (fileItemInfo == null || fileItemInfo.getHash() == null) {
            return false;
        }
        if (iFileInfo.getLength() != fileItemInfo.getContentLength()) {
            return true;
        }
        if (fileItemInfo.getLastContentChangeCheckStamp() != -1L && fileItemInfo.getLastContentChangeCheckStamp() == iFileStorage.getModificationStamp() && iFileStorage.getLocalTimeStamp() == iFileInfo.getLastModified()) {
            return fileItemInfo.isContentChanged();
        }
        IVersionableHandle iVersionableHandle = fileItemInfo.getVersionableHandle();
        IComponentHandle iComponentHandle = share.getSharingDescriptor().getComponent();
        IContextHandle iContextHandle = share.getSharingDescriptor().getConnectionHandle();
        if (share.getTracker().containsDatelessVersionable(iFileInfo.getLastModified(), iVersionableHandle, iComponentHandle, iContextHandle)) {
            return fileItemInfo.isContentChanged();
        }
        subMonitor.beginTask(Messages.ManagedFileStore_1, 100);
        try {
            InputStream inputStream = managedFileStore.openInputStream(0, (IProgressMonitor)subMonitor.newChild(50));
            try {
                contentHash = ContentHash.valueOf((InputStream)inputStream);
                inputStream.close();
                inputStream = null;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                    }
                    catch (RuntimeException runtimeException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        catch (ContentHashAlgorithmException contentHashAlgorithmException) {
            throw (Throwable)new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)contentHashAlgorithmException));
        }
        catch (IOException iOException) {
            throw (Throwable)new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)iOException));
        }
        boolean bl = contentHash.equals((Object)fileItemInfo.getHash());
        share.getTracker().registerDatelessVersionable(iFileInfo.getLastModified(), iVersionableHandle, iComponentHandle, iContextHandle);
        return !bl;
    }

    public ManagedFileStore getChild(IPath iPath) {
        return new ManagedFileStore(this.cfaPath, this.localPath.append(iPath), this.baseStore.getChild(iPath));
    }

    public ManagedFileStore getChild(String string) {
        return new ManagedFileStore(this.cfaPath, this.localPath.append(string), this.baseStore.getChild(string));
    }

    public ManagedFileSystem getFileSystem() {
        return ManagedFileSystem.getInstance();
    }

    public String getName() {
        return this.baseStore.getName();
    }

    public ManagedFileStore getParent() {
        if (this.localPath.segmentCount() == 0) {
            return null;
        }
        IFileStore iFileStore = this.baseStore.getParent();
        if (iFileStore == null) {
            return null;
        }
        return new ManagedFileStore(this.cfaPath, this.localPath.removeLastSegments(1), iFileStore);
    }

    public boolean isParentOf(IFileStore iFileStore) {
        if (!(iFileStore instanceof ManagedFileStore)) {
            return false;
        }
        ManagedFileStore managedFileStore = (ManagedFileStore)iFileStore;
        if (!ManagedFileStore.equal(this.cfaPath, managedFileStore.cfaPath) || !ManagedFileStore.isPrefixOf(this.localPath, managedFileStore.localPath)) {
            return false;
        }
        IFileStore iFileStore2 = this.baseStore;
        if (this.localPath.segmentCount() != managedFileStore.localPath.segmentCount()) {
            iFileStore2.getChild(managedFileStore.localPath.removeFirstSegments(this.localPath.segmentCount()).setDevice(null));
        }
        return managedFileStore.baseStore.equals(iFileStore2);
    }

    private static boolean isPrefixOf(IPath iPath, IPath iPath2) {
        if (!ManagedFileSystem.getInstance().isCaseSensitive()) {
            iPath = new Path(iPath.toString().toUpperCase().toLowerCase());
            iPath2 = new Path(iPath2.toString().toUpperCase().toLowerCase());
        }
        return iPath.equals((Object)iPath2);
    }

    private static boolean equal(IPath iPath, IPath iPath2) {
        if (!ManagedFileSystem.getInstance().isCaseSensitive()) {
            iPath = new Path(iPath.toString().toUpperCase().toLowerCase());
            iPath2 = new Path(iPath2.toString().toUpperCase().toLowerCase());
        }
        return iPath.equals((Object)iPath2);
    }

    public IFileStore mkdir(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.trackingChanges()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            try {
                AbstractLock abstractLock = CFALockUtil.createAndLockForUpdate(this.cfaPath, this.localPath, true, (IProgressMonitor)subMonitor.newChild(1));
                try {
                    this.baseStore.mkdir(n, (IProgressMonitor)subMonitor.newChild(70));
                    if (abstractLock == null) {
                        this.requestBackgroundMetadataUpdate(false);
                    }
                    ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
                    Share share = ((CopyFileArea)iCopyFileArea).getShare(this.localPath);
                    ManagedFileStore.createFolderHierarchyUpToParentOf(this.localPath.append("a"), share, (CopyFileArea)iCopyFileArea, true, (IProgressMonitor)subMonitor.newChild(28));
                }
                finally {
                    if (abstractLock != null) {
                        CFALockUtil.endBatching(abstractLock, (IProgressMonitor)subMonitor.newChild(1));
                    }
                }
            }
            finally {
                ManagedFileStore.done(iProgressMonitor);
            }
        } else {
            this.baseStore.mkdir(n, iProgressMonitor);
        }
        return (IFileStore)this;
    }

    private static void moveMetadata(IPath iPath, Share share, ManagedFileStore managedFileStore, CopyFileArea copyFileArea, IProgressMonitor iProgressMonitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)110);
        IPath iPath2 = managedFileStore.localPath;
        SharingManager sharingManager = SharingManager.getInstance();
        Sandbox sandbox = new Sandbox(copyFileArea);
        FileItemInfo fileItemInfo = copyFileArea.getItemInfo(iPath);
        ResourceType resourceType = fileItemInfo == null ? ResourceType.FOLDER : ResourceType.getResourceType(fileItemInfo.getVersionableHandle());
        Shareable shareable = sharingManager.findShareable(sandbox, iPath, resourceType);
        Shareable shareable2 = sharingManager.findShareable(sandbox, iPath2, resourceType);
        boolean bl = shareable.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(10));
        Share share2 = copyFileArea.getShare(iPath2);
        boolean bl2 = false;
        if (!bl && share2 == null) {
            Collection collection = copyFileArea.allSharePaths(iPath2);
            if (collection.isEmpty()) {
                if (share.getPath().segmentCount() == iPath.segmentCount() && !shareable2.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(10))) {
                    copyFileArea.moveSharingInfo(iPath, iPath2, (IProgressMonitor)subMonitor.newChild(90));
                    bl2 = true;
                }
            } else {
                SubMonitor subMonitor2 = subMonitor.newChild(90);
                subMonitor2.setWorkRemaining(collection.size());
                for (IPath iPath3 : collection) {
                    SubMonitor subMonitor3 = subMonitor2.newChild(1).setWorkRemaining(2);
                    ISharingDescriptor iSharingDescriptor = copyFileArea.getSharingInfo(iPath3);
                    IPath iPath4 = iPath.append(iPath3.removeFirstSegments(iPath2.segmentCount()));
                    Shareable shareable3 = sharingManager.findShareable(sandbox, iPath3, ResourceType.getResourceType(iSharingDescriptor.getRootVersionable()));
                    if (shareable3.shouldBeIgnored((IProgressMonitor)subMonitor3.newChild(1))) continue;
                    FileItemInfo fileItemInfo2 = copyFileArea.getItemInfo(iPath4);
                    if (fileItemInfo2 == null) {
                        copyFileArea.deleteTreeInfo(iPath3, false, (IProgressMonitor)subMonitor3.newChild(1));
                        continue;
                    }
                    if (iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)share.getSharingDescriptor().getConnectionHandle()) && iSharingDescriptor.getComponent().sameItemId((IItemHandle)share.getSharingDescriptor().getComponent())) {
                        if (fileItemInfo2.isFolder() != iSharingDescriptor.getRootVersionable() instanceof IFolderHandle) {
                            copyFileArea.deleteTreeInfo(iPath3, false, (IProgressMonitor)subMonitor3.newChild(1));
                            continue;
                        }
                        if (fileItemInfo2.isFolder()) {
                            SubMonitor subMonitor4 = subMonitor3.newChild(1);
                            subMonitor4.setWorkRemaining(100);
                            share2.getTracker().trackFolderAddition(null, shareable3, (IProgressMonitor)subMonitor4.newChild(10));
                            Map map = copyFileArea.getChildInfos(iPath4, (IProgressMonitor)subMonitor4.newChild(10));
                            subMonitor4.setWorkRemaining(map.size());
                            for (Map.Entry entry : map.entrySet()) {
                                FileItemInfo fileItemInfo3;
                                SubMonitor subMonitor5 = subMonitor4.newChild(1).setWorkRemaining(2);
                                String string = ((StringWrapper)entry.getKey()).toString();
                                IPath iPath5 = iPath4.append(string);
                                IPath iPath6 = iPath3.append(string);
                                Shareable shareable4 = sharingManager.findShareable(sandbox, iPath6, ResourceType.getResourceType((fileItemInfo3 = (FileItemInfo)entry.getValue()).getVersionableHandle()));
                                if (shareable4.shouldBeIgnored((IProgressMonitor)subMonitor5.newChild(1))) continue;
                                copyFileArea.moveTreeInfo(iPath5, iPath6, false, (IProgressMonitor)subMonitor5.newChild(1));
                            }
                            continue;
                        }
                        if (fileItemInfo2.isFile()) {
                            share2.getTracker().trackFileAddition(null, shareable3, (IProgressMonitor)subMonitor3.newChild(1));
                            continue;
                        }
                        if (!fileItemInfo2.isSymbolicLink()) continue;
                        share2.getTracker().trackSymbolicLinkAddition(null, shareable3, (IProgressMonitor)subMonitor3.newChild(1));
                        continue;
                    }
                    ManagedFileStore.refreshSubtree(managedFileStore.getChild(iPath3.removeFirstSegments(iPath2.segmentCount())), (IProgressMonitor)subMonitor3.newChild(1));
                }
                subMonitor2.done();
            }
        } else if (!bl && share2 != null && share2.getSharingDescriptor().getConnectionHandle().sameItemId((IItemHandle)share.getSharingDescriptor().getConnectionHandle()) && share2.getSharingDescriptor().getComponent().sameItemId((IItemHandle)share.getSharingDescriptor().getComponent())) {
            if (iPath.segmentCount() == share.getPath().segmentCount() && share.getSharingDescriptor().getRootVersionable().sameItemId((IItemHandle)share2.getSharingDescriptor().getRootVersionable())) {
                if (!shareable2.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(50))) {
                    if (!iPath.equals((Object)iPath2)) {
                        copyFileArea.moveSharingInfo(iPath, iPath2, (IProgressMonitor)subMonitor.newChild(50));
                    }
                    bl2 = true;
                }
            } else if (iPath.segmentCount() == share.getPath().segmentCount() || iPath2.segmentCount() == share2.getPath().segmentCount()) {
                if (!(shareable2.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(10)) || fileItemInfo == null || iPath2.segmentCount() == share2.getPath().segmentCount() && fileItemInfo.getVersionableHandle().getItemType() != share2.getSharingDescriptor().getRootVersionable().getItemType())) {
                    if (fileItemInfo.isFolder()) {
                        share2.getTracker().trackFolderAddition(null, shareable2, (IProgressMonitor)subMonitor.newChild(10));
                        Map map = copyFileArea.getChildInfos(iPath, (IProgressMonitor)subMonitor.newChild(10));
                        SubMonitor subMonitor6 = subMonitor.newChild(60);
                        subMonitor6.setWorkRemaining(map.size());
                        for (Map.Entry entry : map.entrySet()) {
                            FileItemInfo fileItemInfo4;
                            SubMonitor subMonitor7 = subMonitor6.newChild(1).setWorkRemaining(2);
                            String string = ((StringWrapper)entry.getKey()).toString();
                            IPath iPath7 = iPath.append(string);
                            IPath iPath8 = iPath2.append(string);
                            Shareable shareable5 = sharingManager.findShareable(sandbox, iPath8, ResourceType.getResourceType((fileItemInfo4 = (FileItemInfo)entry.getValue()).getVersionableHandle()));
                            if (shareable5.shouldBeIgnored((IProgressMonitor)subMonitor7.newChild(1))) continue;
                            copyFileArea.moveTreeInfo(iPath7, iPath8, false, (IProgressMonitor)subMonitor7.newChild(1));
                        }
                    } else {
                        share2.getTracker().trackFileAddition(null, shareable2, (IProgressMonitor)subMonitor.newChild(90));
                    }
                }
            } else if (!shareable2.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(50))) {
                copyFileArea.moveTreeInfo(iPath, iPath2, false, (IProgressMonitor)subMonitor.newChild(50));
                bl2 = true;
            }
        } else if (share2 != null) {
            ManagedFileStore.refreshSubtree(managedFileStore, (IProgressMonitor)subMonitor.newChild(90));
        } else {
            Collection collection = copyFileArea.allSharePaths(iPath2);
            SubMonitor subMonitor8 = subMonitor.newChild(90);
            subMonitor8.setWorkRemaining(collection.size());
            for (IPath iPath9 : collection) {
                ManagedFileStore.refreshSubtree(managedFileStore.getChild(iPath9.removeFirstSegments(iPath2.segmentCount())), (IProgressMonitor)subMonitor8.newChild(1));
            }
            subMonitor8.done();
        }
        if (!bl2 && !bl && fileItemInfo != null) {
            copyFileArea.deleteTreeInfo(iPath, false, (IProgressMonitor)subMonitor.newChild(10));
        }
        subMonitor.done();
    }

    /*
     * Unable to fully structure code
     */
    public void move(IFileStore var1_1, int var2_2, IProgressMonitor var3_3) throws CoreException {
        var4_4 = SubMonitor.convert((IProgressMonitor)var3_3, (int)100);
        try {
            block28: {
                var5_5 = this.getCanonicalFileStore((IFileStore)this, var4_4.newChild(1));
                if (!var5_5.equals((Object)this) && !(var6_6 = this.baseStore.fetchInfo(0, (IProgressMonitor)var4_4.newChild(1))).getAttribute(32)) {
                    var5_5.move(var1_1, var2_2, (IProgressMonitor)var4_4.newChild(99));
lbl6:
                    // 7 sources

                    return;
                }
                var1_1 = this.getCanonicalFileStore(var1_1, var4_4.newChild(1));
                var6_6 = null;
                if (var1_1 instanceof ManagedFileStore) {
                    var6_6 = (ManagedFileStore)var1_1;
                    var1_1 = var6_6.baseStore;
                }
                if (this.trackingChanges()) break block28;
                this.moveBaseStore(var1_1, var2_2, var4_4.newChild(100));
                ** GOTO lbl6
            }
            var7_7 = var6_6 == null ? CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, true, (IProgressMonitor)var4_4.newChild(1)) : CFALockUtil.createAndLockForUpdateOfChildren(Arrays.asList(new IPath[]{this.cfaPath, var6_6.cfaPath}), Arrays.asList(new IPath[]{this.localPath, var6_6.localPath}), true, (IProgressMonitor)var4_4.newChild(1));
            try {
                block29: {
                    this.moveBaseStore(var1_1, var2_2, var4_4.newChild(50));
                    if (var7_7.code == 0) break block29;
                    if (var7_7.code != 2) ** GOTO lbl6
                    this.requestBackgroundMetadataUpdate(false);
                    if (var6_6 == null) ** GOTO lbl6
                    MetadataUpdateJob.queueUpdate((ManagedFileStore)var6_6, false);
                    ** GOTO lbl6
                }
                var4_4.setWorkRemaining(49);
                var8_8 = SharingManager.getInstance();
                var9_9 = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
                var10_10 = new Sandbox(var9_9);
                var11_11 = var9_9.getShare(this.localPath);
                var12_12 = null;
                var13_13 = null;
                if (var6_6 != null) {
                    var12_12 = CopyFileAreaManager.instance.getExistingCopyFileArea(var6_6.cfaPath);
                    var13_13 = var12_12.getShare(var6_6.localPath);
                }
                if (var11_11 != null) {
                    ManagedFileStore.createFolderHierarchyUpToParentOf(this.localPath, var11_11, (CopyFileArea)var9_9, true, (IProgressMonitor)var4_4.newChild(10));
                }
                var4_4.setWorkRemaining(39);
                if (var13_13 != null) {
                    ManagedFileStore.createFolderHierarchyUpToParentOf(var6_6.localPath, var13_13, (CopyFileArea)var12_12, true, (IProgressMonitor)var4_4.newChild(10));
                }
                var4_4.setWorkRemaining(29);
                if (var6_6 == null || var9_9 != var12_12) {
                    if (var11_11 == null) {
                        var14_14 = var9_9.allSharePaths(this.localPath);
                        var15_16 = var4_4.newChild(28);
                        var15_16.setWorkRemaining(var14_14.size());
                        var17_18 = var14_14.iterator();
                        while (var17_18.hasNext()) {
                            var16_20 = (IPath)var17_18.next();
                            var18_22 = var15_16.newChild(1).setWorkRemaining(2);
                            var19_24 = var9_9.getSharingInfo(var16_20);
                            var20_25 = var8_8.findShareable(var10_10, this.localPath, ResourceType.getResourceType(var19_24.getRootVersionable()));
                            if (var20_25.shouldBeIgnored((IProgressMonitor)var18_22.newChild(1))) continue;
                            var9_9.deleteTreeInfo(var16_20, false, (IProgressMonitor)var18_22.newChild(1));
                        }
                        var15_16.done();
                    } else {
                        var14_14 = var9_9.getItemInfo(this.localPath);
                        if (var14_14 != null && !(var15_16 = var8_8.findShareable(var10_10, this.localPath, ResourceType.getResourceType(var14_14.getVersionableHandle()))).shouldBeIgnored((IProgressMonitor)var4_4.newChild(8))) {
                            var9_9.deleteTreeInfo(this.localPath, false, (IProgressMonitor)var4_4.newChild(20));
                        }
                    }
                    if (var6_6 != null) {
                        if (var13_13 != null) {
                            ManagedFileStore.refreshSubtree((ManagedFileStore)var6_6, (IProgressMonitor)var4_4.newChild(28));
                        } else {
                            var14_14 = var12_12.allSharePaths(var6_6.localPath);
                            var15_16 = var4_4.newChild(28);
                            var15_16.setWorkRemaining(var14_14.size());
                            var17_18 = var14_14.iterator();
                            while (var17_18.hasNext()) {
                                var16_20 = (IPath)var17_18.next();
                                ManagedFileStore.refreshSubtree(var6_6.getChild(var16_20.removeFirstSegments(var6_6.localPath.segmentCount())), (IProgressMonitor)var15_16.newChild(1));
                            }
                            var15_16.done();
                        }
                    }
                } else if (var11_11 == null) {
                    var14_15 = var9_9.allSharePaths(this.localPath);
                    var15_17 = var4_4.newChild(28);
                    var15_17.setWorkRemaining(var14_15.size());
                    for (IPath var16_21 : var14_15) {
                        var18_23 = var9_9.getShare(var16_21);
                        ManagedFileStore.moveMetadata(var16_21, var18_23, var6_6.getChild(var16_21.removeFirstSegments(this.localPath.segmentCount())), (CopyFileArea)var9_9, (IProgressMonitor)var15_17.newChild(1));
                    }
                    var15_17.done();
                } else {
                    ManagedFileStore.moveMetadata(this.localPath, var11_11, (ManagedFileStore)var6_6, (CopyFileArea)var9_9, (IProgressMonitor)var4_4.newChild(28));
                }
            }
            finally {
                if (var7_7 == null) ** GOTO lbl6
                CFALockUtil.endBatching(var7_7, var4_4.newChild(1));
                ** continue;
            }
        }
        finally {
            ManagedFileStore.done(var3_3);
        }
    }

    private void moveBaseStore(IFileStore iFileStore, int n, SubMonitor subMonitor) throws CoreException {
        if (!this.baseStore.toURI().equals(iFileStore.toURI())) {
            subMonitor.setWorkRemaining(100);
            IFileInfo iFileInfo = iFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(10));
            if (iFileInfo.getAttribute(32) || iFileInfo.exists() && !this.isSameFile(this.baseStore, iFileStore, subMonitor.newChild(2))) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ManagedFileStore_9, (Object)iFileStore.toLocalFile(0, (IProgressMonitor)subMonitor.newChild(10)).getAbsolutePath()), null)));
            }
            try {
                this.baseStore.move(iFileStore, n & 0xFFFFFFFD, (IProgressMonitor)subMonitor.newChild(70));
            }
            catch (CoreException coreException) {
                IFileInfo iFileInfo2;
                IFileInfo iFileInfo3;
                if (coreException.getStatus().getCode() == 272 && !(iFileInfo3 = this.baseStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(10))).exists() && !iFileInfo3.getAttribute(32) && !(iFileInfo2 = iFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(10))).exists() && iFileInfo2.getAttribute(32)) {
                    return;
                }
                throw (Throwable)coreException;
            }
        }
    }

    private boolean isSameFile(IFileStore iFileStore, IFileStore iFileStore2, SubMonitor subMonitor) throws CoreException {
        subMonitor.setWorkRemaining(2);
        File file = iFileStore.toLocalFile(0, (IProgressMonitor)subMonitor.newChild(1));
        if (file == null) {
            return false;
        }
        File file2 = iFileStore2.toLocalFile(0, (IProgressMonitor)subMonitor.newChild(1));
        if (file2 == null) {
            return false;
        }
        try {
            return file.getCanonicalFile().equals(file2.getCanonicalFile());
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
        }
    }

    private IFileStore getCanonicalFileStore(IFileStore iFileStore, SubMonitor subMonitor) throws CoreException {
        File file;
        block4: {
            try {
                File file2 = iFileStore.toLocalFile(0, (IProgressMonitor)subMonitor);
                file = file2.getCanonicalFile();
                if (file.equals(file2)) {
                    return iFileStore;
                }
                Path path = new Path(file.getAbsolutePath());
                ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getCopyFileAreaForPath((IPath)path);
                if (iCopyFileArea == null) break block4;
                IPath iPath = iCopyFileArea.getRoot();
                return (IFileStore)new ManagedFileStore(iPath, path.removeFirstSegments(iPath.segmentCount()).makeRelative(), EFS.getLocalFileSystem().fromLocalFile(file));
            }
            catch (IOException iOException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
            }
        }
        return EFS.getLocalFileSystem().fromLocalFile(file);
    }

    private static void refreshSubtree(ManagedFileStore managedFileStore, IProgressMonitor iProgressMonitor) throws CoreException {
        Sandbox sandbox;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        subMonitor.setTaskName(Messages.ManagedFileStore_3);
        IFileInfo iFileInfo = managedFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
        if (!iFileInfo.exists()) {
            return;
        }
        SharingManager sharingManager = SharingManager.getInstance();
        Shareable shareable = sharingManager.findShareable(sandbox = new Sandbox(CopyFileAreaManager.instance.getExistingCopyFileArea(managedFileStore.cfaPath)), managedFileStore.localPath, iFileInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
        if (shareable.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(10))) {
            return;
        }
        ArrayList<ManagedFileStore> arrayList = new ArrayList<ManagedFileStore>();
        arrayList.add(managedFileStore);
        do {
            int n = arrayList.size() - 1;
            subMonitor.setWorkRemaining(n + 2);
            ManagedFileStore managedFileStore2 = (ManagedFileStore)((Object)arrayList.remove(n));
            IFileInfo[] iFileInfoArray = managedFileStore2.childInfos(0, (IProgressMonitor)subMonitor.newChild(1));
            subMonitor.setWorkRemaining(n + iFileInfoArray.length + 2);
            IFileInfo[] iFileInfoArray2 = iFileInfoArray;
            int n2 = iFileInfoArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IFileInfo iFileInfo2 = iFileInfoArray2[n3];
                shareable = sharingManager.findShareable(sandbox, managedFileStore2.localPath.append(iFileInfo2.getName()), iFileInfo2.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
                if (!shareable.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(1))) {
                    arrayList.add(managedFileStore2.getChild(iFileInfo2.getName()));
                }
                ++n3;
            }
        } while (!arrayList.isEmpty());
    }

    public InputStream openInputStream(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        return this.baseStore.openInputStream(n, iProgressMonitor);
    }

    public OutputStream openOutputStream(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!this.trackingChanges()) {
            return this.baseStore.openOutputStream(n, iProgressMonitor);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            OutputStream outputStream;
            block16: {
                CFALockUtil$LockResult cFALockUtil$LockResult;
                block12: {
                    OutputStream outputStream2;
                    block15: {
                        block13: {
                            ManagedFileStore$1 managedFileStore$1;
                            block14: {
                                cFALockUtil$LockResult = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, true, (IProgressMonitor)subMonitor.newChild(1));
                                try {
                                    if (cFALockUtil$LockResult.code == 0) break block12;
                                    if (cFALockUtil$LockResult.code != 2) break block13;
                                    OutputStream outputStream3 = this.baseStore.openOutputStream(n, (IProgressMonitor)subMonitor.newChild(99));
                                    managedFileStore$1 = new ManagedFileStore$1(this, outputStream3);
                                    if (cFALockUtil$LockResult == null) break block14;
                                }
                                catch (Throwable throwable) {
                                    if (cFALockUtil$LockResult != null) {
                                        CFALockUtil.endBatching(cFALockUtil$LockResult, subMonitor.newChild(1));
                                    }
                                    throw throwable;
                                }
                                CFALockUtil.endBatching(cFALockUtil$LockResult, subMonitor.newChild(1));
                            }
                            return managedFileStore$1;
                        }
                        outputStream2 = this.baseStore.openOutputStream(n, (IProgressMonitor)subMonitor.newChild(99));
                        if (cFALockUtil$LockResult == null) break block15;
                        CFALockUtil.endBatching(cFALockUtil$LockResult, subMonitor.newChild(1));
                    }
                    return outputStream2;
                }
                outputStream = this.openOutputStreamInternal(n, subMonitor.newChild(99));
                if (cFALockUtil$LockResult == null) break block16;
                CFALockUtil.endBatching(cFALockUtil$LockResult, subMonitor.newChild(1));
            }
            return outputStream;
        }
        finally {
            ManagedFileStore.done(iProgressMonitor);
        }
    }

    private OutputStream openOutputStreamInternal(int n, SubMonitor subMonitor) throws CoreException, FileSystemClientException {
        subMonitor.setWorkRemaining(99);
        Object object = this.baseStore.openOutputStream(n, (IProgressMonitor)subMonitor.newChild(70));
        try {
            Object object2;
            Object object3;
            ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
            SharingManager sharingManager = SharingManager.getInstance();
            Sandbox sandbox = new Sandbox(iCopyFileArea);
            Share share = ((CopyFileArea)iCopyFileArea).getShare(this.localPath);
            if (share == null) {
                Collection collection = ((CopyFileAreaStore)((Object)iCopyFileArea)).allSharePaths(this.localPath);
                subMonitor.setWorkRemaining(collection.size() * 2);
                for (IPath iPath : collection) {
                    ISharingDescriptor iSharingDescriptor;
                    Shareable shareable = sharingManager.findShareable(sandbox, iPath, ResourceType.getResourceType((iSharingDescriptor = ((CopyFileAreaStore)((Object)iCopyFileArea)).getSharingInfo(iPath)).getRootVersionable()));
                    if (shareable.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(1))) continue;
                    ((CopyFileAreaStore)((Object)iCopyFileArea)).deleteTreeInfo(iPath, false, (IProgressMonitor)subMonitor.newChild(1));
                }
                OutputStream outputStream = object;
                return outputStream;
            }
            Shareable shareable = sharingManager.findShareable(sandbox, this.localPath, ResourceType.FILE);
            if (shareable.shouldBeIgnored((IProgressMonitor)subMonitor.newChild(10))) {
                ManagedFileStore.createFolderHierarchyUpToParentOf(this.localPath, share, (CopyFileArea)iCopyFileArea, true, (IProgressMonitor)subMonitor.newChild(19));
                OutputStream outputStream = object;
                return outputStream;
            }
            if (share.getPath().segmentCount() == this.localPath.segmentCount() && share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle) {
                ((CopyFileAreaStore)((Object)iCopyFileArea)).deleteTreeInfo(this.localPath, false, (IProgressMonitor)subMonitor.newChild(29));
                OutputStream outputStream = object;
                return outputStream;
            }
            subMonitor.setWorkRemaining(100);
            IFileInfo iFileInfo = this.baseStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(5));
            FileItemInfo fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(this.localPath);
            IFolderHandle iFolderHandle = ManagedFileStore.createFolderHierarchyUpToParentOf(this.localPath, share, (CopyFileArea)iCopyFileArea, false, (IProgressMonitor)subMonitor.newChild(1));
            if (iFolderHandle == null && share.getPath().segmentCount() != this.localPath.segmentCount()) {
                OutputStream outputStream = object;
                return outputStream;
            }
            if (fileItemInfo != null && fileItemInfo.isSymbolicLink()) {
                OutputStream outputStream = object;
                return outputStream;
            }
            if (fileItemInfo == null) {
                if (share.getPath().segmentCount() == this.localPath.segmentCount()) {
                    object3 = share.getSharingDescriptor();
                    object2 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(object3.getRootVersionable(), object3.getComponent(), object3.getConnectionHandle());
                    if (object2 != null && ((FileItemInfo)object2).getHash() != null) {
                        fileItemInfo = new FileItemInfo(fileItemInfo.getVersionableHandle(), true, -1L, fileItemInfo.getParent(), fileItemInfo.getName(), fileItemInfo.isLoadedWithAnotherName(), fileItemInfo.getHash(), fileItemInfo.getContentLength(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getOriginalContentType(), fileItemInfo.getOriginalContentType(), fileItemInfo.getStoredPredecessorHintHash(), fileItemInfo.getStoredSize(), fileItemInfo.getStoredEncoding(), fileItemInfo.getStoredHash(), fileItemInfo.getStoredNumLineDelimiters(), iFileInfo.getAttribute(4), fileItemInfo.isOriginalExecutable());
                        ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(this.localPath, fileItemInfo, (IProgressMonitor)subMonitor.newChild(5));
                    }
                } else {
                    object3 = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(this.localPath.removeLastSegments(1));
                    if (object3 != null && ((FileItemInfo)object3).getVersionableHandle().hasStateId() && (fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getDeletedItem((IFolderHandle)((FileItemInfo)object3).getVersionableHandle(), this.localPath.lastSegment(), share.getSharingDescriptor().getComponent(), share.getSharingDescriptor().getConnectionHandle(), (IProgressMonitor)subMonitor.newChild(5))) != null) {
                        if (fileItemInfo.getVersionableHandle() instanceof IFileItemHandle) {
                            fileItemInfo = new FileItemInfo(fileItemInfo.getVersionableHandle(), true, -1L, fileItemInfo.getParent(), fileItemInfo.getName(), fileItemInfo.isLoadedWithAnotherName(), fileItemInfo.getHash(), fileItemInfo.getContentLength(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getOriginalContentType(), fileItemInfo.getOriginalContentType(), fileItemInfo.getStoredPredecessorHintHash(), fileItemInfo.getStoredSize(), fileItemInfo.getStoredEncoding(), fileItemInfo.getStoredHash(), fileItemInfo.getStoredNumLineDelimiters(), iFileInfo.getAttribute(4), fileItemInfo.isOriginalExecutable());
                            ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(this.localPath, fileItemInfo, (IProgressMonitor)subMonitor.newChild(5));
                        } else {
                            fileItemInfo = null;
                        }
                    }
                }
            }
            try {
                object3 = ContentHash.getHashDigest();
            }
            catch (ContentHashAlgorithmException contentHashAlgorithmException) {
                throw (Throwable)new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)contentHashAlgorithmException));
            }
            if (fileItemInfo != null && fileItemInfo.getHash() != null && (n & 1) != 0 && iFileInfo.getLength() < fileItemInfo.getContentLength()) {
                object2 = this.baseStore.openInputStream(0, (IProgressMonitor)subMonitor.newChild(5));
                try {
                    try {
                        byte[] byArray = new byte[8192];
                        int n2 = ((InputStream)object2).read(byArray);
                        while (n2 != -1) {
                            ((MessageDigest)object3).update(byArray, 0, n2);
                            n2 = ((InputStream)object2).read(byArray);
                        }
                        ((InputStream)object2).close();
                        object2 = null;
                    }
                    catch (IOException iOException) {
                        throw (Throwable)new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)iOException));
                    }
                }
                finally {
                    if (object2 != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (IOException iOException) {
                            LoggingHelper.log(FileSystemStatus.getStatusFor(iOException));
                        }
                    }
                }
                subMonitor.setWorkRemaining(95);
            }
            if (fileItemInfo != null) {
                object2 = fileItemInfo.getHash();
                if (object2 != null) {
                    if ((n & 1) != 0) {
                        if (iFileInfo.getLength() <= fileItemInfo.getContentLength()) {
                            object = new ChangeTrackingOutputStream((MessageDigest)object3, (OutputStream)object, this, (IFileItemHandle)fileItemInfo.getVersionableHandle(), share, (ContentHash)object2, fileItemInfo.getContentLength() - iFileInfo.getLength());
                        } else {
                            Assert.isTrue((boolean)fileItemInfo.isContentChanged());
                        }
                    } else {
                        object = new ChangeTrackingOutputStream((MessageDigest)object3, (OutputStream)object, this, (IFileItemHandle)fileItemInfo.getVersionableHandle(), share, (ContentHash)object2, fileItemInfo.getContentLength());
                    }
                }
            } else {
                share.getTracker().trackFileAddition(iFolderHandle, shareable, (IProgressMonitor)subMonitor.newChild(25));
            }
            OutputStream outputStream = object;
            return outputStream;
        }
        catch (CoreException coreException) {
            try {
                object.close();
            }
            catch (IOException iOException) {}
            throw (Throwable)coreException;
        }
        catch (RuntimeException runtimeException) {
            try {
                object.close();
            }
            catch (IOException iOException) {}
            throw (Throwable)runtimeException;
        }
        finally {
            subMonitor.done();
        }
    }

    public void putInfo(IFileInfo iFileInfo, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        boolean bl = (n & 0x400) != 0 && this.trackingChanges();
        this.baseStore.putInfo(iFileInfo, n, (IProgressMonitor)subMonitor.newChild(bl ? 50 : 100));
        if (bl) {
            this.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(50));
        }
    }

    public URI toURI() {
        return ManagedFileSystem.getCanonicalManagedURI(this.cfaPath, this.localPath, this.baseStore.toURI());
    }

    public IFileStore getBaseStore() {
        return this.baseStore;
    }

    public IPath getLocalPath() {
        return this.localPath;
    }

    public IPath getCfaPath() {
        return this.cfaPath;
    }

    public File toLocalFile(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        return this.baseStore.toLocalFile(n, iProgressMonitor);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ManagedFileStore)) {
            return false;
        }
        ManagedFileStore managedFileStore = (ManagedFileStore)((Object)object);
        return ManagedFileStore.equal(this.cfaPath, managedFileStore.cfaPath) && ManagedFileStore.equal(managedFileStore.localPath, this.localPath) && managedFileStore.baseStore.equals(this.baseStore);
    }

    public String toString() {
        return this.baseStore.toString();
    }

    public int hashCode() {
        IPath iPath = this.cfaPath;
        IPath iPath2 = this.localPath;
        if (!ManagedFileSystem.getInstance().isCaseSensitive()) {
            iPath = new Path(iPath.toString().toUpperCase().toLowerCase());
            iPath2 = new Path(iPath2.toString().toUpperCase().toLowerCase());
        }
        return iPath.hashCode() ^ iPath2.hashCode() ^ this.baseStore.hashCode();
    }

    static /* synthetic */ void access$4(ManagedFileStore managedFileStore, boolean bl) {
        managedFileStore.requestBackgroundMetadataUpdate(bl);
    }
}

