/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager$RuleKind;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class LocalFileStorage
extends FileStorage {
    protected static final Method canExecute;
    protected static final Method setExecutable;
    protected static final Method setWritableMethod;
    private final File file;

    static {
        Method method = null;
        try {
            method = File.class.getMethod("canExecute", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        canExecute = method;
        method = null;
        try {
            method = File.class.getMethod("setExecutable", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        setExecutable = method;
        method = null;
        try {
            method = File.class.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        setWritableMethod = method;
    }

    LocalFileStorage(IFileStorage iFileStorage) {
        super(iFileStorage);
        this.file = iFileStorage.getShareable().getCopyFileAreaRoot().append(iFileStorage.getShareable().getLocalPath()).toFile();
    }

    LocalFileStorage(ISandbox iSandbox, IPath iPath, ResourceType resourceType) {
        super(new FileStorageWrapper(iSandbox, iPath, resourceType));
        this.file = iSandbox.getRoot().append(iPath).toFile();
    }

    public File getFile() {
        return this.file;
    }

    public long getModificationStamp() {
        long l = this.file.lastModified();
        if (l == 0L) {
            return this.getFileStore().fetchInfo().exists() ? 0L : -1L;
        }
        return l;
    }

    public long getLocalTimeStamp() {
        return this.file.lastModified();
    }

    public IFileStorage getParent() {
        FileStorageWrapper fileStorageWrapper = null;
        IPath iPath = this.getLocalPath().removeLastSegments(1);
        if (iPath.segmentCount() != 0) {
            Shareable shareable = new Shareable(this.getSandbox(), iPath, ResourceType.FOLDER);
            fileStorageWrapper = new FileStorageWrapper(shareable, ResourceType.FOLDER);
        }
        return fileStorageWrapper;
    }

    public void resolveChildStorage(FileStorageWrapper fileStorageWrapper, String string, ResourceType resourceType) {
        if (this.file.isDirectory()) {
            File file = new File(this.file, string);
            if (file.exists()) {
                String string2 = string;
                if (!this.getSandbox().isCaseSensitive()) {
                    File[] fileArray;
                    File[] fileArray2 = fileArray = this.file.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file2 = fileArray2[n2];
                        if (file2.getName().equalsIgnoreCase(string)) {
                            string2 = file2.getName();
                        }
                        ++n2;
                    }
                    if (!string2.equals(string)) {
                        fileStorageWrapper = new FileStorageWrapper(this.getSandbox(), this.getLocalPath().append(string2), resourceType);
                    }
                }
                SharingManager.getInstance().resolveFileStorage(fileStorageWrapper, resourceType);
            } else {
                fileStorageWrapper.setUnderlyingStorage(new LocalFileStorage(fileStorageWrapper));
            }
        } else {
            throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.LocalFileStorage_7, (Object)string, (Object[])new Object[]{fileStorageWrapper.getShareable().getLocalPath().toOSString()}));
        }
    }

    public Collection getChildren(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        File[] fileArray;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IFileStore iFileStore = this.getFileStore();
        SharingManager sharingManager = SharingManager.getInstance();
        sharingManager.disableChangeMonitoring();
        try {
            fileArray = iFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
            if (!fileArray.isDirectory() || fileArray.getAttribute(32)) {
                return null;
            }
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.LocalFileStorage_8, (Object)this.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)coreException)));
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
        fileArray = this.file.listFiles();
        if (fileArray == null) {
            return null;
        }
        ArrayList<FileStorageWrapper> arrayList = new ArrayList<FileStorageWrapper>(fileArray.length);
        ISandbox iSandbox = this.getSandbox();
        IPath iPath = this.getLocalPath();
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            ResourceType resourceType = file.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
            Shareable shareable = new Shareable(iSandbox, iPath.append(file.getName()), resourceType);
            FileStorageWrapper fileStorageWrapper = new FileStorageWrapper(shareable, this.getStorage(), resourceType);
            arrayList.add(fileStorageWrapper);
            ++n2;
        }
        return arrayList;
    }

    public InputStream getContents(boolean bl) throws FileSystemClientException {
        return this.getContents();
    }

    public InputStream getContents() throws FileSystemClientException {
        if (this.file.isDirectory()) {
            return null;
        }
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 203, Messages.LocalFileStorage_1, fileNotFoundException)));
        }
    }

    public void create(InputStream inputStream, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.setContents(inputStream, false, iProgressMonitor);
    }

    public void create(boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            try {
                this.getFileStore().mkdir(bl ? 0 : 4, (IProgressMonitor)subMonitor);
            }
            catch (CoreException coreException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.LocalFileStorage_2, (Object)this.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)coreException)));
            }
        }
        finally {
            subMonitor.done();
        }
    }

    public void setContents(InputStream inputStream, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1);
        try {
            if (this.file.isDirectory()) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
                    }
                }
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(Messages.LocalFileStorage_3)));
            }
            boolean bl2 = false;
            try {
                try {
                    OutputStream outputStream = this.getFileStore().openOutputStream(0, (IProgressMonitor)subMonitor.newChild(1));
                    try {
                        if (inputStream != null) {
                            byte[] byArray = new byte[8192];
                            int n = inputStream.read(byArray);
                            while (n != -1) {
                                outputStream.write(byArray, 0, n);
                                n = inputStream.read(byArray);
                            }
                        }
                        bl2 = true;
                    }
                    finally {
                        block28: {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {
                                if (!bl2) break block28;
                                bl2 = false;
                                throw (Throwable)iOException;
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
                }
                catch (CoreException coreException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(coreException)));
                }
            }
            finally {
                block29: {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!bl2) break block29;
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
                        }
                    }
                }
            }
        }
        finally {
            subMonitor.done();
        }
    }

    public void setContents(InputStream inputStream, Shed shed, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)2);
        try {
            if (this.file.isDirectory()) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
                    }
                }
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(Messages.LocalFileStorage_3)));
            }
            boolean bl = false;
            try {
                try {
                    shed.backupIfDirty(this.getStorage().getShareable(), (IProgressMonitor)subMonitor.newChild(1));
                    OutputStream outputStream = this.getFileStore().openOutputStream(0, (IProgressMonitor)subMonitor.newChild(1));
                    try {
                        if (inputStream != null) {
                            byte[] byArray = new byte[8192];
                            int n = inputStream.read(byArray);
                            while (n != -1) {
                                outputStream.write(byArray, 0, n);
                                n = inputStream.read(byArray);
                            }
                        }
                        bl = true;
                    }
                    finally {
                        block28: {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {
                                if (!bl) break block28;
                                bl = false;
                                throw (Throwable)iOException;
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
                }
                catch (CoreException coreException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(coreException)));
                }
            }
            finally {
                block29: {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!bl) break block29;
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
                        }
                    }
                }
            }
        }
        finally {
            subMonitor.done();
        }
    }

    public IPath getIDEPath() {
        return (IPath)new Path(this.file.getPath());
    }

    public String getActualName() {
        String[] stringArray;
        if (this.getSandbox().isCaseSensitive()) {
            return this.file.getName();
        }
        String string = this.file.getName();
        File file = this.file.getParentFile();
        if (file != null && (stringArray = this.file.getParentFile().list()) != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (string2.equalsIgnoreCase(string)) {
                    return string2;
                }
                ++n2;
            }
        }
        return this.file.getName();
    }

    public boolean isExecutable(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (canExecute != null) {
            try {
                return (Boolean)canExecute.invoke((Object)this.file, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(illegalAccessException));
            }
            catch (InvocationTargetException invocationTargetException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(invocationTargetException.getTargetException()));
            }
        }
        IFileStore iFileStore = EFS.getLocalFileSystem().fromLocalFile(this.file);
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        return iFileInfo.getAttribute(4);
    }

    public boolean setExecutable(boolean bl, IProgressMonitor iProgressMonitor) {
        if (setExecutable != null) {
            try {
                return (Boolean)setExecutable.invoke((Object)this.file, bl);
            }
            catch (IllegalAccessException illegalAccessException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(illegalAccessException));
            }
            catch (InvocationTargetException invocationTargetException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(invocationTargetException.getTargetException()));
            }
        }
        IFileStore iFileStore = EFS.getLocalFileSystem().fromLocalFile(this.file);
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        iFileInfo.setAttribute(4, bl);
        try {
            iFileStore.putInfo(iFileInfo, 1024, iProgressMonitor);
        }
        catch (CoreException coreException) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(coreException));
            return false;
        }
        return true;
    }

    public boolean supportsExecBit() {
        return setExecutable != null && canExecute != null && FileStorage.PLATFORM_SUPPORTS_EXEC_BIT || (EFS.getLocalFileSystem().attributes() & 4) != 0;
    }

    public void move(FileStorage fileStorage, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)2);
        try {
            try {
                IFileStore iFileStore = this.getFileStore();
                iFileStore.move(fileStorage.getFileStore(), 0, (IProgressMonitor)subMonitor.newChild(1));
                fileStorage.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (CoreException coreException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(coreException)));
            }
        }
        finally {
            subMonitor.done();
        }
    }

    protected final IFileStore getFileStore() {
        return (IFileStore)new ManagedFileStore(this.getSandbox().getRoot(), this.getLocalPath(), EFS.getLocalFileSystem().getStore(this.getStorage().getShareable().getFullPath()));
    }

    public void delete(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            try {
                if (this.storageExists((IProgressMonitor)subMonitor.newChild(1))) {
                    this.preserveHistory((IProgressMonitor)subMonitor.newChild(1));
                    this.getFileStore().delete(0, (IProgressMonitor)subMonitor.newChild(98));
                }
            }
            catch (CoreException coreException) {
                throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.LocalFileStorage_6, (Object)this.file.getPath(), (Object[])new Object[0]), (Throwable)coreException);
            }
        }
        finally {
            subMonitor.done();
        }
    }

    public boolean contains(ISchedulingRule iSchedulingRule) {
        if (this == iSchedulingRule) {
            return true;
        }
        if (iSchedulingRule instanceof MultiRule) {
            MultiRule multiRule = (MultiRule)iSchedulingRule;
            ISchedulingRule[] iSchedulingRuleArray = multiRule.getChildren();
            int n = 0;
            while (n < iSchedulingRuleArray.length) {
                if (!this.contains(iSchedulingRuleArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (!(iSchedulingRule instanceof IFileStorage)) {
            return false;
        }
        return this.getIDEPath().isPrefixOf(((IFileStorage)iSchedulingRule).getIDEPath());
    }

    public boolean isConflicting(ISchedulingRule iSchedulingRule) {
        if (!(iSchedulingRule instanceof IFileStorage)) {
            return false;
        }
        IPath iPath = ((IFileStorage)iSchedulingRule).getShareable().getFullPath();
        IPath iPath2 = this.getStorage().getShareable().getFullPath();
        return iPath2.isPrefixOf(iPath) || iPath.isPrefixOf(iPath2);
    }

    public String toString() {
        return this.getIDEPath().toString();
    }

    public void refreshCachedSubTree(int n, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isAssignableFrom(File.class)) {
            return this.file;
        }
        return null;
    }

    public void deregisterRepositoryProvider(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        Collection collection = this.getChildren((IProgressMonitor)subMonitor.newChild(1));
        if (collection != null) {
            subMonitor.setWorkRemaining(2 * collection.size());
            for (IFileStorage iFileStorage : collection) {
                if (iFileStorage.getResourceType((IProgressMonitor)subMonitor.newChild(1)) != ResourceType.FOLDER) continue;
                iFileStorage.deregisterRepositoryProvider((IProgressMonitor)subMonitor.newChild(1));
            }
        }
    }

    public void registerRepositorProvider(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
    }

    public boolean isRepositoryProviderRegistered(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return false;
    }

    public void preserveHistory(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
    }

    public URI getLocationURI() {
        String string = this.file.getAbsolutePath();
        String string2 = PathUtils.getRealPath(string);
        if (string2 != null) {
            string = string2;
        }
        return URIUtil.toURI((String)string);
    }

    public ISchedulingRule getResourceRuleForIDE(ISharingManager$RuleKind iSharingManager$RuleKind) {
        return null;
    }

    public void backup(Shed shed, BackupDilemmaHandler backupDilemmaHandler, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        shed.backupInShed(this.getStorage().getShareable(), iProgressMonitor);
    }

    public boolean storageExists(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getStorage().exists(iProgressMonitor);
    }

    public boolean setWritable(boolean bl, IProgressMonitor iProgressMonitor) {
        boolean bl2;
        block10: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)30);
            IFileStore iFileStore = this.getFileStore();
            bl2 = false;
            if ((iFileStore.getFileSystem().attributes() & 2) != 0) {
                SharingManager sharingManager = SharingManager.getInstance();
                sharingManager.disableChangeMonitoring();
                try {
                    try {
                        IFileInfo iFileInfo = iFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(10));
                        iFileInfo.setAttribute(2, false);
                        iFileStore.putInfo(iFileInfo, 0, (IProgressMonitor)subMonitor.newChild(10));
                        iFileInfo = iFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(10));
                        bl2 = !iFileInfo.getAttribute(2);
                    }
                    catch (CoreException coreException) {
                        sharingManager.enableChangeMonitoring();
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    sharingManager.enableChangeMonitoring();
                    throw throwable;
                }
                sharingManager.enableChangeMonitoring();
            }
        }
        if (!bl2 && setWritableMethod != null) {
            try {
                bl2 = (Boolean)setWritableMethod.invoke((Object)bl, true);
            }
            catch (IllegalAccessException illegalAccessException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(illegalAccessException));
            }
            catch (InvocationTargetException invocationTargetException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(invocationTargetException.getTargetException()));
            }
        }
        return bl2;
    }
}

