/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.SharingMetadata2$ConnectionComponent;
import com.ibm.team.filesystem.client.internal.Store;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class LoadedComponentsStore
extends Store {
    private static final int METADATA_VERSION = 0;

    public LoadedComponentsStore(PersistentHeapManager persistentHeapManager, File file) {
        super(file, persistentHeapManager);
    }

    protected void writeCustomMetadata(DataOutputStream dataOutputStream) throws IOException {
        super.writeCustomMetadata(dataOutputStream);
        dataOutputStream.writeInt(0);
    }

    protected void readCustomMetadata(DataInputStream dataInputStream) throws IOException {
        super.readCustomMetadata(dataInputStream);
        int n = dataInputStream.readInt();
        if (n != 0) {
            throw (Throwable)new IllegalArgumentException("Metadata version mismatch " + n + " != " + 0);
        }
    }

    protected long persistStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        long l = this.heap.allocate((long)byteArrayOutputStream.size());
        byteArrayOutputStream.writeTo(this.heap.getOutputStream(l));
        return l;
    }

    protected long writeObject(Object object, int n) throws IOException {
        boolean bl = (n & 1) != 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (bl) {
            SharingMetadata2$ConnectionComponent sharingMetadata2$ConnectionComponent = (SharingMetadata2$ConnectionComponent)object;
            IContextHandle iContextHandle = sharingMetadata2$ConnectionComponent.getConnection();
            IComponentHandle iComponentHandle = sharingMetadata2$ConnectionComponent.getComponent();
            dataOutputStream.writeUTF(iComponentHandle.getItemId().getUuidValue());
            dataOutputStream.writeUTF(iContextHandle.getItemType().getName());
            dataOutputStream.writeUTF(iContextHandle.getItemType().getNamespaceURI());
            dataOutputStream.writeUTF(iContextHandle.getItemId().getUuidValue());
        } else {
            LoadedConfigurationDescriptor loadedConfigurationDescriptor = (LoadedConfigurationDescriptor)object;
            IContextHandle iContextHandle = loadedConfigurationDescriptor.connectionHandle;
            String string = loadedConfigurationDescriptor.connectionName;
            String string2 = loadedConfigurationDescriptor.componentName;
            IComponentHandle iComponentHandle = loadedConfigurationDescriptor.componentHandle;
            String string3 = loadedConfigurationDescriptor.uri;
            UUID uUID = loadedConfigurationDescriptor.id;
            dataOutputStream.writeUTF(iComponentHandle.getItemId().getUuidValue());
            dataOutputStream.writeUTF(iContextHandle.getItemType().getName());
            dataOutputStream.writeUTF(iContextHandle.getItemType().getNamespaceURI());
            dataOutputStream.writeUTF(iContextHandle.getItemId().getUuidValue());
            dataOutputStream.writeUTF(string3);
            dataOutputStream.writeUTF(uUID.getUuidValue());
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeUTF(string2);
        }
        return this.persistStream(byteArrayOutputStream);
    }

    protected Object readObject(InputStream inputStream, int n) throws IOException, ClassNotFoundException {
        boolean bl = (n & 1) != 0;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (bl) {
            UUID uUID = UUID.valueOf((String)dataInputStream.readUTF());
            IComponentHandle iComponentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(uUID, null);
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            IItemType iItemType = IItemType.IRegistry.INSTANCE.getItemType(string, string2);
            uUID = UUID.valueOf((String)dataInputStream.readUTF());
            IContextHandle iContextHandle = (IContextHandle)iItemType.createItemHandle(uUID, null);
            return new SharingMetadata2$ConnectionComponent(iContextHandle, iComponentHandle);
        }
        UUID uUID = UUID.valueOf((String)dataInputStream.readUTF());
        IComponentHandle iComponentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(uUID, null);
        String string = dataInputStream.readUTF();
        String string3 = dataInputStream.readUTF();
        IItemType iItemType = IItemType.IRegistry.INSTANCE.getItemType(string, string3);
        uUID = UUID.valueOf((String)dataInputStream.readUTF());
        IContextHandle iContextHandle = (IContextHandle)iItemType.createItemHandle(uUID, null);
        string3 = dataInputStream.readUTF();
        uUID = UUID.valueOf((String)dataInputStream.readUTF());
        String string4 = dataInputStream.readUTF();
        String string5 = dataInputStream.readUTF();
        return new LoadedConfigurationDescriptor(uUID, string3, iContextHandle, string4, iComponentHandle, string5);
    }
}

