/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.HardcodedPermissionUtils$FailedToRunException;
import com.ibm.team.filesystem.client.internal.HardcodedPermissionUtils$MisbehavingScriptException;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.PlatformDetector;
import com.ibm.team.filesystem.client.internal.PlatformDetector$LauncherType;
import com.ibm.team.filesystem.client.internal.PlatformDetector$Platform;
import com.ibm.team.filesystem.client.internal.utils.IPermissionUtil;
import com.ibm.team.filesystem.client.internal.utils.IPermissionUtil$CannotCreateException;
import com.ibm.team.filesystem.client.internal.utils.IPermissionUtil$CannotModifyException;
import com.ibm.team.filesystem.client.internal.utils.IPermissionUtil$PermissionUtilsException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public class HardcodedPermissionUtils
implements IPermissionUtil {
    public static final String SCRIPTS_DIR = "scripts";
    public static final int RETCODE_CANNOT_MODIFY = 1;
    public static final int RETCODE_CANNOT_CREATE = 2;
    public static final String MKFILE_CMD = "mkfile";
    public static final String MKROOT_CMD = "mkroot";
    private String mkFile = null;
    private String mkRoot = null;

    public HardcodedPermissionUtils(PlatformDetector$LauncherType platformDetector$LauncherType, Map map) {
        PlatformDetector$Platform platformDetector$Platform = PlatformDetector.getPlatform();
        IPath iPath = platformDetector$Platform.getScript(platformDetector$LauncherType, map, MKFILE_CMD);
        IPath iPath2 = platformDetector$Platform.getScript(platformDetector$LauncherType, map, MKROOT_CMD);
        File file = null;
        File file2 = null;
        if (iPath != null) {
            file = iPath.toFile();
        }
        if (iPath2 != null) {
            file2 = iPath2.toFile();
        }
        if (file != null && file.exists()) {
            try {
                this.mkFile = file.getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        if (file2 != null && file2.exists()) {
            try {
                this.mkRoot = file2.getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean run(String string, String string2) throws InterruptedException, IPermissionUtil$PermissionUtilsException {
        Process process;
        if (string == null) {
            return false;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(string, string2);
        try {
            process = processBuilder.start();
        }
        catch (IOException iOException) {
            throw (Throwable)new HardcodedPermissionUtils$FailedToRunException(this, string, string2, iOException);
        }
        int n = process.waitFor();
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                throw (Throwable)new IPermissionUtil$CannotModifyException(this, string2);
            }
            case 2: {
                throw (Throwable)new IPermissionUtil$CannotCreateException(this, string2);
            }
        }
        throw (Throwable)new HardcodedPermissionUtils$MisbehavingScriptException(this, string, string2, n);
    }

    public void mkFile(String string) throws IPermissionUtil$PermissionUtilsException, InterruptedException {
        if (!this.run(this.mkFile, string)) {
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                return;
            }
            boolean bl = false;
            try {
                bl = file.createNewFile();
            }
            catch (IOException iOException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(iOException));
                bl = false;
            }
            if (!bl) {
                throw (Throwable)new IPermissionUtil$CannotCreateException(this, string);
            }
        }
    }

    public void mkRoot(String string) throws IPermissionUtil$PermissionUtilsException, InterruptedException {
        if (!this.run(this.mkRoot, string)) {
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                return;
            }
            file.mkdirs();
        }
    }

    public String getMkRoot() {
        return this.mkRoot;
    }
}

