/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.IWorkspaceCompareReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LogicalConflictReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FileSystemView
implements IFileSystemView {
    private final IConnection connection;
    private final boolean isWorkspaceConnection;
    private final FileSystemServiceProxy fileSystemService;

    public FileSystemView(FileSystemServiceProxy fileSystemServiceProxy, IConnection iConnection) {
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iConnection instanceof IWorkspaceConnection) {
            this.isWorkspaceConnection = true;
        } else {
            this.isWorkspaceConnection = false;
            if (!(iConnection instanceof IBaselineConnection)) {
                throw (Throwable)new IllegalArgumentException();
            }
        }
        this.connection = iConnection;
        this.fileSystemService = fileSystemServiceProxy;
    }

    public IConnection connection() {
        return this.connection;
    }

    public List getBlame(IComponentHandle iComponentHandle, IFileItemHandle iFileItemHandle, IChangeSetHandle iChangeSetHandle, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        return this.fileSystemService.getBlame(this.connection, iComponentHandle, iFileItemHandle, iChangeSetHandle, null, iProgressMonitor);
    }

    public ILogicalConflictReport interpretConflicts(Collection collection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (!this.isWorkspaceConnection) {
            throw (Throwable)new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_2);
        }
        if (collection.isEmpty()) {
            LogicalConflictReport logicalConflictReport = FilesystemDTOFactory.eINSTANCE.createLogicalConflictReport();
            return (ILogicalConflictReport)logicalConflictReport;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        return this.fileSystemService.interpretConflicts((IWorkspaceConnection)this.connection, collection, null, (IProgressMonitor)subMonitor.newChild(99));
    }

    public List interpretChanges(List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        return this.fileSystemService.interpretChanges(this.connection, list, null, (IProgressMonitor)subMonitor.newChild(99));
    }

    public ILogicalConflictReport conflictReport(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (!this.isWorkspaceConnection) {
            throw (Throwable)new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_5);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IUpdateReport iUpdateReport = ((IWorkspaceConnection)this.connection).conflictReport();
        if (iUpdateReport.conflicts().isEmpty()) {
            LogicalConflictReport logicalConflictReport = FilesystemDTOFactory.eINSTANCE.createLogicalConflictReport();
            logicalConflictReport.setConflictReport(iUpdateReport);
            return (ILogicalConflictReport)logicalConflictReport;
        }
        return this.fileSystemService.conflictReport((IWorkspaceConnection)this.connection, null, (IProgressMonitor)subMonitor.newChild(99));
    }

    public IWorkspaceCompareReport compareAsWorkspaces(IWorkspaceConnection iWorkspaceConnection, int n, List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (!this.isWorkspaceConnection) {
            throw (Throwable)new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_5);
        }
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (!WorkspaceComparisonFlags.isValid((int)n)) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        return this.fileSystemService.compareAsWorkspaces((IWorkspaceConnection)this.connection, iWorkspaceConnection, n, list, (IProgressMonitor)subMonitor.newChild(99));
    }
}

