/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.common.IChangeSetSummary;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.IFilesystemService;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.IWorkspaceCompareReport;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolution;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolutionReport;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.common.internal.dto.OverlapRequest;
import com.ibm.team.filesystem.common.internal.dto.OverlapResponse;
import com.ibm.team.filesystem.common.internal.dto.Resolution;
import com.ibm.team.filesystem.common.internal.dto.SharePoint;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RemoteRepoDescriptorUtils;
import com.ibm.team.scm.client.internal.WorkspaceConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.InvalidAuthenticationTokenException;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.ISynchronizationTimes;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.dto.ComponentStateSummary;
import com.ibm.team.scm.common.internal.dto.RemoteRepoDescriptor;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.SyncTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FileSystemServiceProxy {
    private IClientLibraryContext clientLibraryContext;
    private int cachedCompatabilityLevel;
    private static final int MAX_CHANGESETS_TO_INTERPRET = 1024;

    public FileSystemServiceProxy(IClientLibraryContext iClientLibraryContext) {
        if (iClientLibraryContext == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.clientLibraryContext = iClientLibraryContext;
        this.cachedCompatabilityLevel = -1;
    }

    private IFilesystemService getServerFilesystemService() throws TeamRepositoryException {
        IFilesystemService iFilesystemService = (IFilesystemService)this.clientLibraryContext.getServiceInterface(IFilesystemService.class);
        if (iFilesystemService == null) {
            NotLoggedInException notLoggedInException = new NotLoggedInException();
            notLoggedInException.setOrigin((Object)this.clientLibraryContext.teamRepository());
            throw (Throwable)notLoggedInException;
        }
        return iFilesystemService;
    }

    public List getBlame(IConnection iConnection, IComponentHandle iComponentHandle, IFileItemHandle iFileItemHandle, IChangeSetHandle iChangeSetHandle, ISynchronizationInfo iSynchronizationInfo, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        IChangeSetHandle[] iChangeSetHandleArray;
        ThreadCheck.checkLongOpsAllowed();
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        boolean bl = iConnection instanceof IWorkspaceConnection;
        if (iComponentHandle == null && bl) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iFileItemHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            try {
                ISynchronizationTimes[] iSynchronizationTimesArray = iSynchronizationInfo == null ? null : iSynchronizationInfo.getSyncTimes();
                IRepositoryProgressMonitor iRepositoryProgressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)subMonitor);
                iChangeSetHandleArray = bl ? this.getServerFilesystemService().getBlameWS((IWorkspaceHandle)((IWorkspaceConnection)iConnection).getResolvedWorkspace(), iComponentHandle, iFileItemHandle, iChangeSetHandle, iSynchronizationTimesArray, iRepositoryProgressMonitor) : this.getServerFilesystemService().getBlame(((IBaselineConnection)iConnection).getBaseline(), iFileItemHandle, iChangeSetHandle, iSynchronizationTimesArray, iRepositoryProgressMonitor);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                throw (Throwable)this.expandItemNotFoundDetails(iConnection, itemNotFoundException);
            }
        }
        finally {
            subMonitor.done();
        }
        return Collections.unmodifiableList(Arrays.asList(iChangeSetHandleArray));
    }

    public FileAreaUpdateReport incrementalFileLoadStream(IWorkspaceConnection iWorkspaceConnection, IUpdateReport iUpdateReport, Collection collection, Collection collection2, boolean bl, int n, ISynchronizationInfo iSynchronizationInfo, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        if (iUpdateReport == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1000);
        IComponentHandle[] iComponentHandleArray = collection.toArray(new IComponentHandle[collection.size()]);
        SharePoint[] sharePointArray = collection2.toArray(new SharePoint[collection2.size()]);
        ISynchronizationTimes[] iSynchronizationTimesArray = iSynchronizationInfo == null ? null : iSynchronizationInfo.getSyncTimes();
        int n2 = this.getCompatabilityLevel(false, (IProgressMonitor)subMonitor.newChild(1));
        IRepositoryProgressMonitor iRepositoryProgressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)subMonitor);
        try {
            FileAreaUpdateReport fileAreaUpdateReport = n2 == 2 ? this.getServerFilesystemService().incrementalFileLoadStream2((IWorkspaceHandle)iWorkspaceConnection.getResolvedWorkspace(), iUpdateReport, iComponentHandleArray, sharePointArray, bl, n, iSynchronizationTimesArray, iRepositoryProgressMonitor) : this.getServerFilesystemService().incrementalFileLoadStream((IWorkspaceHandle)iWorkspaceConnection.getResolvedWorkspace(), iUpdateReport, iComponentHandleArray, sharePointArray, bl, n, iSynchronizationTimesArray, iRepositoryProgressMonitor);
            FileAreaUpdateReport fileAreaUpdateReport2 = fileAreaUpdateReport;
            return fileAreaUpdateReport2;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            throw (Throwable)this.expandItemNotFoundDetails((IConnection)iWorkspaceConnection, itemNotFoundException);
        }
        finally {
            subMonitor.done();
        }
    }

    public ILogicalConflictReport interpretConflicts(IWorkspaceConnection iWorkspaceConnection, Collection collection, ISynchronizationInfo iSynchronizationInfo, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        IItemConflictReport iItemConflictReport;
        Object object2;
        ThreadCheck.checkLongOpsAllowed();
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (Object object2 : collection) {
            if (!(object2 instanceof IItemConflictReport)) {
                throw (Throwable)new IllegalArgumentException();
            }
            iItemConflictReport = (IItemConflictReport)object2;
            if (iItemConflictReport.getComponent() != null) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        object2 = iSynchronizationInfo == null ? null : iSynchronizationInfo.getSyncTimes();
        iItemConflictReport = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)subMonitor);
        try {
            ILogicalConflictReport iLogicalConflictReport = this.getServerFilesystemService().interpretConflicts((IWorkspaceHandle)iWorkspaceConnection.getResolvedWorkspace(), collection.toArray(new IItemConflictReport[collection.size()]), object2, (IRepositoryProgressMonitor)iItemConflictReport);
            return iLogicalConflictReport;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            throw (Throwable)this.expandItemNotFoundDetails((IConnection)iWorkspaceConnection, itemNotFoundException);
        }
        finally {
            subMonitor.done();
        }
    }

    public LoadTree getFileTreeByVersionable(IConnection iConnection, IComponentHandle iComponentHandle, IVersionableHandle[] iVersionableHandleArray, int n, boolean bl, ISynchronizationInfo iSynchronizationInfo, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        IVersionableHandle[] iVersionableHandleArray2;
        ThreadCheck.checkLongOpsAllowed();
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iVersionableHandleArray == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        HashMap<UUID, IVersionableHandle[]> hashMap = new HashMap<UUID, IVersionableHandle[]>();
        IVersionableHandle[] iVersionableHandleArray3 = iVersionableHandleArray;
        int n2 = iVersionableHandleArray.length;
        int n3 = 0;
        while (n3 < n2) {
            iVersionableHandleArray2 = iVersionableHandleArray3[n3];
            if (iVersionableHandleArray2 == null) {
                throw (Throwable)new IllegalArgumentException();
            }
            hashMap.put(iVersionableHandleArray2.getItemId(), iVersionableHandleArray2);
            ++n3;
        }
        iVersionableHandleArray2 = hashMap.values().toArray(new IVersionableHandle[hashMap.size()]);
        if (n < -1 || n > 1) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1000);
        try {
            ISynchronizationTimes[] iSynchronizationTimesArray = iSynchronizationInfo == null ? null : iSynchronizationInfo.getSyncTimes();
            int n4 = this.getCompatabilityLevel(false, (IProgressMonitor)subMonitor.newChild(1));
            IRepositoryProgressMonitor iRepositoryProgressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)subMonitor);
            LoadTree loadTree = n4 == 2 ? this.getServerFilesystemService().getFileTreeByVersionable2(iConnection.getContextHandle(), iComponentHandle, iVersionableHandleArray2, n, bl, iSynchronizationTimesArray, iRepositoryProgressMonitor) : this.getServerFilesystemService().getFileTreeByVersionable(iConnection.getContextHandle(), iComponentHandle, iVersionableHandleArray2, n, bl, iSynchronizationTimesArray, iRepositoryProgressMonitor);
            LoadTree loadTree2 = loadTree;
            return loadTree2;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            throw (Throwable)this.expandItemNotFoundDetails(iConnection, itemNotFoundException);
        }
        finally {
            subMonitor.done();
        }
    }

    public List applyAccepted(IWorkspaceConnection iWorkspaceConnection, Collection collection, Collection collection2, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        ConflictResolutionReport conflictResolutionReport = null;
        List list = null;
        try {
            try {
                IRepositoryProgressMonitor iRepositoryProgressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)subMonitor.newChild(95));
                conflictResolutionReport = this.getServerFilesystemService().applyAccepted((IWorkspaceHandle)iWorkspaceConnection.getResolvedWorkspace(), collection.toArray(new ILogicalChange[collection.size()]), collection2.toArray(new ConflictResolution[collection2.size()]), null, iRepositoryProgressMonitor);
                list = this.notifyCommitsPerformed(iWorkspaceConnection, conflictResolutionReport, (IProgressMonitor)subMonitor.newChild(5));
            }
            catch (TeamRepositoryException teamRepositoryException) {
                ItemNotFoundException itemNotFoundException;
                if (teamRepositoryException.getData() instanceof ConflictResolutionReport) {
                    conflictResolutionReport = (ConflictResolutionReport)teamRepositoryException.getData();
                    this.notifyCommitsPerformed(iWorkspaceConnection, conflictResolutionReport, (IProgressMonitor)subMonitor.newChild(5));
                } else if (teamRepositoryException instanceof ItemNotFoundException) {
                    itemNotFoundException = this.expandItemNotFoundDetails((IConnection)iWorkspaceConnection, (ItemNotFoundException)((Object)teamRepositoryException));
                }
                throw (Throwable)itemNotFoundException;
            }
        }
        finally {
            subMonitor.done();
        }
        return Collections.unmodifiableList(list);
    }

    public List markAsMerged(IWorkspaceConnection iWorkspaceConnection, Collection collection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ConflictResolutionReport conflictResolutionReport = null;
        List list = null;
        try {
            try {
                IRepositoryProgressMonitor iRepositoryProgressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)subMonitor.newChild(95));
                conflictResolutionReport = this.getServerFilesystemService().markAsMerged((IWorkspaceHandle)iWorkspaceConnection.getResolvedWorkspace(), collection.toArray(new ILogicalChange[collection.size()]), null, iRepositoryProgressMonitor);
                list = this.notifyCommitsPerformed(iWorkspaceConnection, conflictResolutionReport, (IProgressMonitor)subMonitor.newChild(5));
            }
            catch (TeamRepositoryException teamRepositoryException) {
                ItemNotFoundException itemNotFoundException;
                if (teamRepositoryException.getData() instanceof ConflictResolutionReport) {
                    conflictResolutionReport = (ConflictResolutionReport)teamRepositoryException.getData();
                    this.notifyCommitsPerformed(iWorkspaceConnection, conflictResolutionReport, (IProgressMonitor)subMonitor.newChild(5));
                } else if (teamRepositoryException instanceof ItemNotFoundException) {
                    itemNotFoundException = this.expandItemNotFoundDetails((IConnection)iWorkspaceConnection, (ItemNotFoundException)((Object)teamRepositoryException));
                }
                throw (Throwable)itemNotFoundException;
            }
        }
        finally {
            subMonitor.done();
        }
        return Collections.unmodifiableList(list);
    }

    private List notifyCommitsPerformed(IWorkspaceConnection iWorkspaceConnection, ConflictResolutionReport conflictResolutionReport, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ArrayList<IUpdateReport> arrayList = new ArrayList<IUpdateReport>(conflictResolutionReport.getResolutions().size());
        ArrayList arrayList2 = new ArrayList(conflictResolutionReport.getResolutions().size());
        for (Resolution resolution : conflictResolutionReport.getResolutions()) {
            arrayList.add(resolution.getUpdateReport());
            arrayList2.addAll(resolution.getChangeSet());
        }
        ((WorkspaceConnection)iWorkspaceConnection).committedWork((List)arrayList2, arrayList.toArray(new IUpdateReport[arrayList.size()]), iProgressMonitor);
        return arrayList;
    }

    public List interpretChanges(IConnection iConnection, List list, ISynchronizationInfo iSynchronizationInfo, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)list.size());
        try {
            if (list.isEmpty()) {
                List list2 = Collections.emptyList();
                return list2;
            }
            ISynchronizationTimes[] iSynchronizationTimesArray = iSynchronizationInfo == null ? null : iSynchronizationInfo.getSyncTimes();
            IRepositoryProgressMonitor iRepositoryProgressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem(iProgressMonitor);
            IChangeSetHandle[] iChangeSetHandleArray = new IChangeSetHandle[Math.min(1024, list.size())];
            int n = 0;
            ArrayList arrayList = null;
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                if (e == null) {
                    throw (Throwable)new IllegalArgumentException();
                }
                if (!(e instanceof IChangeSetHandle)) {
                    throw (Throwable)new IllegalArgumentException();
                }
                iChangeSetHandleArray[n] = (IChangeSetHandle)e;
                if (++n != iChangeSetHandleArray.length) continue;
                IChangeSetSummary[] iChangeSetSummaryArray = this.getServerFilesystemService().interpretChanges(iConnection.getContextHandle(), iChangeSetHandleArray, iSynchronizationTimesArray, iRepositoryProgressMonitor);
                if (arrayList == null) {
                    if (!listIterator.hasNext()) {
                        List<IChangeSetSummary> list3 = Collections.unmodifiableList(Arrays.asList(iChangeSetSummaryArray));
                        return list3;
                    }
                    arrayList = new ArrayList(list.size());
                }
                arrayList.addAll(Arrays.asList(iChangeSetSummaryArray));
                subMonitor.worked(n);
                int n2 = list.size() - listIterator.nextIndex();
                if (n2 < n) {
                    iChangeSetHandleArray = new IChangeSetHandle[n2];
                }
                n = 0;
            }
            List list4 = Collections.unmodifiableList(arrayList);
            return list4;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            throw (Throwable)this.expandItemNotFoundDetails(iConnection, itemNotFoundException);
        }
        finally {
            subMonitor.done();
        }
    }

    public ILogicalConflictReport conflictReport(IWorkspaceConnection iWorkspaceConnection, ISynchronizationInfo iSynchronizationInfo, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        try {
            ISynchronizationTimes[] iSynchronizationTimesArray = iSynchronizationInfo == null ? null : iSynchronizationInfo.getSyncTimes();
            IRepositoryProgressMonitor iRepositoryProgressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)subMonitor);
            ILogicalConflictReport iLogicalConflictReport = this.getServerFilesystemService().conflictReport((IWorkspaceHandle)iWorkspaceConnection.getResolvedWorkspace(), iSynchronizationTimesArray, iRepositoryProgressMonitor);
            return iLogicalConflictReport;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            throw (Throwable)this.expandItemNotFoundDetails((IConnection)iWorkspaceConnection, itemNotFoundException);
        }
        finally {
            subMonitor.done();
        }
    }

    public List detectOverlap(List list, ISynchronizationInfo iSynchronizationInfo, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (ISynchronizationTimes[] iSynchronizationTimesArray : list) {
            if (iSynchronizationTimesArray != null) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        try {
            ISynchronizationTimes[] iSynchronizationTimesArray;
            iSynchronizationTimesArray = iSynchronizationInfo == null ? null : iSynchronizationInfo.getSyncTimes();
            IRepositoryProgressMonitor iRepositoryProgressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)subMonitor);
            OverlapRequest[] overlapRequestArray = new OverlapRequest[list.size()];
            overlapRequestArray = list.toArray(overlapRequestArray);
            OverlapResponse[] overlapResponseArray = this.getServerFilesystemService().detectOverlap(overlapRequestArray, iSynchronizationTimesArray, iRepositoryProgressMonitor);
            List<OverlapResponse> list2 = Collections.unmodifiableList(Arrays.asList(overlapResponseArray));
            return list2;
        }
        finally {
            subMonitor.done();
        }
    }

    public List getComponentStateSummaries(IConnection iConnection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iConnection instanceof IWorkspaceConnection) {
            try {
                IRepositoryProgressMonitor iRepositoryProgressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)subMonitor);
                IComponentStateSummary[] iComponentStateSummaryArray = this.getServerFilesystemService().getComponentStateSummaries(iConnection.getContextHandle(), iRepositoryProgressMonitor);
                List<IComponentStateSummary> list = Collections.unmodifiableList(Arrays.asList(iComponentStateSummaryArray));
                return list;
            }
            catch (ItemNotFoundException itemNotFoundException) {
                throw (Throwable)this.expandItemNotFoundDetails(iConnection, itemNotFoundException);
            }
            finally {
                subMonitor.done();
            }
        }
        if (iConnection instanceof IBaselineConnection) {
            IBaselineConnection iBaselineConnection = (IBaselineConnection)iConnection;
            ComponentStateSummary componentStateSummary = ScmDtoFactory.eINSTANCE.createComponentStateSummary();
            componentStateSummary.setComponent(iBaselineConnection.getComponent());
            ISyncTime iSyncTime = ISyncTime.FACTORY.getConfigTimeFor((IBaselineHandle)iBaselineConnection.getResolvedBaseline(), null);
            long l = ((SyncTime)iSyncTime).getValue();
            componentStateSummary.setConfigurationState(l);
            componentStateSummary.setChangeHistoryState(l);
            return Collections.singletonList(componentStateSummary);
        }
        throw (Throwable)new IllegalArgumentException();
    }

    private ItemNotFoundException expandItemNotFoundDetails(IConnection iConnection, ItemNotFoundException itemNotFoundException) {
        if (itemNotFoundException.getData() instanceof IItemHandle && ((IItemHandle)itemNotFoundException.getData()).sameItemId((IItemHandle)iConnection.getContextHandle())) {
            String string = null;
            if (iConnection instanceof IWorkspaceConnection) {
                string = NLS.bind((String)Messages.FileSystemServiceProxy_0, (Object)((IWorkspaceConnection)iConnection).getResolvedWorkspace().getName(), (Object[])new Object[0]);
            } else if (iConnection instanceof IBaselineConnection) {
                string = NLS.bind((String)Messages.FileSystemServiceProxy_1, (Object)((IBaselineConnection)iConnection).getResolvedBaseline().getComment(), (Object[])new Object[]{((IBaselineConnection)iConnection).getResolvedBaseline().getCreationDate()});
            }
            if (string != null) {
                ItemNotFoundException itemNotFoundException2 = new ItemNotFoundException(string, (IItemHandle)itemNotFoundException.getData());
                if (itemNotFoundException.getStackTrace() != null) {
                    itemNotFoundException2.setStackTrace(itemNotFoundException.getStackTrace());
                }
                itemNotFoundException = itemNotFoundException2;
            }
        }
        return itemNotFoundException;
    }

    public IWorkspaceCompareReport compareAsWorkspaces(IWorkspaceConnection iWorkspaceConnection, IWorkspaceConnection iWorkspaceConnection2, int n, List list, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iWorkspaceConnection2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (!WorkspaceComparisonFlags.isValid((int)n)) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        IComponentHandle[] iComponentHandleArray = null;
        for (IComponentHandle iComponentHandle : list) {
            if (iComponentHandle != null) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        iComponentHandleArray = list.toArray(new IComponentHandle[list.size()]);
        boolean bl = true;
        while (true) {
            ITeamRepository iTeamRepository;
            RemoteRepoDescriptor remoteRepoDescriptor = null;
            if (!iWorkspaceConnection.sameRepository((IConnection)iWorkspaceConnection2)) {
                iTeamRepository = iWorkspaceConnection2.teamRepository();
                remoteRepoDescriptor = RemoteRepoDescriptorUtils.getRemoteDescriptor((ITeamRepository)iTeamRepository, (IProgressMonitor)((IProgressMonitor)subMonitor.newChild(20)));
            }
            iTeamRepository = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)subMonitor);
            try {
                IWorkspaceCompareReport iWorkspaceCompareReport = this.getServerFilesystemService().compareWorkspaces((IWorkspaceHandle)iWorkspaceConnection.getResolvedWorkspace(), (IWorkspaceHandle)iWorkspaceConnection2.getResolvedWorkspace(), remoteRepoDescriptor, iComponentHandleArray, n, (IRepositoryProgressMonitor)iTeamRepository);
                subMonitor.done();
                return iWorkspaceCompareReport;
            }
            catch (ItemNotFoundException itemNotFoundException) {
                ItemNotFoundException itemNotFoundException2 = this.expandItemNotFoundDetails((IConnection)iWorkspaceConnection, itemNotFoundException);
                itemNotFoundException2 = this.expandItemNotFoundDetails((IConnection)iWorkspaceConnection2, itemNotFoundException2);
                throw (Throwable)itemNotFoundException2;
            }
            catch (InvalidAuthenticationTokenException invalidAuthenticationTokenException) {
                if (!bl) {
                    throw (Throwable)invalidAuthenticationTokenException;
                }
                bl = false;
                RemoteRepoDescriptorUtils.resetRemoteDescriptor((ITeamRepository)iWorkspaceConnection2.teamRepository());
                subMonitor.setWorkRemaining(100);
                continue;
            }
            break;
        }
    }

    int getCompatabilityLevel(boolean bl, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        if (this.cachedCompatabilityLevel < 0 || bl) {
            ThreadCheck.checkLongOpsAllowed();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
            IRepositoryProgressMonitor iRepositoryProgressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)subMonitor);
            this.cachedCompatabilityLevel = this.getServerFilesystemService().getCompatabilityLevel(iRepositoryProgressMonitor);
        }
        return this.cachedCompatabilityLevel;
    }

    public boolean serverSupportsSymbolicLinks(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        return this.getCompatabilityLevel(false, iProgressMonitor) >= 2;
    }
}

