/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemView;
import com.ibm.team.filesystem.client.internal.content.FileContentManager;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.ScmClientLibraryContext;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileSystemManager
implements IFileSystemManager {
    private final IClientLibraryContext context;
    private final FileContentManager cm;

    public FileSystemManager(IClientLibraryContext iClientLibraryContext) {
        this.context = (IClientLibraryContext)new ScmClientLibraryContext(iClientLibraryContext);
        this.cm = new FileContentManager(iClientLibraryContext);
    }

    public FileSystemServiceProxy getFileSystemService() {
        return new FileSystemServiceProxy(this.context);
    }

    public IFileSystemView getFileSystemView(IConnection iConnection) {
        return new FileSystemView(new FileSystemServiceProxy(this.context), iConnection);
    }

    public int getFileSystemServiceCompatabilityLevel(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        return this.getFileSystemService().getCompatabilityLevel(false, iProgressMonitor);
    }

    public IFileContentManager getContentManager() {
        return this.cm;
    }

    public boolean serverSupportsSymbolicLinks(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        return this.getFileSystemService().serverSupportsSymbolicLinks(iProgressMonitor);
    }
}

