/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager$RuleKind;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IFileStorageVisitor;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public final class FileStorageWrapper
implements IFileStorage {
    private final Shareable shareable;
    private final ResourceType resourceTypeHint;
    private FileStorage underlyingStorage = null;
    protected IFileStorage parent;

    public FileStorageWrapper(Shareable shareable, ResourceType resourceType) {
        this.shareable = shareable;
        this.resourceTypeHint = resourceType;
        shareable.setFileStorage(this);
        this.parent = null;
    }

    public FileStorageWrapper(Shareable shareable, IFileStorage iFileStorage, ResourceType resourceType) {
        this.shareable = shareable;
        this.resourceTypeHint = resourceType;
        this.parent = iFileStorage;
        shareable.setFileStorage(this);
    }

    public FileStorageWrapper(ISandbox iSandbox, IPath iPath, ResourceType resourceType) {
        this.shareable = new Shareable(iSandbox, iPath, resourceType);
        this.shareable.setFileStorage(this);
        this.resourceTypeHint = resourceType;
    }

    private FileStorage getUnderlyingStorage() {
        if (this.underlyingStorage == null) {
            if (this.parent == null || ((FileStorageWrapper)this.parent).underlyingStorage == null) {
                SharingManager.getInstance().resolveFileStorage(this, this.resourceTypeHint);
            } else {
                ((FileStorageWrapper)this.parent).underlyingStorage.resolveChildStorage(this, this.shareable.getLocalPath().lastSegment(), this.resourceTypeHint);
            }
        }
        return this.underlyingStorage;
    }

    public final boolean isContentChangedFrom(FileItemInfo fileItemInfo, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        subMonitor.beginTask(Messages.FileStorage_0, 100);
        if (fileItemInfo.getContentLength() != this.getSize((IProgressMonitor)subMonitor.newChild(50))) {
            subMonitor.done();
            return true;
        }
        if (fileItemInfo.getLastContentChangeCheckStamp() != -1L && fileItemInfo.getLastContentChangeCheckStamp() == this.getModificationStamp()) {
            subMonitor.done();
            return fileItemInfo.isContentChanged();
        }
        InputStream inputStream = this.getContents(true);
        try {
            ContentHash contentHash = ContentHash.valueOf((InputStream)inputStream);
            inputStream.close();
            inputStream = null;
            boolean bl = fileItemInfo.getHash().equals((Object)contentHash);
            subMonitor.done();
            boolean bl2 = !bl;
            return bl2;
        }
        catch (ContentHashAlgorithmException contentHashAlgorithmException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.FileStorage_1, (Throwable)contentHashAlgorithmException)));
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.FileStorage_1, (Throwable)iOException)));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LoggingHelper.error("com.ibm.team.filesystem.client", Messages.FileStorage_2, iOException);
                }
                catch (RuntimeException runtimeException) {
                    LoggingHelper.error("com.ibm.team.filesystem.client", Messages.FileStorage_2, runtimeException);
                }
            }
        }
    }

    public final IFileStorage getParent() {
        if (this.parent == null) {
            if (this.shareable.getLocalPath().segmentCount() < 2) {
                return null;
            }
            if (this.underlyingStorage != null) {
                this.parent = this.underlyingStorage.getParent();
            } else {
                IPath iPath = this.shareable.getLocalPath().removeLastSegments(1);
                Shareable shareable = new Shareable(this.shareable.getSandbox(), iPath, ResourceType.FOLDER);
                this.parent = shareable.getFileStorage();
            }
        }
        return this.parent;
    }

    public boolean supportsExecBit() {
        return this.getUnderlyingStorage().supportsExecBit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setExecutable(boolean bl, IProgressMonitor iProgressMonitor) {
        if (this.getUnderlyingStorage().supportsExecBit()) {
            return this.getUnderlyingStorage().setExecutable(bl, iProgressMonitor);
        }
        Shareable shareable = this.getShareable();
        ICopyFileAreaLockRequest iCopyFileAreaLockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(Collections.singleton(shareable));
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            ICopyFileAreasLock iCopyFileAreasLock = ICopyFileAreaManager.instance.lock(Collections.singleton(iCopyFileAreaLockRequest), (IProgressMonitor)subMonitor.newChild(15));
            try {
                if (shareable.getShare((IProgressMonitor)subMonitor.newChild(10)) == null) {
                    return false;
                }
                ICopyFileArea iCopyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot());
                FileItemInfo fileItemInfo = iCopyFileArea.getItemInfo(shareable.getLocalPath());
                if (fileItemInfo == null) {
                    return false;
                }
                if (bl == fileItemInfo.isExecutable()) return true;
                FileItemInfoProxy fileItemInfoProxy = new FileItemInfoProxy(fileItemInfo);
                fileItemInfoProxy.setExecutable(fileItemInfo.isOriginalExecutable(), bl);
                fileItemInfo = fileItemInfoProxy.getFileItemInfo();
                iCopyFileArea.setItemMetaData(shareable.getLocalPath(), fileItemInfo, (IProgressMonitor)subMonitor.newChild(50));
                return true;
            }
            finally {
                iCopyFileAreasLock.release((IProgressMonitor)subMonitor.newChild(25));
            }
        }
        catch (Exception exception) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(exception));
            return false;
        }
    }

    public boolean isExecutable(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (this.getUnderlyingStorage().supportsExecBit()) {
            return this.getUnderlyingStorage().isExecutable(iProgressMonitor);
        }
        FileItemInfo fileItemInfo = this.getShareable().getFileItemInfo(iProgressMonitor);
        return fileItemInfo == null ? false : fileItemInfo.isExecutable();
    }

    public boolean shouldBeIgnored(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getUnderlyingStorage().shouldBeIgnored(iProgressMonitor);
    }

    public final Shareable getShareable() {
        return this.shareable;
    }

    /*
     * Unable to fully structure code
     */
    public void accept(IFileStorageVisitor var1_1, int var2_2, IProgressMonitor var3_3) throws FileSystemClientException {
        var4_4 = SubMonitor.convert((IProgressMonitor)var3_3, (int)20);
        this.getUnderlyingStorage().lock((IProgressMonitor)var4_4.newChild(1));
        try {
            block9: {
                if (var2_2 == 0) {
                    var1_1.visit(this, (IProgressMonitor)var4_4);
lbl7:
                    // 3 sources

                    return;
                }
                if (var2_2 != 1) break block9;
                if (!var1_1.visit(this, (IProgressMonitor)var4_4.newChild(1)) || (var5_5 = this.getChildren((IProgressMonitor)var4_4.newChild(1))) == null) ** GOTO lbl7
                var4_4.setWorkRemaining(var5_5.size());
                var7_7 = var5_5.iterator();
                while (true) {
                    if (var7_7.hasNext()) ** break;
                    ** continue;
                    var6_9 = (IFileStorage)var7_7.next();
                    var6_9.accept(var1_1, 0, (IProgressMonitor)var4_4.newChild(1));
                }
            }
            var5_6 = new LinkedList<FileStorageWrapper>();
            var5_6.add(this);
            while ((var6_10 = (IFileStorage)var5_6.poll()) != null) {
                var7_8 = var1_1.visit(var6_10, (IProgressMonitor)var4_4);
                if (!var7_8 || (var8_11 = var6_10.getChildren((IProgressMonitor)var4_4.newChild(1))) == null) continue;
                var5_6.addAll(var8_11);
            }
        }
        finally {
            this.getUnderlyingStorage().unlock();
        }
    }

    public boolean requiresBackup(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getUnderlyingStorage().requiresBackup(iProgressMonitor);
    }

    public final String getName() {
        return this.shareable.getLocalPath().lastSegment();
    }

    private final ManagedFileStore getFileStore() {
        return new ManagedFileStore(this.shareable.getCopyFileAreaRoot(), this.shareable.getLocalPath(), EFS.getLocalFileSystem().getStore(this.shareable.getFullPath()));
    }

    public void create(String string, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (ManagedFileStore.supportsSymLinks()) {
            try {
                this.getFileStore().symlink(string, (IProgressMonitor)subMonitor.newChild(80));
                this.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)subMonitor.newChild(20));
            }
            catch (CoreException coreException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_7, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{string.toString()}), (Throwable)coreException)));
            }
        }
    }

    public boolean exists(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object;
        ManagedFileStore managedFileStore = this.getFileStore();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)2);
        try {
            object = managedFileStore.toLocalFile(0, (IProgressMonitor)subMonitor.newChild(1));
            if (object != null && ((File)object).exists()) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        object = SharingManager.getInstance();
        ((SharingManager)object).disableChangeMonitoring();
        try {
            IFileInfo iFileInfo = managedFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
            boolean bl = iFileInfo.getAttribute(32) || iFileInfo.exists();
            return bl;
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_0, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)coreException)));
        }
        finally {
            ((SharingManager)object).enableChangeMonitoring();
        }
    }

    public long getSize(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ManagedFileStore managedFileStore = this.getFileStore();
        SharingManager sharingManager = SharingManager.getInstance();
        sharingManager.disableChangeMonitoring();
        try {
            IFileInfo iFileInfo = managedFileStore.fetchInfo(0, iProgressMonitor);
            if (!iFileInfo.exists() || iFileInfo.isDirectory() || iFileInfo.getAttribute(32)) {
                return -1L;
            }
            long l = iFileInfo.getLength();
            return l;
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_1, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)coreException)));
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
    }

    public boolean isFile(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ManagedFileStore managedFileStore = this.getFileStore();
        SharingManager sharingManager = SharingManager.getInstance();
        sharingManager.disableChangeMonitoring();
        try {
            IFileInfo iFileInfo = managedFileStore.fetchInfo(0, iProgressMonitor);
            boolean bl = iFileInfo.exists() && !iFileInfo.isDirectory() && !iFileInfo.getAttribute(32);
            return bl;
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_2, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)coreException)));
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
    }

    public boolean isFolder(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ManagedFileStore managedFileStore = this.getFileStore();
        SharingManager sharingManager = SharingManager.getInstance();
        sharingManager.disableChangeMonitoring();
        try {
            IFileInfo iFileInfo = managedFileStore.fetchInfo(0, iProgressMonitor);
            boolean bl = iFileInfo.isDirectory() && !iFileInfo.getAttribute(32);
            return bl;
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_3, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)coreException)));
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
    }

    public final boolean isSymbolicLink(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ManagedFileStore managedFileStore = this.getFileStore();
        SharingManager sharingManager = SharingManager.getInstance();
        sharingManager.disableChangeMonitoring();
        try {
            IFileInfo iFileInfo = managedFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(100));
            boolean bl = iFileInfo.getAttribute(32);
            return bl;
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_4, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)coreException)));
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
    }

    public final ResourceType getResourceType(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ManagedFileStore managedFileStore = this.getFileStore();
        SharingManager sharingManager = SharingManager.getInstance();
        sharingManager.disableChangeMonitoring();
        try {
            IFileInfo iFileInfo = managedFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(100));
            if (iFileInfo.getAttribute(32)) {
                ResourceType resourceType = ResourceType.SYMBOLIC_LINK;
                return resourceType;
            }
            if (iFileInfo.isDirectory()) {
                ResourceType resourceType = ResourceType.FOLDER;
                return resourceType;
            }
            if (iFileInfo.exists()) {
                ResourceType resourceType = ResourceType.FILE;
                return resourceType;
            }
            return null;
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_13, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)coreException)));
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
    }

    public boolean isReadOnly(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ManagedFileStore managedFileStore = this.getFileStore();
        SharingManager sharingManager = SharingManager.getInstance();
        sharingManager.disableChangeMonitoring();
        try {
            IFileInfo iFileInfo = managedFileStore.fetchInfo(0, iProgressMonitor);
            boolean bl = iFileInfo.getAttribute(2);
            return bl;
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_5, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)coreException)));
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
    }

    public void setTarget(Shed shed, String string, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        IFileInfo iFileInfo;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        this.getParent();
        ManagedFileStore managedFileStore = this.getFileStore();
        SharingManager sharingManager = SharingManager.getInstance();
        sharingManager.disableChangeMonitoring();
        try {
            try {
                iFileInfo = managedFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (CoreException coreException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_8, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{string.toString()}), (Throwable)coreException)));
            }
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
        if (!iFileInfo.getAttribute(32)) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_11, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{string.toString()}), null)));
        }
        shed.backupIfDirty(this.shareable, (IProgressMonitor)subMonitor.newChild(9));
        try {
            managedFileStore.delete(0, (IProgressMonitor)subMonitor.newChild(35));
            managedFileStore.symlink(string, (IProgressMonitor)subMonitor.newChild(35));
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_8, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{string.toString()}), (Throwable)coreException)));
        }
        this.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)subMonitor.newChild(20));
    }

    public String getTarget(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ManagedFileStore managedFileStore = this.getFileStore();
        SharingManager sharingManager = SharingManager.getInstance();
        sharingManager.disableChangeMonitoring();
        try {
            IFileInfo iFileInfo = managedFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(10));
            if (!iFileInfo.getAttribute(32)) {
                return null;
            }
            String string = iFileInfo.getStringAttribute(64);
            return string;
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_12, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)coreException)));
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
    }

    public void backup(Shed shed, BackupDilemmaHandler backupDilemmaHandler, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        this.getUnderlyingStorage().backup(shed, backupDilemmaHandler, iProgressMonitor);
    }

    public void create(InputStream inputStream, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.getUnderlyingStorage().create(inputStream, iProgressMonitor);
    }

    public void create(boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.getUnderlyingStorage().create(bl, iProgressMonitor);
    }

    public void delete(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        IFileInfo iFileInfo;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ManagedFileStore managedFileStore = this.getFileStore();
        SharingManager sharingManager = SharingManager.getInstance();
        sharingManager.disableChangeMonitoring();
        try {
            try {
                iFileInfo = managedFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (CoreException coreException) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_9, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)coreException)));
            }
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
        if (iFileInfo.getAttribute(32)) {
            this.getUnderlyingStorage().delete((IProgressMonitor)subMonitor.newChild(99));
        } else if (iFileInfo.isDirectory()) {
            Collection collection = this.getChildren((IProgressMonitor)subMonitor.newChild(1));
            subMonitor.setWorkRemaining(collection.size() * 10 + 10);
            for (IFileStorage iFileStorage : collection) {
                iFileStorage.delete((IProgressMonitor)subMonitor.newChild(10));
            }
            this.getUnderlyingStorage().delete((IProgressMonitor)subMonitor.newChild(10));
        } else {
            this.getUnderlyingStorage().delete((IProgressMonitor)subMonitor.newChild(99));
        }
    }

    public void delete(Shed shed, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        shed.backupIfDirty(this.shareable, (IProgressMonitor)subMonitor.newChild(10));
        this.delete((IProgressMonitor)subMonitor.newChild(90));
    }

    public void deregisterRepositoryProvider(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.getUnderlyingStorage().deregisterRepositoryProvider(iProgressMonitor);
    }

    public String getActualName() {
        return this.getUnderlyingStorage().getActualName();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFileStorage getChild(String string, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ManagedFileStore managedFileStore = this.getFileStore();
        SharingManager sharingManager = SharingManager.getInstance();
        sharingManager.disableChangeMonitoring();
        try {
            void var9_14;
            Object object;
            Object object2;
            IFileInfo iFileInfo = managedFileStore.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
            if (!iFileInfo.isDirectory()) return null;
            if (iFileInfo.getAttribute(32)) {
                return null;
            }
            IFileInfo iFileInfo2 = null;
            if (this.shareable.getSandbox().isCaseSensitive()) {
                object2 = managedFileStore.getChild(string);
                iFileInfo2 = object2.fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
            } else {
                String[] stringArray;
                object2 = string.toUpperCase().toLowerCase();
                String[] stringArray2 = stringArray = managedFileStore.childNames(0, (IProgressMonitor)subMonitor.newChild(1));
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = stringArray2[n2];
                    if (((String)object).length() == ((String)object2).length() && ((String)object).toUpperCase().toLowerCase().equals(object2)) {
                        iFileInfo2 = managedFileStore.getChild((String)object).fetchInfo(0, (IProgressMonitor)subMonitor.newChild(1));
                        break;
                    }
                    ++n2;
                }
            }
            if (iFileInfo2 == null) {
                return null;
            }
            object2 = this.shareable.getLocalPath().append(iFileInfo2.getName());
            if (iFileInfo2.getAttribute(32)) {
                ResourceType resourceType = ResourceType.SYMBOLIC_LINK;
            } else {
                if (!iFileInfo2.exists()) {
                    return null;
                }
                if (iFileInfo2.isDirectory()) {
                    ResourceType resourceType = ResourceType.FOLDER;
                } else {
                    ResourceType resourceType = ResourceType.FILE;
                }
            }
            object = new Shareable(this.shareable.getSandbox(), (IPath)object2, (ResourceType)var9_14);
            FileStorageWrapper fileStorageWrapper = new FileStorageWrapper((Shareable)object, this, (ResourceType)var9_14);
            return fileStorageWrapper;
        }
        catch (CoreException coreException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_6, (Object)string, (Object[])new Object[]{this.shareable.getLocalPath().toString()}), (Throwable)coreException)));
        }
        finally {
            sharingManager.enableChangeMonitoring();
        }
    }

    public Collection getChildren(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getUnderlyingStorage().getChildren(iProgressMonitor);
    }

    public InputStream getContents() throws FileSystemClientException {
        return this.getUnderlyingStorage().getContents();
    }

    public InputStream getContents(boolean bl) throws FileSystemClientException {
        return this.getUnderlyingStorage().getContents(bl);
    }

    public IPath getIDEPath() {
        return this.getUnderlyingStorage().getIDEPath();
    }

    public long getLocalTimeStamp() {
        return this.getUnderlyingStorage().getLocalTimeStamp();
    }

    public URI getLocationURI() {
        return this.getUnderlyingStorage().getLocationURI();
    }

    public long getModificationStamp() {
        return this.getUnderlyingStorage().getModificationStamp();
    }

    public ISchedulingRule getResourceRuleForIDE(ISharingManager$RuleKind iSharingManager$RuleKind) {
        return this.getUnderlyingStorage().getResourceRuleForIDE(iSharingManager$RuleKind);
    }

    public boolean isRepositoryProviderRegistered(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getUnderlyingStorage().isRepositoryProviderRegistered(iProgressMonitor);
    }

    public void move(ISandbox iSandbox, IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (!iSandbox.equals(this.getShareable().getSandbox())) {
            throw (Throwable)new IllegalArgumentException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ResourceType resourceType = this.getResourceType((IProgressMonitor)subMonitor.newChild(1));
        if (resourceType == null) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_14, (Object)this.getShareable().getLocalPath().toOSString(), (Object[])new Object[0]), null)));
        }
        FileStorage fileStorage = this.getUnderlyingStorage();
        ResourceType resourceType2 = resourceType;
        if (resourceType == ResourceType.SYMBOLIC_LINK) {
            resourceType2 = this.getShareable().getFullPath().toFile().isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
        }
        Shareable shareable = new Shareable(iSandbox, iPath, resourceType2);
        FileStorageWrapper fileStorageWrapper = new FileStorageWrapper(shareable, resourceType2);
        SharingManager.getInstance().resolveFileStorage(fileStorageWrapper, resourceType2);
        FileStorage fileStorage2 = fileStorageWrapper.underlyingStorage;
        fileStorage.move(fileStorage2, iProgressMonitor);
    }

    public void preserveHistory(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (this.isFile((IProgressMonitor)subMonitor.newChild(1))) {
            this.getUnderlyingStorage().preserveHistory((IProgressMonitor)subMonitor.newChild(99));
        }
    }

    public void refreshCachedSubTree(int n, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.getUnderlyingStorage().refreshCachedSubTree(n, iProgressMonitor);
    }

    public void registerRepositorProvider(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.getUnderlyingStorage().registerRepositorProvider(iProgressMonitor);
    }

    public void setContents(InputStream inputStream, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.getUnderlyingStorage().setContents(inputStream, bl, iProgressMonitor);
    }

    public void setContents(InputStream inputStream, Shed shed, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        this.getUnderlyingStorage().setContents(inputStream, shed, iProgressMonitor);
    }

    public boolean storageExists(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.getUnderlyingStorage().storageExists(iProgressMonitor);
    }

    public boolean contains(ISchedulingRule iSchedulingRule) {
        return this.getUnderlyingStorage().contains(iSchedulingRule);
    }

    public boolean isConflicting(ISchedulingRule iSchedulingRule) {
        return this.getUnderlyingStorage().isConflicting(iSchedulingRule);
    }

    public Object getAdapter(Class clazz) {
        return this.getUnderlyingStorage().getAdapter(clazz);
    }

    public final void setUnderlyingStorage(FileStorage fileStorage) {
        this.underlyingStorage = fileStorage;
    }

    public boolean setWritable(boolean bl, IProgressMonitor iProgressMonitor) {
        return this.getUnderlyingStorage().setWritable(bl, iProgressMonitor);
    }
}

