/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.util.Map;

public class FileItemInfoProxy {
    private IVersionableHandle handle;
    private long lastContentChangeCheckStamp = -1L;
    private boolean contentChanged = false;
    private IFolderHandle parent;
    private String name;
    private boolean loadedWithAnotherName = false;
    private long contentLength = -1L;
    private ContentHash hash = null;
    private FileLineDelimiter lineDelimiter = null;
    private FileLineDelimiter originalLineDelimiter = null;
    private String contentType = null;
    private String originalContentType = null;
    ContentHash predecessorHintHash = null;
    long sizeInRepo = -1L;
    String encoding = null;
    ContentHash hashInRepo = null;
    long numLineDelimiters = -1L;
    private boolean originalExecutable = false;
    private boolean executable = false;

    public FileItemInfoProxy(IVersionableHandle iVersionableHandle, IFolderHandle iFolderHandle, String string, boolean bl) {
        this.handle = iVersionableHandle;
        this.parent = iFolderHandle;
        this.name = string == null || string.length() == 0 ? null : string;
        this.loadedWithAnotherName = bl;
    }

    public FileItemInfoProxy(IVersionableHandle iVersionableHandle, IFolderHandle iFolderHandle, String string) {
        this.handle = iVersionableHandle;
        this.parent = iFolderHandle;
        this.name = string == null || string.length() == 0 ? null : string;
        this.loadedWithAnotherName = false;
    }

    public FileItemInfoProxy(FileItemInfo fileItemInfo) {
        this.handle = fileItemInfo.getVersionableHandle();
        this.hashInRepo = fileItemInfo.getStoredHash();
        this.contentChanged = fileItemInfo.isContentChanged();
        this.contentLength = fileItemInfo.getContentLength();
        this.contentType = fileItemInfo.getContentType();
        this.predecessorHintHash = fileItemInfo.getStoredPredecessorHintHash();
        this.encoding = fileItemInfo.getStoredEncoding();
        this.executable = fileItemInfo.isExecutable();
        this.hash = fileItemInfo.getHash();
        this.lastContentChangeCheckStamp = fileItemInfo.getLastContentChangeCheckStamp();
        this.lineDelimiter = fileItemInfo.getLineDelimiter();
        this.loadedWithAnotherName = fileItemInfo.isLoadedWithAnotherName();
        this.name = fileItemInfo.getName();
        this.numLineDelimiters = fileItemInfo.getStoredNumLineDelimiters();
        this.originalContentType = fileItemInfo.getOriginalContentType();
        this.originalExecutable = fileItemInfo.isOriginalExecutable();
        this.originalLineDelimiter = fileItemInfo.getOriginalLineDelimiter();
        this.parent = fileItemInfo.getParent();
        this.sizeInRepo = fileItemInfo.getStoredSize();
    }

    public FileItemInfo getFileItemInfo() {
        if (this.handle instanceof IFolderHandle) {
            return new FileItemInfo((IFolderHandle)this.handle, this.parent, this.name, this.loadedWithAnotherName);
        }
        if (this.handle instanceof ISymbolicLinkHandle) {
            return new FileItemInfo((ISymbolicLinkHandle)this.handle, !this.hash.equals((Object)this.hashInRepo), this.parent, this.name, this.loadedWithAnotherName, this.hash, this.hashInRepo);
        }
        return new FileItemInfo(this.handle, this.contentChanged, this.lastContentChangeCheckStamp, this.parent, this.name, this.loadedWithAnotherName, this.hash, this.contentLength, this.originalLineDelimiter, this.lineDelimiter, this.originalContentType, this.contentType, this.predecessorHintHash, this.sizeInRepo, this.encoding, this.hashInRepo, this.numLineDelimiters, this.executable, this.originalExecutable);
    }

    public void setContentInfo(long l, ContentHash contentHash, long l2, FileContent fileContent) {
        this.contentChanged = false;
        this.lastContentChangeCheckStamp = l;
        this.hash = contentHash;
        this.contentLength = l2;
        this.originalLineDelimiter = fileContent.getLineDelimiter();
        this.lineDelimiter = fileContent.getLineDelimiter();
        this.predecessorHintHash = fileContent.getPredecessorHintHash();
        this.sizeInRepo = fileContent.getSize();
        this.encoding = fileContent.getCharacterEncoding();
        this.hashInRepo = fileContent.getHash();
        this.numLineDelimiters = fileContent.getLineDelimiterCount();
    }

    public void setContentChanged(boolean bl, long l) {
        this.contentChanged = bl;
        this.lastContentChangeCheckStamp = l;
    }

    public void setProperties(IVersionable iVersionable) {
        if (iVersionable instanceof IFileItem) {
            IFileItem iFileItem = (IFileItem)iVersionable;
            this.originalExecutable = iFileItem.isExecutable();
            this.executable = iFileItem.isExecutable();
            this.originalContentType = iFileItem.getContentType();
            this.contentType = iFileItem.getContentType();
        }
    }

    public void setProperties(Map map) {
        this.originalContentType = (String)map.get("contentType");
        this.contentType = (String)map.get("contentType");
    }

    public void setExecutable(boolean bl, boolean bl2) {
        this.originalExecutable = bl;
        this.executable = bl2;
    }

    public void setItemState(IVersionableHandle iVersionableHandle) {
        this.handle = iVersionableHandle;
    }

    public void changeIdentity(IFolderHandle iFolderHandle, String string) {
        this.parent = iFolderHandle;
        this.name = string;
    }

    public void changeProperties(boolean bl, long l, FileLineDelimiter fileLineDelimiter, String string, boolean bl2) {
        this.contentChanged = bl;
        this.lastContentChangeCheckStamp = l;
        this.lineDelimiter = fileLineDelimiter;
        this.contentType = string;
        this.executable = bl2;
    }

    public void setTarget(long l, String string) throws TeamRepositoryException {
        this.lastContentChangeCheckStamp = l;
        this.hashInRepo = this.hash = FileItemInfoProxy.getLinkTargetHash(string);
    }

    public static ContentHash getLinkTargetHash(String string) throws TeamRepositoryException {
        try {
            return LocalChangeTracker.getLinkHash(string);
        }
        catch (ContentHashAlgorithmException contentHashAlgorithmException) {
            throw (Throwable)new TeamRepositoryException(NLS.bind((String)Messages.FileItemInfoProxy_0, (Object)string, (Object[])new Object[0]), (Throwable)contentHashAlgorithmException);
        }
        catch (IOException iOException) {
            throw (Throwable)new TeamRepositoryException((Throwable)iOException);
        }
    }
}

