/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.DiskBackedMapManager$AsyncSaveJob;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ICorruptible;
import com.ibm.team.filesystem.client.internal.LockableMap;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public abstract class DiskBackedMapManager {
    protected ReadWriteLock lock;
    protected Map inUse;
    protected DiskBackedMapManager$AsyncSaveJob saveJob;
    protected Set lockedExclusively = new HashSet();
    protected final ICorruptible corruptible;

    public DiskBackedMapManager(ReadWriteLock readWriteLock, PersistentBusyFlag persistentBusyFlag, ICorruptible iCorruptible) {
        this.lock = readWriteLock;
        this.inUse = new HashMap();
        this.saveJob = new DiskBackedMapManager$AsyncSaveJob(this, persistentBusyFlag);
        this.corruptible = iCorruptible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockableMap loadMap(IPath iPath, boolean bl, IPath iPath2) throws FileSystemClientException {
        this.lock.acquireRead();
        boolean bl2 = false;
        try {
            LockableMap lockableMap;
            Map map = this.inUse;
            synchronized (map) {
                lockableMap = (LockableMap)this.inUse.get(iPath);
                try {
                    if (lockableMap == null) {
                        lockableMap = this.getLockableMap(iPath, iPath2);
                        this.inUse.put(iPath, lockableMap);
                        if (bl) {
                            this.setBusy();
                            this.lockedExclusively.add(iPath);
                        }
                    }
                }
                catch (DBHMException dBHMException) {
                    this.corruptible.setCorrupt(true, "Failure during load", dBHMException.getCause());
                    throw (Throwable)dBHMException;
                }
                catch (Exception exception) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.DiskBackedMapManager_1, (Throwable)exception)));
                }
            }
            DiskBackedMapManager$AsyncSaveJob.access$0(this.saveJob, iPath);
            lockableMap.acquire(bl);
            bl2 = true;
            LockableMap lockableMap2 = lockableMap;
            return lockableMap2;
        }
        finally {
            if (!bl2) {
                this.lock.release();
            }
        }
    }

    private void setBusy() {
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", -1, "Exception setting busy flag", null);
        this.saveJob.busyFlag.setBusy(multiStatus);
        if (!multiStatus.isOK()) {
            LoggingHelper.log((IStatus)multiStatus);
        }
    }

    public void releaseMap(LockableMap lockableMap) throws FileSystemClientException {
        if (lockableMap.release()) {
            this.saveJob.requestSave(lockableMap.getPath());
        }
        this.lock.release();
    }

    public void closeAll() throws FileSystemClientException {
        Assert.isTrue((this.lock.threadWrites() > 0 ? 1 : 0) != 0);
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, "Errors happening while saving map", null);
        Iterator iterator = this.inUse.values().iterator();
        while (iterator.hasNext()) {
            LockableMap lockableMap = (LockableMap)iterator.next();
            try {
                iterator.remove();
                lockableMap.close();
            }
            catch (DBHMException dBHMException) {
                this.corruptible.setCorrupt(true, "Failure during closeAll()", dBHMException.getCause());
                multiStatus.add(FileSystemStatus.getStatusFor(4, this.errorClosing(lockableMap), dBHMException.getCause()));
            }
            catch (IOException iOException) {
                multiStatus.add(FileSystemStatus.getStatusFor(4, this.errorClosing(lockableMap), (Throwable)iOException));
            }
        }
        this.lockedExclusively.clear();
        this.saveJob.busyFlag.setComplete(multiStatus);
        if (!multiStatus.isOK()) {
            throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
        }
    }

    private String errorClosing(LockableMap lockableMap) {
        return NLS.bind((String)"Error closing {0}", (Object)lockableMap.getPath(), (Object[])new Object[0]);
    }

    protected abstract LockableMap getLockableMap(IPath var1, IPath var2);
}

