/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.DiskBackedMapManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LockableMap;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class DiskBackedMapManager$AsyncSaveJob
extends Job {
    private static final int SAVE_THRESHOLD = 1024;
    private static final int SCHEDULING_DELAY = 200;
    private Collection toSave;
    private volatile long latestRequest;
    protected PersistentBusyFlag busyFlag;
    final /* synthetic */ DiskBackedMapManager this$0;

    public DiskBackedMapManager$AsyncSaveJob(DiskBackedMapManager diskBackedMapManager, PersistentBusyFlag persistentBusyFlag) {
        this.this$0 = diskBackedMapManager;
        super("Saving metadata maps");
        this.toSave = new LinkedHashSet();
        this.setUser(false);
        this.setSystem(true);
        this.busyFlag = persistentBusyFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSave(IPath iPath) {
        Collection collection = this.toSave;
        synchronized (collection) {
            this.toSave.add(iPath);
        }
        this.latestRequest = System.currentTimeMillis();
        this.schedule(200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSave(IPath iPath) {
        Collection collection = this.toSave;
        synchronized (collection) {
            this.toSave.remove(iPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        if (System.currentTimeMillis() - this.latestRequest < 200L) {
            boolean bl;
            Collection collection = this.toSave;
            synchronized (collection) {
                bl = this.toSave.size() > 1024;
            }
            if (!bl) {
                this.schedule(200L);
                return Status.CANCEL_STATUS;
            }
        }
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, "Errors happened while saving map", null);
        this.this$0.lock.acquireWrite();
        try {
            IPath iPath;
            if (!this.busyFlag.isBusy() && !this.this$0.lockedExclusively.isEmpty()) {
                multiStatus.add((IStatus)new FileSystemStatus(NLS.bind((String)"Expected busyFlag to be set: {0}", (Object)this.busyFlag, (Object[])new Object[0])));
            }
            boolean bl = false;
            while ((iPath = this.getNext()) != null) {
                LockableMap lockableMap = (LockableMap)this.this$0.inUse.remove(iPath);
                this.this$0.lockedExclusively.remove(iPath);
                if (lockableMap == null) continue;
                try {
                    lockableMap.close();
                    bl = true;
                }
                catch (DBHMException dBHMException) {
                    this.this$0.corruptible.setCorrupt(true, "close() failed", dBHMException.getCause());
                    multiStatus.add(FileSystemStatus.getStatusFor(4, NLS.bind((String)"Error closing {0}", (Object)iPath, (Object[])new Object[0]), dBHMException.getCause()));
                }
                catch (IOException iOException) {
                    multiStatus.add(FileSystemStatus.getStatusFor(4, NLS.bind((String)"Error closing {0}", (Object)iPath, (Object[])new Object[0]), (Throwable)iOException));
                }
            }
            if (this.this$0.lockedExclusively.isEmpty() && (bl || !multiStatus.isOK())) {
                this.busyFlag.setComplete(multiStatus);
            }
        }
        finally {
            this.this$0.lock.release();
        }
        return (IStatus)multiStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPath getNext() {
        Collection collection = this.toSave;
        synchronized (collection) {
            block4: {
                if (!this.toSave.isEmpty()) break block4;
                return null;
            }
            Iterator iterator = this.toSave.iterator();
            IPath iPath = (IPath)iterator.next();
            iterator.remove();
            return iPath;
        }
    }

    static /* synthetic */ void access$0(DiskBackedMapManager$AsyncSaveJob diskBackedMapManager$AsyncSaveJob, IPath iPath) {
        diskBackedMapManager$AsyncSaveJob.cancelSave(iPath);
    }
}

