/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileContentInputStreamProvider;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Date;

public class ClientFileStateFactory {
    public static FileState create(ITeamRepository repo, IItemType type, IVersionable item) {
        if (item == null) {
            return FileState.getDeletedState((IItemType)type, null);
        }
        if (item instanceof IFileItem) {
            IFileItem fileItem = (IFileItem)item;
            return ClientFileStateFactory.getFileState(repo, fileItem);
        }
        if (item instanceof IFolder) {
            return FileState.create((VersionablePathSegment)VersionablePathSegment.pathFor((IVersionable)item), (Date)item.modified(), (boolean)false, (StateId)StateId.forItem((IItem)item));
        }
        if (item instanceof ISymbolicLink) {
            return ClientFileStateFactory.getSymbolicLinkState(repo, (ISymbolicLink)item);
        }
        return FileState.getDeletedState((IItemType)type, (VersionablePathSegment)VersionablePathSegment.pathFor((IVersionable)item));
    }

    private static FileState getFileState(ITeamRepository repo, IFileItem item) {
        IFileContent content = item.getContent();
        String mimeType = item.getContentType();
        FileLineDelimiter delimiter = content.getLineDelimiter();
        boolean isText = FileState.isTextType((String)mimeType);
        FileContentInputStreamProvider inputStreamProvider = new FileContentInputStreamProvider(repo, (IFileItemHandle)item, content);
        return FileState.create((VersionablePathSegment)VersionablePathSegment.pathFor((IVersionable)item), (Date)item.getFileTimestamp(), (IInputStreamProvider)inputStreamProvider, (boolean)item.isExecutable(), (String)mimeType, (FileLineDelimiter)delimiter, (boolean)isText, (String)content.getCharacterEncoding(), (boolean)false, (StateId)StateId.forItem((IItem)item));
    }

    private static FileState getSymbolicLinkState(ITeamRepository repo, ISymbolicLink item) {
        return FileState.create((VersionablePathSegment)VersionablePathSegment.pathFor((IVersionable)item), (Date)item.modified(), (boolean)false, (StateId)StateId.forItem((IItem)item), (String)item.getTarget());
    }
}

