/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingOutputStream;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ChangeTrackingOutputStream
extends DigestComputingOutputStream {
    final ContentHash targetHash;
    final IFileItemHandle handle;
    private final Share share;
    final ManagedFileStore managed;
    final long targetSize;
    boolean closed = false;

    public ChangeTrackingOutputStream(MessageDigest messageDigest, OutputStream outputStream, ManagedFileStore managedFileStore, IFileItemHandle iFileItemHandle, Share share, ContentHash contentHash, long l) {
        super(messageDigest, outputStream);
        this.managed = managedFileStore;
        this.handle = iFileItemHandle;
        this.share = share;
        this.targetHash = contentHash;
        this.targetSize = l;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        ISharingDescriptor iSharingDescriptor = this.share.getSharingDescriptor();
        try {
            AbstractLock abstractLock = CFALockUtil.lockExistingForUpdate(this.share.getCopyFileAreaPath(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent(), null);
            if (abstractLock == null) {
                return;
            }
            try {
                ICopyFileArea iCopyFileArea = CopyFileAreaManager.instance.getExistingCopyFileArea(this.share.getCopyFileAreaPath());
                IPath iPath = ((CopyFileAreaStore)((Object)iCopyFileArea)).getLocalPathFor((IVersionableHandle)this.handle, this.share.getSharingDescriptor().getComponent(), this.share.getSharingDescriptor().getConnectionHandle(), null);
                if (iPath != null) {
                    ContentHash contentHash;
                    boolean bl;
                    FileItemInfo fileItemInfo = ((CopyFileAreaStore)((Object)iCopyFileArea)).getItemInfo(iPath);
                    Assert.isTrue((boolean)fileItemInfo.getVersionableHandle().sameItemId((IItemHandle)this.handle));
                    if (this.targetSize == this.getContentSize()) {
                        this.managed.addDatelessItem((IVersionableHandle)this.handle, this.share.getSharingDescriptor().getComponent(), this.share.getSharingDescriptor().getConnectionHandle());
                    }
                    boolean bl2 = bl = !(contentHash = ContentHash.valueOf((byte[])this.getFinalDigest())).equals((Object)this.targetHash) || this.targetSize != this.getContentSize();
                    if (bl != fileItemInfo.isContentChanged()) {
                        long l = this.share.getShareable(iPath, ResourceType.FILE).getFileStorage().getModificationStamp();
                        ((CopyFileAreaStore)((Object)iCopyFileArea)).setItemInfo(iPath, new FileItemInfo(fileItemInfo.getVersionableHandle(), bl, l, fileItemInfo.getParent(), fileItemInfo.getName(), fileItemInfo.isLoadedWithAnotherName(), fileItemInfo.getHash(), fileItemInfo.getContentLength(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getLineDelimiter(), fileItemInfo.getOriginalContentType(), fileItemInfo.getContentType(), fileItemInfo.getStoredPredecessorHintHash(), fileItemInfo.getStoredSize(), fileItemInfo.getStoredEncoding(), fileItemInfo.getStoredHash(), fileItemInfo.getStoredNumLineDelimiters(), fileItemInfo.isExecutable(), fileItemInfo.isOriginalExecutable()), null);
                    }
                }
            }
            finally {
                CFALockUtil.endBatching(abstractLock, null);
            }
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.client", "Error aquiring path for shareable", (Throwable)((Object)fileSystemClientException)));
            return;
        }
    }

    public void finalize() throws IOException {
        if (!this.closed) {
            this.close();
            LoggingHelper.log(new FileSystemStatus("Stream finalized without beind close()ed"));
        }
    }
}

