/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ICorruptible;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AsyncSavePDBHMJob
extends Job {
    private static final int SCHEDULING_DELAY = 200;
    private volatile long latestRequest;
    private Object lockObj;
    private final PersistentBusyFlag busyFlag;
    private final ICorruptible corruptible;

    public AsyncSavePDBHMJob(String string, PersistentBusyFlag persistentBusyFlag, Object object, ICorruptible iCorruptible) {
        super(string);
        this.setUser(false);
        this.setSystem(true);
        this.lockObj = object;
        this.busyFlag = persistentBusyFlag;
        this.corruptible = iCorruptible;
    }

    public void requestSave() {
        this.latestRequest = System.currentTimeMillis();
        this.schedule(200L);
    }

    protected abstract PersistentDiskBackedHashMap getMapToPesist();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        if (System.currentTimeMillis() - this.latestRequest < 200L) {
            this.schedule(200L);
            return Status.CANCEL_STATUS;
        }
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.AsyncSavePDBHMJob_0, null);
        Object object = this.lockObj;
        synchronized (object) {
            PersistentDiskBackedHashMap persistentDiskBackedHashMap = this.getMapToPesist();
            try {
                if (persistentDiskBackedHashMap != null) {
                    persistentDiskBackedHashMap.persist();
                    this.busyFlag.setComplete(multiStatus);
                }
            }
            catch (DBHMException dBHMException) {
                this.corruptible.setCorrupt(true, "Save failed", dBHMException.getCause());
                multiStatus.add(FileSystemStatus.getStatusFor(4, Messages.AsyncSavePDBHMJob_1, dBHMException.getCause()));
            }
            catch (IOException iOException) {
                multiStatus.add(FileSystemStatus.getStatusFor(4, Messages.AsyncSavePDBHMJob_2, (Throwable)iOException));
            }
        }
        return (IStatus)multiStatus;
    }
}

