/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore$UserConfigDir;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.repository.client.ITeamRepository;
import java.io.File;
import java.util.Map;

public class FileSystemCore {
    public static final String HOME_CONFIG_DIRECTORY = ".jazz-scm";
    public static final String LOCAL_APP_DATA = "LOCALAPPDATA";
    public static final String SCM_CONFIG_DIRECTORY = "SCM_CONFIG_DIRECTORY";
    public static final String SCM_DIRECTORY = "jazz-scm";
    public static final String ID = "com.ibm.team.filesystem.client";
    public static final String USER_DIR = String.valueOf(System.getProperty("user.home")) + File.separator + ".jazz-scm";
    private static boolean isShutDown = false;

    public static FileSystemCore$UserConfigDir getUserConfigDir() {
        return FileSystemCore.getUserConfigDir(System.getenv());
    }

    public static FileSystemCore$UserConfigDir getUserConfigDir(Map map) {
        String string = null;
        boolean bl = false;
        String string2 = (String)map.get(LOCAL_APP_DATA);
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            string = String.valueOf(string2) + File.separator + SCM_DIRECTORY;
            bl = true;
        }
        if ((string2 = (String)map.get(SCM_CONFIG_DIRECTORY)) != null && (string2 = string2.trim()).length() > 0) {
            string = string2;
            bl = false;
        }
        if (string == null) {
            string = String.valueOf(System.getProperty("user.home")) + File.separator + HOME_CONFIG_DIRECTORY;
            bl = false;
        }
        return new FileSystemCore$UserConfigDir(string, bl);
    }

    public static ISharingManager getSharingManager() {
        return SharingManager.getInstance();
    }

    public static IFileSystemManager getFileSystemManager(ITeamRepository iTeamRepository) {
        if (iTeamRepository == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        return (IFileSystemManager)iTeamRepository.getClientLibrary(IFileSystemManager.class);
    }

    public static IFileContentManager getContentManager(ITeamRepository iTeamRepository) {
        return FileSystemCore.getFileSystemManager(iTeamRepository).getContentManager();
    }

    public static void startUp() {
        isShutDown = false;
    }

    public static void shutDown() throws FileSystemClientException {
        isShutDown = true;
        SharingManager.conditionalShutDown();
        ICopyFileAreaManager.instance.shutdown(null);
    }

    public static boolean isShutDown() {
        return isShutDown;
    }

    private FileSystemCore() {
    }
}

