/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.InternalPreferencesUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchPath {
    private static final String ATTR_PATH = "path";
    private static final String ATTR_ITEMID = "itemid";
    private static final String ATTR_PARENTID = "parent";
    private static final String ATTR_VERSIONABLE = "versionable";
    private IPath estimatedFilePath;
    private VersionablePath versionablePath;

    public PatchPath(VersionablePath path) {
        this(path.toPath(), path);
    }

    public PatchPath(IPath path, VersionablePath versionablePath) {
        this.estimatedFilePath = path;
        this.versionablePath = versionablePath;
    }

    public IPath getEstimatedFilePath() {
        return this.estimatedFilePath;
    }

    public SiloedItemId<IVersionable> getSiloedItemId() {
        return SiloedItemId.create(this.getItemId(), this.getComponent());
    }

    public ItemId<IVersionable> getItemId() {
        return this.versionablePath.getItemId();
    }

    public ItemId<IComponent> getComponent() {
        return this.versionablePath.getSiloedItemId().getComponent();
    }

    public IResource getResource(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IResource resource = CoreShareablesUtil.getResourceFor(this.versionablePath, (IProgressMonitor)progress);
        if (resource != null) {
            return resource;
        }
        return ResourceUtil.getResource(this.estimatedFilePath);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.estimatedFilePath == null ? 0 : this.estimatedFilePath.hashCode());
        result = 31 * result + (this.versionablePath == null ? 0 : this.versionablePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatchPath other = (PatchPath)obj;
        if (this.estimatedFilePath == null ? other.estimatedFilePath != null : !this.estimatedFilePath.equals((Object)other.estimatedFilePath)) {
            return false;
        }
        return !(this.versionablePath == null ? other.versionablePath != null : !this.versionablePath.equals((Object)other.versionablePath));
    }

    public static PatchPath load(Preferences br) throws CoreException {
        Path originalPath = new Path(br.get(ATTR_PATH, ""));
        VersionablePath versionablePath = InternalPreferencesUtil.getVersionablePath(br);
        return new PatchPath((IPath)originalPath, versionablePath);
    }

    public static VersionablePath loadVersionablePath(Preferences br) throws CoreException {
        return InternalPreferencesUtil.getVersionablePath(br);
    }

    public void save(Preferences bw) {
        bw.put(ATTR_PATH, this.estimatedFilePath.toString());
        InternalPreferencesUtil.putVersionablePath(bw, this.versionablePath);
    }

    public static void saveVersionablePath(Preferences bw, VersionablePath path) {
        InternalPreferencesUtil.putVersionablePath(bw, path);
    }

    public VersionablePath getVersionablePath() {
        return this.versionablePath;
    }

    public static PatchPath createFrom(IPath ipath, IProgressMonitor monitor) throws FileSystemClientException {
        IResource resource = ResourceUtil.getResource(ipath);
        VersionablePath vp = CoreShareablesUtil.getPathTo(resource, false, monitor);
        return new PatchPath(ipath, vp);
    }

    public static PatchPath createFrom(IPath estimatedPath, VersionablePath vp) {
        return new PatchPath(estimatedPath, vp);
    }
}

