/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.patches;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.JobRealm;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.patches.MovableResource;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedPatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.PatchResult;
import com.ibm.team.filesystem.rcp.core.patches.LocalFileOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchedFile;
import com.ibm.team.filesystem.rcp.core.patches.PendingContentChange;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.core.preferences.PreferencesUtil;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IChangeSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchModel {
    private WritableSet patches;
    private static PatchModel instance;

    public static PatchModel getDefault() {
        if (instance == null) {
            JobRealm realm = new JobRealm(Messages.PatchModel_JobName);
            instance = new PatchModel(realm);
        }
        return instance;
    }

    public static boolean modelExists() {
        return instance != null;
    }

    public Realm getRealm() {
        return this.patches.getRealm();
    }

    public PatchModel(Realm realm) {
        this.patches = new WritableSet(realm);
    }

    public IObservableSet getPatches() {
        return this.patches;
    }

    public final PendingContentChange addPatchResult(PatchResult result, String patchName) {
        PendingContentChange change = new PendingContentChange(this.getRealm(), patchName);
        change.addResult(result);
        this.addPatch(change);
        return change;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PendingContentChange> syncAddPatch(List<ParsedPatch> patches, IProgressMonitor monitor) {
        final ArrayList<PendingContentChange> contentChanges = new ArrayList<PendingContentChange>();
        final Object mutex = new Object();
        for (ParsedPatch next : patches) {
            final boolean[] listenerRan = new boolean[1];
            this.addPatch(next, "", new IChangeListener<PatchModel, PendingContentChange>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void changed(PatchModel source, PendingContentChange property) {
                    Object object = mutex;
                    synchronized (object) {
                        if (property != null) {
                            contentChanges.add(property);
                        }
                        listenerRan[0] = true;
                        mutex.notifyAll();
                    }
                }
            });
            Object object = mutex;
            synchronized (object) {
                if (!listenerRan[0]) {
                    try {
                        mutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return contentChanges;
    }

    public void addPatch(ParsedPatch newPatch, final String changeDescription, final IChangeListener<PatchModel, PendingContentChange> resultListener) {
        final ParsedPatch patch = newPatch.copy();
        Job addPatchJob = new Job(Messages.PatchModel_1){

            protected IStatus run(IProgressMonitor monitor) {
                ParsedPatch mergedPatch;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                progress.setWorkRemaining(100);
                try {
                    mergedPatch = patch.resolveHunks((IProgressMonitor)progress.newChild(100));
                }
                catch (TeamRepositoryException e) {
                    this.fireNullEvent((IChangeListener<PatchModel, PendingContentChange>)resultListener);
                    return StatusUtil.newStatus(PatchModel.class, (Throwable)e);
                }
                catch (IOException e) {
                    this.fireNullEvent((IChangeListener<PatchModel, PendingContentChange>)resultListener);
                    return StatusUtil.newStatus(PatchModel.class, (Throwable)e);
                }
                catch (FileSystemClientException e) {
                    this.fireNullEvent((IChangeListener<PatchModel, PendingContentChange>)resultListener);
                    return StatusUtil.newStatus(PatchModel.class, (Throwable)e);
                }
                PatchModel.this.getRealm().asyncExec(new Runnable(){

                    public void run() {
                        PatchModel.this.addToPendingPatches(changeDescription, mergedPatch, (IChangeListener<PatchModel, PendingContentChange>)resultListener);
                        mergedPatch.dispose();
                    }
                });
                return Status.OK_STATUS;
            }

            private void fireNullEvent(final IChangeListener<PatchModel, PendingContentChange> resultListener2) {
                PatchModel.this.getRealm().asyncExec(new Runnable(){

                    public void run() {
                        resultListener2.changed((Object)PatchModel.this, null);
                    }
                });
            }
        };
        addPatchJob.setUser(true);
        addPatchJob.schedule();
    }

    private static String getCommentForChangeSet(ParsedPatch patch) {
        String truncatedComment = patch.getDescription().getComment();
        return PatchModel.truncateComment(truncatedComment);
    }

    private static String truncateComment(String originalComment) {
        long maxLength = IChangeSet.ITEM_TYPE.getMaxSize(IChangeSet.COMMENT_PROPERTY);
        if ((long)originalComment.length() > maxLength) {
            originalComment = originalComment.substring(0, (int)maxLength);
        }
        return originalComment;
    }

    private void addToPendingPatches(String defaultDescription, ParsedPatch mergedPatch, final IChangeListener<PatchModel, PendingContentChange> resultListener) {
        PatchModel model = this;
        Realm realm = model.getRealm();
        String description = PatchModel.getCommentForChangeSet(mergedPatch);
        if (description.equals("")) {
            description = defaultDescription;
        }
        String finalDescription = description;
        final PendingContentChange contentChange = new PendingContentChange(realm, finalDescription);
        ArrayList<LocalFileOp> toVerify = new ArrayList<LocalFileOp>();
        Set<ParsedFilePatch> filePatches = mergedPatch.getFilePatchSet();
        contentChange.addWorkItems(mergedPatch.getDescription().getWorkItems());
        for (ParsedFilePatch pfp : filePatches) {
            VersionablePath path = pfp.getVersionablePath();
            PatchedFile file = contentChange.getFile(path);
            if (file == null) {
                file = new PatchedFile(realm, contentChange, path);
                contentChange.addFile(file);
            }
            try {
                List<PatchOp> ops = pfp.getAllOps(null);
                for (PatchOp patchOp : ops) {
                    LocalFileOp op = new LocalFileOp(file, patchOp);
                    file.addOp(op);
                    toVerify.add(op);
                }
            }
            catch (CoreException e) {
                StatusUtil.log(PatchModel.class, (Throwable)e);
            }
        }
        model.addPatch(contentChange);
        IChangeListener verifyFinishedListener = new IChangeListener(){

            public void changed(Object source, Object property) {
                if (resultListener != null) {
                    resultListener.changed((Object)PatchModel.this, (Object)contentChange);
                }
            }
        };
        this.verifyHunks(toVerify, (IChangeListener<PatchModel, List<LocalFileOp>>)verifyFinishedListener);
    }

    public void verifyHunks(final List<LocalFileOp> toVerify, final IChangeListener<PatchModel, List<LocalFileOp>> resultListener) {
        Job verifyJob = new Job(Messages.PatchModel_0){

            protected IStatus run(IProgressMonitor monitor) {
                PatchModel model = PatchModel.this;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                HashMap fileOps = new HashMap();
                for (LocalFileOp next : toVerify) {
                    CollectionUtil.addToMapOfLists(fileOps, (Object)next.getFile(), (Object)next);
                }
                final HashMap<LocalFileOp, IStatus> resultSet = new HashMap<LocalFileOp, IStatus>();
                progress.setWorkRemaining(fileOps.size() + toVerify.size());
                for (Map.Entry nextEntry : fileOps.entrySet()) {
                    try {
                        MovableResource mr = MovableResource.create(((PatchedFile)nextEntry.getKey()).getVersionablePath(), (IProgressMonitor)progress.newChild(1));
                        for (LocalFileOp nextOp : (List)nextEntry.getValue()) {
                            IStatus status = nextOp.getOp().verify(mr, (IProgressMonitor)progress.newChild(1));
                            resultSet.put(nextOp, status);
                        }
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log(PatchModel.class, (Throwable)e);
                    }
                    catch (FileSystemClientException e) {
                        StatusUtil.log(PatchModel.class, (Throwable)e);
                    }
                    catch (Exception e) {
                        StatusUtil.log(PatchModel.class, (Throwable)e);
                    }
                }
                model.getRealm().asyncExec(new Runnable(){

                    public void run() {
                        for (LocalFileOp next : resultSet.keySet()) {
                            next.setStatus((IStatus)resultSet.get(next));
                        }
                        resultListener.changed((Object)PatchModel.this, (Object)toVerify);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        verifyJob.setUser(false);
        verifyJob.schedule();
    }

    public void addPatch(PendingContentChange contentChange) {
        this.patches.add((Object)contentChange);
    }

    public void removePatch(PendingContentChange contentChange) {
        this.patches.remove((Object)contentChange);
        contentChange.dispose();
    }

    public void removeHunk(LocalFileOp toRemove) {
        PatchedFile file = toRemove.getFile();
        file.removeOp(toRemove);
        if (file.getOps().isEmpty()) {
            this.removeFile(file);
        }
    }

    public void removeFile(PatchedFile file) {
        PendingContentChange contentChange = file.getPatch();
        contentChange.removeFile(file);
        if (contentChange.getPatchedDirectories().isEmpty()) {
            this.removePatch(contentChange);
        }
    }

    public void load(SerializationContext context, IProgressMonitor monitor) throws CoreException {
        String[] children;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        Preferences prefs = context.getPrefs();
        try {
            children = prefs.childrenNames();
        }
        catch (BackingStoreException e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        progress.setWorkRemaining(children.length);
        final ArrayList<PendingContentChange> changes = new ArrayList<PendingContentChange>();
        int i = 0;
        while (i < children.length) {
            String next = children[i];
            Preferences nextPrefs = prefs.node(next);
            changes.add(PendingContentChange.load(this.getRealm(), new SerializationContext(nextPrefs, context.getFileStore()), (IProgressMonitor)progress.newChild(1)));
            ++i;
        }
        this.getRealm().asyncExec(new Runnable(){

            public void run() {
                PatchModel.this.patches.clear();
                PatchModel.this.patches.addAll((Collection)changes);
            }
        });
    }

    public void save(SerializationContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.patches.size());
        Preferences prefs = context.getPrefs();
        try {
            PreferencesUtil.clearDescendants((Preferences)prefs);
        }
        catch (BackingStoreException e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
        int counter = 0;
        for (PendingContentChange next : this.patches) {
            Preferences child = prefs.node("" + counter++);
            next.save(new SerializationContext(child, context.getFileStore()), (IProgressMonitor)progress.newChild(1));
        }
    }

    public void removeAll(Collection<PendingContentChange> toRemove) {
        for (PendingContentChange next : toRemove) {
            this.removePatch(next);
        }
    }

    public void dispose() {
        ArrayList<PendingContentChange> toRemove = new ArrayList<PendingContentChange>();
        toRemove.addAll((Collection<PendingContentChange>)this.patches);
        this.removeAll(toRemove);
        this.patches.dispose();
    }
}

