/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.patches;

import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedFilePatch;
import com.ibm.team.filesystem.rcp.core.internal.patches.ParsedPatch;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchedFile;
import com.ibm.team.filesystem.rcp.core.patches.PendingContentChange;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalFileOp {
    private PatchedFile file;
    private PatchOp op;
    private IObservableValue currentStatus;
    private IStatus currentStatusValue = Status.OK_STATUS;
    private IChangeListener listener = new IChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleChange(ChangeEvent event) {
            LocalFileOp localFileOp = LocalFileOp.this;
            synchronized (localFileOp) {
                LocalFileOp.this.currentStatusValue = (IStatus)LocalFileOp.this.currentStatus.getValue();
            }
        }
    };

    public LocalFileOp(PatchedFile file, PatchOp op) {
        this.file = file;
        this.op = op.copy();
        this.currentStatus = new WritableValue(file.getRealm());
        this.currentStatus.addChangeListener(this.listener);
    }

    public PatchedFile getFile() {
        return this.file;
    }

    public PatchOp getOp() {
        return this.op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus getStatus() {
        LocalFileOp localFileOp = this;
        synchronized (localFileOp) {
            return this.currentStatusValue;
        }
    }

    public IObservableValue observeStatus() {
        return this.currentStatus;
    }

    public void setStatus(IStatus currentStatus) {
        this.currentStatus.setValue((Object)currentStatus);
    }

    public Realm getRealm() {
        return this.currentStatus.getRealm();
    }

    public LocalFileOp clone(PatchedFile newParent) {
        return new LocalFileOp(newParent, this.op);
    }

    public void dispose() {
        this.currentStatus.dispose();
        this.op.dispose();
    }

    public static ParsedPatch computePatch(Collection<LocalFileOp> hunks) {
        ParsedPatch pp = ParsedPatch.create();
        HashSet<PendingContentChange> contentChanges = new HashSet<PendingContentChange>();
        for (LocalFileOp next : hunks) {
            PatchedFile file = next.getFile();
            contentChanges.add(file.getPatch());
            ParsedFilePatch pfp = pp.createPatchFor(file.getVersionablePath());
            pfp.addOp(next.getOp().copy());
        }
        ChangeDescription resultingDescription = new ChangeDescription();
        for (PendingContentChange nextChange : contentChanges) {
            resultingDescription = resultingDescription.merge(nextChange.getChangeDescription());
        }
        pp.setDescription(resultingDescription);
        return pp;
    }
}

