/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.operations.CancelRemoteChangesOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.internal.LoggingHelper;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreOperation {
    List<Ignoreable> toIgnore = new LinkedList<Ignoreable>();
    Collection<? extends IIgnoreProvider.IIgnoreRule> rules = null;
    private IRepositoryResolver resolver;
    private Boolean locked = false;
    IConnection connection;
    IComponentHandle component;

    public IgnoreOperation addIgnoreable(ISandbox sandbox, IWorkspaceConnection connection, IShareable shareable, IVersionableHandle remote, IContextHandle workspace, IComponentHandle component, IRemoteChangeSummary summary, boolean cancelChange, IProgressMonitor monitor) throws FileSystemClientException {
        this.ensureUnlocked((IConnection)connection, component);
        this.toIgnore.add(new IgnoreableVersionedShareable(this.resolver, sandbox, connection, shareable, remote, workspace, component, summary, true, cancelChange, monitor));
        return this;
    }

    public IgnoreOperation addIgnoreable(ISandbox sandbox, IWorkspaceConnection connection, IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShare share = shareable.getShare((IProgressMonitor)progress.newChild(33));
        if (share == null) {
            throw new IllegalArgumentException("Cannot ignore unshared item");
        }
        this.ensureUnlocked((IConnection)connection, share.getSharingDescriptor().getComponent());
        IVersionableHandle h = shareable.getRemote((IProgressMonitor)progress.newChild(33));
        if (h == null) {
            this.toIgnore.add(new IgnoreablePendingShareable(connection, shareable));
        } else {
            this.toIgnore.add(new IgnoreableVersionedShareable(this.resolver, sandbox, connection, shareable, h, share.getSharingDescriptor().getConnectionHandle(), share.getSharingDescriptor().getComponent(), null, true, true, (IProgressMonitor)progress.newChild(34)));
        }
        return this;
    }

    public IgnoreOperation addIgnoreable(IConnection conn, IComponentHandle component, IRemoteChangeSummary summary, IShareable shareable) {
        this.ensureUnlocked(conn, component);
        this.toIgnore.add(new IgnoreableRemoteChangeSummary(summary, shareable, true));
        return this;
    }

    public IgnoreOperation(IRepositoryResolver resolver) {
        this.resolver = resolver;
    }

    public IgnoreOperation() {
        this(null);
    }

    public void execute(IProgressMonitor m) throws TeamRepositoryException, FileSystemClientException {
        this.lock();
        if (this.connection == null) {
            assert (this.component == null);
            assert (this.toIgnore == null || this.toIgnore.size() == 0);
            assert (this.rules == null || this.rules.size() == 0);
            m.done();
            return;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (int)10);
        Collection<IComponentHandle> components = this.getAffectedComponents(monitor.newChild(1));
        final HashSet<ConfigurationDescriptor> descriptors = new HashSet<ConfigurationDescriptor>();
        while (true) {
            monitor.setWorkRemaining(9);
            FlowNodeLock flowLock = new FlowNodeLock();
            for (IComponentHandle cHandle : components) {
                ConfigurationDescriptor desc = new ConfigurationDescriptor(this.connection, cHandle);
                flowLock.toWriteLock(desc);
                descriptors.add(desc);
            }
            flowLock.acquire((IProgressMonitor)monitor.newChild(1));
            try {
                final boolean[] done = new boolean[1];
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
                        try {
                            ICopyFileAreasLock lock = ICopyFileAreaManager.instance.lock(Collections.singleton(ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest((Set)descriptors, true)), (IProgressMonitor)monitor.newChild(1));
                            try {
                                Collection myComps = IgnoreOperation.this.getAffectedComponents(monitor.newChild(1));
                                for (IComponentHandle cHandle : myComps) {
                                    ConfigurationDescriptor desc = new ConfigurationDescriptor(IgnoreOperation.this.connection, cHandle);
                                    if (descriptors.remove(desc)) continue;
                                    descriptors.clear();
                                    done[0] = false;
                                }
                                if (!descriptors.isEmpty()) {
                                    descriptors.clear();
                                    done[0] = false;
                                    return;
                                }
                                IgnoreOperation.this.run((IProgressMonitor)monitor.newChild(4));
                                done[0] = true;
                            }
                            finally {
                                lock.release((IProgressMonitor)monitor.newChild(1));
                            }
                        }
                        catch (FileSystemClientException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                try {
                    SharingManager.getInstance().runWithinFileSystemLock(runnable, null, (IProgressMonitor)monitor.newChild(5));
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof TeamRepositoryException) {
                        throw (TeamRepositoryException)cause;
                    }
                    if (cause instanceof FileSystemClientException) {
                        throw (FileSystemClientException)cause;
                    }
                    throw new TeamRepositoryException(Messages.IgnoreOperation_IGNORE_OPERATION_FAILED, cause);
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationCanceledException();
                }
                if (!done[0]) continue;
                return;
            }
            finally {
                WorkspaceLockUtil.release((FlowNodeLock)flowLock);
                continue;
            }
            break;
        }
    }

    private Collection<IComponentHandle> getAffectedComponents(SubMonitor monitor) {
        monitor.setWorkRemaining(this.toIgnore.size());
        HashMap<UUID, IComponentHandle> toReturn = new HashMap<UUID, IComponentHandle>();
        for (Ignoreable ignoreable : this.toIgnore) {
            try {
                IComponentHandle h = ignoreable.getComponent(monitor.newChild(1));
                toReturn.put(h.getItemId(), h);
            }
            catch (FileSystemClientException e) {
                LoggingHelper.log((String)"com.ibm.team.filesystem.rcp.core", (IStatus)FileSystemStatus.getStatusFor((int)4, (String)Messages.IgnoreOperation_ErrorMessageComponents, (Throwable)e));
            }
            catch (TeamRepositoryException e) {
                LoggingHelper.log((String)"com.ibm.team.filesystem.rcp.core", (IStatus)FileSystemStatus.getStatusFor((int)4, (String)Messages.IgnoreOperation_ErrorMessageComponents, (Throwable)e));
            }
        }
        return toReturn.values();
    }

    private void run(IProgressMonitor m) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (int)38);
        try {
            this.syncPendingChanges(monitor.newChild(1));
            this.rationalizeIgnoreables(monitor.newChild(1));
            this.updateIgnoreManager(monitor.newChild(1));
            CancelRemoteChangesOperation op = new CancelRemoteChangesOperation(this.resolver);
            op.addCancelables(this.toIgnore);
            try {
                op.execute((IProgressMonitor)monitor.newChild(30));
            }
            catch (NotLoggedInException notLoggedInException) {
                monitor.done();
                return;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void syncPendingChanges(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor iterProgress;
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<ISandbox, Share> shares = new HashMap<ISandbox, Share>();
        SubMonitor subProgress = monitor.newChild(50).setWorkRemaining(this.toIgnore.size());
        for (Ignoreable ignoreable : this.toIgnore) {
            IShare share;
            IShareable shareable = ignoreable.getShareable((IProgressMonitor)(iterProgress = subProgress.newChild(1).setWorkRemaining(100)).newChild(50));
            if (shareable == null || (share = shareable.getShare((IProgressMonitor)iterProgress.newChild(50))) == null || shares.containsKey(shareable.getSandbox())) continue;
            shares.put(shareable.getSandbox(), (Share)share);
        }
        subProgress = monitor.newChild(50).setWorkRemaining(shares.size());
        for (Map.Entry entry : shares.entrySet()) {
            iterProgress = subProgress.newChild(1).setWorkRemaining(100);
            if (entry.getValue() == null) continue;
            Share share = (Share)entry.getValue();
            AbstractLock rule = CFALockUtil.createAndLockForUpdate((IPath)share.getCopyFileAreaPath(), (IContextHandle)share.getSharingDescriptor().getConnectionHandle(), (IComponentHandle)share.getSharingDescriptor().getComponent(), (IProgressMonitor)iterProgress.newChild(10));
            try {
                share.syncChanges((IProgressMonitor)iterProgress.newChild(80));
            }
            finally {
                CFALockUtil.endBatching((AbstractLock)rule, (IProgressMonitor)iterProgress.newChild(10));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock() {
        Boolean bl = this.locked;
        synchronized (bl) {
            this.locked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureUnlocked(IConnection conn, IComponentHandle comp) {
        Boolean bl = this.locked;
        synchronized (bl) {
            if (this.connection == null) {
                assert (this.component == null);
                this.connection = conn;
                this.component = comp;
            } else if (!conn.getContextHandle().sameItemId((IItemHandle)this.connection.getContextHandle())) {
                throw new IllegalStateException("IgnoreOperation may only be called on items shared on the same connection.");
            }
            if (this.locked.booleanValue()) {
                throw new IllegalStateException("execute() has already been called on " + this.getClass().getSimpleName());
            }
        }
    }

    private void rationalizeIgnoreables(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        monitor.beginTask(Messages.IgnoreOperation_FindingIgnoresProgressMessage, 3);
        this.purgeContainedIgnoreables(monitor.newChild(1));
        this.collectContainedChanges(monitor.newChild(2));
    }

    private void purgeContainedIgnoreables(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IShareable shareable;
        monitor.beginTask(Messages.IgnoreOperation_RemovingIgnoresProgressMessage, 5 * this.toIgnore.size());
        HashSet<IPath> parents = new HashSet<IPath>();
        for (Ignoreable ignoreable : this.toIgnore) {
            shareable = ignoreable.getShareable((IProgressMonitor)monitor.newChild(1));
            if (shareable == null || shareable.getResourceType((IProgressMonitor)monitor.newChild(1)) != ResourceType.FOLDER) continue;
            parents.add(shareable.getLocalPath());
        }
        Iterator<Ignoreable> iToIgnore = this.toIgnore.iterator();
        block1: while (iToIgnore.hasNext()) {
            Ignoreable ignoreable = iToIgnore.next();
            shareable = ignoreable.getShareable((IProgressMonitor)monitor.newChild(1));
            if (shareable == null) continue;
            IPath path = shareable.getLocalPath();
            for (IPath possibleAncestor : parents) {
                if (possibleAncestor.equals((Object)path) || !possibleAncestor.isPrefixOf(path)) continue;
                iToIgnore.remove();
                continue block1;
            }
        }
    }

    private void collectContainedChanges(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        monitor.beginTask(Messages.IgnoreOperation_FindingChangesProgressMessage, this.toIgnore.size() * 2);
        try {
            HashMap allActivities = new HashMap();
            HashMap<ConfigurationDescriptor, HashMap<UUID, IShareable>> allIgnoreableIds = new HashMap<ConfigurationDescriptor, HashMap<UUID, IShareable>>();
            for (Ignoreable ignoreable : this.toIgnore) {
                IComponentSyncContext context;
                IVersionableHandle item;
                SubMonitor iterProgress;
                IShareable shareable = ignoreable.getShareable((IProgressMonitor)(iterProgress = monitor.newChild(1).setWorkRemaining(100)).newChild(50));
                if (shareable != null && (item = shareable.getRemote((IProgressMonitor)iterProgress.newChild(50))) != null && (context = ComponentSyncUtil.getContext(shareable)) != null) {
                    ConfigurationDescriptor descriptor = new ConfigurationDescriptor(context.getOutgoingConnection(), (IComponentHandle)context.getComponent());
                    HashSet activities = (HashSet)allActivities.get(descriptor);
                    if (activities == null) {
                        activities = new HashSet();
                        allActivities.put(descriptor, activities);
                    }
                    activities.addAll(context.getOutgoingActivitySource().getActivities());
                    HashMap<UUID, IShareable> ignorableIds = (HashMap<UUID, IShareable>)allIgnoreableIds.get(descriptor);
                    if (ignorableIds == null) {
                        ignorableIds = new HashMap<UUID, IShareable>();
                        allIgnoreableIds.put(descriptor, ignorableIds);
                    }
                    ignorableIds.put(item.getItemId(), shareable);
                }
                this.checkCancelled(monitor);
            }
            monitor.setWorkRemaining(allActivities.size());
            for (Map.Entry entry : allActivities.entrySet()) {
                Map ignorableIds = (Map)allIgnoreableIds.get(entry.getKey());
                for (IRemoteActivity activity : (Set)entry.getValue()) {
                    block6: for (IRemoteChangeSummary summary : activity.getChanges()) {
                        IChange change = summary.getChange();
                        if (change == null || change.kind() == 0) continue;
                        IChangeSummary changeSummary = summary.getChangeSummary();
                        List ancestorPath = changeSummary.isChangeType(8) ? changeSummary.getNewAncestorPathHint() : changeSummary.getAncestorPathHint();
                        Iterator iPair = ancestorPath.iterator();
                        while (iPair.hasNext()) {
                            INameItemPair pair = (INameItemPair)iPair.next();
                            IShareable s = (IShareable)ignorableIds.get(pair.getItem().getItemId());
                            if (!iPair.hasNext() || s == null) continue;
                            IShareable descShareable = s.getSandbox().findShareable(((ConfigurationDescriptor)entry.getKey()).connectionHandle, ((ConfigurationDescriptor)entry.getKey()).componentHandle, pair.getItem(), (IProgressMonitor)monitor);
                            this.toIgnore.add(new IgnoreableRemoteChangeSummary(summary, descShareable, false));
                            continue block6;
                        }
                    }
                }
                monitor.worked(1);
                this.checkCancelled(monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void checkCancelled(SubMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void updateIgnoreManager(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (this.rules != null) {
            this.applyIgnoreRules(monitor);
            return;
        }
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.toIgnore.size() * 3));
        try {
            int i = 0;
            for (Ignoreable ignoreable : this.toIgnore) {
                monitor.setTaskName(NLS.bind((String)Messages.IgnoreOperation_UpdatingProgressMessage, (Object)(++i), (Object[])new Object[]{this.toIgnore.size()}));
                if (ignoreable.shouldUpdateIgnoreManager) {
                    IShareable shareable = ignoreable.getShareable((IProgressMonitor)monitor.newChild(1));
                    if (shareable == null) continue;
                    DefaultIgnoreProvider.getDefault((IProgressMonitor)monitor.newChild(1)).ignore(shareable, (IProgressMonitor)monitor.newChild(1));
                    continue;
                }
                monitor.worked(3);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void applyIgnoreRules(SubMonitor monitor) throws FileSystemClientException {
        Assert.isNotNull(this.rules);
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.rules.size());
        try {
            for (IIgnoreProvider.IIgnoreRule iIgnoreRule : this.rules) {
                ((DefaultIgnoreProvider)iIgnoreRule.getProvider()).addIgnoreRule(iIgnoreRule, (IProgressMonitor)monitor.newChild(1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public IgnoreOperation setIgnoreRules(IWorkspaceConnection connection, IComponentHandle component, Collection<? extends IgnoreRule> rules, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        return this.setIgnoreRules(connection, component, rules, false, progress);
    }

    public IgnoreOperation setIgnoreRules(IWorkspaceConnection connection, IComponentHandle component, Collection<? extends IgnoreRule> rules, boolean includeIgnoredResources, IProgressMonitor progress) throws FileSystemClientException {
        if (rules == null) {
            throw new IllegalArgumentException("rules may not be null");
        }
        this.ensureUnlocked((IConnection)connection, component);
        if (this.toIgnore.size() > 0) {
            throw new IllegalStateException("Cannot set ignore rule. #addIgnoreable() has already been called");
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        this.rules = rules;
        try {
            HashSet ignored = new HashSet();
            IgnoreUtils.findIgnoresForRules(rules, (boolean)includeIgnoredResources, ignored, (IProgressMonitor)monitor.newChild(9));
            monitor.setWorkRemaining(ignored.size());
            for (IShareable shareable : ignored) {
                this.addIgnoreable(shareable.getSandbox(), connection, shareable, (IProgressMonitor)monitor.newChild(1));
            }
        }
        finally {
            this.lock();
            monitor.done();
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Ignoreable
    implements CancelRemoteChangesOperation.Cancelable {
        boolean shouldUpdateIgnoreManager;
        private boolean shouldCancelChange;

        private Ignoreable() {
        }

        public void setShouldCancelChange(boolean b) {
            this.shouldCancelChange = b;
        }

        @Override
        public boolean shouldCancelChange() {
            return this.shouldCancelChange;
        }

        @Override
        public abstract CancelRemoteChangesOperation.ChangeSetUndoList getUndoList(SubMonitor var1) throws TeamRepositoryException, FileSystemClientException;

        @Override
        public abstract IShareable getShareable(IProgressMonitor var1) throws FileSystemClientException, TeamRepositoryException;

        abstract Collection<IShareable> getShareables(SubMonitor var1) throws FileSystemClientException, TeamRepositoryException;

        @Override
        public abstract IWorkspaceConnection getConnection();

        @Override
        public abstract UUID getUUID();

        @Override
        public Collection<IShareable> getRefreshShareables(IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            return this.getShareables(SubMonitor.convert((IProgressMonitor)mon));
        }

        abstract IComponentHandle getComponent(SubMonitor var1) throws FileSystemClientException, TeamRepositoryException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IgnoreablePendingShareable
    extends Ignoreable {
        private IShareable shareable;
        private IWorkspaceConnection connection;

        public IgnoreablePendingShareable(IWorkspaceConnection connection, IShareable shareable) {
            this.connection = connection;
            this.shareable = shareable;
            this.shouldUpdateIgnoreManager = true;
            this.setShouldCancelChange(false);
        }

        @Override
        public IWorkspaceConnection getConnection() {
            return this.connection;
        }

        @Override
        public IShareable getShareable(IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            return this.shareable;
        }

        @Override
        Collection<IShareable> getShareables(SubMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            ArrayList<IShareable> list = new ArrayList<IShareable>(1);
            list.add(this.getShareable((IProgressMonitor)mon));
            return list;
        }

        @Override
        public UUID getUUID() {
            throw new UnsupportedOperationException("Must be committed");
        }

        @Override
        public CancelRemoteChangesOperation.ChangeSetUndoList getUndoList(SubMonitor monitor) throws TeamRepositoryException {
            throw new UnsupportedOperationException("Must be committed");
        }

        @Override
        IComponentHandle getComponent(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
            monitor.setWorkRemaining(2);
            IShareable shareable = this.getShareable((IProgressMonitor)monitor.newChild(1));
            IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
            Assert.isNotNull((Object)share);
            return share.getSharingDescriptor().getComponent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IgnoreableRemoteChangeSummary
    extends Ignoreable {
        IRemoteChangeSummary summary;
        private IShareable shareable;

        public IgnoreableRemoteChangeSummary(IRemoteChangeSummary summary, IShareable shareable, boolean updateIgnoreManager) {
            this.summary = summary;
            this.shareable = shareable;
            this.shouldUpdateIgnoreManager = updateIgnoreManager;
            this.setShouldCancelChange(true);
        }

        @Override
        public CancelRemoteChangesOperation.ChangeSetUndoList getUndoList(SubMonitor monitor) {
            ArrayList<IChange> toReturn = new ArrayList<IChange>(2);
            toReturn.add(this.summary.getChange());
            return new CancelRemoteChangesOperation.ChangeSetUndoList(this.summary.getChangeSummary().component(), this.summary.getActivity().getChangeSetHandle(), Collections.singletonList(this.summary.getChange().item()));
        }

        @Override
        public IShareable getShareable(IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
            if (progress != null) {
                progress.done();
            }
            return this.shareable;
        }

        @Override
        public Collection<IShareable> getShareables(SubMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            IChangeSummary changeSummary;
            mon.beginTask(Messages.IgnoreOperation_FINDING_FILES_AND_DIRECTORIES_TO_REFRESH, 4);
            ArrayList<IShareable> result = new ArrayList<IShareable>(2);
            IShareable shareable = this.getShareable((IProgressMonitor)mon);
            if (shareable != null) {
                result.add(shareable);
            }
            if ((changeSummary = this.summary.getChangeSummary()).isChangeType(8)) {
                IComponent componentHandle = this.summary.getActivity().getActivitySource().getModel().getComponent();
                IWorkspace contextHandle = this.summary.getActivity().getActivitySource().getWorkspace();
                SharingManager sharingManager = SharingManager.getInstance();
                Collection shareHints = sharingManager.findShareables((IContextHandle)contextHandle, (IComponentHandle)componentHandle, changeSummary.item(), (IProgressMonitor)mon.newChild(1));
                mon.setWorkRemaining(shareHints.size() * 2);
                for (IShareable shareHint : shareHints) {
                    IPath cfaRoot = shareHint.getShare((IProgressMonitor)mon.newChild(1)).getSandbox().getRoot();
                    IPath shareablePath = (IPath)sharingManager.getPathRelativeToShares(cfaRoot, (IContextHandle)contextHandle, (IComponentHandle)componentHandle, Collections.singletonList(changeSummary.getAncestorPathHint()), (IProgressMonitor)mon.newChild(1)).get(0);
                    if (shareablePath == null) continue;
                    ISandbox sandbox = sharingManager.getSandbox(cfaRoot, false);
                    shareable = sharingManager.findShareable(sandbox, shareablePath, ResourceType.getResourceType((IVersionableHandle)changeSummary.item()));
                    result.add(shareable);
                }
            }
            mon.done();
            return result;
        }

        @Override
        public IWorkspaceConnection getConnection() {
            return this.summary.getActivity().getActivitySource().getModel().getOutgoingTeamPlace();
        }

        @Override
        IComponentHandle getComponent(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
            return this.summary.getChangeSummary().component();
        }

        @Override
        public UUID getUUID() {
            return this.summary.getItem().getItemId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IgnoreableVersionedShareable
    extends Ignoreable {
        private IRepositoryResolver resolver;
        private ISandbox sandbox;
        private IWorkspaceConnection connection;
        private IShareable shareable;
        private IVersionableHandle remote;
        private IRemoteChangeSummary summary;
        private IComponentHandle component;
        private IContextHandle ws;

        IgnoreableVersionedShareable(IRepositoryResolver resolver, ISandbox sandbox, final IWorkspaceConnection connection, IShareable shareable, IVersionableHandle remote, IContextHandle connectableHandle, IComponentHandle component, IRemoteChangeSummary summary, boolean updateIgnoreManager, boolean cancelChange, IProgressMonitor monitor) throws FileSystemClientException {
            if (remote == null) {
                throw new IllegalArgumentException("Remote handle may not be null");
            }
            IVersionableHandle shareableRemoteHandle = shareable.getRemote(monitor);
            if (cancelChange && shareable != null && shareableRemoteHandle == null) {
                throw new IllegalArgumentException("shareable must have a remote to cancel change");
            }
            if (cancelChange && shareable != null && !remote.getItemId().equals((Object)shareableRemoteHandle.getItemId())) {
                throw new IllegalArgumentException("UUID of shareable and UUID remote item do not match(" + shareableRemoteHandle.getItemId() + " != " + remote.getItemId() + ")");
            }
            if (connectableHandle == null) {
                throw new IllegalArgumentException("connection may not be null");
            }
            if (component == null) {
                throw new IllegalArgumentException("component may not be null");
            }
            if (resolver == null) {
                resolver = new IRepositoryResolver(){

                    public ITeamRepository getRepoFor(String uri, UUID id) {
                        return connection.teamRepository();
                    }
                };
            }
            this.resolver = resolver;
            this.sandbox = sandbox;
            this.connection = connection;
            this.shareable = shareable;
            this.remote = remote;
            this.ws = connectableHandle;
            this.component = component;
            this.summary = summary;
            this.shouldUpdateIgnoreManager = updateIgnoreManager;
            this.setShouldCancelChange(cancelChange);
        }

        public String toString() {
            return "Ignoreable(" + this.shareable + ", " + this.remote + ")";
        }

        @Override
        public CancelRemoteChangesOperation.ChangeSetUndoList getUndoList(SubMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
            if (this.summary != null) {
                return this.getUndoListFromSummary(monitor);
            }
            monitor.setWorkRemaining(100);
            Share share = (Share)this.shareable.getShare((IProgressMonitor)monitor.newChild(5));
            IContextHandle cHandle = share.getSharingDescriptor().getConnectionHandle();
            IComponentHandle component = share.getSharingDescriptor().getComponent();
            ITeamRepository repo = this.resolver.getRepoFor(share.getSharingDescriptor().getRepositoryUri(), share.getSharingDescriptor().getRepositoryId());
            IWorkspaceManager wsMan = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            IWorkspaceConnection connection = wsMan.getWorkspaceConnection((IWorkspaceHandle)cHandle, (IProgressMonitor)monitor.newChild(5));
            List changesets = connection.activeChangeSets();
            monitor.setWorkRemaining(changesets.size());
            monitor.subTask(Messages.IgnoreOperation_SubTask);
            IChangeSet changesetHandle = null;
            LinkedList<IVersionableHandle> toUndo = new LinkedList<IVersionableHandle>();
            block0: for (IChangeSetHandle csHandle : changesets) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IChangeSet changeSet = (IChangeSet)connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)csHandle, 0, (IProgressMonitor)monitor.newChild(1));
                for (IChange c : changeSet.changes()) {
                    if (!this.remote.getItemId().equals((Object)c.item().getItemId())) continue;
                    toUndo.add(c.item());
                    changesetHandle = changeSet;
                    continue block0;
                }
            }
            return new CancelRemoteChangesOperation.ChangeSetUndoList(component, (IChangeSetHandle)changesetHandle, (List<IVersionableHandle>)toUndo);
        }

        private CancelRemoteChangesOperation.ChangeSetUndoList getUndoListFromSummary(SubMonitor monitor) {
            Assert.isNotNull((Object)this.summary);
            monitor.beginTask(Messages.IgnoreOperation_GetUndoListProgressMessage, 1);
            ArrayList<IVersionableHandle> toReturn = new ArrayList<IVersionableHandle>(2);
            toReturn.add(this.summary.getChange().item());
            monitor.done();
            return new CancelRemoteChangesOperation.ChangeSetUndoList(this.component, this.summary.getActivity().getChangeSetHandle(), toReturn);
        }

        @Override
        public IShareable getShareable(IProgressMonitor monitor) throws FileSystemClientException {
            if (this.shareable != null) {
                monitor.beginTask(null, 1);
                monitor.worked(1);
                monitor.done();
                return this.shareable;
            }
            if (this.sandbox != null) {
                this.shareable = this.sandbox.findShareable(this.ws, this.component, this.remote, monitor);
            }
            return this.shareable;
        }

        @Override
        public Collection<IShareable> getShareables(SubMonitor mon) throws FileSystemClientException, TeamRepositoryException {
            IShareable s = this.getShareable((IProgressMonitor)mon);
            if (s == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.singleton(s);
        }

        @Override
        public IWorkspaceConnection getConnection() {
            return this.connection;
        }

        @Override
        public UUID getUUID() {
            return this.remote.getItemId();
        }

        @Override
        IComponentHandle getComponent(SubMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
            return this.component;
        }
    }
}

