/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.streams;

import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public final class InputStreamStorage
implements IStorage,
IEncodedStorage {
    private IInputStreamProvider inputStreamProvider;
    private IPath fullPath;
    private String encoding;

    public InputStreamStorage(IInputStreamProvider inputStreamProvider) {
        this(inputStreamProvider, ResourcesPlugin.getEncoding());
    }

    public InputStreamStorage(IInputStreamProvider inputStreamProvider, String encoding) {
        this(inputStreamProvider, encoding, "temp.txt");
    }

    public InputStreamStorage(IInputStreamProvider inputStreamProvider, String encoding, String filename) {
        this.inputStreamProvider = inputStreamProvider;
        long currentTime = System.currentTimeMillis();
        this.fullPath = new Path("__temporary_pathname__/" + currentTime + "/" + filename);
        this.encoding = encoding;
    }

    public InputStream getContents() throws CoreException {
        try {
            return this.inputStreamProvider.getInputStream((IProgressMonitor)TempHelper.MONITOR);
        }
        catch (IOException e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    public IPath getFullPath() {
        return this.fullPath;
    }

    public String getName() {
        return this.fullPath.lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getCharset() throws CoreException {
        return this.encoding;
    }
}

