/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentSeed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConfigurationChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPostWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutComponent;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.FilesystemRestClientDTOworkspaceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.WorkspaceUpdateUtil;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.ProcessPackage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.Visibility;
import com.ibm.team.scm.client.VisibilityEnum;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.RestUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class WorkspaceUtil {
    private static final String putWorkspaceRequest = "postPutWorkspace";

    public static PutWorkspaceResultDTO putWorkspace(ParmsPutWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.workspace.repositoryUrl);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        if (RestUtils.isSet((String)parms.name)) {
            wc.setName(parms.name, (IProgressMonitor)monitor.newChild(5));
        }
        if (RestUtils.isSet((String)parms.description)) {
            wc.setDescription(parms.description, (IProgressMonitor)monitor.newChild(5));
        }
        if (RestUtils.isSet((String)parms.newVisibility)) {
            VisibilityEnum viz = WorkspaceUtil.translate(parms.newVisibility);
            IProjectAreaHandle pa = null;
            if (viz.equals((Object)VisibilityEnum.PROTECTED) && RestUtils.isSet((String)parms.newProjectAreaVisibility)) {
                pa = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.newProjectAreaVisibility), null);
            }
            wc.setVisibility(new Visibility(viz, pa), (IProgressMonitor)monitor.newChild(5));
        }
        PutWorkspaceResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createPutWorkspaceResultDTO();
        if (RestUtils.isSet((String)parms.newOwnerItemId)) {
            IContributorHandle newOwner = null;
            if (wc.isStream()) {
                if (!RestUtils.isSet((String)parms.newOwnerItemType)) {
                    throw new IllegalArgumentException("require project area type to be set for streams");
                }
                ItemType itemType = ItemUtil.itemTypeFor((String)parms.newOwnerItemType, (String)ProcessPackage.eINSTANCE.getNsURI());
                IProcessAreaHandle processAreaHandle = (IProcessAreaHandle)itemType.createItemHandle((Object)repo, UUID.valueOf((String)parms.newOwnerItemId), null);
                newOwner = processAreaHandle;
            } else {
                newOwner = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.newOwnerItemId), null);
            }
            wc.setOwner((IAuditableHandle)newOwner, (IProgressMonitor)monitor.newChild(10));
        }
        WorkspaceUtil.applyComponentChanges(wc, parms.configurationChanges, result, (IProgressMonitor)monitor.newChild(50));
        WorkspaceUtil.applyFlowTableChanges(wc, parms, (IProgressMonitor)monitor.newChild(10));
        result.setWorkspace(CoreUtil.translateWorkspace(wc, true, true, (IProgressMonitor)monitor.newChild(10)));
        return result;
    }

    private static VisibilityEnum translate(String visibility) {
        if (visibility.equals("public")) {
            return VisibilityEnum.PUBLIC_TO_ALL;
        }
        if (visibility.equals("project")) {
            return VisibilityEnum.PROTECTED;
        }
        if (visibility.equals("private")) {
            return VisibilityEnum.PRIVATE_TO_OWNER;
        }
        throw new IllegalArgumentException("Unknown visibility");
    }

    private static void applyFlowTableChanges(IWorkspaceConnection connection, ParmsPutWorkspace parms, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceHandle oldCurrentHandle;
        IWorkspaceHandle defaultWorkspaceHandle;
        int n;
        int n2;
        ParmsWorkspace[] parmsWorkspaceArray;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFlowTable flowTable = connection.getFlowTable().getWorkingCopy();
        boolean changed = false;
        if (parms.flowTargetsToRemove != null && parms.flowTargetsToRemove.length > 0) {
            parmsWorkspaceArray = parms.flowTargetsToRemove;
            n2 = parms.flowTargetsToRemove.length;
            n = 0;
            while (n < n2) {
                ParmsWorkspace workspace = parmsWorkspaceArray[n];
                IWorkspaceHandle workspaceHandle = workspace.getWorkspaceHandle();
                ComponentFlowUtil.removeCollaboration(flowTable, workspaceHandle);
                ++n;
            }
            changed = true;
        }
        if (parms.flowTargets != null && parms.flowTargets.length > 0) {
            parmsWorkspaceArray = parms.flowTargets;
            n2 = parms.flowTargets.length;
            n = 0;
            while (n < n2) {
                ParmsWorkspace change = parmsWorkspaceArray[n];
                IWorkspaceHandle flowTarget = change.workspace.getWorkspaceHandle();
                if (flowTable.getAcceptFlow((IFlowNodeHandle)flowTarget) != null || flowTable.getDeliverFlow((IFlowNodeHandle)flowTarget) != null) {
                    flowTable.setComponentScopes((IFlowNodeHandle)flowTarget, (Collection)change.getComponentScopes());
                    changed = true;
                } else {
                    IWorkspaceConnection remote = change.workspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(10));
                    ComponentFlowUtil.addCollaboration(flowTable, connection, remote);
                    flowTable.setComponentScopes((IFlowNodeHandle)flowTarget, (Collection)change.getComponentScopes());
                    changed = true;
                }
                ++n;
            }
        }
        if (parms.defaultFlowTarget != null && !(defaultWorkspaceHandle = parms.defaultFlowTarget.getWorkspaceHandle()).sameItemId((IItemHandle)FlowUtils.getDefaultFlowTarget((IWorkspaceConnection)connection))) {
            ComponentFlowUtil.setDefaultCollaboration(flowTable, defaultWorkspaceHandle);
            changed = true;
        }
        boolean currentChanged = false;
        IWorkspaceHandle newCurrentHandle = null;
        if (parms.currentFlowTarget != null && !(newCurrentHandle = parms.currentFlowTarget.getWorkspaceHandle()).sameItemId((IItemHandle)(oldCurrentHandle = ComponentFlowUtil.getCurrentCollaboration(connection)))) {
            ComponentFlowUtil.setCurrentCollaboration(flowTable, newCurrentHandle);
            currentChanged = true;
            changed = true;
        }
        if (changed) {
            connection.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(30));
        }
        if (currentChanged) {
            FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceCollaboration((IWorkspaceHandle)connection.getResolvedWorkspace(), newCurrentHandle, false, null);
        }
    }

    public static void putComponent(ParmsPutComponent parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
        IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.componentItemId), null);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        if (RestUtils.isSet((String)parms.name)) {
            wm.renameComponent(componentHandle, parms.name, (IProgressMonitor)monitor.newChild(1));
        }
        if (RestUtils.isSet((String)parms.newOwnerItemId)) {
            if (parms.newOwnerItemType.equals(IContributor.ITEM_TYPE.getName())) {
                IContributorHandle newOwnerHandle = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.newOwnerItemId), null);
                wm.setComponentOwner(componentHandle, (IAuditableHandle)newOwnerHandle, (IProgressMonitor)monitor.newChild(1));
            } else {
                ItemType itemType = ItemUtil.itemTypeFor((String)parms.newOwnerItemType, (String)ProcessPackage.eINSTANCE.getNsURI());
                IProcessAreaHandle processAreaHandle = (IProcessAreaHandle)itemType.createItemHandle((Object)repo, UUID.valueOf((String)parms.newOwnerItemId), null);
                wm.setComponentOwner(componentHandle, (IAuditableHandle)processAreaHandle, (IProgressMonitor)monitor.newChild(1));
            }
        }
        if (RestUtils.isSet((String)parms.newVisibility)) {
            wm.setComponentVisibility(componentHandle, WorkspaceUtil.createVisibility(parms), (IProgressMonitor)monitor.newChild(1));
        }
    }

    private static Visibility createVisibility(ParmsPutComponent parms) {
        if (parms.newVisibility.equals("public")) {
            return Visibility.PUBLIC;
        }
        if (parms.newVisibility.equals("private")) {
            return Visibility.PRIVATE;
        }
        return new Visibility(VisibilityEnum.PROTECTED, (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.newProjectAreaScope), null));
    }

    public static WorkspaceDetailsDTO postWorkspace(ParmsPostWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IWorkspaceConnection seedConnection = null;
        if (parms.seed != null) {
            seedConnection = parms.seed.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        }
        if (parms.isStream.booleanValue()) {
            ItemType itemType = ItemUtil.itemTypeFor((String)parms.processAreaType, (String)ProcessPackage.eINSTANCE.getNsURI());
            IProcessAreaHandle processAreaHandle = (IProcessAreaHandle)itemType.createItemHandle((Object)repo, UUID.valueOf((String)parms.processAreaId), null);
            IWorkspaceConnection stream = wm.createStream(processAreaHandle, parms.name, parms.description, (IProgressMonitor)monitor.newChild(10));
            if (seedConnection != null) {
                ArrayList<IFlowNodeConnection.IComponentAdditionOp> ops = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>();
                List components = seedConnection.getComponents();
                for (IComponent component : components) {
                    ops.add(seedConnection.componentOpFactory().addComponent((IComponentHandle)component, (IConnection)seedConnection, false));
                }
                stream.applyComponentOperations(ops, (IProgressMonitor)monitor.newChild(60));
            }
            return CoreUtil.translateWorkspace(stream, true, true, (IProgressMonitor)monitor.newChild(10));
        }
        IContributorHandle owner = RepositoryUtils.getLoggedInContributor((ITeamRepository)repo);
        IWorkspaceConnection workspace = wm.createWorkspace(owner, parms.name, parms.description, seedConnection, seedConnection, (IProgressMonitor)monitor.newChild(70));
        if (RestUtils.isSet((String)parms.visibility)) {
            VisibilityEnum viz = WorkspaceUtil.translate(parms.visibility);
            IProjectAreaHandle pa = null;
            if (viz.equals((Object)VisibilityEnum.PROTECTED) && RestUtils.isSet((String)parms.projectAreaVisibility)) {
                pa = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.projectAreaVisibility), null);
            }
            workspace.setVisibility(new Visibility(viz, pa), (IProgressMonitor)monitor.newChild(5));
        }
        return CoreUtil.translateWorkspace(workspace, true, true, (IProgressMonitor)monitor.newChild(10));
    }

    private static void applyComponentChanges(IWorkspaceConnection connection, ParmsConfigurationChanges parms, PutWorkspaceResultDTO result, IProgressMonitor progress) throws TeamRepositoryException {
        if (parms == null) {
            return;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(50 + 10 * parms.components.length));
        ParmsWorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
        workspaceUpdateDilemmaHandler.componentFlowDirection = "continue";
        workspaceUpdateDilemmaHandler.disconnectedComponentsDirection = "continue";
        workspaceUpdateDilemmaHandler.validate(putWorkspaceRequest, new Object[]{"workspaceUpdateDilemmaHandler"});
        WorkspaceUpdateDilemmaHandler dilemmaHandler = WorkspaceUpdateUtil.getWorkspaceUpdateDilemmaHandler(workspaceUpdateDilemmaHandler, parms.pendingChangesDilemmaHandler, parms.outOfSyncInstructions, parms.backupDilemmaHandler, null, null, null, null, result.getConfigurationsWithUnCheckedInChanges(), result.getLineDelimiterFailures(), result.getEncodingFailures(), result.getOutOfSyncShares(), null, null, null, result.getBackedUpToShed(), result.getNonAtomicCheckInOffers());
        IWorkspaceUpdateOperation workspaceUpdateOperation = IOperationFactory.instance.getWorkspaceUpdateOperation(dilemmaHandler);
        ParmsComponentChange[] parmsComponentChangeArray = parms.components;
        int n = parms.components.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentHandle component;
            IComponentHandle component2;
            IConnection seedConnection;
            ParmsComponentChange command = parmsComponentChangeArray[n2];
            ITeamRepository repo = connection.teamRepository();
            if (command.cmd.equals("addComponent")) {
                if (command.componentItemId == null) {
                    workspaceUpdateOperation.addComponent(connection, command.name);
                } else if (command.seed != null) {
                    seedConnection = WorkspaceUtil.getSeedConnection(command.componentItemId, command.seed, (IProgressMonitor)monitor.newChild(10));
                    component2 = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)seedConnection.teamRepository(), UUID.valueOf((String)command.componentItemId), null);
                    if (seedConnection instanceof IBaselineConnection) {
                        workspaceUpdateOperation.replace(connection, (IBaselineConnection)seedConnection);
                    } else {
                        workspaceUpdateOperation.replace(connection, (IWorkspaceConnection)seedConnection, Collections.singletonList(component2));
                    }
                } else {
                    component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)command.componentItemId), null);
                    workspaceUpdateOperation.addComponent(connection, component);
                }
            } else if (command.cmd.equals("removeComponent")) {
                component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)command.componentItemId), null);
                workspaceUpdateOperation.removeComponent(connection, component);
            } else if (command.cmd.equals("replaceComponent")) {
                seedConnection = WorkspaceUtil.getSeedConnection(command.componentItemId, command.seed, (IProgressMonitor)monitor.newChild(10));
                component2 = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)seedConnection.teamRepository(), UUID.valueOf((String)command.componentItemId), null);
                if (seedConnection instanceof IBaselineConnection) {
                    workspaceUpdateOperation.replace(connection, (IBaselineConnection)seedConnection);
                } else {
                    workspaceUpdateOperation.replace(connection, (IWorkspaceConnection)seedConnection, Collections.singletonList(component2));
                }
            }
            ++n2;
        }
        try {
            workspaceUpdateOperation.run((IProgressMonitor)monitor.newChild(50));
            for (ConfigurationDescriptor descriptor : workspaceUpdateOperation.getComponentsAdded()) {
                result.getComponentsAdded().add(CoreUtil.translateConfigurationDescriptor(descriptor));
            }
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
    }

    private static IConnection getSeedConnection(String componentItemId, ParmsComponentSeed seed, IProgressMonitor progress) throws TeamRepositoryException {
        if (seed != null) {
            ITeamRepository repo = CommonUtil.getTeamRepository((String)seed.repositoryUrl);
            if (seed.itemTypeId.equals("workspace")) {
                IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)seed.itemId), null);
                return SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(workspaceHandle, progress);
            }
            if (seed.itemTypeId.equals("baseline")) {
                IBaselineHandle bh = (IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)seed.itemId), null);
                return SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(bh, progress);
            }
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            IBaselineSetHandle sh = (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)seed.itemId), null);
            IBaselineSet snapShot = (IBaselineSet)repo.itemManager().fetchCompleteItem((IItemHandle)sh, 0, (IProgressMonitor)monitor.newChild(25));
            List baselines = repo.itemManager().fetchCompleteItems(snapShot.getBaselines(), 0, (IProgressMonitor)monitor.newChild(25));
            UUID componentId = UUID.valueOf((String)componentItemId);
            for (IBaseline baseline : baselines) {
                if (!baseline.getItemId().equals((Object)componentId)) continue;
                return SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(baseline, (IProgressMonitor)monitor.newChild(50));
            }
            throw new TeamRepositoryException(NLS.bind((String)Messages.FilesystemRestClient_1, (Object)snapShot.getName()));
        }
        return null;
    }

    public static WorkspaceDetailsDTO getWorkspaceDetails(ParmsGetWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection connection = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(25));
        if (parms.refresh.booleanValue()) {
            connection.refresh((IProgressMonitor)monitor.newChild(10));
        }
        return CoreUtil.translateWorkspace(connection, parms.includeComponents, parms.includeFlowTargets, (IProgressMonitor)monitor.newChild(65));
    }
}

