/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAcceptChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsContext;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResolveChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.BackupInShedDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.GapChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.NonAtomicCheckInDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredBaselineUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredComponentConflictItemDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredComponentUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredWorkspaceUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EncodingErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceUpdateUtil {
    private static final String request = "WorkspaceUpdate";

    public static WorkspaceUpdateResultDTO workspaceUpdate(ParmsWorkspaceUpdate parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate(request, new Object[0]);
        WorkspaceUpdateResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createWorkspaceUpdateResultDTO();
        WorkspaceUpdateDilemmaHandler dilemmaHandler = WorkspaceUpdateUtil.getWorkspaceUpdateDilemmaHandler(parms.workspaceUpdateDilemmaHandler, parms.pendingChangesDilemmaHandler, parms.outOfSyncInstructions, parms.backupDilemmaHandler, result.getComponentFlowAdditions(), result.getComponentFlowDeletions(), result.getComponentReplacementCandidates(), result.getDisconnectedComponents(), result.getConfigurationsWithUnCheckedInChanges(), result.getLineDelimiterFailures(), result.getEncodingFailures(), result.getOutOfSyncShares(), result.getActiveChangeSets(), result.getActiveChangeSetsOverlap(), result.getGap(), result.getBackedUpToShed(), result.getNonAtomicCheckInOffers());
        IWorkspaceUpdateOperation workspaceUpdateOperation = WorkspaceUpdateUtil.prepareWorkspaceUpdateOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(9));
        try {
            if (parms.evaluateRequestOnly == null || !parms.evaluateRequestOnly.booleanValue()) {
                workspaceUpdateOperation.run((IProgressMonitor)monitor.newChild(90));
            } else {
                workspaceUpdateOperation.runPreConditionsOnly((IProgressMonitor)monitor.newChild(90));
            }
            result.setChangeSetsAlreadyInHistory(workspaceUpdateOperation.changeSetsAlreadyInHistory());
            result.setAcceptedSuspendedChanges(workspaceUpdateOperation.acceptedSuspendedChangeSets());
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setChangeSetsAlreadyInHistory(workspaceUpdateOperation.changeSetsAlreadyInHistory());
            result.setAcceptedSuspendedChanges(workspaceUpdateOperation.acceptedSuspendedChangeSets());
            result.setCancelled(true);
        }
        WorkspaceUpdateUtil.recordConfigurationDescriptors(workspaceUpdateOperation.getComponentsAdded(), result.getComponentsAdded());
        if (parms.structuredResultOptions != null) {
            WorkspaceUpdateUtil.populateWorkspaceUpdateResult(parms, workspaceUpdateOperation, result, monitor.newChild(1));
        }
        return result;
    }

    private static void populateWorkspaceUpdateResult(ParmsWorkspaceUpdate parms, IWorkspaceUpdateOperation workspaceUpdateOperation, WorkspaceUpdateResultDTO result, SubMonitor mon) throws TeamRepositoryException {
        IWorkspaceUpdateOperation.IWorkspaceUpdateReport report = workspaceUpdateOperation.getUpdateReport();
        if (report == null) {
            return;
        }
        mon.beginTask(Messages.WorkspaceUpdateUtil_POPULATING_RESULT_OBJECT, report.getConnections().size());
        for (IWorkspaceConnection wsConn : report.getConnections()) {
            SubMonitor wsMon = mon.newChild(1);
            wsMon.beginTask(NLS.bind((String)Messages.WorkspaceUpdateUtil_POPULATING_RESULT_FOR_REMOTE_WORKSPACE, (Object)wsConn.getName(), (Object[])new Object[0]), 3);
            StructuredWorkspaceUpdateReportDTO dto = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createStructuredWorkspaceUpdateReportDTO();
            result.getStructuredResult().add(dto);
            dto.setRepositoryUrl(wsConn.teamRepository().getRepositoryURI());
            dto.setRepositoryName(wsConn.teamRepository().getName());
            dto.setWorkspaceItemId(wsConn.getContextHandle().getItemId().getUuidValue());
            dto.setWorkspaceName(wsConn.getName());
            List compHandles = report.getAffectedComponents(wsConn);
            List comps = wsConn.teamRepository().itemManager().fetchCompleteItems(compHandles, 0, (IProgressMonitor)wsMon.newChild(1));
            wsMon.setWorkRemaining(comps.size());
            boolean hasConflicts = false;
            for (IComponent comp : comps) {
                SubMonitor compMon = wsMon.newChild(1);
                compMon.beginTask(NLS.bind((String)Messages.WorkspaceUpdateUtil_POPULATING_RESULT_FOR_REMOTE_WORKSPACE_AND_COMPONENT, (Object)wsConn.getName(), (Object[])new Object[]{comp.getName()}), report.getBaselines(wsConn, (IComponentHandle)comp).size() + 1);
                StructuredComponentUpdateReportDTO compDto = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createStructuredComponentUpdateReportDTO();
                dto.getComponents().add(compDto);
                compDto.setComponentItemId(comp.getItemId().getUuidValue());
                compDto.setComponentName(comp.getName());
                compDto.getAcceptedChangeSets().addAll(WorkspaceUpdateUtil.translateChangeSets(wsConn, report.getAcceptedChanges(wsConn, (IComponentHandle)comp), (IProgressMonitor)compMon.newChild(1)));
                List baselineHandles = report.getBaselines(wsConn, (IComponentHandle)comp);
                List baselines = wsConn.teamRepository().itemManager().fetchCompleteItems(baselineHandles, 0, (IProgressMonitor)compMon.newChild(1));
                compMon.setWorkRemaining(baselines.size());
                for (IBaseline baseline : baselines) {
                    StructuredBaselineUpdateReportDTO baselineDto = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createStructuredBaselineUpdateReportDTO();
                    compDto.getAcceptedBaselines().add(baselineDto);
                    baselineDto.setBaselineItemId(baseline.getItemId().getUuidValue());
                    baselineDto.setBaselineId((long)baseline.getId());
                    baselineDto.setBaselineName(baseline.getName());
                }
                IUpdateReport update = wsConn.conflictReport((IComponentHandle)comp);
                SubMonitor conflictMon = SubMonitor.convert((IProgressMonitor)compMon.newChild(1), (int)update.getConflictsForComponent((IComponentHandle)comp).size());
                for (IItemConflictReport conflict : update.getConflictsForComponent((IComponentHandle)comp)) {
                    StructuredComponentConflictItemDTO conflictDto = WorkspaceUpdateUtil.translateConflict(wsConn, comp, conflict, conflictMon.newChild(1));
                    compDto.getConflictedItems().add(conflictDto);
                    hasConflicts = true;
                }
            }
            dto.setHasConflicts(hasConflicts);
        }
    }

    private static StructuredComponentConflictItemDTO translateConflict(IWorkspaceConnection wsConn, IComponent comp, IItemConflictReport conflict, SubMonitor mon) {
        StructuredComponentConflictItemDTO conflictDto = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createStructuredComponentConflictItemDTO();
        conflictDto.setConflictedItemId(conflict.item().getItemId().getUuidValue());
        try {
            Collection shareables = SharingManager.getInstance().findShareables(wsConn.getContextHandle(), (IComponentHandle)comp, conflict.item(), (IProgressMonitor)mon);
            for (IShareable shareable : shareables) {
                conflictDto.getLoadedShareables().add(CoreUtil.translateShareable(shareable));
            }
        }
        catch (FileSystemClientException e) {
            LogFactory.getLog((String)WorkspaceUpdateUtil.class.getName()).error((Object)Messages.WorkspaceUpdateUtil_FINDSHAREABLES_ERROR, (Throwable)e);
        }
        return conflictDto;
    }

    private static List<ChangeSetSyncDTO> translateChangeSets(IWorkspaceConnection wsConn, List<IChangeSetHandle> changes, IProgressMonitor progress) throws TeamRepositoryException {
        if (changes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ItemId<IChangeSet>> recast = new ArrayList<ItemId<IChangeSet>>(changes.size());
        for (IChangeSetHandle csHandle : changes) {
            recast.add(new ItemId((IItemHandle)csHandle));
        }
        ParmsResolveChangeSet csParms = new ParmsResolveChangeSet();
        csParms.context = new ParmsContext();
        csParms.context.repositoryUrl = wsConn.teamRepository().getRepositoryURI();
        csParms.context.itemId = wsConn.getContextHandle().getItemId().getUuidValue();
        csParms.context.type = "workspace";
        csParms.includeChanges = true;
        return SyncViewDTOUtil.createChangeSetDTOsFromChangeSets(wsConn.teamRepository(), recast, csParms, progress);
    }

    private static IWorkspaceUpdateOperation prepareWorkspaceUpdateOperation(ParmsWorkspaceUpdate parms, WorkspaceUpdateDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        List components;
        IWorkspaceConnection sourceWorkspace;
        IWorkspaceConnection workspace;
        int n;
        int n2;
        ParmsAcceptChangeSets[] parmsAcceptChangeSetsArray;
        SubMonitor subMonitor;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)600);
        IWorkspaceUpdateOperation workspaceUpdateOperation = IOperationFactory.instance.getWorkspaceUpdateOperation(dilemmaHandler);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)workspaceUpdateOperation);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, (IRefreshingOperation)workspaceUpdateOperation);
        workspaceUpdateOperation.setPopulateUpdateReport(parms.structuredResultOptions != null);
        if (parms.acceptChangeSets != null && parms.acceptChangeSets.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.acceptChangeSets.length * 10);
            parmsAcceptChangeSetsArray = parms.acceptChangeSets;
            n2 = parms.acceptChangeSets.length;
            n = 0;
            while (n < n2) {
                ParmsAcceptChangeSets acceptChangeSetsParm = parmsAcceptChangeSetsArray[n];
                ITeamRepository repo = CommonUtil.getTeamRepository((String)acceptChangeSetsParm.workspace.repositoryUrl);
                IWorkspaceConnection workspace2 = acceptChangeSetsParm.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
                String[] stringArray = acceptChangeSetsParm.changeSetItemIds;
                int n3 = acceptChangeSetsParm.changeSetItemIds.length;
                int n4 = 0;
                while (n4 < n3) {
                    String changeSetItemId = stringArray[n4];
                    changeSets.add(CommonUtil.createChangeSetHandle((ITeamRepository)repo, (String)changeSetItemId));
                    ++n4;
                }
                workspaceUpdateOperation.acceptChangeSets(workspace2, null, changeSets);
                ++n;
            }
        }
        if (parms.workspaceAcceptDetailed != null && parms.workspaceAcceptDetailed.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceAcceptDetailed.length * 30);
            parmsAcceptChangeSetsArray = parms.workspaceAcceptDetailed;
            n2 = parms.workspaceAcceptDetailed.length;
            n = 0;
            while (n < n2) {
                int n5;
                ParmsAcceptChangeSets workspaceAcceptDetailed = parmsAcceptChangeSetsArray[n];
                workspace = workspaceAcceptDetailed.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                ITeamRepository sourceRepo = CommonUtil.getTeamRepository((String)workspaceAcceptDetailed.sourceWorkspace.repositoryUrl);
                IWorkspaceConnection sourceWorkspace2 = workspaceAcceptDetailed.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                List baselines = workspaceAcceptDetailed.getBaselineHandles();
                ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
                if (workspaceAcceptDetailed.changeSetItemIds != null) {
                    String[] stringArray = workspaceAcceptDetailed.changeSetItemIds;
                    n5 = workspaceAcceptDetailed.changeSetItemIds.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String changeSetItemId = stringArray[n6];
                        changeSets.add(CommonUtil.createChangeSetHandle((ITeamRepository)sourceRepo, (String)changeSetItemId));
                        ++n6;
                    }
                }
                ArrayList<IComponentHandle> components2 = new ArrayList<IComponentHandle>();
                if (workspaceAcceptDetailed.componentItemIds != null) {
                    String[] stringArray = workspaceAcceptDetailed.componentItemIds;
                    int n7 = workspaceAcceptDetailed.componentItemIds.length;
                    n5 = 0;
                    while (n5 < n7) {
                        String componentItemId = stringArray[n5];
                        components2.add(CommonUtil.createComponentHandle((ITeamRepository)sourceRepo, (String)componentItemId));
                        ++n5;
                    }
                }
                IChangeHistorySyncReport syncReport = WorkspaceUpdateUtil.getSyncReport(workspace, sourceWorkspace2, (IProgressMonitor)subMonitor.newChild(10));
                workspaceUpdateOperation.accept(workspace, sourceWorkspace2, syncReport, baselines, changeSets, components2);
                ++n;
            }
        }
        if (parms.workspaceAccept != null && parms.workspaceAccept.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceAccept.length * 30);
            parmsAcceptChangeSetsArray = parms.workspaceAccept;
            n2 = parms.workspaceAccept.length;
            n = 0;
            while (n < n2) {
                ParmsAcceptChangeSets workspaceAccept = parmsAcceptChangeSetsArray[n];
                workspace = workspaceAccept.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                sourceWorkspace = workspaceAccept.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IChangeHistorySyncReport syncReport = WorkspaceUpdateUtil.getSyncReport(workspace, sourceWorkspace, (IProgressMonitor)subMonitor.newChild(10));
                workspaceUpdateOperation.accept(workspace, sourceWorkspace, syncReport);
                ++n;
            }
        }
        if (parms.workspaceReplaceWithBaseline != null && parms.workspaceReplaceWithBaseline.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceReplaceWithBaseline.length * 20);
            parmsAcceptChangeSetsArray = parms.workspaceReplaceWithBaseline;
            n2 = parms.workspaceReplaceWithBaseline.length;
            n = 0;
            while (n < n2) {
                ParmsAcceptChangeSets workspaceReplaceWithBaseline = parmsAcceptChangeSetsArray[n];
                workspace = workspaceReplaceWithBaseline.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IBaselineConnection sourceBaseline = workspaceReplaceWithBaseline.baseline.getBaselineConnection((IProgressMonitor)subMonitor.newChild(10));
                workspaceUpdateOperation.replace(workspace, sourceBaseline);
                ++n;
            }
        }
        if (parms.workspaceReplaceWithSnapshot != null && parms.workspaceReplaceWithSnapshot.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceReplaceWithSnapshot.length * 10);
            parmsAcceptChangeSetsArray = parms.workspaceReplaceWithSnapshot;
            n2 = parms.workspaceReplaceWithSnapshot.length;
            n = 0;
            while (n < n2) {
                ParmsAcceptChangeSets workspaceReplaceWithSnapshot = parmsAcceptChangeSetsArray[n];
                workspace = workspaceReplaceWithSnapshot.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IBaselineSetHandle sourceBaselineSet = workspaceReplaceWithSnapshot.baselineSet.getBaselineSetHandle();
                components = workspaceReplaceWithSnapshot.getComponentHandles();
                if (components.isEmpty()) {
                    workspaceUpdateOperation.replace(workspace, sourceBaselineSet);
                } else {
                    workspaceUpdateOperation.replace(workspace, sourceBaselineSet, components);
                }
                ++n;
            }
        }
        if (parms.workspaceReplaceWithWorkspace != null && parms.workspaceReplaceWithWorkspace.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceReplaceWithWorkspace.length * 10);
            parmsAcceptChangeSetsArray = parms.workspaceReplaceWithWorkspace;
            n2 = parms.workspaceReplaceWithWorkspace.length;
            n = 0;
            while (n < n2) {
                ParmsAcceptChangeSets workspaceReplaceWithWorkspace = parmsAcceptChangeSetsArray[n];
                workspace = workspaceReplaceWithWorkspace.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                sourceWorkspace = workspaceReplaceWithWorkspace.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                components = workspaceReplaceWithWorkspace.getComponentHandles();
                if (components.isEmpty()) {
                    workspaceUpdateOperation.replace(workspace, sourceWorkspace);
                } else {
                    workspaceUpdateOperation.replace(workspace, sourceWorkspace, components);
                }
                ++n;
            }
        }
        return workspaceUpdateOperation;
    }

    private static IChangeHistorySyncReport getSyncReport(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
        int flags = ((ComponentSyncModel)ComponentSyncModel.getInstance()).getCompareToFlags();
        IChangeHistorySyncReport syncReport = SyncCache.get().fetch((IWorkspaceConnection)workspace, (IWorkspaceConnection)sourceWorkspace, (int)flags, (IProgressMonitor)monitor).syncReport;
        return syncReport;
    }

    public static WorkspaceUpdateDilemmaHandler getWorkspaceUpdateDilemmaHandler(ParmsWorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaParms, ParmsPendingChangesDilemmaHandler pendingChangesDilemmaParms, ParmsOutOfSyncInstructions outOfSyncInstructions, ParmsBackupDilemmaHandler backupInstructions, final List<ConfigurationDescriptorDTO> componentFlowAdditions, final List<ConfigurationDescriptorDTO> componentFlowDeletions, final List<ConfigurationDescriptorDTO> componentReplacementCandidates, final List<ConfigurationDescriptorDTO> disconnectedComponents, final List<ConfigurationDescriptorDTO> configurationsWithPendingChanges, List<LineDelimiterErrorDTO> lineDelimiterErrors, List<EncodingErrorDTO> encodingErrors, List<ShareDTO> outOfSyncShares, final List<ProblemChangeSetsDTO> activeChangeSetsEncountered, final List<ProblemChangeSetsDTO> activeChangeSetsOverlapEncountered, final List<GapChangeSetsDTO> gapEncountered, List<BackupInShedDTO> backedUpInShed, List<NonAtomicCheckInDTO> nonAtomicCommitOffers) throws TeamRepositoryException {
        int gapInstruction;
        int activeChangeSetsOverlapInstruction;
        int activeChangeSetsInstruction;
        int staleDataInstruction;
        int disconnectedComponentsInstruction;
        int componentFlowInstruction;
        int replaceComponentsInstruction;
        if (workspaceUpdateDilemmaParms == null) {
            replaceComponentsInstruction = 2;
            componentFlowInstruction = 2;
            disconnectedComponentsInstruction = 2;
            staleDataInstruction = 2;
            activeChangeSetsInstruction = 2;
            activeChangeSetsOverlapInstruction = 2;
            gapInstruction = 2;
        } else {
            ParmsWorkspaceUpdateDilemmaHandler dilemmaParms = workspaceUpdateDilemmaParms;
            replaceComponentsInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.componentReplacementCandidatesDirection, true, "workspaceUpdateDilemmaHandler.componentReplacementCandidatesDirection");
            componentFlowInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.componentFlowDirection, true, "workspaceUpdateDilemmaHandler.componentFlowDirection");
            disconnectedComponentsInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.disconnectedComponentsDirection, false, "workspaceUpdateDilemmaHandler.disconnectedComponentsDirection");
            staleDataInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.staleDataDirection, false, "workspaceUpdateDilemmaHandler.staleDataDirection");
            activeChangeSetsInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.activeChangeSetsDirection, true, "activeChangeSetsDirection");
            activeChangeSetsOverlapInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.activeChangeSetsOverlapDirection, true, "activeChangeSetsOverlapDirection");
            gapInstruction = WorkspaceUpdateUtil.getInstruction(dilemmaParms.gapDirection, true, "gapDirection");
        }
        final int pendingChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(pendingChangesDilemmaParms);
        WorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaHandler = new WorkspaceUpdateDilemmaHandler(backupInstructions, backedUpInShed, outOfSyncInstructions, outOfSyncShares, pendingChangesDilemmaParms, lineDelimiterErrors, encodingErrors, nonAtomicCommitOffers){
            final BackupDilemmaHandler backupDilemmaHandler;
            final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler;
            final CommitDilemmaHandler commitDilemmaHandler;
            {
                this.backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parmsBackupDilemmaHandler, list);
                this.outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parmsOutOfSyncInstructions, list2, this.backupDilemmaHandler);
                this.commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parmsPendingChangesDilemmaHandler, this.outOfSyncDilemmaHandler, this.backupDilemmaHandler, (List<LineDelimiterErrorDTO>)list3, (List<EncodingErrorDTO>)list4, (List<NonAtomicCheckInDTO>)list5);
            }

            public int componentReplacementCandidates(Collection<ConfigurationDescriptor> replaceConfigurations) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(replaceConfigurations, componentReplacementCandidates);
                return replaceComponentsInstruction;
            }

            public int componentsToBeAddedOrRemoved(Collection<ConfigurationDescriptor> added, Collection<ConfigurationDescriptor> removed) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(added, componentFlowAdditions);
                WorkspaceUpdateUtil.recordConfigurationDescriptors(removed, componentFlowDeletions);
                return componentFlowInstruction;
            }

            public int disconnectedComponents(Collection<ConfigurationDescriptor> configurations) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(configurations, disconnectedComponents);
                return disconnectedComponentsInstruction;
            }

            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return this.commitDilemmaHandler;
            }

            public int staleData(IWorkspaceConnection workspaceConnection, IWorkspaceConnection sourceWorkspaceConnection) {
                return staleDataInstruction;
            }

            public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(changes.keySet(), configurationsWithPendingChanges);
                return pendingChangesInstruction;
            }

            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return this.outOfSyncDilemmaHandler;
            }

            public int activeChangeSets(IWorkspaceConnection workspace, Collection<IChangeSetHandle> activeChangeSets) {
                if (activeChangeSets != null) {
                    activeChangeSetsEncountered.add(CoreUtil.translateProblemChangeSetsDTO(workspace, activeChangeSets));
                }
                return activeChangeSetsInstruction;
            }

            public int activeChangeSetsOverlap(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> activeChangeSets) {
                if (activeChangeSetsOverlapEncountered != null) {
                    activeChangeSetsOverlapEncountered.add(CoreUtil.translateProblemChangeSetsDTO(workspace, activeChangeSets));
                }
                return activeChangeSetsOverlapInstruction;
            }

            public int gap(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSetsWithGap, boolean handlingSuspended) {
                if (gapEncountered != null) {
                    gapEncountered.add(CoreUtil.translateGapProblemChangeSetsDTO(workspace, changeSetsWithGap, handlingSuspended));
                }
                return gapInstruction;
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return this.backupDilemmaHandler;
            }
        };
        return workspaceUpdateDilemmaHandler;
    }

    private static void recordConfigurationDescriptors(Collection<ConfigurationDescriptor> configurationDescriptors, List<ConfigurationDescriptorDTO> configurationDescriptorDTOs) {
        if (configurationDescriptorDTOs != null) {
            for (ConfigurationDescriptor descriptor : configurationDescriptors) {
                configurationDescriptorDTOs.add(CoreUtil.translateConfigurationDescriptor(descriptor));
            }
        }
    }

    private static int getInstruction(String direction, boolean noIsValidDirection, String field) {
        int uncheckedInChangesInstruction = 2;
        if ("continue".equals(direction)) {
            uncheckedInChangesInstruction = 0;
        } else if (direction == null) {
            uncheckedInChangesInstruction = 2;
        } else if ("cancel".equals(direction)) {
            uncheckedInChangesInstruction = 1;
        } else if ("fail".equals(direction)) {
            uncheckedInChangesInstruction = 2;
        } else if ("no".equals(direction)) {
            uncheckedInChangesInstruction = 3;
        } else {
            if (noIsValidDirection) {
                throw new IllegalArgumentException(NLS.bind((String)"Invalid value {0} of {1} must be one of {2}, {3}, {4} or {5}", (Object[])new Object[]{direction, field, "cancel", "continue", "no", "fail"}, (Object[])new Object[0]));
            }
            throw new IllegalArgumentException(NLS.bind((String)"Invalid value {0} of {1} must be one of {2}, {3}, or {4}", (Object[])new Object[]{direction, field, "cancel", "continue", "fail"}, (Object[])new Object[0]));
        }
        return uncheckedInChangesInstruction;
    }
}

