/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.operations.UndoChangesOperation;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangesToRelocate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRelocateChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoCheckedInChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoLocalChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUndoLocalChangesRequest;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.BackupInShedDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.UndoCheckedInChangesResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.UndoLocalChangesResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoChangesUtil {
    private static final String UNDO_CHECKEDIN_CHANGES_REQUEST = "postUndoCheckedInChanges";
    private static final String UNDO_LOCAL_CHANGES_REQUEST = "postUndoLocalChanges";
    private static final String RELOCATE_CHANGES_REQUEST = "postRelocateChanges";

    public static UndoLocalChangesResultDTO undo(ParmsUndoLocalChanges parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        UndoLocalChangesResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createUndoLocalChangesResultDTO();
        UndoDilemmaHandler dilemmaHandler = UndoChangesUtil.getUndoDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.backupDilemmaHandler, result.getBackedUpToShed());
        ILocalChange[] changesToUndo = UndoChangesUtil.findChangesToUndo(parms, (IProgressMonitor)monitor.newChild(10));
        if (changesToUndo.length == 0) {
            return result;
        }
        ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
        try {
            lcm.undoChanges(changesToUndo, dilemmaHandler, (IProgressMonitor)monitor.newChild(65));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static ILocalChange[] findChangesToUndo(ParmsUndoLocalChanges parms, IProgressMonitor progress) throws TeamRepositoryException {
        int n;
        int n2;
        String[] stringArray;
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        HashMap changesToUndo = new HashMap();
        ParmsUndoLocalChangesRequest[] parmsUndoLocalChangesRequestArray = parms.undoRequests;
        int n3 = parms.undoRequests.length;
        int n4 = 0;
        while (n4 < n3) {
            ConfigurationDescriptor descriptor;
            HashSet<UUID> changes;
            ParmsUndoLocalChangesRequest request = parmsUndoLocalChangesRequestArray[n4];
            ITeamRepository repo = CommonUtil.getTeamRepository((String)request.workspace.repositoryUrl);
            IWorkspaceHandle workspace = request.workspace.getWorkspaceHandle();
            IComponentHandle component = request.getComponentHandle();
            ISandbox sandbox = sharingManager.getSandbox((IPath)new Path(request.sandboxPath), true);
            if (sandbox == null) break;
            HashMap changesToUndoForSandbox = (HashMap)changesToUndo.get(sandbox);
            if (changesToUndoForSandbox == null) {
                changesToUndoForSandbox = new HashMap();
                changesToUndo.put(sandbox, changesToUndoForSandbox);
            }
            if ((changes = (HashSet<UUID>)changesToUndoForSandbox.get(descriptor = new ConfigurationDescriptor(repo.getId(), repo.getRepositoryURI(), (IContextHandle)workspace, component))) == null) {
                changes = new HashSet<UUID>();
                changesToUndoForSandbox.put(descriptor, changes);
            }
            stringArray = request.versionableItemIds;
            n2 = request.versionableItemIds.length;
            n = 0;
            while (n < n2) {
                String versionableItemId = stringArray[n];
                changes.add(UUID.valueOf((String)versionableItemId));
                ++n;
            }
            ++n4;
        }
        ILocalChangeManager lcm = sharingManager.getLocalChangeManager();
        ArrayList<String> toUndo = new ArrayList<String>();
        for (Map.Entry entry : changesToUndo.entrySet()) {
            ISandbox sandbox = (ISandbox)entry.getKey();
            HashMap changesToUndoInSandbox = (HashMap)entry.getValue();
            for (Map.Entry entryToUndo : changesToUndoInSandbox.entrySet()) {
                ConfigurationDescriptor descriptor = (ConfigurationDescriptor)entryToUndo.getKey();
                HashSet versionableItemIds = (HashSet)entryToUndo.getValue();
                ILocalChange[] localChanges = lcm.getPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, sandbox);
                stringArray = localChanges;
                n2 = localChanges.length;
                n = 0;
                while (n < n2) {
                    String localChange = stringArray[n];
                    if (versionableItemIds.contains(localChange.getTarget().getItemId())) {
                        toUndo.add(localChange);
                    }
                    ++n;
                }
            }
        }
        return toUndo.toArray(new ILocalChange[toUndo.size()]);
    }

    public static UndoCheckedInChangesResultDTO undo(ParmsUndoCheckedInChanges parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        UndoCheckedInChangesResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createUndoCheckedInChangesResultDTO();
        UndoDilemmaHandler dilemmaHandler = UndoChangesUtil.getUndoDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.backupDilemmaHandler, result.getBackedUpToShed());
        UndoChangesOperation undoOperation = UndoChangesUtil.prepareUndoOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        if (undoOperation == null) {
            return result;
        }
        try {
            undoOperation.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static UndoDilemmaHandler getUndoDilemmaHandler(ParmsOutOfSyncInstructions outOfSyncInstructions, List<ShareDTO> outOfSyncShares, ParmsBackupDilemmaHandler backupInstructions, List<BackupInShedDTO> backedUpInShed) {
        UndoDilemmaHandler undoDilemmaHandler = new UndoDilemmaHandler(backupInstructions, backedUpInShed, outOfSyncInstructions, outOfSyncShares){
            final BackupDilemmaHandler backupDilemmaHandler;
            final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler;
            {
                this.backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parmsBackupDilemmaHandler, list);
                this.outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parmsOutOfSyncInstructions, list2, this.backupDilemmaHandler);
            }

            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return this.outOfSyncDilemmaHandler;
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return this.backupDilemmaHandler;
            }
        };
        return undoDilemmaHandler;
    }

    private static UndoChangesOperation prepareUndoOperation(ParmsUndoCheckedInChanges parms, UndoDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        HashSet versionableItemIds;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.workspace.repositoryUrl);
        IWorkspaceConnection workspace = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        UndoChangesOperation op = new UndoChangesOperation(workspace, dilemmaHandler);
        HashMap<UUID, HashSet> changes = new HashMap<UUID, HashSet>();
        ArrayList<IChangeSetHandle> csHandles = new ArrayList<IChangeSetHandle>(parms.changesToUndo.length);
        ParmsUndoChanges[] parmsUndoChangesArray = parms.changesToUndo;
        int n = parms.changesToUndo.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsUndoChanges changesToUndoParm = parmsUndoChangesArray[n2];
            IChangeSetHandle changeSet = CommonUtil.createChangeSetHandle((ITeamRepository)repo, (String)changesToUndoParm.changeSetItemId);
            csHandles.add(changeSet);
            versionableItemIds = (HashSet)changes.get(changeSet.getItemId());
            if (versionableItemIds == null) {
                versionableItemIds = new HashSet();
                changes.put(changeSet.getItemId(), versionableItemIds);
            }
            String[] stringArray = changesToUndoParm.versionableItemIds;
            int n3 = changesToUndoParm.versionableItemIds.length;
            int n4 = 0;
            while (n4 < n3) {
                String versionableToUndo = stringArray[n4];
                versionableItemIds.add(UUID.valueOf((String)versionableToUndo));
                ++n4;
            }
            ++n2;
        }
        boolean undo = false;
        List changeSets = repo.itemManager().fetchCompleteItems(csHandles, 0, (IProgressMonitor)monitor.newChild(90));
        int i = 0;
        for (IChangeSet changeSet : changeSets) {
            if (changeSet == null) {
                throw new IllegalArgumentException(NLS.bind((String)"Change set {0} with item id: {1} does not exist", (Object)i, (Object[])new Object[]{((IChangeSetHandle)csHandles.get(i)).getItemId().getUuidValue()}));
            }
            versionableItemIds = (HashSet)changes.get(changeSet.getItemId());
            ArrayList<IChange> changesToUndo = new ArrayList<IChange>(versionableItemIds.size());
            for (IChange change : changeSet.changes()) {
                if (!versionableItemIds.contains(change.item().getItemId())) continue;
                changesToUndo.add(change);
            }
            if (!changesToUndo.isEmpty()) {
                op.addChangesToUndo((IChangeSetHandle)changeSet, changesToUndo);
                undo = true;
            }
            ++i;
        }
        if (undo) {
            return op;
        }
        return null;
    }

    public static void relocateChanges(ParmsRelocateChanges parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<IChangeSetHandle> sourceChangeSets = new ArrayList<IChangeSetHandle>();
        ArrayList<IVersionableHandle> itemsToMove = new ArrayList<IVersionableHandle>();
        ArrayList<IChangeSetHandle> targetChangeSets = new ArrayList<IChangeSetHandle>();
        IWorkspaceConnection workspaceConnection = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        UndoChangesUtil.findChangesToRelocate(parms, workspaceConnection, sourceChangeSets, itemsToMove, targetChangeSets, (IProgressMonitor)monitor.newChild(20));
        if (!itemsToMove.isEmpty()) {
            workspaceConnection.relocateChanges(targetChangeSets, itemsToMove, sourceChangeSets, (IProgressMonitor)monitor.newChild(65));
            try {
                ComponentSyncModel.getInstance().refresh(true, (IProgressMonitor)monitor.newChild(10));
            }
            catch (FileSystemClientException e) {
                throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
            }
        }
    }

    private static void findChangesToRelocate(ParmsRelocateChanges parms, IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> sourceChangeSets, List<IVersionableHandle> itemsToMove, List<IChangeSetHandle> targetChangeSets, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = workspaceConnection.teamRepository();
        ArrayList<IChangeSetHandle> changeSetHandles = new ArrayList<IChangeSetHandle>(parms.changesToRelocate.length);
        ParmsChangesToRelocate[] parmsChangesToRelocateArray = parms.changesToRelocate;
        int n = parms.changesToRelocate.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsChangesToRelocate changesToRelocate = parmsChangesToRelocateArray[n2];
            changeSetHandles.add(CommonUtil.createChangeSetHandle((ITeamRepository)repo, (String)changesToRelocate.changeSetItemId));
            ++n2;
        }
        List changeSets = repo.itemManager().fetchCompleteItems(changeSetHandles, 0, (IProgressMonitor)monitor.newChild(50));
        IComponentHandle componentHandle = null;
        HashMap versionablesInChangeSets = new HashMap();
        int i = 0;
        while (i < parms.changesToRelocate.length) {
            IChangeSet changeSet = (IChangeSet)changeSets.get(i);
            if (changeSet == null) {
                throw new IllegalArgumentException(NLS.bind((String)"Change set {0} does not exist", (Object)((IChangeSetHandle)changeSetHandles.get(i)).getItemId().toString(), (Object[])new Object[0]));
            }
            if (componentHandle == null) {
                componentHandle = changeSet.getComponent();
            } else if (!componentHandle.sameItemId((IItemHandle)changeSet.getComponent())) {
                throw new IllegalArgumentException("The changes to be moved must all be from change sets within the same component");
            }
            HashMap<UUID, IVersionableHandle> versionablesInChangeSet = (HashMap<UUID, IVersionableHandle>)versionablesInChangeSets.get(changeSet.getItemId());
            if (versionablesInChangeSet == null) {
                versionablesInChangeSet = new HashMap<UUID, IVersionableHandle>();
                versionablesInChangeSets.put(changeSet.getItemId(), versionablesInChangeSet);
                for (IChange change : changeSet.changes()) {
                    versionablesInChangeSet.put(change.item().getItemId(), change.item());
                }
            }
            ++i;
        }
        i = 0;
        while (i < parms.changesToRelocate.length) {
            Map versionablesInChangeSet = (Map)versionablesInChangeSets.get(UUID.valueOf((String)parms.changesToRelocate[i].changeSetItemId));
            IVersionableHandle handle = (IVersionableHandle)versionablesInChangeSet.get(UUID.valueOf((String)parms.changesToRelocate[i].versionableItemId));
            if (handle == null) {
                throw new TeamRepositoryException(Messages.UndoChangesUtil_0);
            }
            sourceChangeSets.add((IChangeSetHandle)changeSetHandles.get(i));
            itemsToMove.add(handle);
            ++i;
        }
        if (!itemsToMove.isEmpty()) {
            IChangeSetHandle targetChangeSet = parms.targetChangeSetItemId == null || parms.targetChangeSetItemId.trim().length() == 0 ? workspaceConnection.createChangeSet(componentHandle, "", true, (IProgressMonitor)monitor.newChild(50)) : (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.targetChangeSetItemId), null);
            int i2 = 0;
            while (i2 < sourceChangeSets.size()) {
                targetChangeSets.add(targetChangeSet);
                ++i2;
            }
        }
    }
}

