/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxShare;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareOverlap;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShare;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShareRequest;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EncodingErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.share.FilesystemRestClientDTOshareFactory;
import com.ibm.team.filesystem.common.internal.rest.client.share.MultipleSandboxShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.share.ShareOverlapDTO;
import com.ibm.team.filesystem.common.internal.rest.client.share.ShareResultDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.IgnoresUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareUtil {
    public static ShareResultDTO share(final ParmsShare parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        final ShareResultDTO result = FilesystemRestClientDTOshareFactory.eINSTANCE.createShareResultDTO();
        final BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, result.getBackedUpToShed());
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.commitDilemmaHandler, null, backupDilemmaHandler, null, (List<EncodingErrorDTO>)result.getEncodingFailures(), null);
        ShareDilemmaHandler shareDilemmaHandler = new ShareDilemmaHandler(){

            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return new OutOfSyncDilemmaHandler(){

                    public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                        return 0;
                    }

                    public boolean willIgnoreAllSharesOutOfSync() {
                        return true;
                    }
                };
            }

            public int overlappingShareRequests(Collection<? extends IShareOverlap> projectShares) {
                for (IShareOverlap iShareOverlap : projectShares) {
                    result.getShareOverlaps().add(this.translateShareOverlap(iShareOverlap));
                }
                return 0;
            }

            public int multipleSandboxesForConfigurations(Collection<? extends IMultipleSandboxShare> multipleSandboxesForShares) {
                for (IMultipleSandboxShare iMultipleSandboxShare : multipleSandboxesForShares) {
                    result.getMultipleSandboxShares().add(this.translateMultipleSandboxShare(iMultipleSandboxShare));
                }
                return parms.getMultipleSandboxDirection();
            }

            private Object translateMultipleSandboxShare(IMultipleSandboxShare multiSandboxShare) {
                MultipleSandboxShareDTO multipleSandboxShare = FilesystemRestClientDTOshareFactory.eINSTANCE.createMultipleSandboxShareDTO();
                multipleSandboxShare.setConfiguration(CoreUtil.translateConfigurationDescriptor(multiSandboxShare.getConfiguration()));
                for (ISandbox sandbox : multiSandboxShare.getSandboxes()) {
                    multipleSandboxShare.getSandboxes().add(sandbox.getRoot().toOSString());
                }
                for (IShareable shareRoot : multiSandboxShare.getShareables()) {
                    multipleSandboxShare.getRoots().add(CoreUtil.translateShareable(shareRoot));
                }
                return multipleSandboxShare;
            }

            private ShareOverlapDTO translateShareOverlap(IShareOverlap overlap) {
                ShareOverlapDTO shareOverlap = FilesystemRestClientDTOshareFactory.eINSTANCE.createShareOverlapDTO();
                shareOverlap.setRepositoryURL(overlap.getConnection().teamRepository().getRepositoryURI());
                shareOverlap.setWorkspaceItemId(overlap.getConnection().getContextHandle().getItemId().getUuidValue());
                shareOverlap.setComponentItemId(overlap.getComponent().getItemId().getUuidValue());
                shareOverlap.setRoot(CoreUtil.translateShareable(overlap.getShareRoot()));
                for (IShareable shareable : overlap.getOverlappingShareRoots()) {
                    shareOverlap.getOverlappingRoots().add(CoreUtil.translateShareable(shareable));
                }
                for (IShare share : overlap.getOverlappingShares()) {
                    shareOverlap.getOverlappingShares().add(CoreUtil.translateShare(share));
                }
                return shareOverlap;
            }

            public int encodingErrors(Collection<? extends IEncodingUploadFailure> failedUploads, IProgressMonitor monitor) {
                return commitDilemmaHandler.encodingErrors(failedUploads, monitor);
            }

            public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemClientException {
                return commitDilemmaHandler.lineDelimiterErrors(failedFiles, monitor);
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return backupDilemmaHandler;
            }
        };
        IShareOperation shareOperation = ShareUtil.prepareShareRequest(parms, shareDilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        try {
            shareOperation.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        for (IChangeSetHandle changeSetHandle : shareOperation.getCommittedChangeSets()) {
            result.getChangeSetsCommitted().add(changeSetHandle.getItemId().getUuidValue());
        }
        return result;
    }

    private static IShareOperation prepareShareRequest(ParmsShare parms, ShareDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IShareOperation op = IOperationFactory.instance.getShareOperation(dilemmaHandler);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)parms.shareRequests.length);
        ParmsShareRequest[] parmsShareRequestArray = parms.shareRequests;
        int n = parms.shareRequests.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsShareRequest request = parmsShareRequestArray[n2];
            SubMonitor loopMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(1), (int)60);
            IWorkspaceConnection workspace = request.workspace.getWorkspaceConnection((IProgressMonitor)loopMonitor.newChild(10));
            ISandbox sandbox = SharingManager.getInstance().getSandbox((IPath)new Path(request.sandboxPath), false);
            ArrayList<Path> itemsToShare = new ArrayList<Path>(request.itemsToShare.length);
            String[] stringArray = request.itemsToShare;
            int n3 = request.itemsToShare.length;
            int n4 = 0;
            while (n4 < n3) {
                String itemRelativePath = stringArray[n4];
                itemsToShare.add(new Path(itemRelativePath));
                ++n4;
            }
            String[] newFolderNames = request.newFolderPath == null || request.newFolderPath.trim().length() == 0 ? new String[]{} : new Path(request.newFolderPath).segments();
            IComponentHandle component = request.getComponentHandle();
            if (component == null) {
                op.share(workspace, request.componentName, newFolderNames, sandbox, itemsToShare, parms.overwrite.booleanValue(), (IProgressMonitor)loopMonitor.newChild(10));
            } else {
                IChangeSetHandle changeSet = request.getChangeSetHandle();
                IFolderHandle parentFolder = request.getParentFolderHandle();
                op.share(workspace, changeSet, component, parentFolder, newFolderNames, sandbox, itemsToShare, parms.overwrite.booleanValue(), (IProgressMonitor)loopMonitor.newChild(10));
            }
            if (request.ignoreRules != null) {
                ShareUtil.purgeIgnoresBeforeShare(request, loopMonitor.newChild(10));
                if (request.ignoreRules.length > 0) {
                    IgnoresUtil.ValidatedIgnoreRuleList val;
                    DefaultIgnoreProvider dip = (DefaultIgnoreProvider)IgnoreManager.getInstance().getIgnoreProvider("default", (IProgressMonitor)loopMonitor.newChild(1));
                    try {
                        val = IgnoresUtil.validateIgnoreRuleList(workspace, component, dip, request.ignoreRules, (IProgressMonitor)loopMonitor.newChild(1));
                    }
                    catch (FileSystemClientException e) {
                        throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
                    }
                    SubMonitor ruleMonitor = SubMonitor.convert((IProgressMonitor)loopMonitor.newChild(8), (int)val.rules.size());
                    for (IgnoreRule rule : val.rules) {
                        try {
                            dip.addIgnoreRule((IIgnoreProvider.IIgnoreRule)rule, (IProgressMonitor)ruleMonitor.newChild(1));
                        }
                        catch (FileSystemClientException e) {
                            throw new TeamRepositoryException(NLS.bind((String)Messages.ShareUtil_FAILURE_CREATING_IGNORE_RULE, (Object)rule.getMatcher().getPattern()), (Throwable)e);
                        }
                    }
                    ruleMonitor.done();
                    dip.clearFileCache();
                }
            }
            loopMonitor.done();
            ++n2;
        }
        return op;
    }

    private static void purgeIgnoresBeforeShare(ParmsShareRequest request, SubMonitor monitor) throws TeamRepositoryException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(request.itemsToShare.length * 2));
        int i = 1;
        String[] stringArray = request.itemsToShare;
        int n = request.itemsToShare.length;
        int n2 = 0;
        while (n2 < n) {
            String relativeShareRoot = stringArray[n2];
            File shareRoot = new Path(request.sandboxPath).append(relativeShareRoot).toFile();
            monitor.setTaskName(NLS.bind((String)Messages.ShareUtil_PURGING_IGNORES_FROM_PROJECT, (Object[])new Object[]{shareRoot, i++, request.itemsToShare.length}));
            LinkedList<File> toDelete = new LinkedList<File>();
            ShareUtil.visit(shareRoot, toDelete, (IProgressMonitor)monitor.newChild(1));
            SubMonitor victimMonitor = monitor.newChild(1);
            victimMonitor.setWorkRemaining(toDelete.size());
            for (File staleIgnoreFile : toDelete) {
                victimMonitor.subTask(NLS.bind((String)Messages.ShareUtil_DELETING_IGNORE_FILE, (Object)staleIgnoreFile.getAbsolutePath()));
                if (staleIgnoreFile.delete()) continue;
                throw new TeamRepositoryException(NLS.bind((String)Messages.ShareUtil_FAILED_TO_PURGE_IGNORES, (Object)staleIgnoreFile.getAbsolutePath()));
            }
            ++n2;
        }
    }

    private static void visit(File file, LinkedList<File> toDelete, IProgressMonitor progress) throws TeamRepositoryException {
        if (file.getName().equals(".jazzignore")) {
            toDelete.add(file);
        } else {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath()));
            try {
                File[] children;
                IFileInfo fileInfo = fileStore.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                if (!fileInfo.getAttribute(32) && (children = file.listFiles()) != null) {
                    monitor.setWorkRemaining(children.length);
                    File[] fileArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        ShareUtil.visit(child, toDelete, (IProgressMonitor)monitor.newChild(1));
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.ShareUtil_0, (Object)file.getAbsolutePath()), (Throwable)e);
            }
        }
    }
}

