/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.magic.LocalContentExaminer;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangeFilePropertiesOperation;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSummary;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterErrorInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyUpdates;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxPaths;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IChangeSetSummary;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ChangeSummaryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilesystemRestClientDTOresourceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.resource.IgnoreReasonDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertyChangeResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SandboxPathsResultDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.IgnoresUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    public static ResourcesDTO getResourceProperties(ParmsResourceProperties parms, IProgressMonitor progress) throws TeamRepositoryException {
        boolean computeFully;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(2 * parms.fullResourcePaths.length + 1));
        boolean bl = computeFully = parms.computeFully != null && parms.computeFully != false;
        if (computeFully) {
            monitor.setWorkRemaining(parms.fullResourcePaths.length * 3);
        }
        HashMap<ConfigurationDescriptor, ArrayList<ResourcePropertiesDTO>> sharePaths = new HashMap<ConfigurationDescriptor, ArrayList<ResourcePropertiesDTO>>();
        ArrayList<IShareable> shareables = new ArrayList<IShareable>(parms.fullResourcePaths.length);
        String[] stringArray = parms.fullResourcePaths;
        int n = parms.fullResourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String fullResourceStringPath = stringArray[n2];
            Path path = new Path(fullResourceStringPath);
            try {
                ResourceType resourceType = PathUtils.getResourceType((IPath)path, (IProgressMonitor)monitor.newChild(1));
                if (resourceType == null) {
                    resourceType = ResourceType.FILE;
                }
                shareables.add(SharingManager.getInstance().findShareable((IPath)path, resourceType));
            }
            catch (FileSystemClientException e) {
                throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
            }
            ++n2;
        }
        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareables, (IProgressMonitor)monitor.newChild(1));
        ResourcesDTO resources = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcesDTO();
        int path = 0;
        for (IShareable iShareable : shareables) {
            SubMonitor resourceMonitor = monitor.newChild(1);
            resourceMonitor.setWorkRemaining(100);
            ResourcePropertiesDTO resourceProperties = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcePropertiesDTO();
            resources.getResourceProperties().add(resourceProperties);
            resourceProperties.setFullPath(parms.fullResourcePaths[path++]);
            if (iShareable != null) {
                resourceProperties.setPath(CoreUtil.translateShareable(iShareable));
                try {
                    ResourceType type = iShareable.getResourceType((IProgressMonitor)resourceMonitor.newChild(5));
                    resourceProperties.setLocal(type != null);
                    IShare share = iShareable.getShare((IProgressMonitor)resourceMonitor.newChild(10));
                    resourceProperties.setShared(share != null);
                    if (!resourceProperties.isShared()) {
                        resourceProperties.setRemote(false);
                    } else {
                        IVersionableHandle versionable;
                        assert (share != null);
                        ISharingDescriptor descriptor = share.getSharingDescriptor();
                        resourceProperties.setShare(CoreUtil.translateShare(share));
                        resourceProperties.setIgnored(iShareable.shouldBeIgnored((IProgressMonitor)resourceMonitor.newChild(15)));
                        if (computeFully && resourceProperties.isIgnored()) {
                            ResourceUtil.getResourceIgnoreProperties(iShareable, resourceProperties, resourceMonitor.newChild(10));
                        }
                        if ((versionable = iShareable.getVersionable((IProgressMonitor)resourceMonitor.newChild(15))) == null) {
                            resourceProperties.setRemote(false);
                        } else {
                            resourceProperties.setItemId(versionable.getItemId().getUuidValue());
                            resourceProperties.setVersionableItemType(CoreUtil.getVersionableItemType(versionable));
                            if (versionable.hasStateId()) {
                                resourceProperties.setStateId(versionable.getStateId().getUuidValue());
                                resourceProperties.setRemote(true);
                                if (computeFully) {
                                    ConfigurationDescriptor configDescriptor = new ConfigurationDescriptor(descriptor.getRepositoryId(), descriptor.getRepositoryUri(), descriptor.getConnectionHandle(), descriptor.getComponent());
                                    ArrayList<ResourcePropertiesDTO> properties = (ArrayList<ResourcePropertiesDTO>)sharePaths.get(configDescriptor);
                                    if (properties == null) {
                                        properties = new ArrayList<ResourcePropertiesDTO>();
                                        sharePaths.put(configDescriptor, properties);
                                    }
                                    properties.add(resourceProperties);
                                }
                            } else {
                                resourceProperties.setRemote(false);
                            }
                        }
                        ILocalChange pendingChange = LocalChangeManager.getInstance().getPendingChange(iShareable, (IProgressMonitor)resourceMonitor.newChild(15));
                        resourceProperties.setDirty(pendingChange.getType() != 0);
                        if (type == ResourceType.FILE) {
                            resourceProperties.setVersionableItemType("file");
                            FileItemInfo info = ((Shareable)iShareable).getFileItemInfo((IProgressMonitor)resourceMonitor.newChild(15));
                            if (info != null) {
                                FilePropertiesDTO fileProperties = FilesystemRestClientDTOresourceFactory.eINSTANCE.createFilePropertiesDTO();
                                fileProperties.setContentType(info.getContentType());
                                if (info.getLineDelimiter() != null) {
                                    fileProperties.setLineDelimiter(info.getLineDelimiter().toString());
                                }
                                fileProperties.setOriginalContentType(info.getOriginalContentType());
                                if (info.getOriginalLineDelimiter() != null) {
                                    fileProperties.setOriginalLineDelimiter(info.getOriginalLineDelimiter().toString());
                                }
                                fileProperties.setExecutable(iShareable.isExecutable((IProgressMonitor)resourceMonitor.newChild(15)));
                                fileProperties.setOriginalExecutable(info.isOriginalExecutable());
                                fileProperties.setOriginalEncoding(info.getStoredEncoding());
                                resourceProperties.setFileProperties(fileProperties);
                            }
                        } else if (type == ResourceType.FOLDER) {
                            resourceProperties.setVersionableItemType("folder");
                        } else if (type == ResourceType.SYMBOLIC_LINK) {
                            resourceProperties.setVersionableItemType("symbolic_link");
                        }
                    }
                }
                catch (FileSystemClientException e) {
                    throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
                }
            }
            resourceMonitor.done();
        }
        if (computeFully) {
            monitor = monitor.setWorkRemaining(sharePaths.size() * 30);
            for (Map.Entry entry : sharePaths.entrySet()) {
                IConfiguration configuration = ((ConfigurationDescriptor)entry.getKey()).getConfiguration((IProgressMonitor)monitor.newChild(10));
                List properties = (List)entry.getValue();
                ArrayList<Object> versionables = new ArrayList<Object>(properties.size());
                for (ResourcePropertiesDTO resourceProperties : properties) {
                    if ("folder".equals(resourceProperties.getVersionableItemType())) {
                        versionables.add((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)configuration.teamRepository(), UUID.valueOf((String)resourceProperties.getItemId()), null));
                        continue;
                    }
                    if ("file".equals(resourceProperties.getVersionableItemType())) {
                        versionables.add((IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)configuration.teamRepository(), UUID.valueOf((String)resourceProperties.getItemId()), null));
                        continue;
                    }
                    if (!"file".equals(resourceProperties.getVersionableItemType())) continue;
                    versionables.add((ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle((Object)configuration.teamRepository(), UUID.valueOf((String)resourceProperties.getItemId()), null));
                }
                List ancestors = configuration.locateAncestors(versionables, (IProgressMonitor)monitor.newChild(20));
                int i = 0;
                for (IAncestorReport report : ancestors) {
                    ResourcePropertiesDTO resourceProperties = (ResourcePropertiesDTO)properties.get(i);
                    ++i;
                    if (report.getNameItemPairs().isEmpty()) continue;
                    resourceProperties.setRemotePath(CoreUtil.translatePath(report));
                }
            }
        }
        return resources;
    }

    private static void getResourceIgnoreProperties(IShareable shareable, ResourcePropertiesDTO resourceProperties, SubMonitor monitor) {
        IIgnoreManager.IIgnoreReason reasons;
        try {
            reasons = IgnoreManager.getInstance().findIgnoreReasons(shareable, (IProgressMonitor)monitor);
        }
        catch (FileSystemClientException fileSystemClientException) {
            return;
        }
        if (reasons == null) {
            return;
        }
        IgnoreReasonDTO reasonDTO = FilesystemRestClientDTOresourceFactory.eINSTANCE.createIgnoreReasonDTO();
        PathDTO inheritPath = null;
        if (reasons.inherited()) {
            inheritPath = CoreUtil.translatePath(reasons.inheritsFrom().getLocalPath());
        }
        reasonDTO.setInheritsFrom(inheritPath);
        for (IIgnoreProvider.IIgnoreRule rule : reasons.getRules()) {
            reasonDTO.getRules().add(IgnoresUtil.translateRule(rule));
        }
        resourceProperties.setIgnoreReason(reasonDTO);
    }

    public static ChangePropertiesDilemmaHandler getChangePropertiesDilemmaHandler(ParmsLineDelimiterDilemmaHandler lineDelimiterDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported, ParmsOutOfSyncInstructions outOfSyncDilemmaHandler, List<ShareDTO> sharesOutOfSync, final BackupDilemmaHandler backupDilemmaHandler) {
        final LineDelimiterErrorHandler lineDelimiterErrorHandler = new LineDelimiterErrorHandler(lineDelimiterDilemmaHandler, lineDelimiterErrorsReported);
        final OutOfSyncDilemmaHandler oosDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(outOfSyncDilemmaHandler, sharesOutOfSync, backupDilemmaHandler);
        ChangePropertiesDilemmaHandler dilemmaHandler = new ChangePropertiesDilemmaHandler(){

            public int inconsistentLineDelimiters(List<IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) throws FileSystemClientException {
                return lineDelimiterErrorHandler.inconsistentLineDelimiters(inconsistentDelimiters, monitor);
            }

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                return oosDilemmaHandler.outOfSync(sharesOutOfSync);
            }

            public boolean willIgnoreAllSharesOutOfSync() {
                return oosDilemmaHandler.willIgnoreAllSharesOutOfSync();
            }

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                return oosDilemmaHandler.collision(collisions, removedShares, sharesOutOfSync);
            }

            public int invalidLoadRequest(Collection<IInvalidLoadRequest> requests) {
                return oosDilemmaHandler.invalidLoadRequest(requests);
            }

            public int newItemsToLoad(Collection<IShareableToLoad> sharesToLoad) {
                return oosDilemmaHandler.newItemsToLoad(sharesToLoad);
            }

            public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
                return oosDilemmaHandler.overlappingLoadRequests(foldersOverlapping);
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return backupDilemmaHandler;
            }
        };
        return dilemmaHandler;
    }

    public static LineDelimiterErrorDTO translateLineDelimiterError(IShareable shareable, FileLineDelimiter incompatibleLineDelimiterSetting, IProgressMonitor monitor) throws FileSystemClientException {
        LineDelimiterErrorDTO failedUpload = FilesystemRestClientDTOresourceFactory.eINSTANCE.createLineDelimiterErrorDTO();
        failedUpload.setFileName(CoreUtil.translatePath(shareable.getLocalPath()));
        failedUpload.setShare(CoreUtil.translateShare(shareable.getShare(monitor)));
        if (incompatibleLineDelimiterSetting != null) {
            failedUpload.setLineDelimiter(ResourceUtil.getLineDelimiter(incompatibleLineDelimiterSetting));
        }
        return failedUpload;
    }

    public static ResourcePropertyChangeResultDTO postResourceProperties(ParmsResourcePropertyUpdates parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ResourcePropertyChangeResultDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcePropertyChangeResultDTO();
        BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, result.getBackedUpToShed());
        ChangePropertiesDilemmaHandler dilemmaHandler = ResourceUtil.getChangePropertiesDilemmaHandler(parms.lineDelimiterDilemmaHandler, result.getLineDelimiterFailures(), parms.outOfSyncInstructions, result.getOutOfSyncShares(), backupDilemmaHandler);
        try {
            IChangeFilePropertiesOperation op = ResourceUtil.prepareChangePropertyOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static IChangeFilePropertiesOperation prepareChangePropertyOperation(ParmsResourcePropertyUpdates parms, ChangePropertiesDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        IChangeFilePropertiesOperation op = IOperationFactory.instance.getChangeFilePropertiesOperation(dilemmaHandler);
        ParmsResourcePropertyChange[] parmsResourcePropertyChangeArray = parms.resourcePropertyChanges;
        int n = parms.resourcePropertyChanges.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsResourcePropertyChange propertyChangeRequest = parmsResourcePropertyChangeArray[n2];
            IShareable shareable = ResourceUtil.findShareableFor(propertyChangeRequest.sandboxPath, propertyChangeRequest.filePath, progress);
            if (propertyChangeRequest.lineDelimiter != null && propertyChangeRequest.lineDelimiter.length() > 0) {
                FileLineDelimiter lineDelimiter = ResourceUtil.getLineDelimiter(propertyChangeRequest.lineDelimiter);
                op.setLineDelimiter(shareable, lineDelimiter);
            }
            if (propertyChangeRequest.mimeType != null && propertyChangeRequest.mimeType.length() > 0) {
                op.setContentType(shareable, propertyChangeRequest.mimeType);
            }
            ++n2;
        }
        return op;
    }

    private static FileLineDelimiter getLineDelimiter(String lineDelimiterSetting) {
        return LocalContentExaminer.getLineDelimiter((String)lineDelimiterSetting);
    }

    private static String getLineDelimiter(FileLineDelimiter lineDelimiterSetting) {
        return LocalContentExaminer.getLineDelimiter((FileLineDelimiter)lineDelimiterSetting);
    }

    public static IShareable findShareableFor(String sandboxPath, String path, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        ISandbox sandbox = SharingManager.getInstance().getSandbox((IPath)new Path(sandboxPath), true);
        if (sandbox == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.ResourceUtil_0, (Object)sandboxPath, (Object[])new Object[0]));
        }
        Path resourcePath = new Path(path);
        ResourceType resourceType = PathUtils.getResourceType((IPath)sandbox.getRoot().append(path), (IProgressMonitor)progress);
        if (resourceType == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.ResourceUtil_1, (Object)path, (Object[])new Object[0]));
        }
        return sandbox.findShareable((IPath)resourcePath, resourceType);
    }

    public static SandboxPathsResultDTO getSandboxPaths(ParmsSandboxPaths parms, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)parms.pathsToResolve.length);
        SandboxPathsResultDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createSandboxPathsResultDTO();
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SharingManager sm = SharingManager.getInstance();
        String[] stringArray = parms.pathsToResolve;
        int n = parms.pathsToResolve.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable shareable;
            ResourceType resourceType;
            String completePath = stringArray[n2];
            Path path = new Path(completePath);
            path.toFile();
            try {
                resourceType = PathUtils.getResourceType((IPath)path, (IProgressMonitor)monitor.newChild(1));
                if (resourceType == null) {
                    resourceType = ResourceType.FILE;
                }
            }
            catch (FileSystemClientException fileSystemClientException) {
                resourceType = ResourceType.FILE;
            }
            if ((shareable = sm.findShareable((IPath)path, resourceType)) == null && cfaMgr.copyFileAreaExists((IPath)path, 0)) {
                shareable = new Shareable((IPath)path, (IPath)Path.EMPTY, ResourceType.FOLDER);
            }
            if (shareable == null && parms.includeNonRegisteredSandboxes) {
                Path sandboxPath = path;
                Path relativePath = Path.EMPTY;
                while (sandboxPath.segmentCount() > 0 && shareable == null) {
                    if (cfaMgr.copyFileAreaExists((IPath)sandboxPath, 2)) {
                        relativePath = path.removeFirstSegments(sandboxPath.segmentCount()).setDevice(null).makeRelative();
                        shareable = new Shareable((IPath)sandboxPath, (IPath)relativePath, resourceType);
                        continue;
                    }
                    sandboxPath = sandboxPath.removeLastSegments(1);
                }
            }
            result.getPaths().add(CoreUtil.translateShareable(shareable));
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
        return result;
    }

    public static ChangeSummaryDTO getChangeSummary(ParmsChangeSummary parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ChangeSummaryDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createChangeSummaryDTO();
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        ITeamRepository repo = wc.teamRepository();
        IChangeSetHandle handle = CommonUtil.createChangeSetHandle((ITeamRepository)repo, (String)parms.changeSetItemId);
        IChangeSet changeSet = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)monitor.newChild(10));
        IFileSystemView fsv = FileSystemCore.getFileSystemManager((ITeamRepository)repo).getFileSystemView((IConnection)wc);
        List summaries = fsv.interpretChanges(Collections.singletonList(changeSet), (IProgressMonitor)monitor.newChild(80));
        IChangeSetSummary summary = (IChangeSetSummary)summaries.get(0);
        IChangeSummary changeSummary = null;
        for (IChangeSummary cs : summary.changes()) {
            if (!cs.item().getItemId().getUuidValue().equals(parms.versionableItemId)) continue;
            changeSummary = cs;
            break;
        }
        if (changeSummary == null) {
            throw new TeamRepositoryException("Resource not found in given change set");
        }
        if (changeSummary.afterState() != null) {
            result.setAfterStateId(changeSummary.afterState().getStateId().getUuidValue());
        }
        if (changeSummary.beforeState() != null) {
            result.setBeforeStateId(changeSummary.beforeState().getStateId().getUuidValue());
        }
        for (IChange change : changeSet.changes()) {
            IVersionableHandle lastMergeState;
            if (!change.item().getItemId().equals((Object)parms.versionableItemId)) continue;
            if (change.mergeStates().size() <= 0 || (lastMergeState = (IVersionableHandle)change.mergeStates().get(change.mergeStates().size() - 1)) == null || lastMergeState.getStateId() == null) break;
            result.setLastMergeState(lastMergeState.getStateId().getUuidValue());
            break;
        }
        result.setPathHint(ComponentSyncUtil.toString(changeSummary.getPathHint(), false));
        String[] newPathHint = changeSummary.getNewPathHint();
        if (newPathHint != null) {
            result.setNewPathHint(ComponentSyncUtil.toString(newPathHint, false));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineDelimiterErrorHandler {
        private final Map<String, Boolean> lineDelimiterInstructions;
        private final int generalLineDelimiterDirection;
        private final List<LineDelimiterErrorDTO> lineDelimiterErrorsReported;

        public LineDelimiterErrorHandler(ParmsLineDelimiterDilemmaHandler parmsLineDelimiterDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported) {
            if (parmsLineDelimiterDilemmaHandler == null) {
                this.generalLineDelimiterDirection = 2;
                this.lineDelimiterInstructions = Collections.EMPTY_MAP;
            } else {
                this.generalLineDelimiterDirection = this.getDirection(parmsLineDelimiterDilemmaHandler.generalLineDelimiterErrorInstruction);
                this.lineDelimiterInstructions = this.initializeLineDelimiterInstructions(parmsLineDelimiterDilemmaHandler.lineDelimiterErrorInstructions);
            }
            this.lineDelimiterErrorsReported = lineDelimiterErrorsReported;
        }

        private HashMap<String, Boolean> initializeLineDelimiterInstructions(ParmsLineDelimiterErrorInstructions[] lineDelimiterErrorInstructions) {
            HashMap<String, Boolean> instructions = new HashMap<String, Boolean>();
            if (lineDelimiterErrorInstructions != null) {
                int i = 0;
                while (i < lineDelimiterErrorInstructions.length) {
                    ParmsLineDelimiterErrorInstructions instruction = lineDelimiterErrorInstructions[i];
                    IPath path = new Path(instruction.sandboxPath).append(instruction.filePath);
                    path.removeTrailingSeparator();
                    instructions.put(path.toString(), instruction.forceConsistentDelimiters);
                    ++i;
                }
            }
            return instructions;
        }

        private int getDirection(String direction) {
            if ("cancel".equals(direction)) {
                return 1;
            }
            if ("continue".equals(direction)) {
                return 0;
            }
            return 2;
        }

        public int inconsistentLineDelimiters(List<IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) throws FileSystemClientException {
            if (this.lineDelimiterErrorsReported != null) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)inconsistentDelimiters.size());
                for (IChangePropertiesRequest request : inconsistentDelimiters) {
                    SubMonitor subProgress = progress.newChild(1).setWorkRemaining(100);
                    FileLineDelimiter d = request.getLineDelimiter((IProgressMonitor)subProgress.newChild(30));
                    this.lineDelimiterErrorsReported.add(ResourceUtil.translateLineDelimiterError(request.getShareableToChange(), d, (IProgressMonitor)subProgress.newChild(70)));
                }
            }
            boolean followGeneralInstruction = false;
            for (IChangePropertiesRequest request : inconsistentDelimiters) {
                IPath path = request.getShareableToChange().getFullPath();
                path.removeTrailingSeparator();
                Boolean instruction = this.lineDelimiterInstructions.get(path.toString());
                if (instruction == null) {
                    if (this.generalLineDelimiterDirection == 0) {
                        request.setForceLineDelimiterConversion(false);
                    }
                    followGeneralInstruction = true;
                    continue;
                }
                request.setForceLineDelimiterConversion(instruction.booleanValue());
            }
            if (followGeneralInstruction) {
                return this.generalLineDelimiterDirection;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemClientException {
            if (this.lineDelimiterErrorsReported != null) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 * failedFiles.size()));
                List<LineDelimiterErrorDTO> list = this.lineDelimiterErrorsReported;
                synchronized (list) {
                    for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
                        FileLineDelimiter ld = iLineDelimiterUploadFailure.getShareable().getLineDelimiter((IProgressMonitor)progress.newChild(5));
                        this.lineDelimiterErrorsReported.add(ResourceUtil.translateLineDelimiterError(iLineDelimiterUploadFailure.getShareable(), ld, (IProgressMonitor)progress.newChild(5)));
                    }
                }
            }
            int result = 0;
            for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
                IPath path = iLineDelimiterUploadFailure.getShareable().getFullPath();
                path.removeTrailingSeparator();
                Boolean instruction = this.lineDelimiterInstructions.get(path.toString());
                if (instruction == null) {
                    if (this.generalLineDelimiterDirection == 0) {
                        iLineDelimiterUploadFailure.setForceConsistentDelimiters(false);
                        continue;
                    }
                    result = this.generalLineDelimiterDirection;
                    break;
                }
                iLineDelimiterUploadFailure.setForceConsistentDelimiters(instruction.booleanValue());
            }
            return result;
        }
    }
}

