/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPreOperationRefresh;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRecomputeLocalChanges;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class RefreshUtil {
    /*
     * WARNING - void declaration
     */
    public static void recomputeLocalChanges(ParmsRecomputeLocalChanges parm, IProgressMonitor progress) throws TeamRepositoryException {
        try {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)101);
            ISandbox sandbox = SharingManager.getInstance().getSandbox((IPath)new Path(parm.sandboxPath), true);
            if (sandbox == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.RefreshUtil_0, (Object)parm.sandboxPath));
            }
            if (parm.paths == null || parm.paths.length == 0) {
                SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(null, (IProgressMonitor)monitor.newChild(1));
                IShare[] shares = sandbox.allShares((IProgressMonitor)monitor.newChild(10));
                LocalChangeManager.getInstance().refreshChanges(shares, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)monitor.newChild(90));
            } else {
                void var7_12;
                LocalChangeManager lcm = LocalChangeManager.getInstance();
                monitor.setWorkRemaining(10 * parm.paths.length);
                ArrayList<Shareable> shareables = new ArrayList<Shareable>(parm.paths.length);
                String[] stringArray = parm.paths;
                int n = parm.paths.length;
                boolean n2 = false;
                while (var7_12 < n) {
                    Shareable shareable;
                    String relativePath = stringArray[var7_12];
                    IPath path = sandbox.getRoot().append(relativePath);
                    ResourceType resourceType = PathUtils.getResourceType((IPath)path, (IProgressMonitor)monitor.newChild(1));
                    if (resourceType == null) {
                        shareable = new Shareable(sandbox, (IPath)new Path(relativePath), ResourceType.FOLDER);
                        FileItemInfo info = shareable.getFileItemInfo((IProgressMonitor)monitor.newChild(1));
                        if (info == null) break;
                        if (ResourceType.getResourceType((IVersionableHandle)info.getVersionableHandle()) != ResourceType.FOLDER) {
                            shareable = new Shareable(sandbox, (IPath)new Path(relativePath), ResourceType.getResourceType((IVersionableHandle)info.getVersionableHandle()));
                        }
                    } else {
                        shareable = new Shareable(sandbox, (IPath)new Path(relativePath), resourceType);
                    }
                    shareables.add(shareable);
                    ++var7_12;
                }
                SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareables, (IProgressMonitor)monitor.newChild(1));
                ArrayList<IShareable> unsharedItems = new ArrayList<IShareable>();
                for (IShareable iShareable : shareables) {
                    IShare share = iShareable.getShare((IProgressMonitor)monitor.newChild(1));
                    if (share == null) {
                        unsharedItems.add(iShareable);
                        break;
                    }
                    lcm.refreshChanges(share, iShareable, (IProgressMonitor)monitor.newChild(9));
                }
                if (!unsharedItems.isEmpty()) {
                    HashSet<IShare> hashSet = new HashSet<IShare>();
                    HashSet<IShareable> shareableRoots = new HashSet<IShareable>();
                    IShare[] shares = sandbox.allShares((IProgressMonitor)monitor.newChild(10));
                    block4: for (IShareable shareable : unsharedItems) {
                        IShare[] iShareArray = shares;
                        int n3 = shares.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IShare share = iShareArray[n4];
                            if (PathUtils.isPrefixOf((IPath)shareable.getLocalPath(), (boolean)sandbox.isCaseSensitive(), (IPath)share.getPath())) {
                                hashSet.add(share);
                                shareableRoots.add(share.getShareable());
                                continue block4;
                            }
                            ++n4;
                        }
                    }
                    if (!hashSet.isEmpty()) {
                        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareableRoots, (IProgressMonitor)monitor.newChild(1));
                        IShare[] recompute = hashSet.toArray(new IShare[hashSet.size()]);
                        LocalChangeManager.getInstance().refreshChanges(recompute, ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN, (IProgressMonitor)monitor.newChild(90));
                    }
                }
            }
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException("Failed to recompute local changes", (Throwable)e);
        }
    }

    public static void configureRefresh(ParmsPreOperationRefresh parms, IRefreshingOperation op) {
        if (op == null) {
            throw new IllegalArgumentException();
        }
        op.setRefreshBeforeRun(parms != null && "complete".equals(parms.refreshMode));
    }
}

