/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.operations.ILockOperation;
import com.ibm.team.filesystem.client.operations.IUnlockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLock;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLockDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLockResources;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUnlock;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUnlockResources;
import com.ibm.team.filesystem.client.restproxy.notification.IServerNotificationChannel;
import com.ibm.team.filesystem.common.internal.rest.client.locks.ComponentLockReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.ContributorNameDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.FilesystemRestClientDTOlocksFactory;
import com.ibm.team.filesystem.common.internal.rest.client.locks.LockEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.LockedResourcesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.LockedShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.StreamLockReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.UnlockResourcesResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.VersionableLockDTO;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.CurrentFlowsManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.ShareableCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.UserLockCache;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.ILockSearchResult;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockedResourcesDTOUtil {
    public static void startLockedResourcesRefreshNotification(final IServerNotificationChannel notifier) {
        IListener listener = new IListener(){

            public void handleEvents(List events) {
                notifier.queueNotification("LockedResourcesDTORefreshNotification", IFilesystemRestClient.LockedResourcesDTORefreshEvent.TYPE, (IParameterWrapper)new IFilesystemRestClient.LockedResourcesDTORefreshEvent());
            }
        };
        UserLockCache.get().addGenericListener("lock", listener);
    }

    public static LockedResourcesDTO getLockedResources(IProgressMonitor progress) {
        LockedResourcesDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createLockedResourcesDTO();
        UserLockCache cache = UserLockCache.get();
        result.getTeamLocks().addAll(LockedResourcesDTOUtil.getStreamLockReportDTOs(cache.getStreamLockReportsCache()));
        HashSet<IWorkspaceConnection> wcs = CurrentFlowsManager.getCurrentFlows(FileSystemResourcesPlugin.getComponentSyncModel());
        for (IStreamLockReport report : cache.getStreamLockReportsUserCache()) {
            result.getUserLocks().add(LockedResourcesDTOUtil.getStreamLockReportDTO(LockedResourcesDTOUtil.findConnection(report.getStream(), wcs), report));
        }
        result.getLockedShareables().addAll(LockedResourcesDTOUtil.getLockedShareableDTOs(cache.getShareableUserCache()));
        result.getLockedShareables().addAll(LockedResourcesDTOUtil.getLockedShareableDTOs(cache.getShareableCache()));
        for (IContributor contributor : cache.getOwnersCache()) {
            result.getOwners().add(LockedResourcesDTOUtil.getContributorNameDTO(contributor));
        }
        return result;
    }

    private static IWorkspaceConnection findConnection(IWorkspaceHandle workspace, Collection<IWorkspaceConnection> connections) {
        for (IWorkspaceConnection wc : connections) {
            if (!wc.getResolvedWorkspace().sameItemId((IItemHandle)workspace)) continue;
            return wc;
        }
        return null;
    }

    private static Collection<StreamLockReportDTO> getStreamLockReportDTOs(HashMap<IWorkspaceConnection, ILockSearchResult> reports) {
        ArrayList<StreamLockReportDTO> result = new ArrayList<StreamLockReportDTO>();
        for (Map.Entry<IWorkspaceConnection, ILockSearchResult> value : reports.entrySet()) {
            for (IStreamLockReport report : value.getValue().getReports()) {
                result.add(LockedResourcesDTOUtil.getStreamLockReportDTO(value.getKey(), report));
            }
        }
        return result;
    }

    public static StreamLockReportDTO getStreamLockReportDTO(IWorkspaceConnection wc, IStreamLockReport report) {
        StreamLockReportDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createStreamLockReportDTO();
        result.setStreamItemId(report.getStream().getItemId().getUuidValue());
        if (wc != null) {
            result.setStreamName(wc.getName());
        }
        for (IComponentLockReport clr : report.getComponentLocks()) {
            result.getComponentLockReports().add(LockedResourcesDTOUtil.getComponentLockReportDTO(clr));
        }
        return result;
    }

    private static ComponentLockReportDTO getComponentLockReportDTO(IComponentLockReport report) {
        ComponentLockReportDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createComponentLockReportDTO();
        result.setComponentItemId(report.getComponent().getItemId().getUuidValue());
        for (IVersionableLock lock : report.getLocks()) {
            result.getVersionableLocks().add(LockedResourcesDTOUtil.getVersionableLockDTO(lock));
        }
        return result;
    }

    private static VersionableLockDTO getVersionableLockDTO(IVersionableLock lock) {
        VersionableLockDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createVersionableLockDTO();
        result.setContributorItemId(lock.getContributor().getItemId().getUuidValue());
        result.setVersionableItemId(lock.getVersionable().getItemId().getUuidValue());
        return result;
    }

    private static Collection<LockedShareableDTO> getLockedShareableDTOs(HashMap<IShareable, ShareableCache.ShareableInfo> cache) {
        ArrayList<LockedShareableDTO> result = new ArrayList<LockedShareableDTO>();
        for (Map.Entry<IShareable, ShareableCache.ShareableInfo> entry : cache.entrySet()) {
            LockedShareableDTO dto = FilesystemRestClientDTOlocksFactory.eINSTANCE.createLockedShareableDTO();
            dto.setLockedShareable(CoreUtil.translateShareable(entry.getKey()));
            dto.setVersionableItemId(entry.getValue().versionable.getItemId().getUuidValue());
            dto.setComponentItemId(entry.getValue().component.getItemId().getUuidValue());
            dto.setStreamItemId(entry.getValue().stream.getResolvedWorkspace().getItemId().getUuidValue());
            result.add(dto);
        }
        return result;
    }

    private static ContributorNameDTO getContributorNameDTO(IContributor contributor) {
        ContributorNameDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createContributorNameDTO();
        result.setContributorItemId(contributor.getItemId().getUuidValue());
        result.setName(contributor.getName());
        return result;
    }

    public static void postLockResources(ParmsLockResources parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.setWorkRemaining(parms.locks.length * 2);
        ILockOperation lockOperation = IOperationFactory.instance.getLockOperation((LockDilemmaHandler)LockedResourcesDTOUtil.getLockDilemmaHandler(null));
        ParmsLock[] parmsLockArray = parms.locks;
        int n = parms.locks.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsLock lock = parmsLockArray[n2];
            IWorkspaceConnection connection = lock.workspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
            ITeamRepository repo = CommonUtil.getTeamRepository((String)lock.workspace.repositoryUrl);
            IComponentHandle componentHandle = CommonUtil.createComponentHandle((ITeamRepository)repo, (String)lock.componentItemId);
            IVersionableHandle versionableHandle = lock.versionable.getVersionableHandle(repo);
            lockOperation.lock(connection, componentHandle, versionableHandle);
            ++n2;
        }
        progress.setWorkRemaining(100);
        try {
            lockOperation.run((IProgressMonitor)progress.newChild(100));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
    }

    public static UnlockResourcesResultDTO postUnlockResources(ParmsUnlockResources parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.setWorkRemaining(parms.locks.length * 2);
        DaemonLockDilemmaHandler handler = LockedResourcesDTOUtil.getLockDilemmaHandler(parms.lockDilemmaHandler);
        IUnlockOperation unlockOperation = IOperationFactory.instance.getUnlockOperation((LockDilemmaHandler)handler);
        UnlockResourcesResultDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createUnlockResourcesResultDTO();
        ParmsUnlock[] parmsUnlockArray = parms.locks;
        int n = parms.locks.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsUnlock lock = parmsUnlockArray[n2];
            IWorkspaceConnection connection = lock.workspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
            ITeamRepository repo = CommonUtil.getTeamRepository((String)lock.workspace.repositoryUrl);
            IComponentHandle componentHandle = CommonUtil.createComponentHandle((ITeamRepository)repo, (String)lock.componentItemId);
            IVersionableHandle versionableHandle = lock.versionable.getVersionableHandle(repo);
            IContributorHandle contributorHandle = null;
            if (lock.contributorItemId != null) {
                contributorHandle = CommonUtil.createContributorHandle((ITeamRepository)repo, (String)lock.contributorItemId);
            }
            unlockOperation.unlock(connection, componentHandle, versionableHandle, contributorHandle);
            ++n2;
        }
        progress.setWorkRemaining(100);
        try {
            unlockOperation.run((IProgressMonitor)progress.newChild(100));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.getCurrentUserDoesntOwnLocks().addAll(LockedResourcesDTOUtil.getLockEntryDTOs(handler.locks));
            result.setCancelled(true);
        }
        return result;
    }

    private static Collection<LockEntryDTO> getLockEntryDTOs(Map<ITeamRepository, List<LockEntry>> locks) {
        ArrayList<LockEntryDTO> result = new ArrayList<LockEntryDTO>();
        for (List<LockEntry> lockEntries : locks.values()) {
            for (LockEntry lockEntry : lockEntries) {
                LockEntryDTO dto = FilesystemRestClientDTOlocksFactory.eINSTANCE.createLockEntryDTO();
                dto.setRepositoryItemId(lockEntry.getRepository().getRepositoryURI());
                dto.setWorkspaceItemId(lockEntry.getStream().getItemId().getUuidValue());
                dto.setComponentItemId(lockEntry.getComponent().getItemId().getUuidValue());
                dto.setVersionableItemId(lockEntry.getVersionable().getItemId().getUuidValue());
                result.add(dto);
            }
        }
        return result;
    }

    private static DaemonLockDilemmaHandler getLockDilemmaHandler(ParmsLockDilemmaHandler lockDilemmaHandlerParms) {
        int currentUserDoesntOwnLock = 2;
        if (lockDilemmaHandlerParms == null) {
            currentUserDoesntOwnLock = 2;
        } else if ("continue".equals(lockDilemmaHandlerParms.currentUserDoesntOwnLock)) {
            currentUserDoesntOwnLock = 0;
        } else if (lockDilemmaHandlerParms.currentUserDoesntOwnLock == null) {
            currentUserDoesntOwnLock = 2;
        } else if ("cancel".equals(lockDilemmaHandlerParms.currentUserDoesntOwnLock)) {
            currentUserDoesntOwnLock = 1;
        } else if ("no".equals(lockDilemmaHandlerParms.currentUserDoesntOwnLock)) {
            currentUserDoesntOwnLock = 3;
        } else {
            throw new IllegalArgumentException(NLS.bind((String)"Invalid value {0} of {1} must be one of {2}, {3}, {4} or {5}", (Object[])new Object[]{lockDilemmaHandlerParms.currentUserDoesntOwnLock, "currentuserDoesntOwnLock", "cancel", "continue", "no", "fail"}, (Object[])new Object[0]));
        }
        DaemonLockDilemmaHandler lockDilemmaHandler = new DaemonLockDilemmaHandler(currentUserDoesntOwnLock);
        return lockDilemmaHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DaemonLockDilemmaHandler
    extends LockDilemmaHandler {
        public Map<ITeamRepository, List<LockEntry>> locks;
        int currentUserDoesntOwnLock;

        public DaemonLockDilemmaHandler(int currentUserDoesntOwnLock) {
            this.currentUserDoesntOwnLock = currentUserDoesntOwnLock;
        }

        public int currentUserDoesntOwnLock(Map<ITeamRepository, List<LockEntry>> locks) {
            this.locks = locks;
            return this.currentUserDoesntOwnLock;
        }
    }
}

