/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadLocation;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxLoad;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoad;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadComponentVersionables;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPath;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUnload;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceComponent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.CollisionDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.FilesystemRestClientDTOloadFactory;
import com.ibm.team.filesystem.common.internal.rest.client.load.InvalidLoadRequestDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadEvaluationDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadLocationDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadOverlapDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.LoadResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.MultipleSandboxLoadDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.OverlappedItemDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.RemovedShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.ShareToLoadDTO;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadUtil {
    private static final String LOAD_REQUEST = "putLoadCFA";
    private static final String UNLOAD_REQUEST = "postUnloadCFA";
    private static final String EVALUATE_LOAD_REQUEST = "getLoadCFA";

    public static LoadEvaluationDTO evaluateLoad(ParmsLoad parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ILoadOperation loadOperation = LoadUtil.prepareLoadRequest(EVALUATE_LOAD_REQUEST, parms, LoadDilemmaHandler.getDefault(), (IProgressMonitor)monitor.newChild(10));
        try {
            loadOperation.evaluateLoadRequests((IProgressMonitor)monitor.newChild(84));
            LoadEvaluationDTO result = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadEvaluationDTO();
            LoadUtil.translateCollisions(result, loadOperation.getCollisions(), (IProgressMonitor)monitor.newChild(5));
            LoadUtil.translateInvalidLoadRequests(result, loadOperation.getInvalidLoadRequests());
            LoadUtil.translateOverlaps(result, loadOperation.getLoadOverlaps());
            LoadUtil.translateNewShares(result, loadOperation.getNewSharesToLoad());
            LoadUtil.translateSharesOutOfSync(result, loadOperation.getSharesOutOfSync());
            LoadUtil.translateSharesToBeRemoved(result, loadOperation.getSharesToBeRemoved());
            LoadUtil.translateMultipleSandboxLoads(result, loadOperation.getMultipleSandboxLoads((IProgressMonitor)monitor.newChild(1)));
            return result;
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
    }

    private static void translateCollisions(LoadEvaluationDTO translation, Collection<ICollision> collisions, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)collisions.size());
        for (ICollision collision : collisions) {
            CollisionDTO loadCollision = FilesystemRestClientDTOloadFactory.eINSTANCE.createCollisionDTO();
            loadCollision.setPath(CoreUtil.translatePath(collision.getShareable().getLocalPath()));
            loadCollision.setDetail(collision.getStatus().getMessage());
            loadCollision.setCollidedWithExistingContent(collision.collidedWithExistingContent());
            if (collision.collidedWithExistingContent() && collision.getShareable().getShare((IProgressMonitor)progress.newChild(1)) != null) {
                loadCollision.setCollidedWithExistingShare(true);
            } else {
                loadCollision.setCollidedWithExistingShare(false);
            }
            for (ILoadLocation location : collision.getLocations()) {
                LoadLocationDTO loadLocation = LoadUtil.translateLoadLocation(location);
                loadCollision.getLoadLocations().add(loadLocation);
            }
            translation.getCollisions().add(loadCollision);
        }
    }

    private static void translateInvalidLoadRequests(LoadEvaluationDTO translation, Collection<IInvalidLoadRequest> invalidLoadRequests) {
        for (IInvalidLoadRequest invalid : invalidLoadRequests) {
            InvalidLoadRequestDTO invalidRequest = FilesystemRestClientDTOloadFactory.eINSTANCE.createInvalidLoadRequestDTO();
            LoadLocationDTO location = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
            location.setRepositoryURL(invalid.getInvalidRequest().getConnection().teamRepository().getRepositoryURI());
            location.setContextItemId(invalid.getInvalidRequest().getConnection().getContextHandle().getItemId().getUuidValue());
            location.setIsWorkspaceContext(invalid.getInvalidRequest().getConnection().getContextHandle() instanceof IWorkspaceHandle);
            location.setComponentItemId(invalid.getInvalidRequest().getComponent().getItemId().getUuidValue());
            location.setVersionableItemId(invalid.getInvalidRequest().getVersionableToLoad().getItemId().getUuidValue());
            location.setVersionableItemType(CoreUtil.getVersionableItemType(invalid.getInvalidRequest().getVersionableToLoad()));
            invalidRequest.setLoadLocation(location);
            invalidRequest.setReason(invalid.getStatus().getMessage());
            translation.getInvalidLoadRequests().add(invalidRequest);
        }
    }

    private static void translateOverlaps(LoadEvaluationDTO translation, Collection<ILoadOverlap> overlaps) {
        for (ILoadOverlap overlap : overlaps) {
            LoadOverlapDTO loadOverlap = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadOverlapDTO();
            LoadLocationDTO loadLocation = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
            loadLocation.setContextItemId(overlap.getConnection().getContextHandle().getItemId().getUuidValue());
            loadLocation.setIsWorkspaceContext(overlap.getConnection().getContextHandle() instanceof IWorkspaceHandle);
            loadLocation.setRepositoryURL(overlap.getConnection().teamRepository().getRepositoryURI());
            loadLocation.setComponentItemId(overlap.getComponent().getItemId().getUuidValue());
            loadLocation.setVersionableItemId(overlap.getItem().getItemId().getUuidValue());
            loadLocation.setVersionableItemType(CoreUtil.getVersionableItemType(overlap.getItem()));
            loadOverlap.setLoadLocation(loadLocation);
            loadOverlap.setPath(CoreUtil.translatePath(overlap.getPath()));
            for (IShare share : overlap.getOverlappingShares()) {
                ShareDTO overlappedShare = CoreUtil.translateShare(share);
                loadOverlap.getOverlappingShares().add(overlappedShare);
            }
            Map overlappingItems = overlap.getOverlappingItems();
            for (Map.Entry item : overlappingItems.entrySet()) {
                OverlappedItemDTO overlappedItem = FilesystemRestClientDTOloadFactory.eINSTANCE.createOverlappedItemDTO();
                overlappedItem.setVersionableHandle((IVersionableHandle)item.getKey());
                overlappedItem.setPath(CoreUtil.translatePath((String[])item.getValue()));
                loadOverlap.getOverlappingItems().add(overlappedItem);
            }
            translation.getOverlappingLoadRequests().add(loadOverlap);
        }
    }

    private static void translateNewShares(LoadEvaluationDTO translation, Collection<IShareableToLoad> newSharesToLoad) {
        for (IShareableToLoad newShare : newSharesToLoad) {
            ShareToLoadDTO newShareToLoad = FilesystemRestClientDTOloadFactory.eINSTANCE.createShareToLoadDTO();
            newShareToLoad.setPath(CoreUtil.translatePath(newShare.getShareable().getLocalPath()));
            LoadLocationDTO loadLocation = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
            loadLocation.setRepositoryURL(newShare.getLoadLocation().getConnection().teamRepository().getRepositoryURI());
            loadLocation.setContextItemId(newShare.getLoadLocation().getConnection().getContextHandle().getItemId().getUuidValue());
            loadLocation.setIsWorkspaceContext(newShare.getLoadLocation().getConnection() instanceof IWorkspaceConnection);
            loadLocation.setComponentItemId(newShare.getLoadLocation().getComponent().getItemId().getUuidValue());
            loadLocation.setVersionableItemId(newShare.getLoadLocation().getRootToLoad().getItemId().getUuidValue());
            loadLocation.setVersionableItemType(CoreUtil.getVersionableItemType(newShare.getLoadLocation().getRootToLoad()));
            newShareToLoad.setLoadLocation(loadLocation);
            translation.getNewSharesToLoad().add(newShareToLoad);
        }
    }

    private static void translateSharesOutOfSync(LoadEvaluationDTO translation, Collection<IShareOutOfSync> sharesOutOfSync) {
        for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
            ShareDTO share = CoreUtil.translateShare(shareOutOfSync.getShare());
            translation.getSharesOutOfSync().add(share);
        }
    }

    private static void translateSharesToBeRemoved(LoadEvaluationDTO translation, Collection<IRemovedShare> sharesToBeRemoved) {
        for (IRemovedShare shareToBeRemoved : sharesToBeRemoved) {
            ShareDTO share = CoreUtil.translateShare(shareToBeRemoved.getShare());
            RemovedShareDTO shareRemoved = FilesystemRestClientDTOloadFactory.eINSTANCE.createRemovedShareDTO();
            shareRemoved.setShare(share);
            shareRemoved.setUncommittedChangeCount(shareToBeRemoved.getUncommittedChangeCount());
            translation.getSharesToBeRemoved().add(shareRemoved);
        }
    }

    private static void translateMultipleSandboxLoads(LoadEvaluationDTO translation, Collection<IMultipleSandboxLoad> multipleSandboxLoads) {
        for (IMultipleSandboxLoad multipleSandboxLoad : multipleSandboxLoads) {
            MultipleSandboxLoadDTO multiSandbox = FilesystemRestClientDTOloadFactory.eINSTANCE.createMultipleSandboxLoadDTO();
            multiSandbox.setConfiguration(CoreUtil.translateConfigurationDescriptor(multipleSandboxLoad.getConfiguration()));
            for (ISandbox sandbox : multipleSandboxLoad.getSandboxes()) {
                multiSandbox.getSandboxes().add(sandbox.getRoot().toOSString());
            }
            for (ILoadLocation loadLocation : multipleSandboxLoad.getLoadLocations()) {
                multiSandbox.getLoadLocations().add(LoadUtil.translateLoadLocation(loadLocation));
            }
            translation.getMultipleSandboxLoads().add(multiSandbox);
        }
    }

    private static LoadLocationDTO translateLoadLocation(ILoadLocation location) {
        LoadLocationDTO loadLocation = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadLocationDTO();
        loadLocation.setRepositoryURL(location.getConnection().teamRepository().getRepositoryURI());
        loadLocation.setContextItemId(location.getConnection().getContextHandle().getItemId().getUuidValue());
        loadLocation.setIsWorkspaceContext(location.getConnection() instanceof IWorkspaceConnection);
        loadLocation.setComponentItemId(location.getComponent().getItemId().getUuidValue());
        loadLocation.setVersionableItemId(location.getRootToLoad().getItemId().getUuidValue());
        loadLocation.setVersionableItemType(CoreUtil.getVersionableItemType(location.getRootToLoad()));
        return loadLocation;
    }

    public static void unload(ParmsUnload parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        try {
            int n;
            UnshareDilemmaHandler dilemmaHandler = LoadUtil.getUnshareDilemmaHandler(parms);
            IUnshareOperation op = IOperationFactory.instance.getUnshareOperation(dilemmaHandler);
            op.setDeleteContent(parms.deleteContent.booleanValue());
            if (parms.fullSharePaths != null) {
                SharingManager sharingManager = SharingManager.getInstance();
                ArrayList<IShare> projects = new ArrayList<IShare>();
                SubMonitor loopProgress = monitor.newChild(5).setWorkRemaining(parms.fullSharePaths.length * 2);
                ParmsPath[] parmsPathArray = parms.fullSharePaths;
                int n2 = parms.fullSharePaths.length;
                n = 0;
                while (n < n2) {
                    IShare share;
                    IShareable shareable;
                    ParmsPath shareName = parmsPathArray[n];
                    ISandbox sandbox = sharingManager.getSandbox((IPath)new Path(shareName.sandboxPath), false);
                    IPath path = sandbox.getRoot().append(shareName.relativePath);
                    ResourceType resourceType = PathUtils.getResourceType((IPath)path, (IProgressMonitor)loopProgress.newChild(1));
                    if (resourceType != null && (shareable = sharingManager.findShareable(path, resourceType)) != null && (share = shareable.getShare((IProgressMonitor)loopProgress.newChild(1))) != null && shareable.getLocalPath().segmentCount() == share.getPath().segmentCount()) {
                        projects.add(share);
                    }
                    ++n;
                }
                op.requestUnshareShares(projects);
            }
            if (parms.unloadRequests != null) {
                ArrayList<ConfigurationDescriptor> descriptors = new ArrayList<ConfigurationDescriptor>();
                SubMonitor loopProgress = monitor.newChild(10).setWorkRemaining(parms.unloadRequests.length);
                ParmsWorkspaceComponent[] parmsWorkspaceComponentArray = parms.unloadRequests;
                n = parms.unloadRequests.length;
                int n3 = 0;
                while (n3 < n) {
                    ParmsWorkspaceComponent component = parmsWorkspaceComponentArray[n3];
                    IWorkspaceConnection workspaceConnection = component.workspace.getWorkspaceConnection((IProgressMonitor)loopProgress.newChild(1));
                    IComponentHandle componentHandle = component.getComponentHandle();
                    ConfigurationDescriptor descriptor = new ConfigurationDescriptor((IConnection)workspaceConnection, componentHandle);
                    descriptors.add(descriptor);
                    ++n3;
                }
                op.requestUnshare(descriptors);
            }
            op.run((IProgressMonitor)monitor.newChild(100));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
    }

    private static UnshareDilemmaHandler getUnshareDilemmaHandler(final ParmsUnload parms) {
        return new UnshareDilemmaHandler(){

            public int emptySandbox(Collection<ISandbox> emptySandboxes) {
                if (parms.deleteEmptySandboxes.booleanValue()) {
                    return 0;
                }
                return 3;
            }
        };
    }

    public static LoadResultDTO load(final ParmsLoad parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        LoadResultDTO result = FilesystemRestClientDTOloadFactory.eINSTANCE.createLoadResultDTO();
        final BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, result.getBackedUpToShed());
        LoadDilemmaHandler loadDilemmaHandler = new LoadDilemmaHandler(){

            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                for (ICollision collision : collisions) {
                    if (collision.getLocations().size() > 1) {
                        return 2;
                    }
                    collision.setLoadLocation((ILoadLocation)collision.getLocations().iterator().next());
                }
                for (IRemovedShare removedShare : removedShares) {
                    removedShare.isToBeDeleted(parms.deleteRemovedShares == null ? false : parms.deleteRemovedShares);
                }
                return 0;
            }

            public int invalidLoadRequest(Collection<IInvalidLoadRequest> requests) {
                return 2;
            }

            public int newItemsToLoad(Collection<IShareableToLoad> sharesToLoad) {
                return super.newItemsToLoad(sharesToLoad);
            }

            public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
                return 2;
            }

            public int invalidLoadLocations(Collection<IInvalidLoadLocation> invalidLoadLocations) {
                return 2;
            }

            public int multipleSandboxLoad(Collection<IMultipleSandboxLoad> locations) {
                return 0;
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return backupDilemmaHandler;
            }
        };
        ILoadOperation loadOperation = LoadUtil.prepareLoadRequest(LOAD_REQUEST, parms, loadDilemmaHandler, (IProgressMonitor)monitor.newChild(5));
        try {
            loadOperation.run((IProgressMonitor)monitor.newChild(95));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        return result;
    }

    private static ILoadOperation prepareLoadRequest(String request, ParmsLoad parms, LoadDilemmaHandler loadDilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IComponentHandle component;
        IWorkspaceConnection workspaceConnection;
        Path relativePath;
        ISandbox sandbox;
        Path cfaPath;
        ParmsLoadComponentVersionables componentFolders;
        int n;
        int n2;
        ParmsLoadComponentVersionables[] parmsLoadComponentVersionablesArray;
        SubMonitor subMonitor;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)400);
        ILoadOperation loadOperation = IOperationFactory.instance.getLoadOperation(loadDilemmaHandler);
        ISharingManager sharingManager = FileSystemCore.getSharingManager();
        if (parms.componentVersionablesToLoad != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.componentVersionablesToLoad.length * 10);
            parmsLoadComponentVersionablesArray = parms.componentVersionablesToLoad;
            n2 = parms.componentVersionablesToLoad.length;
            n = 0;
            while (n < n2) {
                Map exp;
                componentFolders = parmsLoadComponentVersionablesArray[n];
                cfaPath = new Path(componentFolders.sandboxPath);
                sandbox = sharingManager.getSandbox((IPath)cfaPath, false);
                relativePath = componentFolders.relativeLoadPath == null ? new Path("") : new Path(componentFolders.relativeLoadPath);
                workspaceConnection = componentFolders.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                component = componentFolders.getComponentHandle();
                ArrayList versionablesToLoad = new ArrayList(componentFolders.getFolderHandles());
                versionablesToLoad.addAll(componentFolders.getFileItemHandles());
                versionablesToLoad.addAll(componentFolders.getSymbolicLinkHandles());
                if (versionablesToLoad.isEmpty() && (exp = workspaceConnection.configuration(component).childEntriesForRoot((IProgressMonitor)subMonitor.newChild(1))) != null) {
                    versionablesToLoad.addAll(exp.values());
                }
                loadOperation.requestLoad(sandbox, (IPath)relativePath, workspaceConnection, component, versionablesToLoad);
                ++n;
            }
        }
        if (parms.versionablesToLoad != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.componentVersionablesToLoad.length * 10);
            parmsLoadComponentVersionablesArray = parms.versionablesToLoad;
            n2 = parms.versionablesToLoad.length;
            n = 0;
            while (n < n2) {
                componentFolders = parmsLoadComponentVersionablesArray[n];
                cfaPath = new Path(componentFolders.sandboxPath);
                sandbox = sharingManager.getSandbox((IPath)cfaPath, false);
                relativePath = componentFolders.relativeLoadPath == null ? new Path("") : new Path(componentFolders.relativeLoadPath);
                workspaceConnection = componentFolders.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                component = componentFolders.getComponentHandle();
                IVersionableHandle versionableToLoad = componentFolders.getVersionableHandle();
                loadOperation.requestLoadAs(sandbox, (IPath)relativePath, componentFolders.alternativeName, workspaceConnection, component, versionableToLoad);
                ++n;
            }
        }
        if (parms.loadRules != null && parms.loadRules.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(10 + parms.loadRules.length * 20);
            parmsLoadComponentVersionablesArray = parms.loadRules;
            n2 = parms.loadRules.length;
            n = 0;
            while (n < n2) {
                ParmsLoadComponentVersionables loadRules = parmsLoadComponentVersionablesArray[n];
                cfaPath = new Path(loadRules.sandboxPath);
                sandbox = sharingManager.getSandbox((IPath)cfaPath, false);
                relativePath = loadRules.relativeLoadPath == null ? new Path("") : new Path(loadRules.relativeLoadPath);
                workspaceConnection = loadRules.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                component = loadRules.getComponentHandle();
                ILoadRule loadRule = ILoadRule.loadRuleFactory.createLoadRule(workspaceConnection, component);
                IFileItemHandle loadRuleFileItem = loadRules.getLoadRuleFileItemHandle();
                if (loadRuleFileItem != null) {
                    loadRule.addLoadRules(loadRuleFileItem, (IProgressMonitor)subMonitor.newChild(10));
                } else {
                    loadRule.addLoadRules((InputStream)new ByteArrayInputStream(loadRules.loadRuleFileContents.getBytes()), "UTF-8", (IProgressMonitor)subMonitor.newChild(10));
                }
                loadOperation.requestLoad(sandbox, (IPath)relativePath, Collections.singleton(loadRule), (IProgressMonitor)subMonitor.newChild(10));
                ++n;
            }
        }
        return loadOperation;
    }
}

