/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class LabelsUtil {
    public static final String CONTENT_THREADS_PREFERENCE = "content_threads";
    public static final String AUTO_COMMIT_PREFERENCE = "auto commit";
    public static final boolean AUTO_COMMIT_PREFERENCE_DEFAULT = false;
    public static final String FILESYSTEM_IDE_UI_PLUGIN_ID = "com.ibm.team.filesystem.ide.ui";

    public static String getConflictType(IConflictItem conflict, boolean html) {
        ILogicalChange logicalChange = conflict.getLogicalChange();
        switch (conflict.getType()) {
            case 1: {
                if (logicalChange.kind() == 1) {
                    switch (((ILogicalConflict)logicalChange).conflictType()) {
                        case 9: {
                            return Messages.FilesystemHTMLGenerator_0;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 10: {
                            return Messages.FilesystemHTMLGenerator_111;
                        }
                    }
                    return Messages.FilesystemHTMLGenerator_112;
                }
            }
            case 3: {
                return Messages.FilesystemHTMLGenerator_113;
            }
            case 2: {
                return Messages.FilesystemHTMLGenerator_114;
            }
        }
        return Messages.FilesystemHTMLGenerator_115;
    }

    public static String getConflictInformation(IConflictItem conflict, boolean mine, boolean html) {
        return LabelsUtil.getConflictInformation(conflict.getLogicalChange(), mine, html);
    }

    public static String getConflictInformation(ILogicalChange logicalChange, boolean mine, boolean html) {
        if (logicalChange.kind() == 1) {
            ILogicalConflict conflict = (ILogicalConflict)logicalChange;
            switch (conflict.conflictType()) {
                case 1: {
                    return Messages.FilesystemHTMLGenerator_116;
                }
                case 2: {
                    return mine ? Messages.FilesystemHTMLGenerator_117 : Messages.FilesystemHTMLGenerator_118;
                }
                case 3: {
                    return mine ? Messages.FilesystemHTMLGenerator_119 : Messages.FilesystemHTMLGenerator_120;
                }
                case 5: {
                    return mine ? Messages.FilesystemHTMLGenerator_121 : Messages.FilesystemHTMLGenerator_122;
                }
                case 4: {
                    return mine ? Messages.FilesystemHTMLGenerator_123 : Messages.FilesystemHTMLGenerator_124;
                }
                case 10: {
                    return mine ? Messages.FilesystemHTMLGenerator_125 : Messages.FilesystemHTMLGenerator_126;
                }
                case 9: {
                    return Messages.FilesystemHTMLGenerator_127;
                }
                case 7: {
                    return mine ? Messages.FilesystemHTMLGenerator_128 : Messages.FilesystemHTMLGenerator_129;
                }
                case 8: {
                    return mine ? Messages.FilesystemHTMLGenerator_130 : Messages.FilesystemHTMLGenerator_131;
                }
                case 6: {
                    return Messages.FilesystemHTMLGenerator_132;
                }
            }
            return Messages.FilesystemHTMLGenerator_133;
        }
        if (logicalChange.kind() == 2) {
            if (logicalChange.isChangeType(1)) {
                return mine ? Messages.FilesystemHTMLGenerator_134 : Messages.FilesystemHTMLGenerator_135;
            }
            if (logicalChange.isChangeType(2)) {
                return mine ? Messages.FilesystemHTMLGenerator_136 : Messages.FilesystemHTMLGenerator_137;
            }
            if (logicalChange.isChangeType(12)) {
                return mine ? Messages.FilesystemHTMLGenerator_138 : Messages.FilesystemHTMLGenerator_139;
            }
            if (logicalChange.isChangeType(4)) {
                return Messages.FilesystemHTMLGenerator_140;
            }
            if (logicalChange.isChangeType(8)) {
                return mine ? Messages.FilesystemHTMLGenerator_141 : Messages.FilesystemHTMLGenerator_142;
            }
            if (logicalChange.isChangeType(16)) {
                return Messages.FilesystemHTMLGenerator_143;
            }
            return mine ? Messages.FilesystemHTMLGenerator_144 : Messages.FilesystemHTMLGenerator_145;
        }
        if (logicalChange.kind() == 3) {
            if (logicalChange.isChangeType(1)) {
                return mine ? Messages.FilesystemHTMLGenerator_146 : Messages.FilesystemHTMLGenerator_147;
            }
            if (logicalChange.isChangeType(2)) {
                return mine ? Messages.FilesystemHTMLGenerator_148 : Messages.FilesystemHTMLGenerator_149;
            }
            if (logicalChange.isChangeType(12)) {
                return mine ? Messages.FilesystemHTMLGenerator_150 : Messages.FilesystemHTMLGenerator_151;
            }
            if (logicalChange.isChangeType(4)) {
                return mine ? Messages.FilesystemHTMLGenerator_152 : Messages.FilesystemHTMLGenerator_153;
            }
            if (logicalChange.isChangeType(8)) {
                return mine ? Messages.FilesystemHTMLGenerator_154 : Messages.FilesystemHTMLGenerator_155;
            }
            if (logicalChange.isChangeType(16)) {
                return mine ? Messages.FilesystemHTMLGenerator_156 : Messages.FilesystemHTMLGenerator_157;
            }
            return mine ? Messages.FilesystemHTMLGenerator_158 : Messages.FilesystemHTMLGenerator_159;
        }
        return Messages.FilesystemHTMLGenerator_160;
    }

    public static String getConflictLocalResource(IConflictItem conflict, boolean html, IProgressMonitor progress) {
        return LabelsUtil.html(conflict.getLocalPath(progress), html);
    }

    public static String getConflictAcceptedResource(IConflictItem conflict, boolean html, IProgressMonitor progress) {
        return LabelsUtil.html(conflict.getFullPath(true, progress), html);
    }

    public static String getDetails(IConflictItem conflictItem, boolean mine, boolean html) {
        return LabelsUtil.getDetails(conflictItem.getLogicalChange(), mine, html);
    }

    public static String getDetails(ILogicalChange logicalChange, boolean mine, boolean html) {
        boolean properties = false;
        boolean content = false;
        if (mine) {
            if (logicalChange.kind() == 1) {
                ILogicalConflict conflict = (ILogicalConflict)logicalChange;
                properties = conflict.isSelectedModificationChange(11);
                content = conflict.isSelectedModificationChange(4);
            }
        } else {
            properties = logicalChange.isModificationChange(11);
            content = logicalChange.isModificationChange(4);
        }
        return LabelsUtil.formatDetails(properties, content, html);
    }

    private static String formatDetails(boolean properties, boolean content, boolean html) {
        String details = "";
        if (properties && content) {
            details = Messages.FilesystemHTMLGenerator_162;
        } else if (properties) {
            details = Messages.FilesystemHTMLGenerator_163;
        } else if (content) {
            details = Messages.FilesystemHTMLGenerator_164;
        }
        return LabelsUtil.html(details, html);
    }

    public static String getLocalChangeInformation(ILocalChange change, boolean html) {
        switch (change.getType()) {
            case 8: {
                String[] pathHint = change.getCounterpart().getPath().segments();
                String[] newPathHint = change.getResultingPath().segments();
                String oldName = pathHint[pathHint.length - 1];
                int type = LabelsUtil.getDescription(pathHint, newPathHint);
                switch (type) {
                    case 1: {
                        return LabelsUtil.html(NLS.bind((String)Messages.FilesystemHTMLGenerator_165, (Object)ComponentSyncUtil.toString(pathHint, true)), html);
                    }
                    case 2: {
                        return LabelsUtil.html(NLS.bind((String)Messages.FilesystemHTMLGenerator_166, (Object)oldName), html);
                    }
                    case 3: {
                        return LabelsUtil.html(NLS.bind((String)Messages.FilesystemHTMLGenerator_167, (Object)ComponentSyncUtil.toString(pathHint, true), (Object)oldName), html);
                    }
                }
                break;
            }
            case 9: 
            case 40: 
            case 41: {
                String[] pathHint = change.getCounterpart().getPath().segments();
                String[] newPathHint = change.getResultingPath().segments();
                String oldName = pathHint[pathHint.length - 1];
                int type = LabelsUtil.getDescription(pathHint, newPathHint);
                switch (type) {
                    case 1: {
                        return LabelsUtil.html(NLS.bind((String)Messages.FilesystemHTMLGenerator_168, (Object)ComponentSyncUtil.toString(pathHint, true)), html);
                    }
                    case 2: {
                        return LabelsUtil.html(NLS.bind((String)Messages.FilesystemHTMLGenerator_169, (Object)oldName), html);
                    }
                    case 3: {
                        return LabelsUtil.html(NLS.bind((String)Messages.FilesystemHTMLGenerator_170, (Object)ComponentSyncUtil.toString(pathHint, true), (Object)oldName), html);
                    }
                }
                break;
            }
            case 2: {
                return LabelsUtil.html(NLS.bind((String)Messages.FilesystemHTMLGenerator_171, (Object)change.getPath().lastSegment()), html);
            }
            case 4: {
                return LabelsUtil.html(NLS.bind((String)Messages.FilesystemHTMLGenerator_172, (Object)change.getPath().lastSegment()), html);
            }
            case 1: 
            case 32: 
            case 33: {
                return LabelsUtil.html(NLS.bind((String)Messages.FilesystemHTMLGenerator_173, (Object)change.getPath().lastSegment()), html);
            }
        }
        return LabelsUtil.html(NLS.bind((String)Messages.FilesystemHTMLGenerator_174, (Object)change.getPath().lastSegment()), html);
    }

    static String html(String string, boolean html) {
        return html ? LabelsUtil.html(string) : string;
    }

    public static String html(String string) {
        return string.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String getResolveHint(IConflictItem conflict, boolean html) {
        ILogicalChange logicalChange = conflict.getLogicalChange();
        boolean fileChange = logicalChange.item() instanceof IFileItemHandle;
        String structureResolution = Messages.FilesystemHTMLGenerator_85;
        String contentMultipleResolution = Messages.FilesystemHTMLGenerator_86;
        switch (conflict.getType()) {
            case 1: {
                if (logicalChange.kind() != 1) break;
                switch (((ILogicalConflict)logicalChange).conflictType()) {
                    case 9: {
                        return Messages.FilesystemHTMLGenerator_87;
                    }
                    case 1: {
                        String explanation = String.valueOf(Messages.FilesystemHTMLGenerator_88) + structureResolution;
                        if (fileChange) {
                            explanation = String.valueOf(explanation) + Messages.FilesystemHTMLGenerator_89;
                        }
                        return explanation;
                    }
                    case 3: {
                        return String.valueOf(Messages.FilesystemHTMLGenerator_90) + structureResolution;
                    }
                    case 2: {
                        return String.valueOf(Messages.FilesystemHTMLGenerator_91) + structureResolution;
                    }
                    case 10: {
                        return String.valueOf(Messages.FilesystemHTMLGenerator_92) + contentMultipleResolution;
                    }
                    case 8: {
                        return String.valueOf(Messages.FilesystemHTMLGenerator_93) + contentMultipleResolution;
                    }
                    case 5: {
                        return String.valueOf(Messages.FilesystemHTMLGenerator_94) + contentMultipleResolution;
                    }
                    case 7: {
                        return String.valueOf(Messages.FilesystemHTMLGenerator_95) + structureResolution;
                    }
                    case 4: {
                        return String.valueOf(Messages.FilesystemHTMLGenerator_96) + contentMultipleResolution;
                    }
                    case 6: {
                        return String.valueOf(Messages.FilesystemHTMLGenerator_97) + contentMultipleResolution;
                    }
                }
                return Messages.FilesystemHTMLGenerator_98;
            }
            case 3: {
                return Messages.FilesystemHTMLGenerator_99;
            }
            case 2: {
                return Messages.FilesystemHTMLGenerator_100;
            }
        }
        return "";
    }

    public static int getDescription(String[] pathHint, String[] newPathHint) {
        String oldName = pathHint[pathHint.length - 1];
        String newName = newPathHint[newPathHint.length - 1];
        if (oldName.equals(newName)) {
            return 1;
        }
        boolean samePath = false;
        if (pathHint.length == newPathHint.length) {
            samePath = true;
            int i = 0;
            while (i < pathHint.length - 1) {
                if (!pathHint[i].equals(newPathHint[i])) {
                    samePath = false;
                    break;
                }
                ++i;
            }
        }
        if (samePath) {
            return 2;
        }
        return 3;
    }

    public static class ContentDescription {
        public static final String NO_CONTEXT = "";

        public static String getDescription(IComponentSyncContext[] contexts, boolean noChangesMessage) {
            if (contexts.length == 0) {
                return ContentDescription.noContextsDescription();
            }
            return ContentDescription.getChangesCountDescription(contexts, noChangesMessage);
        }

        public static String noContextsDescription() {
            return NO_CONTEXT;
        }

        public static String getChangesCountDescription(int nBaselines, int nChanges, boolean noChangesMessage) {
            String result = NO_CONTEXT;
            boolean addSep = false;
            if (nBaselines != 0) {
                result = String.valueOf(result) + (nBaselines == 1 ? Messages.LocalConfiguration_6 : NLS.bind((String)Messages.LocalConfiguration_7, (Object)nBaselines));
                addSep = true;
            }
            if (nChanges != 0) {
                if (addSep) {
                    result = String.valueOf(result) + (nBaselines != 0 ? " + " : ", ");
                }
                result = String.valueOf(result) + (nChanges == 1 ? Messages.LocalConfiguration_10 : NLS.bind((String)Messages.LocalConfiguration_11, (Object)nChanges));
                addSep = true;
            }
            if (noChangesMessage && result.length() == 0) {
                result = Messages.LocalConfiguration_12;
            }
            return result;
        }

        public static String getChangesCountDescription(int nLocal, int nIncomingBaselines, int nIncoming, int nOutgoingBaselines, int nOutgoing, int nConflict, int nCollision, int nComponentChanges, boolean noChangesMessage) {
            String result = NO_CONTEXT;
            boolean addSep = false;
            if (ComponentSyncModel.DEGRADED_NOCHANGES || ComponentSyncModel.DEGRADED_NOWORKITEMS) {
                result = String.valueOf(result) + Messages.LocalConfiguration_39;
                addSep = true;
            }
            if (nLocal != 0) {
                result = String.valueOf(result) + NLS.bind((String)Messages.LocalConfiguration_14, (Object)nLocal);
                addSep = true;
            }
            if (nIncomingBaselines != 0) {
                if (addSep) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + (nIncomingBaselines == 1 ? Messages.LocalConfiguration_16 : NLS.bind((String)Messages.LocalConfiguration_17, (Object)nIncomingBaselines));
                addSep = true;
            }
            if (nIncoming != 0) {
                if (addSep) {
                    result = String.valueOf(result) + (nIncomingBaselines != 0 ? " + " : ", ");
                }
                result = String.valueOf(result) + (nIncoming == 1 ? Messages.LocalConfiguration_20 : NLS.bind((String)Messages.LocalConfiguration_21, (Object)nIncoming));
                addSep = true;
            }
            if (nOutgoingBaselines != 0) {
                if (addSep) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + (nOutgoingBaselines == 1 ? Messages.LocalConfiguration_23 : NLS.bind((String)Messages.LocalConfiguration_24, (Object)nOutgoingBaselines));
                addSep = true;
            }
            if (nOutgoing != 0) {
                if (addSep) {
                    result = String.valueOf(result) + (nOutgoingBaselines != 0 ? " + " : ", ");
                }
                result = String.valueOf(result) + (nOutgoing == 1 ? Messages.LocalConfiguration_27 : NLS.bind((String)Messages.LocalConfiguration_28, (Object)nOutgoing));
                addSep = true;
            }
            if (nConflict != 0) {
                if (addSep) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + (nConflict == 1 ? Messages.LocalConfiguration_30 : NLS.bind((String)Messages.LocalConfiguration_31, (Object)nConflict));
                addSep = true;
            }
            if (nCollision != 0) {
                if (addSep) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + (nCollision == 1 ? Messages.LocalConfiguration_33 : NLS.bind((String)Messages.LocalConfiguration_34, (Object)nCollision));
                addSep = true;
            }
            if (nComponentChanges != 0) {
                if (addSep) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + (nComponentChanges == 1 ? Messages.LocalConfiguration_36 : NLS.bind((String)Messages.LocalConfiguration_37, (Object)nComponentChanges));
                addSep = true;
            }
            if (noChangesMessage && result.length() == 0) {
                result = Messages.LocalConfiguration_38;
            }
            return result;
        }

        public static String getChangesCountDescription(IComponentSyncContext[] contexts, boolean noChangesMessage) {
            int nIncoming = 0;
            int nOutgoing = 0;
            int nPendingLocal = 0;
            int nConflict = 0;
            int nCollision = 0;
            int nComponentChanges = 0;
            int nIncomingBaselines = 0;
            int nOutgoingBaselines = 0;
            int i = 0;
            while (i < contexts.length) {
                IComponentSyncContext context = contexts[i];
                int type = context.getType();
                if (type != 1) {
                    nIncoming += context.getIncomingActivitySource().getActivities().size();
                    nIncomingBaselines += context.getIncomingActivitySource().getBaselines().size();
                }
                if (type == 3 || type == 4 || type == 5 || type == 6) {
                    ++nComponentChanges;
                }
                nOutgoingBaselines += context.getOutgoingActivitySource().getBaselines().size();
                List outgoing = context.getOutgoingActivitySource().getActivities();
                nOutgoing += outgoing.size();
                if (!context.getLocalChangeSource().getAutoCheckinMode() || !context.getLocalChangeSource().isAutoCheckinArmed()) {
                    nPendingLocal += context.getLocalChangeSource().getLocalChanges().size();
                }
                nConflict += context.getOutgoingActivitySource().getConflictItems().size();
                for (IRemoteActivity activity : outgoing) {
                    if (!context.hasConflict(activity)) continue;
                    ++nCollision;
                }
                ++i;
            }
            return ContentDescription.getChangesCountDescription(nPendingLocal, nIncomingBaselines, nIncoming, nOutgoingBaselines, nOutgoing, nConflict, nCollision, nComponentChanges, noChangesMessage);
        }
    }
}

