/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IDeleteFoldersOperation;
import com.ibm.team.filesystem.client.operations.IMoveFoldersOperation;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.filesystem.client.operations.MoveFoldersDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeleteFoldersInWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveAcrossComponentRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveFoldersInWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.BackupInShedDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.NonAtomicCheckInDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EncodingErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.DeleteFoldersInWorkspaceResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.FilesystemRestClientDTOworkspaceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.MoveFoldersInWorkspaceResultDTO;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderManipulationUtil {
    static final String MOVE_FOLDERS = "moveFoldersInWorkspace";
    static final String DELETE_FOLDERS = "deleteFoldersInWorkspace";

    public static DeleteFoldersInWorkspaceResultDTO deleteFoldersInWorkspace(ParmsDeleteFoldersInWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        DeleteFoldersInWorkspaceResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createDeleteFoldersInWorkspaceResultDTO();
        BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, result.getBackedUpToShed());
        OutOfSyncDilemmaHandler oosDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), backupDilemmaHandler);
        CommitDilemmaHandler dilemmaHandler = CommitUtil.getCommitDilemmaHandler(null, oosDilemmaHandler, backupDilemmaHandler, null, null, null);
        try {
            IDeleteFoldersOperation op = FolderManipulationUtil.prepareOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            op.run((IProgressMonitor)monitor.newChild(75));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static IDeleteFoldersOperation prepareOperation(ParmsDeleteFoldersInWorkspace parms, CommitDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        IDeleteFoldersOperation op = IOperationFactory.instance.getDeleteFoldersOperation(dilemmaHandler);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(parms.projectsToDelete.length + 5));
        IShareable[] shareables = new IShareable[parms.projectsToDelete.length];
        int i = 0;
        while (i < parms.projectsToDelete.length) {
            shareables[i] = ResourceUtil.findShareableFor(parms.sandboxPath, parms.projectsToDelete[i], (IProgressMonitor)progress.newChild(1));
            ++i;
        }
        op.addDeleteRequest(shareables, (IProgressMonitor)progress.newChild(5));
        if (parms.deleteContent != null && parms.deleteContent.booleanValue()) {
            op.setDeleteContent(true);
        } else {
            op.setDeleteContent(false);
        }
        return op;
    }

    public static MoveFoldersInWorkspaceResultDTO moveFoldersInWorkspace(ParmsMoveFoldersInWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        MoveFoldersInWorkspaceResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createMoveFoldersInWorkspaceResultDTO();
        MoveFoldersDilemmaHandler dilemmaHandler = FolderManipulationUtil.getMoveFoldersDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUnCheckedInChanges(), result.getLineDelimiterFailures(), result.getEncodingFailures(), result.getBackedUpToShed(), result.getNonAtomicCheckInOffers(), monitor.newChild(10));
        IMoveFoldersOperation op = FolderManipulationUtil.prepareOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            op.run((IProgressMonitor)monitor.newChild(80));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static MoveFoldersDilemmaHandler getMoveFoldersDilemmaHandler(ParmsMoveFoldersInWorkspace parms, List outOfSyncShares, final List configurationsWithPendingChanges, List lineDelimiterFailures, List<EncodingErrorDTO> encodingFailures, List<BackupInShedDTO> backedUpInShed, List<NonAtomicCheckInDTO> nonAtomicCommitOffers, SubMonitor newChild) {
        final int pendingChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, backedUpInShed);
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, backupDilemmaHandler);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, outOfSyncDilemmaHandler, backupDilemmaHandler, (List<LineDelimiterErrorDTO>)lineDelimiterFailures, encodingFailures, nonAtomicCommitOffers);
        MoveFoldersDilemmaHandler dilemmaHandler = new MoveFoldersDilemmaHandler(){

            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
                this.recordConfigurationDescriptors(changes.keySet(), configurationsWithPendingChanges);
                return pendingChangesInstruction;
            }

            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            private void recordConfigurationDescriptors(Collection<ConfigurationDescriptor> configurationDescriptors, List<ConfigurationDescriptorDTO> configurationDescriptorDTOs) {
                if (configurationDescriptorDTOs != null) {
                    for (ConfigurationDescriptor descriptor : configurationDescriptors) {
                        configurationDescriptorDTOs.add(CoreUtil.translateConfigurationDescriptor(descriptor));
                    }
                }
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return backupDilemmaHandler;
            }
        };
        return dilemmaHandler;
    }

    private static IMoveFoldersOperation prepareOperation(ParmsMoveFoldersInWorkspace parms, MoveFoldersDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IComponentHandle sourceComponent;
        IWorkspaceConnection workspaceConnection;
        ParmsMoveAcrossComponentRequest request;
        int n;
        int n2;
        ParmsMoveAcrossComponentRequest[] parmsMoveAcrossComponentRequestArray;
        SubMonitor iterProgress;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IMoveFoldersOperation op = IOperationFactory.instance.getMoveFoldersOperation(dilemmaHandler);
        if (parms.moveAcrossComponentRequests != null) {
            iterProgress = monitor.newChild(50);
            iterProgress = iterProgress.setWorkRemaining(parms.moveAcrossComponentRequests.length);
            parmsMoveAcrossComponentRequestArray = parms.moveAcrossComponentRequests;
            n2 = parms.moveAcrossComponentRequests.length;
            n = 0;
            while (n < n2) {
                request = parmsMoveAcrossComponentRequestArray[n];
                workspaceConnection = request.workspace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(1));
                sourceComponent = request.getSourceComponentHandle();
                IComponentHandle targetComponent = request.getTargetComponentHandle();
                IFolderHandle[] foldersToMove = request.getToMoveFolderHandles();
                IFolderHandle[] parentsToMoveInto = request.getParentFolderHandles();
                op.addMoveAcrossComponentRequest(workspaceConnection, sourceComponent, foldersToMove, targetComponent, parentsToMoveInto, request.sourceChangeSetComment, request.targetChangeSetComment);
                ++n;
            }
        }
        if (parms.moveWithinComponentRequests != null) {
            iterProgress = monitor.newChild(50);
            iterProgress = iterProgress.setWorkRemaining(parms.moveWithinComponentRequests.length);
            parmsMoveAcrossComponentRequestArray = parms.moveWithinComponentRequests;
            n2 = parms.moveWithinComponentRequests.length;
            n = 0;
            while (n < n2) {
                request = parmsMoveAcrossComponentRequestArray[n];
                workspaceConnection = request.workspace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(1));
                sourceComponent = request.getComponentHandle();
                IFolderHandle[] foldersToMove = request.getToMoveFolderHandles();
                IFolderHandle[] parentsToMoveInto = request.getParentFolderHandles();
                op.addMoveWithinComponentRequest(workspaceConnection, sourceComponent, foldersToMove, parentsToMoveInto, request.changeSetComment);
                ++n;
            }
        }
        if (parms.renameFolderRequests != null) {
            iterProgress = monitor.newChild(50);
            iterProgress = iterProgress.setWorkRemaining(parms.moveWithinComponentRequests.length);
            parmsMoveAcrossComponentRequestArray = parms.renameFolderRequests;
            n2 = parms.renameFolderRequests.length;
            n = 0;
            while (n < n2) {
                request = parmsMoveAcrossComponentRequestArray[n];
                workspaceConnection = request.workspace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(1));
                IComponentHandle component = request.getComponentHandle();
                IFolderHandle[] foldersToRename = request.getRenameFolderHandles();
                op.addRenameRequest(workspaceConnection, component, foldersToRename, request.newNames, request.changeSetComment);
                ++n;
            }
        }
        RefreshUtil.configureRefresh(parms.preoperationRefresh, (IRefreshingOperation)op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        return op;
    }
}

