/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.rest.parameters.ParmsEncodingDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsEncodingErrorInstructions;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EncodingErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilesystemRestClientDTOresourceFactory;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingErrorHandler {
    private List<EncodingErrorDTO> encodingErrorsReported;
    private int generalInstruction;
    private boolean performDefaultHandling;
    private HashMap<String, EncodingErrorInstruction> individualInstructions;

    public EncodingErrorHandler(ParmsEncodingDilemmaHandler encodingDilemmaHandler, List<EncodingErrorDTO> encodingErrorsReported) {
        this.encodingErrorsReported = encodingErrorsReported;
        this.generalInstruction = this.getDirection(encodingDilemmaHandler.generalEncodingErrorInstruction);
        this.performDefaultHandling = encodingDilemmaHandler.performDefaultHandling == null ? true : encodingDilemmaHandler.performDefaultHandling;
        this.individualInstructions = this.initializeEncodingInstructions(encodingDilemmaHandler.encodingErrorInstructions);
    }

    public EncodingErrorHandler(List<EncodingErrorDTO> encodingErrorsReported) {
        this.encodingErrorsReported = encodingErrorsReported;
        this.generalInstruction = 0;
        this.performDefaultHandling = true;
        this.individualInstructions = this.initializeEncodingInstructions(null);
    }

    private int getDirection(String direction) {
        if ("cancel".equals(direction)) {
            return 1;
        }
        if ("continue".equals(direction)) {
            return 0;
        }
        if ("no".equals(direction)) {
            return 3;
        }
        return 2;
    }

    private HashMap<String, EncodingErrorInstruction> initializeEncodingInstructions(ParmsEncodingErrorInstructions[] encodingErrorInstructions) {
        HashMap<String, EncodingErrorInstruction> instructions = new HashMap<String, EncodingErrorInstruction>();
        if (encodingErrorInstructions != null) {
            int i = 0;
            while (i < encodingErrorInstructions.length) {
                ParmsEncodingErrorInstructions instruction = encodingErrorInstructions[i];
                IPath path = new Path(instruction.sandboxPath).append(instruction.filePath);
                path.removeTrailingSeparator();
                instructions.put(path.toString(), new EncodingErrorInstruction(instruction));
                ++i;
            }
        }
        return instructions;
    }

    public boolean isPerformDefault() {
        return this.performDefaultHandling;
    }

    public int getDirection() {
        return this.generalInstruction;
    }

    public Collection<? extends IEncodingUploadFailure> applyDetailedInstructions(Collection<? extends IEncodingUploadFailure> failedUploads) {
        if (this.individualInstructions.isEmpty()) {
            return failedUploads;
        }
        ArrayList<IEncodingUploadFailure> failuresWithNoDetailedInstructions = new ArrayList<IEncodingUploadFailure>();
        for (IEncodingUploadFailure iEncodingUploadFailure : failedUploads) {
            IPath path = iEncodingUploadFailure.getShareable().getFullPath().removeTrailingSeparator();
            EncodingErrorInstruction instruction = this.individualInstructions.get(path.toString());
            if (instruction == null) {
                failuresWithNoDetailedInstructions.add(iEncodingUploadFailure);
                continue;
            }
            instruction.handleError(iEncodingUploadFailure);
        }
        return failuresWithNoDetailedInstructions;
    }

    public void recordUploadFailures(Collection<? extends IEncodingUploadFailure> failedUploads) {
        if (this.encodingErrorsReported != null) {
            for (IEncodingUploadFailure iEncodingUploadFailure : failedUploads) {
                this.encodingErrorsReported.add(EncodingErrorHandler.translate(iEncodingUploadFailure));
            }
        }
    }

    public static EncodingErrorDTO translate(IEncodingUploadFailure failure) {
        EncodingErrorDTO failedUpload = FilesystemRestClientDTOresourceFactory.eINSTANCE.createEncodingErrorDTO();
        failedUpload.setShareable(CoreUtil.translateShareable(failure.getShareable()));
        failedUpload.setMalformedContent(failure.isMalformedContent());
        failedUpload.setUnknownEncoding(failure.isUnknownEncoding());
        failedUpload.setAtomicCommit(failure.isAtomicCommit());
        if (failure.getOriginalEncoding() != null) {
            failedUpload.setPredecessorEncoding(failure.getOriginalEncoding());
        }
        failedUpload.setEncoding(failure.getEncoding());
        failedUpload.setDirectionProvided(failure.hasDirection());
        return failedUpload;
    }

    private class EncodingErrorInstruction {
        private boolean skipFile;
        private boolean ignoreEncoding;
        private String alternativeEncoding;

        public EncodingErrorInstruction(ParmsEncodingErrorInstructions instruction) {
            this.skipFile = instruction.skipFile == null ? false : instruction.skipFile;
            this.ignoreEncoding = instruction.ignoreEncoding == null ? false : instruction.ignoreEncoding;
            this.alternativeEncoding = instruction.encoding;
        }

        public void handleError(IEncodingUploadFailure failure) {
            if (this.skipFile) {
                if (!failure.isAtomicCommit()) {
                    failure.setSkipFailure(true);
                }
            } else if (this.ignoreEncoding) {
                failure.setIgnoreEncoding(true);
            } else {
                failure.setAlternativeEncoding(this.alternativeEncoding);
            }
        }
    }
}

