/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliver;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverChangeSetsOrBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DeliverResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.NonAtomicCheckInDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EncodingErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.LockedResourcesDTOUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class DeliverUtil {
    public static DeliverResultDTO deliver(ParmsDeliver parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        DeliverResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createDeliverResultDTO();
        DeliverDilemmaHandler dilemmaHandler = DeliverUtil.getDeliverDilemmaHandler(parms, result);
        IDeliverOperation deliverOperation = DeliverUtil.prepareDeliverOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        try {
            deliverOperation.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(CommonUtil.getErrorMessage((FileSystemClientException)e), (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static DeliverDilemmaHandler getDeliverDilemmaHandler(ParmsDeliver parms, final DeliverResultDTO result) {
        final BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, result.getBackedUpToShed());
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), backupDilemmaHandler);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, outOfSyncDilemmaHandler, backupDilemmaHandler, (List<LineDelimiterErrorDTO>)result.getLineDelimiterFailures(), (List<EncodingErrorDTO>)result.getEncodingFailures(), (List<NonAtomicCheckInDTO>)result.getNonAtomicCheckInOffers());
        final int uncheckedInChanges = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final int flowComponents = DeliverUtil.getFlowComponentsDilemaValue(parms.deliverDilemmaHandler);
        final int flowToNonDefaultTarget = DeliverUtil.getFlowToNonDefaultTarget(parms.deliverDilemmaHandler);
        DeliverDilemmaHandler handler = new DeliverDilemmaHandler(){

            public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
                for (ConfigurationDescriptor configuration : changes.keySet()) {
                    result.getConfigurationsWithUnCheckedInChanges().add(CoreUtil.translateConfigurationDescriptor(configuration));
                }
                return uncheckedInChanges;
            }

            public int notDefaultTarget(Collection<IWorkspaceConnection> targets) {
                result.setFlowToNonDefaultTarget(true);
                return flowToNonDefaultTarget;
            }

            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            public int deliverCombinedProblem(IWorkspaceConnection workspaceConnection, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, TeamRepositoryException exception) {
                return super.deliverCombinedProblem(workspaceConnection, syncReport, baselines, changeSets, exception);
            }

            public int componentsToBeAddedOrRemoved(List<IComponentHandle> added, List<IComponentHandle> removed) {
                result.setComponentsToFlow(true);
                return flowComponents;
            }

            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            public int lockBeingHeld(IStreamLockReport lock, IWorkspaceConnection workspaceConnection, int requestsLeft) {
                return 0;
            }

            public Map<IStreamLockReport, IWorkspaceConnection> locksToRelease(Map<IStreamLockReport, IWorkspaceConnection> locks) {
                for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
                    result.getLocksToRelease().add(LockedResourcesDTOUtil.getStreamLockReportDTO(entry.getValue(), entry.getKey()));
                }
                return Collections.EMPTY_MAP;
            }

            public void locksWereHeld(Map<IStreamLockReport, IWorkspaceConnection> locks) {
                for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
                    result.getLocksWereHeld().add(LockedResourcesDTOUtil.getStreamLockReportDTO(entry.getValue(), entry.getKey()));
                }
            }

            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return backupDilemmaHandler;
            }
        };
        return handler;
    }

    private static IDeliverOperation prepareDeliverOperation(ParmsDeliver parms, DeliverDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IWorkspaceConnection targetWorkspace;
        IWorkspaceConnection sourceWorkspace;
        ITeamRepository repo;
        int n;
        int n2;
        ParmsDeliverChangeSetsOrBaselines[] parmsDeliverChangeSetsOrBaselinesArray;
        SubMonitor subMonitor;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)200);
        IDeliverOperation deliverOperation = IOperationFactory.instance.getDeliverOperation(dilemmaHandler);
        if (parms.deliverChangeSetsOrBaselines != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.deliverChangeSetsOrBaselines.length * 10);
            parmsDeliverChangeSetsOrBaselinesArray = parms.deliverChangeSetsOrBaselines;
            n2 = parms.deliverChangeSetsOrBaselines.length;
            n = 0;
            while (n < n2) {
                int n3;
                ParmsDeliverChangeSetsOrBaselines deliverChangeSets = parmsDeliverChangeSetsOrBaselinesArray[n];
                repo = CommonUtil.getTeamRepository((String)deliverChangeSets.sourceWorkspace.repositoryUrl);
                sourceWorkspace = deliverChangeSets.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                targetWorkspace = deliverChangeSets.targetWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
                if (deliverChangeSets.changeSetItemIds != null) {
                    String[] stringArray = deliverChangeSets.changeSetItemIds;
                    n3 = deliverChangeSets.changeSetItemIds.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String changeSetItemId = stringArray[n4];
                        changeSets.add(CommonUtil.createChangeSetHandle((ITeamRepository)repo, (String)changeSetItemId));
                        ++n4;
                    }
                }
                ArrayList<IBaselineHandle> baselines = new ArrayList<IBaselineHandle>();
                if (deliverChangeSets.baselineItemIds != null) {
                    String[] stringArray = deliverChangeSets.baselineItemIds;
                    int n5 = deliverChangeSets.baselineItemIds.length;
                    n3 = 0;
                    while (n3 < n5) {
                        String baselineId = stringArray[n3];
                        baselines.add((IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)baselineId), null));
                        ++n3;
                    }
                }
                IChangeHistorySyncReport report = DeliverUtil.getCompareReport(sourceWorkspace, targetWorkspace, (IProgressMonitor)monitor);
                deliverOperation.deliver(sourceWorkspace, targetWorkspace, report, baselines, changeSets, Collections.EMPTY_LIST);
                ++n;
            }
        }
        if (parms.deliverComponents != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.deliverComponents.length * 10);
            parmsDeliverChangeSetsOrBaselinesArray = parms.deliverComponents;
            n2 = parms.deliverComponents.length;
            n = 0;
            while (n < n2) {
                ParmsDeliverChangeSetsOrBaselines deliverComponents = parmsDeliverChangeSetsOrBaselinesArray[n];
                repo = CommonUtil.getTeamRepository((String)deliverComponents.sourceWorkspace.repositoryUrl);
                sourceWorkspace = deliverComponents.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                targetWorkspace = deliverComponents.targetWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                String[] stringArray = deliverComponents.componentItemIds;
                int n6 = deliverComponents.componentItemIds.length;
                int n7 = 0;
                while (n7 < n6) {
                    String componentItemId = stringArray[n7];
                    IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)componentItemId), null);
                    IChangeHistorySyncReport report = DeliverUtil.getCompareReport(sourceWorkspace, targetWorkspace, (IProgressMonitor)monitor);
                    deliverOperation.deliver(sourceWorkspace, targetWorkspace, report, component);
                    ++n7;
                }
                ++n;
            }
        }
        if (parms.deliverWorkspaces != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.deliverWorkspaces.length * 10);
            parmsDeliverChangeSetsOrBaselinesArray = parms.deliverWorkspaces;
            n2 = parms.deliverWorkspaces.length;
            n = 0;
            while (n < n2) {
                ParmsDeliverChangeSetsOrBaselines deliverWorkspaces = parmsDeliverChangeSetsOrBaselinesArray[n];
                IWorkspaceConnection sourceWorkspace2 = deliverWorkspaces.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IWorkspaceConnection targetWorkspace2 = deliverWorkspaces.targetWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IChangeHistorySyncReport report = DeliverUtil.getCompareReport(sourceWorkspace2, targetWorkspace2, (IProgressMonitor)monitor);
                deliverOperation.deliver(sourceWorkspace2, targetWorkspace2, report);
                ++n;
            }
        }
        RefreshUtil.configureRefresh(parms.preoperationRefresh, (IRefreshingOperation)deliverOperation);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)deliverOperation);
        return deliverOperation;
    }

    private static IChangeHistorySyncReport getCompareReport(IWorkspaceConnection source, IWorkspaceConnection target, IProgressMonitor monitor) throws TeamRepositoryException {
        int flags = ((ComponentSyncModel)ComponentSyncModel.getInstance()).getCompareToFlags();
        return SyncCache.get().fetch((IWorkspaceConnection)source, (IWorkspaceConnection)target, (int)flags, (IProgressMonitor)monitor).syncReport;
    }

    public static int getFlowComponentsDilemaValue(ParmsDeliverDilemmaHandler deliverParms) {
        int flowComponents;
        if (deliverParms == null) {
            flowComponents = 0;
        } else if ("continue".equals(deliverParms.flowComponents)) {
            flowComponents = 0;
        } else if (deliverParms.flowComponents == null) {
            flowComponents = 0;
        } else if ("cancel".equals(deliverParms.flowComponents)) {
            flowComponents = 1;
        } else if ("fail".equals(deliverParms.flowComponents)) {
            flowComponents = 2;
        } else if ("no".equals(deliverParms.flowComponents)) {
            flowComponents = 3;
        } else {
            throw new IllegalArgumentException("The value of flowComponents must be one of cancel, continue, no or fail");
        }
        return flowComponents;
    }

    public static int getFlowToNonDefaultTarget(ParmsDeliverDilemmaHandler deliverParms) {
        int flowToNonDefaultTarget;
        if (deliverParms == null) {
            flowToNonDefaultTarget = 0;
        } else if ("continue".equals(deliverParms.flowToNonDefault)) {
            flowToNonDefaultTarget = 0;
        } else if (deliverParms.flowToNonDefault == null) {
            flowToNonDefaultTarget = 0;
        } else if ("cancel".equals(deliverParms.flowToNonDefault)) {
            flowToNonDefaultTarget = 1;
        } else if ("fail".equals(deliverParms.flowToNonDefault)) {
            flowToNonDefaultTarget = 2;
        } else {
            throw new IllegalArgumentException("The value of flowToNonDefault must be one of cancel, continue, no or fail");
        }
        return flowToNonDefaultTarget;
    }
}

