/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.GapChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineSetDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConnectionDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.SandboxDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.Visibility;
import com.ibm.team.scm.client.VisibilityEnum;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreUtil {
    public static ShareDTO translateShare(IShare share) {
        ShareDTO translation = FilesystemRestClientDTOcoreFactory.eINSTANCE.createShareDTO();
        ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
        translation.setComponentItemId(sharingDescriptor.getComponent().getItemId().getUuidValue());
        translation.setComponentName(sharingDescriptor.getComponentName());
        translation.setRootVersionableItemId(sharingDescriptor.getRootVersionable().getItemId().getUuidValue());
        translation.setRootVersionableItemType(CoreUtil.getVersionableItemType(sharingDescriptor.getRootVersionable()));
        translation.setSandboxPath(share.getSandbox().getRoot().toOSString());
        translation.setPath(CoreUtil.translatePath(share.getPath()));
        translation.setContextItemId(sharingDescriptor.getConnectionHandle().getItemId().getUuidValue());
        translation.setIsWorkspaceContext(sharingDescriptor.getConnectionHandle() instanceof IWorkspaceHandle);
        translation.setContextName(sharingDescriptor.getConnectionName());
        translation.setRepositoryURL(sharingDescriptor.getRepositoryUri());
        return translation;
    }

    public static String translatePathToString(PathDTO path) {
        StringBuffer buf = new StringBuffer();
        for (String seg : path.getSegments()) {
            buf.append('/');
            buf.append(seg);
        }
        return buf.toString();
    }

    public static PathDTO translatePath(IPath path) {
        return CoreUtil.translatePath(path.segments());
    }

    public static PathDTO translatePath(IShareable shareable) {
        return CoreUtil.translatePath(shareable.getLocalPath());
    }

    public static PathDTO translatePath(String path) {
        return CoreUtil.translatePath(new Path(path).segments());
    }

    public static PathDTO translatePath(String[] pathSegments) {
        PathDTO path = FilesystemRestClientDTOcoreFactory.eINSTANCE.createPathDTO();
        path.getSegments().addAll(Arrays.asList(pathSegments));
        return path;
    }

    public static PathDTO translatePath(IAncestorReport report) {
        PathDTO path = FilesystemRestClientDTOcoreFactory.eINSTANCE.createPathDTO();
        Iterator iPairs = report.getNameItemPairs().iterator();
        iPairs.next();
        while (iPairs.hasNext()) {
            path.getSegments().add(((INameItemPair)iPairs.next()).getName());
        }
        return path;
    }

    public static ConfigurationDescriptorDTO translateConfigurationDescriptor(ConfigurationDescriptor descriptor) {
        ConfigurationDescriptorDTO configurationDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationDescriptorDTO();
        ConnectionDescriptorDTO connectionDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConnectionDescriptorDTO();
        connectionDescriptor.setRepositoryURL(descriptor.uri);
        connectionDescriptor.setContextItemId(descriptor.connectionHandle.getItemId().getUuidValue());
        connectionDescriptor.setIsWorkspaceContext(descriptor.connectionHandle instanceof IWorkspaceHandle);
        configurationDescriptor.setConnection(connectionDescriptor);
        configurationDescriptor.setComponentItemId(descriptor.componentHandle.getItemId().getUuidValue());
        return configurationDescriptor;
    }

    public static BaselineDTO translateBaseline(IBaselineConnection baselineConnection, HashMap<UUID, IContributor> contributors) {
        return CoreUtil.translateBaseline(baselineConnection.teamRepository(), baselineConnection.getResolvedBaseline(), contributors);
    }

    public static HashMap<UUID, IContributor> fetchCreatorAndGetModifiedBy(ITeamRepository repo, List<IBaseline> baselines, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, IContributorHandle> contributorHandles = new HashMap<UUID, IContributorHandle>();
        for (IBaseline baseline : baselines) {
            IContributorHandle contributor = baseline.getCreator();
            contributorHandles.put(contributor.getItemId(), contributor);
            contributor = baseline.getModifiedBy();
            if (contributor == null) continue;
            contributorHandles.put(contributor.getItemId(), contributor);
        }
        List contributors = repo.itemManager().fetchCompleteItems(new ArrayList(contributorHandles.values()), 0, monitor);
        HashMap<UUID, IContributor> result = new HashMap<UUID, IContributor>();
        for (IContributorHandle contributor : contributors) {
            result.put(contributor.getItemId(), (IContributor)contributor);
        }
        return result;
    }

    public static BaselineDTO translateBaseline(ITeamRepository repository, IBaseline baseline, HashMap<UUID, IContributor> contributors) {
        BaselineDTO baselineDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineDTO();
        baselineDTO.setItemId(baseline.getItemId().getUuidValue());
        baselineDTO.setRepositoryURL(repository.getRepositoryURI());
        baselineDTO.setId(baseline.getId());
        baselineDTO.setName(baseline.getName());
        baselineDTO.setComment(baseline.getComment());
        baselineDTO.setComponentItemId(baseline.getComponent().getItemId().getUuidValue());
        baselineDTO.setCreationDate(baseline.getCreationDate().getTime());
        baselineDTO.setCreatorContributorItemId(baseline.getCreator().getItemId().getUuidValue());
        baselineDTO.setModifiedDate(baseline.modified().getTime());
        baselineDTO.setModifierContributorItemId(baseline.getModifiedBy().getItemId().getUuidValue());
        IContributor contributor = contributors.get(baseline.getCreator().getItemId());
        if (contributor != null) {
            baselineDTO.setCreatorContributorName(contributor.getName());
        }
        if ((contributor = contributors.get(baseline.getModifiedBy().getItemId())) != null) {
            baselineDTO.setModifierContributorName(contributor.getName());
        }
        return baselineDTO;
    }

    public static BaselineSetDTO translateBaselineSet(ITeamRepository repository, IBaselineSet baselineSet) {
        BaselineSetDTO baselineSetDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineSetDTO();
        baselineSetDTO.setComment(baselineSet.getComment());
        baselineSetDTO.setCreationDate(baselineSet.getCreationDate().getTime());
        baselineSetDTO.setCreatorContributorItemId(baselineSet.getCreator().getItemId().getUuidValue());
        baselineSetDTO.setItemId(baselineSet.getItemId().getUuidValue());
        baselineSetDTO.setModifiedDate(baselineSet.modified().getTime());
        baselineSetDTO.setModifierContributorItemId(baselineSet.getModifiedBy().getItemId().getUuidValue());
        baselineSetDTO.setName(baselineSet.getName());
        baselineSetDTO.setOwnerWorkspaceItemId(baselineSet.getOwner().getItemId().getUuidValue());
        baselineSetDTO.setRepositoryURL(repository.getRepositoryURI());
        for (IBaselineHandle baselineHandle : baselineSet.getBaselines()) {
            baselineSetDTO.getBaselineItemIds().add(baselineHandle.getItemId().getUuidValue());
        }
        return baselineSetDTO;
    }

    public static ProblemChangeSetsDTO translateProblemChangeSetsDTO(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> changeSets) {
        ProblemChangeSetsDTO problemChangeSetsDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createProblemChangeSetsDTO();
        problemChangeSetsDTO.setRepositoryURL(workspace.teamRepository().getRepositoryURI());
        problemChangeSetsDTO.setWorkspaceItemId(workspace.getContextHandle().getItemId().getUuidValue());
        for (IChangeSetHandle iChangeSetHandle : changeSets) {
            problemChangeSetsDTO.getChangeSetItemIds().add(iChangeSetHandle.getItemId().getUuidValue());
        }
        return problemChangeSetsDTO;
    }

    public static GapChangeSetsDTO translateGapProblemChangeSetsDTO(IWorkspaceConnection workspace, Collection<IChangeSetHandle> changeSets, boolean handlingSuspended) {
        GapChangeSetsDTO gapChangeSetsDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createGapChangeSetsDTO();
        gapChangeSetsDTO.setRepositoryURL(workspace.teamRepository().getRepositoryURI());
        gapChangeSetsDTO.setWorkspaceItemId(workspace.getContextHandle().getItemId().getUuidValue());
        for (IChangeSetHandle changeSet : changeSets) {
            gapChangeSetsDTO.getChangeSetItemIds().add(changeSet.getItemId().getUuidValue());
        }
        gapChangeSetsDTO.setHandlingSuspended(handlingSuspended);
        return gapChangeSetsDTO;
    }

    public static WorkspaceDetailsDTO translateWorkspace(IWorkspaceConnection connection, boolean includeComponents, boolean includeFlowTargets, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        WorkspaceDetailsDTO workspace = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceDetailsDTO();
        workspace.setRepositoryURL(connection.teamRepository().getRepositoryURI());
        workspace.setItemId(connection.getResolvedWorkspace().getItemId().getUuidValue());
        workspace.setOwner(connection.getOwner());
        workspace.setName(connection.getName());
        workspace.setDescription(connection.getDescription());
        workspace.setStream(connection.isStream());
        if (!connection.isStream()) {
            Visibility visibility = connection.getVisibility();
            workspace.setProjectAreaVisibility(visibility.getProjectAreaScope() == null ? null : visibility.getProjectAreaScope().getItemId().getUuidValue());
            workspace.setVisibility(CoreUtil.visibilityToString(visibility));
        }
        if (includeComponents) {
            ArrayList<Object> toRetrieve = new ArrayList<Object>(2 * connection.getComponentsInfo().size());
            for (ICurrentComponentInfo currentComponentInfo : connection.getComponentsInfo()) {
                toRetrieve.add(currentComponentInfo.basis());
                toRetrieve.add(currentComponentInfo.getComponent());
            }
            List items = connection.teamRepository().itemManager().fetchCompleteItems(toRetrieve, 0, (IProgressMonitor)monitor.newChild(20));
            HashMap<UUID, IAuditable> retrieved = new HashMap<UUID, IAuditable>();
            ArrayList<IBaseline> baselines = new ArrayList<IBaseline>();
            for (IAuditable auditable : items) {
                if (auditable == null) continue;
                retrieved.put(auditable.getItemId(), auditable);
                if (!(auditable instanceof IBaseline)) continue;
                baselines.add((IBaseline)auditable);
            }
            HashMap<UUID, IContributor> contributors = CoreUtil.fetchCreatorAndGetModifiedBy(connection.teamRepository(), baselines, (IProgressMonitor)monitor.newChild(20));
            ArrayList<IComponentHandle> toQueryForOwner = new ArrayList<IComponentHandle>();
            for (ICurrentComponentInfo currentComponentInfo : connection.getComponentsInfo()) {
                toQueryForOwner.add(currentComponentInfo.getComponent());
            }
            List owners = toQueryForOwner.isEmpty() ? Collections.EMPTY_LIST : SCMPlatform.getWorkspaceManager((ITeamRepository)connection.teamRepository()).findOwnersForComponents(toQueryForOwner, (IProgressMonitor)monitor.newChild(20));
            HashMap<UUID, IAuditableHandle> byOwner = new HashMap<UUID, IAuditableHandle>();
            int i = 0;
            while (i < owners.size()) {
                IAuditableHandle owner = (IAuditableHandle)owners.get(i);
                IComponentHandle comp = (IComponentHandle)toQueryForOwner.get(i);
                byOwner.put(comp.getItemId(), owner);
                ++i;
            }
            List visibilities = toQueryForOwner.isEmpty() ? Collections.EMPTY_LIST : SCMPlatform.getWorkspaceManager((ITeamRepository)connection.teamRepository()).findVisibilityForComponents(toQueryForOwner, (IProgressMonitor)monitor.newChild(20));
            HashMap<UUID, Visibility> vizByOwner = new HashMap<UUID, Visibility>();
            int i2 = 0;
            while (i2 < visibilities.size()) {
                Visibility viz = (Visibility)visibilities.get(i2);
                IComponentHandle comp = (IComponentHandle)toQueryForOwner.get(i2);
                vizByOwner.put(comp.getItemId(), viz);
                ++i2;
            }
            for (ICurrentComponentInfo currentComponentInfo : connection.getComponentsInfo()) {
                BaselineDTO baselineDTO;
                WorkspaceComponentDTO component = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceComponentDTO();
                workspace.getComponents().add(component);
                component.setItemId(currentComponentInfo.getComponent().getItemId().getUuidValue());
                IAuditable auditable = (IAuditable)retrieved.get(currentComponentInfo.getComponent().getItemId());
                if (auditable instanceof IComponent) {
                    IComponent fullComponent = (IComponent)auditable;
                    component.setName(fullComponent.getName());
                    component.setRootFolder(fullComponent.getRootFolder().getItemId().getUuidValue());
                    IAuditableHandle owner = (IAuditableHandle)byOwner.get(fullComponent.getItemId());
                    component.setOwner(owner);
                    if (owner instanceof IContributorHandle) {
                        Visibility compViz = (Visibility)vizByOwner.get(currentComponentInfo.getComponent().getItemId());
                        component.setProjectAreaVisibility(compViz.getProjectAreaScope() == null ? null : compViz.getProjectAreaScope().getItemId().getUuidValue());
                        component.setVisibility(CoreUtil.visibilityToString(compViz));
                    }
                }
                if ((auditable = (IAuditable)retrieved.get(currentComponentInfo.basis().getItemId())) instanceof IBaseline) {
                    IBaseline fullBaseline = (IBaseline)auditable;
                    baselineDTO = CoreUtil.translateBaseline(connection.teamRepository(), fullBaseline, contributors);
                } else {
                    baselineDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineDTO();
                    baselineDTO.setItemId(currentComponentInfo.basis().getItemId().getUuidValue());
                }
                component.setBaseline(baselineDTO);
            }
        }
        if (includeFlowTargets) {
            IFlowNodeHandle flowNode;
            List flowEntries = workspace.getFlowEntries();
            IFlowTable flowTable = connection.getFlowTable();
            IWorkspaceHandle defaultCollaborationHandle = FlowUtils.getDefaultFlowTarget((IWorkspaceConnection)connection);
            IWorkspaceHandle currentCollaborationHandle = ComponentFlowUtil.getCurrentCollaboration(connection);
            HashSet<UUID> targetsReported = new HashSet<UUID>();
            for (IFlowEntry entry : flowTable.acceptSources()) {
                flowNode = entry.getFlowNode();
                if (!(flowNode instanceof IWorkspaceHandle) || !targetsReported.add(flowNode.getItemId())) continue;
                flowEntries.add(CoreUtil.translateFlowEntry(entry, defaultCollaborationHandle, currentCollaborationHandle, connection.teamRepository()));
            }
            for (IFlowEntry entry : flowTable.deliverTargets()) {
                flowNode = entry.getFlowNode();
                if (!(flowNode instanceof IWorkspaceHandle) || !targetsReported.add(flowNode.getItemId())) continue;
                flowEntries.add(CoreUtil.translateFlowEntry(entry, defaultCollaborationHandle, currentCollaborationHandle, connection.teamRepository()));
            }
        }
        return workspace;
    }

    private static String visibilityToString(Visibility visibility) {
        if (visibility.getVisibility().equals((Object)VisibilityEnum.PRIVATE_TO_OWNER)) {
            return "private";
        }
        if (visibility.getVisibility().equals((Object)VisibilityEnum.PUBLIC_TO_ALL)) {
            return "public";
        }
        return "project";
    }

    private static WorkspaceFlowEntryDTO translateFlowEntry(IFlowEntry entry, IWorkspaceHandle defaultCollaborationHandle, IWorkspaceHandle currentCollaborationHandle, ITeamRepository repo) {
        WorkspaceFlowEntryDTO flowEntry = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceFlowEntryDTO();
        flowEntry.setRepositoryURL(repo.getRepositoryURI());
        flowEntry.setWorkspaceItemId(entry.getFlowNode().getItemId().getUuidValue());
        boolean isCurrentFlow = false;
        if (currentCollaborationHandle != null) {
            isCurrentFlow = currentCollaborationHandle.sameItemId((IItemHandle)entry.getFlowNode());
        }
        flowEntry.setCurrentFlow(isCurrentFlow);
        boolean isDefaultFlow = false;
        if (defaultCollaborationHandle != null) {
            isDefaultFlow = defaultCollaborationHandle.sameItemId((IItemHandle)entry.getFlowNode());
        }
        flowEntry.setDefaultFlow(isDefaultFlow);
        List componentScopes = entry.getComponentScopes();
        for (IComponentHandle componentHandle : componentScopes) {
            flowEntry.getScopedComponentItemIds().add(componentHandle.getItemId().getUuidValue());
        }
        return flowEntry;
    }

    public static ShareableDTO translateShareable(IShareable shareable) {
        ShareableDTO shareableDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createShareableDTO();
        if (shareable != null) {
            shareableDTO.setSandboxPath(shareable.getSandbox().getRoot().removeTrailingSeparator().toOSString());
            shareableDTO.setRelativePath(CoreUtil.translatePath(shareable.getLocalPath()));
        }
        return shareableDTO;
    }

    public static SandboxDTO translateSandbox(ISandbox sandbox, boolean computeFully, IProgressMonitor progress) throws FileSystemClientException {
        SandboxDTO dto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createSandboxDTO();
        dto.setSandboxPath(sandbox.getRoot().toOSString());
        dto.setCaseSensitive(Boolean.valueOf(sandbox.isCaseSensitive()));
        if (computeFully) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
            List shares = dto.getAllShares();
            IShare[] iShareArray = sandbox.allShares((IProgressMonitor)monitor.newChild(1));
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                shares.add(CoreUtil.translateShare(share));
                ++n2;
            }
            dto.setCorrupted(Boolean.valueOf(sandbox.isCorrupted((IProgressMonitor)monitor.newChild(1))));
        }
        return dto;
    }

    public static IResource findRoot(IPath path, IProgressMonitor progress) throws TeamRepositoryException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource existingAncestor = null;
        IPath existingAncestorPath = path;
        while (path.segmentCount() > 0) {
            existingAncestor = root.findMember(existingAncestorPath);
            if (existingAncestor != null) break;
            existingAncestorPath = existingAncestorPath.removeLastSegments(1);
        }
        assert (existingAncestor != null && existingAncestor.exists());
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)1);
        mon.beginTask(NLS.bind((String)Messages.CoreUtil_REFRESHING_TO_PATH, (Object)path.toPortableString()), path.segmentCount() - existingAncestorPath.segmentCount());
        if (existingAncestor.getFullPath().equals((Object)path)) {
            try {
                existingAncestor.refreshLocal(0, (IProgressMonitor)mon.newChild(1));
            }
            catch (CoreException e) {
                throw new TeamRepositoryException("Exception refreshing " + existingAncestor.getFullPath().toPortableString(), (Throwable)e);
            }
            if (existingAncestor.exists()) {
                return existingAncestor;
            }
            return null;
        }
        mon.setWorkRemaining(path.segmentCount() - existingAncestor.getFullPath().segmentCount());
        IPath walker = existingAncestor.getFullPath();
        int i = walker.segmentCount();
        while (i < path.segmentCount()) {
            mon.subTask(NLS.bind((String)Messages.CoreUtil_REFRESHING_PATH, (Object)existingAncestor.getFullPath().toPortableString()));
            try {
                existingAncestor.refreshLocal(1, (IProgressMonitor)mon.newChild(1));
            }
            catch (CoreException e) {
                throw new TeamRepositoryException("Exception refreshing " + existingAncestor.getFullPath().toPortableString(), (Throwable)e);
            }
            walker = walker.append(path.segment(i));
            existingAncestor = root.findMember(walker);
            if (existingAncestor == null) {
                try {
                    root.findMember(path.removeLastSegments(1)).refreshLocal(2, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return null;
            }
            ++i;
        }
        return existingAncestor;
    }

    public static IResource findRoot(String p, IProgressMonitor progress) throws TeamRepositoryException {
        return CoreUtil.findRoot((IPath)new Path(p), progress);
    }

    public static String getVersionableItemType(IItemType itemType) {
        if (IFileItem.ITEM_TYPE.equals(itemType)) {
            return "file";
        }
        if (IFolder.ITEM_TYPE.equals(itemType)) {
            return "folder";
        }
        if (ISymbolicLink.ITEM_TYPE.equals(itemType)) {
            return "symbolic_link";
        }
        return "";
    }

    public static String getVersionableItemType(IVersionableHandle versionableHandle) {
        if (versionableHandle instanceof IFileItemHandle) {
            return "file";
        }
        if (versionableHandle instanceof IFolderHandle) {
            return "folder";
        }
        if (versionableHandle instanceof ISymbolicLinkHandle) {
            return "symbolic_link";
        }
        return "";
    }
}

